/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.NumericMap;

public class ContinuousRangeToNumericMap
extends NumericMap {
    protected double inMin = 0.0;
    protected double inMax = 1.0;
    protected double outMin = 0.0;
    protected double outMax = 1.0;
    protected int labelCount = 2;
    protected double margin = 0.0;

    public void setOffset(double offset) {
        this.margin = offset;
    }

    public double getOffset() {
        return this.margin;
    }

    @Override
    public void init(AInitAction ia) {
        double outSize;
        super.init(ia);
        if (ia.beenInitialized(this)) {
            return;
        }
        Formatter labelFormat = this.getOwnerFormatter();
        this.labelVector.removeAllValues();
        this.uniqueValueVector.removeAllValues();
        this.labelVector.setSize(this.labelCount);
        this.uniqueValueVector.setSize(this.labelCount);
        double inSize = this.inMax - this.inMin;
        if (inSize == 0.0) {
            Debug.println((String)"Input range is zero. Using OutputMin value for all incoming data points.");
        }
        if ((outSize = this.outMax - this.outMin) == 0.0) {
            Debug.println((String)"Output range is zero. Using InputMin value for all incoming data points.");
        }
        if (this.labelCount >= 2) {
            for (int i = 0; i < this.labelCount; ++i) {
                double ratio = (double)i / (double)(this.labelCount - 1);
                this.labelVector.setValueAt(labelFormat.format(new Double(this.inMin + ratio * inSize)).trim(), i);
                this.uniqueValueVector.setValueAt(this.outMin + ratio * outSize + this.margin, i);
            }
        } else if (this.labelCount == 1) {
            this.labelVector.setValueAt(labelFormat.format(new Double(inSize / 2.0)).trim(), 0);
            this.uniqueValueVector.setValueAt(outSize / 2.0 + this.margin, 0);
        }
    }

    public double getValue(double input) {
        double mappedValue;
        double denominator = this.inMax - this.inMin;
        if (denominator == 0.0) {
            mappedValue = this.outMin;
        } else {
            double normalizedValue = (input - this.inMin) / denominator;
            mappedValue = this.outMin + (this.outMax - this.outMin) * normalizedValue;
        }
        return mappedValue + this.margin;
    }

    public double getInverseValue(double output) {
        double mappedValue;
        double denominator = this.outMax - this.outMin;
        output -= this.margin;
        if (denominator == 0.0) {
            mappedValue = this.inMin;
        } else {
            double normalizedValue = (output - this.outMin) / denominator;
            mappedValue = this.inMin + (this.inMax - this.inMin) * normalizedValue;
        }
        return mappedValue;
    }

    @Override
    public double getOutputMin() {
        return this.outMin;
    }

    public void setOutputMin(double min) {
        this.outMin = min;
        this.setModified();
    }

    @Override
    public double getOutputMax() {
        return this.outMax;
    }

    public void setOutputMax(double max) {
        this.outMax = max;
        this.setModified();
    }

    public double getInputMin() {
        return this.inMin;
    }

    public void setInputMin(double min) {
        this.inMin = min;
        this.setModified();
    }

    public double getInputMax() {
        return this.inMax;
    }

    public void setInputMax(double max) {
        this.inMax = max;
        this.setModified();
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public void setLabelCount(int num) {
        this.labelCount = num < 0 ? 0 : num;
        this.setModified();
    }
}

