/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.MissingValues;
import com.sas.graphics.util.vtk.ColorPipe;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.ColorVector;
import com.sas.graphics.util.vtk.ValueMap;
import java.awt.Color;
import java.util.Hashtable;

public abstract class ColorMap
extends ValueMap {
    protected ColorVector uniqueValueVector = new ColorVector();
    public final ColorPipe uniqueValue = this.uniqueValueVector;
    private boolean replaceMissingValues = false;
    protected boolean labelMissingValues = false;
    protected Color missingReplacement = ColorProperty.getDefaultColor();
    protected Hashtable labelMissingValueTable = null;
    protected Hashtable replaceMissingValueTable = null;
    protected Hashtable missingReplacementTable = null;

    public ColorMap() {
        this.uniqueValueVector.setOwner(this);
    }

    public void setMissingReplacement(Color c) {
        this.missingReplacement = c;
        this.setModified();
    }

    public Color getMissingReplacement() {
        return this.missingReplacement;
    }

    public void setMissingReplacement(Color c, MissingValues missingValue) {
        if (this.missingReplacementTable == null) {
            this.missingReplacementTable = new Hashtable();
        }
        this.missingReplacementTable.put(missingValue, c);
        this.setModified();
    }

    public Color getMissingReplacement(MissingValues missingValue) {
        Object value;
        Color result = this.missingReplacement;
        if (this.missingReplacementTable != null && (value = this.missingReplacementTable.get(missingValue)) != null) {
            result = (Color)value;
        }
        return result;
    }

    public void setReplaceMissingValues(boolean b) {
        this.replaceMissingValues = b;
        this.setModified();
    }

    public void setReplaceMissingValues(boolean b, MissingValues mv) {
        if (this.replaceMissingValueTable == null) {
            this.replaceMissingValueTable = new Hashtable();
        }
        this.replaceMissingValueTable.put(mv, new Boolean(b));
        this.setModified();
    }

    public boolean isReplaceMissingValues() {
        return this.replaceMissingValues;
    }

    public boolean isReplaceMissingValues(MissingValues mv) {
        Object value;
        boolean result = this.isReplaceMissingValues();
        if (!result && this.replaceMissingValueTable != null && (value = this.replaceMissingValueTable.get(mv)) != null) {
            result = (Boolean)value;
        }
        return result;
    }

    public boolean isLabelMissingValues() {
        return this.labelMissingValues;
    }

    protected void setLabelMissingValues(boolean b) {
        this.labelMissingValues = b;
        this.setModified();
    }

    protected void setLabelMissingValues(boolean b, MissingValues missingValue) {
        if (this.labelMissingValueTable == null) {
            this.labelMissingValueTable = new Hashtable();
        }
        this.labelMissingValueTable.put(missingValue, new Boolean(b));
        this.setModified();
    }

    public boolean isLabelMissingValues(MissingValues missingValue) {
        Object value;
        boolean result = this.labelMissingValues;
        if (this.labelMissingValueTable != null && (value = this.labelMissingValueTable.get(missingValue)) != null) {
            result = (Boolean)value;
        }
        if (!result) {
            result = this.isLabelMissingValues();
        }
        return result;
    }

    protected boolean isLabelMissingValuesAny() {
        return this.labelMissingValues || this.labelMissingValueTable != null;
    }

    protected boolean isReplaceMissingValuesAny() {
        return this.replaceMissingValues || this.replaceMissingValueTable != null;
    }
}

