/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.Calculator;
import com.sas.graphics.util.vtk.ColorPipe;
import com.sas.graphics.util.vtk.DiscreteRangeToColorMapper;
import java.awt.Adjustable;
import java.awt.Color;
import java.util.Vector;

public class AxisLabelSelector {
    protected Color[] labelColors = new Color[]{Color.black, Color.red};
    protected static double[] labelRange = new double[]{0.0, 1.0};
    Vector selectedLabelIndex = new Vector();
    protected Calculator calculator = new Calculator();
    protected DiscreteRangeToColorMapper mapper = new DiscreteRangeToColorMapper();
    public final ColorPipe labelColor;
    protected Adjustable adjustable;
    protected String[] labels;

    public AxisLabelSelector() {
        this.labelColor = this.mapper.value;
        this.setupCalculator();
        this.mapper.input.connectFrom(this.calculator.value);
        this.mapper.setRangeValue(labelRange);
        this.mapper.setColorValue(this.labelColors);
        this.adjustable = null;
    }

    public void setAdjustable(Adjustable adjustable) {
        this.adjustable = adjustable;
    }

    public Adjustable getAdjustable() {
        return this.adjustable;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLabelColor(Color color) {
        this.labelColors[0] = color;
    }

    public Color getLabelColor() {
        return this.labelColors[0];
    }

    public void setSelectedLabelColor(Color color) {
        this.labelColors[1] = color;
    }

    public Color getSelectedLabelColor() {
        return this.labelColors[1];
    }

    public void removeAllSelections() {
        this.selectedLabelIndex.removeAllElements();
        this.setupCalculator();
    }

    public void selectLabelAtIndex(int i, boolean append) {
        if (this.adjustable != null) {
            i = this.adjustable.getValue() + i;
        }
        int elementIndex = this.findLabelIndex(i);
        Integer ie = new Integer(i);
        if (append) {
            if (elementIndex < 0) {
                this.selectedLabelIndex.addElement(ie);
            } else {
                this.selectedLabelIndex.removeElementAt(elementIndex);
            }
        } else {
            this.selectedLabelIndex.removeAllElements();
            if (elementIndex < 0) {
                this.selectedLabelIndex.addElement(ie);
            }
        }
        this.setupCalculator();
    }

    protected int findLabelIndex(int labelIndex) {
        int n = this.selectedLabelIndex.size();
        for (int i = 0; i < n; ++i) {
            Integer v = (Integer)this.selectedLabelIndex.elementAt(i);
            if (v != labelIndex) continue;
            return i;
        }
        return -1;
    }

    protected void setupCalculator() {
        Integer io;
        int i;
        int size = this.selectedLabelIndex.size();
        int min = 0;
        int max = Integer.MAX_VALUE;
        int visibleLabelCount = size;
        if (this.adjustable != null) {
            min = this.adjustable.getValue();
            max = min + this.adjustable.getVisibleAmount();
            visibleLabelCount = 0;
            for (i = 0; i < size; ++i) {
                io = (Integer)this.selectedLabelIndex.elementAt(i);
                if (io < min || io > max) continue;
                ++visibleLabelCount;
            }
        }
        if (visibleLabelCount == 0) {
            this.calculator.setExpression("0");
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            int addedLabelIndexCount = 0;
            for (i = 0; i < size; ++i) {
                io = (Integer)this.selectedLabelIndex.elementAt(i);
                if (io < min || io > max) continue;
                int labelIndex = io - min;
                sb.append("obs=" + labelIndex);
                if (++addedLabelIndexCount >= visibleLabelCount) continue;
                sb.append(" | ");
            }
            sb.append(") ? 1 : 0");
            String s = new String(sb);
            this.calculator.setExpression(s);
        }
    }

    public String[] getSelectedLabels() {
        int[] selectedIndices = this.getSelectedIndices();
        String[] selectedLabels = new String[selectedIndices.length];
        for (int i = 0; i < selectedIndices.length; ++i) {
            selectedLabels[i] = this.labels[selectedIndices[i]];
        }
        return selectedLabels;
    }

    public int[] getSelectedIndices() {
        int n = this.selectedLabelIndex.size();
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer io = (Integer)this.selectedLabelIndex.elementAt(i);
            indices[i] = io;
        }
        return indices;
    }

    public int getSelectedIndicesCount() {
        return this.selectedLabelIndex.size();
    }

    public void update() {
        this.setupCalculator();
    }
}

