/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.PropertyContainer;
import java.util.Hashtable;

public abstract class Action {
    public static final int EPOCH = 0;
    private int valueIndex;
    private static long timeStamp = 1L;
    private Object graphicsContext;
    private AResetAction resetAction = null;
    private Hashtable visitedElements = new Hashtable();

    protected Action(Object gContext) {
        this.graphicsContext = gContext;
    }

    protected Action(Object gContext, AResetAction aResetAction) {
        this(gContext);
        this.resetAction = aResetAction;
    }

    public static long getTimeStamp() {
        return timeStamp++;
    }

    public abstract void apply(Element var1);

    public Object getGraphicsContext() {
        return this.graphicsContext;
    }

    public void setValueIndex(int index) {
        this.valueIndex = index;
        if (this.resetAction != null) {
            this.resetAction.setValueIndex(index);
        }
    }

    public int getValueIndex() {
        return this.valueIndex;
    }

    public boolean beenVisited(PropertyContainer o) {
        boolean rc = this.visitedElements.containsKey(o);
        if (!rc) {
            this.visitedElements.put(o, this);
        }
        return rc;
    }

    public void clearVisits() {
        this.visitedElements.clear();
    }

    public AResetAction getResetAction() {
        return this.resetAction;
    }

    public void pushName(Element e) {
    }

    public void popName(Element e) {
    }
}

