/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.Accumulator;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;

public class AccumulatorByCategory
extends Accumulator {
    public final IntegerProperty category = new IntegerProperty(this, true);
    protected double[] totals;
    protected int categoryCount;

    @Override
    public double getValue(int index) throws MissingValueException {
        double r;
        if (this.lastIndex == index) {
            return this.lastValue;
        }
        int cat = this.category.getValue(index);
        if (this.getPostAccumulate()) {
            r = this.totals[cat];
            int n = cat;
            this.totals[n] = this.totals[n] + this.input.getValue(index);
        } else {
            int n = cat;
            this.totals[n] = this.totals[n] + this.input.getValue(index);
            r = this.totals[cat];
        }
        this.lastIndex = index;
        this.lastValue = r;
        return r;
    }

    @Override
    protected void reset() {
        double sv = this.getStartValue();
        for (int i = 0; this.totals != null && i < this.totals.length; ++i) {
            this.totals[i] = sv;
        }
        this.lastIndex = -1;
    }

    @Override
    public void init(AInitAction initAction) {
        this.categoryCount = 0;
        super.init(initAction);
        if (initAction.beenInitialized(this)) {
            return;
        }
        try {
            int n = initAction.getValueCount();
            for (int i = 0; i < n; ++i) {
                int c = this.category.getValue(i);
                if (c <= this.categoryCount) continue;
                this.categoryCount = c;
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        ++this.categoryCount;
        if (this.totals == null || this.totals.length < this.categoryCount) {
            this.totals = new double[this.categoryCount];
        }
        this.reset();
    }
}

