/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.AResetAction;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.PropertyContainer;

public class Accumulator
extends PropertyContainer
implements NumericPipe {
    public final NumericProperty input = new NumericProperty(this, true);
    public final NumericPipe value = this;
    private double total = this.startValue = 0.0;
    private double startValue;
    private boolean postAccumulate = true;
    protected int lastIndex = -1;
    protected double lastValue;

    public void setPostAccumulate(boolean trueOrFalse) {
        this.postAccumulate = trueOrFalse;
    }

    public boolean getPostAccumulate() {
        return this.postAccumulate;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        double r;
        if (index == this.lastIndex) {
            return this.lastValue;
        }
        if (this.postAccumulate) {
            r = this.total;
            this.total += this.input.getValue(index);
        } else {
            this.total += this.input.getValue(index);
            r = this.total;
        }
        this.lastIndex = index;
        this.lastValue = r;
        return r;
    }

    public void setStartValue(double aStartValue) {
        this.startValue = aStartValue;
        this.reset();
    }

    public double getStartValue() {
        return this.startValue;
    }

    @Override
    public void reset(AResetAction resetAction) {
        this.reset();
    }

    protected void reset() {
        this.total = this.startValue;
        this.lastIndex = -1;
    }

    @Override
    public void init(AInitAction initAction) {
        this.reset();
        super.init(initAction);
    }
}

