/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import java.awt.Color;

public abstract class AWedge
extends Element {
    public final NumericProperty angle = new NumericProperty(this, true);
    public final NumericProperty startAngle = new NumericProperty(this, true);
    public final NumericProperty innerRadius = new NumericProperty(this, true);
    public final NumericProperty outerRadius = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final IntegerProperty precision = new IntegerProperty(this, true);

    public AWedge(ATransform transform) {
        super(transform);
        this.precision.setValue(16);
        this.edgeColor.setValue(Color.black);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
        this.innerRadius.setValue(0.0);
        this.outerRadius.setValue(1.0);
        this.startAngle.setValue(0.0);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d pt = bBoxAction.pt1;
        pt.z = 0.0;
        double ang = this.angle.getValue(index);
        double sa = this.startAngle.getValue(index);
        double ir = this.innerRadius.getValue(index);
        double or = this.outerRadius.getValue(index);
        double p = this.precision.getValue(index);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        double increment = Math.PI * 2 / p;
        int segments = 1;
        if (Math.abs(ang) > increment) {
            segments = (int)Math.round(Math.abs(ang) / increment);
        }
        double d = increment = ang > 0.0 ? increment : -increment;
        if (ir > 0.0) {
            pt.x = Math.cos(sa + ang) * ir;
            pt.y = Math.sin(sa + ang) * ir;
            box.union(pt);
            pt.x = Math.cos(sa) * ir;
            pt.y = Math.sin(sa) * ir;
            box.union(pt);
        }
        double a = sa;
        for (int i = 0; i < segments; ++i) {
            pt.x = Math.cos(a) * or;
            pt.y = Math.sin(a) * or;
            box.union(pt);
            a += increment;
        }
        pt.x = Math.cos(sa + ang) * or;
        pt.y = Math.sin(sa + ang) * or;
        box.union(pt);
    }
}

