/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;

public abstract class ASphere
extends Element {
    public final NumericProperty radius = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final IntegerProperty precision = new IntegerProperty(this, true);
    protected static double[][] x;
    protected static double[] y;
    protected static double[][] z;
    protected static int lastPrecision;
    protected static int nLongitude;
    protected static int nLatitude;

    protected ASphere(ATransform transform) {
        super(transform);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
        this.precision.setValue(16);
        this.radius.setValue(1.0);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        double radi = Math.abs(this.radius.getValue(index));
        size.y = size.z = radi * 2.0;
        size.x = size.z;
        center.set(0.0, 0.0, 0.0);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }

    protected static synchronized void calculatePoints(int precision) {
        nLongitude = precision + 1;
        nLatitude = nLongitude / 2;
        x = new double[nLatitude + 1][nLongitude + 1];
        y = new double[nLatitude + 1];
        z = new double[nLatitude + 1][nLongitude + 1];
        double alpha = 0.0;
        double beta = 0.0;
        double betaCos = 0.0;
        double PIOverTwo = 1.5707963705062866;
        double twoPI = Math.PI * 2;
        for (int latitude = 0; latitude <= nLatitude; ++latitude) {
            beta = (double)latitude / (double)nLatitude * Math.PI + PIOverTwo;
            betaCos = Math.cos(beta);
            ASphere.y[latitude] = Math.sin(beta);
            for (int longitude = 0; longitude <= nLongitude; ++longitude) {
                alpha = (double)longitude / (double)nLongitude * twoPI;
                ASphere.x[latitude][longitude] = -1.0 * betaCos * Math.cos(alpha);
                ASphere.z[latitude][longitude] = betaCos * Math.sin(alpha);
            }
        }
    }

    static {
        lastPrecision = -1;
    }
}

