/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.LinearRing;
import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.WKBPolygon;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.StringProperty;
import java.awt.Color;
import java.util.Vector;

public abstract class ASpatialDataMap
extends Element {
    public final ColorProperty color = new ColorProperty(this, true);
    public final StringProperty spatialData = new StringProperty(this, true);
    public ColorProperty edgeColor = new ColorProperty(this, true);
    public BooleanProperty edgeOn = new BooleanProperty(this, true);
    public BooleanProperty fillOn = new BooleanProperty(this, true);
    public NumericProperty height = new NumericProperty(this, true);
    public BooleanProperty heightOn = new BooleanProperty(this, true);
    private char[] charArray = null;
    private int charArrayPointer = 0;
    private ReusableDouble key = new ReusableDouble();
    protected double worldPixelWidth = -1.0;
    protected double worldPixelHeight = -1.0;
    protected boolean vertexCullingEnabled = true;
    protected WKBMultiPolygon[] multiPolygons = null;
    protected Vector highlightRegions = new Vector();
    protected Color highlightColor = Color.white;
    public boolean centers = true;
    protected int numMultiPolygons;
    protected double xMin = Double.MAX_VALUE;
    protected double xMax = -1.7976931348623157E308;
    protected double yMin = Double.MAX_VALUE;
    protected double yMax = -1.7976931348623157E308;

    protected ASpatialDataMap(ATransform transform) {
        super(transform);
        this.edgeColor.setValue(Color.black);
        this.fillOn.setValue(true);
        this.heightOn.setValue(false);
    }

    public void setWorldPixelWidth(double width) {
        this.worldPixelWidth = width;
    }

    public double getWorldPixelWidth() {
        return this.worldPixelWidth;
    }

    public void setWorldPixelHeight(double height) {
        this.worldPixelHeight = height;
    }

    public double getWorldPixelheight() {
        return this.worldPixelHeight;
    }

    public void setVertexCullingEnabled(boolean trueOrFalse) {
        this.vertexCullingEnabled = trueOrFalse;
    }

    public boolean isVertexCullingEnabled() {
        return this.vertexCullingEnabled;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void addHighlightRegion(int index) {
        this.highlightRegions.addElement(new ReusableDouble((double)index));
    }

    public void removeHighlightRegion(int index) {
        this.key.value = index;
        this.highlightRegions.removeElement(this.key);
    }

    public boolean isRegionHighlighted(int index) {
        this.key.value = index;
        return this.highlightRegions.indexOf(this.key) != -1;
    }

    public void removeAllHighlightRegions() {
        this.highlightRegions.removeAllElements();
    }

    public Vector getHighlightRegions() {
        return this.highlightRegions;
    }

    protected abstract void rebuildLists(AInitAction var1);

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        if (!initAction.beenInitialized(this)) {
            this.rebuildLists(initAction);
        }
    }

    public void readSpatialData() {
        AInitAction initAction = new AInitAction();
        this.spatialData.init(initAction);
        this.numMultiPolygons = initAction.getValueCount();
        this.readMapFromStrings();
    }

    public void clear() {
        this.multiPolygons = null;
    }

    public int size() {
        return this.numMultiPolygons;
    }

    protected void readMapFromStrings() {
        this.multiPolygons = new WKBMultiPolygon[this.numMultiPolygons];
        for (int i = 0; i < this.numMultiPolygons; ++i) {
            try {
                String tempString = this.spatialData.getValue(i);
                if (tempString.length() == 0) {
                    this.multiPolygons[i] = null;
                    continue;
                }
                this.charArray = tempString.toCharArray();
                this.charArrayPointer = 0;
                this.multiPolygons[i] = this.readMultiPolygon();
                continue;
            }
            catch (Throwable e) {
                System.out.println("Error reading map data: index=" + i);
            }
        }
        int a = 5;
    }

    public WKBMultiPolygon readMultiPolygon() {
        long numPolygons;
        int type;
        WKBMultiPolygon multiPolygon = new WKBMultiPolygon();
        String endian = new String(this.charArray, this.charArrayPointer, 2);
        this.charArrayPointer += 4;
        multiPolygon.byteOrder = this.getByteFromString(endian) == 1;
        String typeString = new String(this.charArray, this.charArrayPointer, 4);
        this.charArrayPointer += 4;
        multiPolygon.wkbType = type = this.getIntFromString(typeString, multiPolygon.byteOrder);
        String numPolygonsString = new String(this.charArray, this.charArrayPointer, 8);
        this.charArrayPointer += 8;
        multiPolygon.num_wkbPolygons = numPolygons = this.getLongFromString(numPolygonsString, multiPolygon.byteOrder);
        multiPolygon.WKBPolygons = new WKBPolygon[(int)numPolygons];
        int i = 0;
        while ((long)i < numPolygons) {
            multiPolygon.WKBPolygons[i] = this.readPolygon();
            ++i;
        }
        return multiPolygon;
    }

    public WKBPolygon readPolygon() {
        WKBPolygon polygon = new WKBPolygon();
        String interiorEndianString = new String(this.charArray, this.charArrayPointer, 2);
        this.charArrayPointer += 4;
        polygon.byteOrder = this.getByteFromString(interiorEndianString) == 1;
        String typeString = new String(this.charArray, this.charArrayPointer, 4);
        this.charArrayPointer += 4;
        polygon.wkbType = this.getIntFromString(typeString, polygon.byteOrder);
        String numRingsString = new String(this.charArray, this.charArrayPointer, 8);
        this.charArrayPointer += 8;
        polygon.numRings = this.getLongFromString(numRingsString, polygon.byteOrder);
        polygon.rings = new LinearRing[(int)polygon.numRings];
        int i = 0;
        while ((long)i < polygon.numRings) {
            polygon.rings[i] = new LinearRing();
            String numPointsString = new String(this.charArray, this.charArrayPointer, 8);
            this.charArrayPointer += 8;
            polygon.rings[i].numPoints = this.getLongFromString(numPointsString, polygon.byteOrder);
            this.charArrayPointer += 8;
            polygon.rings[i].points = new Vec3d[(int)polygon.rings[i].numPoints];
            int j = 0;
            while ((long)j < polygon.rings[i].numPoints) {
                String xString = new String(this.charArray, this.charArrayPointer, 16);
                this.charArrayPointer += 16;
                String yString = new String(this.charArray, this.charArrayPointer, 16);
                this.charArrayPointer += 16;
                polygon.rings[i].points[j] = new Vec3d(this.getDoubleFromString(xString, polygon.byteOrder), this.getDoubleFromString(yString, polygon.byteOrder), 0.0);
                if (polygon.rings[i].points[j].x < this.xMin) {
                    this.xMin = polygon.rings[i].points[j].x;
                }
                if (polygon.rings[i].points[j].x > this.xMax) {
                    this.xMax = polygon.rings[i].points[j].x;
                }
                if (polygon.rings[i].points[j].y < this.yMin) {
                    this.yMin = polygon.rings[i].points[j].y;
                }
                if (polygon.rings[i].points[j].y > this.yMax) {
                    this.yMax = polygon.rings[i].points[j].y;
                }
                ++j;
            }
            ++i;
        }
        return polygon;
    }

    public byte getByteFromString(String tempString) {
        return Byte.parseByte(tempString, 16);
    }

    public int getIntFromString(String tempString, boolean bigEndian) {
        if (bigEndian) {
            tempString = this.swapEnd(tempString);
        }
        return Integer.parseInt(tempString, 16);
    }

    public long getLongFromString(String tempString, boolean bigEndian) {
        if (bigEndian) {
            tempString = this.swapEnd(tempString);
        }
        return Long.parseLong(tempString, 16);
    }

    public double getDoubleFromString(String tempString, boolean bigEndian) {
        if (bigEndian) {
            tempString = this.swapEnd(tempString);
        }
        return Double.longBitsToDouble(this.getLongBitsFromString(tempString));
    }

    public long getLongBitsFromString(String tempString) {
        long l = 0L;
        int shift = 0;
        long b = 0L;
        for (int i = 15; i >= 0; --i) {
            switch (tempString.charAt(i)) {
                case '0': {
                    break;
                }
                case '1': {
                    l += 1L << shift;
                    break;
                }
                case '2': {
                    l += 2L << shift;
                    break;
                }
                case '3': {
                    l += 3L << shift;
                    break;
                }
                case '4': {
                    l += 4L << shift;
                    break;
                }
                case '5': {
                    l += 5L << shift;
                    break;
                }
                case '6': {
                    l += 6L << shift;
                    break;
                }
                case '7': {
                    l += 7L << shift;
                    break;
                }
                case '8': {
                    l += 8L << shift;
                    break;
                }
                case '9': {
                    l += 9L << shift;
                    break;
                }
                case 'A': 
                case 'a': {
                    l += 10L << shift;
                    break;
                }
                case 'B': 
                case 'b': {
                    l += 11L << shift;
                    break;
                }
                case 'C': 
                case 'c': {
                    l += 12L << shift;
                    break;
                }
                case 'D': 
                case 'd': {
                    l += 13L << shift;
                    break;
                }
                case 'E': 
                case 'e': {
                    l += 14L << shift;
                    break;
                }
                case 'F': 
                case 'f': {
                    l += 15L << shift;
                }
            }
            shift += 4;
        }
        return l;
    }

    public String swapEnd(String tempString) {
        char[] ary = tempString.toCharArray();
        char[] rev = new char[ary.length];
        int placement = 0;
        for (int i = ary.length - 1; i >= 0; i -= 2) {
            rev[placement++] = ary[i - 1];
            rev[placement++] = ary[i];
        }
        return new String(rev);
    }

    public void setupHighlight(ASpatialDataMap map, Vector indexVector) {
    }

    private WKBMultiPolygon elementAt(int index) {
        return this.multiPolygons[index];
    }

    public Vec3d getCenter(int index) {
        double maxSize = Double.MIN_VALUE;
        int foundIndex = -1;
        if (this.multiPolygons[index] == null) {
            return null;
        }
        int i = 0;
        while ((long)i < this.multiPolygons[index].num_wkbPolygons) {
            double newSize = this.getPolygonSize(this.multiPolygons[index].WKBPolygons[i]);
            if (newSize >= maxSize) {
                maxSize = newSize;
                foundIndex = i;
            }
            ++i;
        }
        if (foundIndex != -1) {
            return this.getCenterWithinPolygon(this.multiPolygons[index].WKBPolygons[foundIndex]);
        }
        return null;
    }

    protected double getPolygonSize(WKBPolygon poly) {
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        int i = 0;
        while ((long)i < poly.rings[0].numPoints) {
            Vec3d point = poly.rings[0].points[i];
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (point.y > ymax) {
                ymax = point.y;
            }
            ++i;
        }
        return Math.pow((xmax - xmin) * (xmax - xmin) + (ymax - ymin) * (ymax - ymin), 0.5);
    }

    Vec3d getCenterWithinPolygon(WKBPolygon poly) {
        int j;
        Vec3d centroid = new Vec3d();
        Vec3d average = new Vec3d();
        Vec3d newPoint = new Vec3d();
        int numPoints = 0;
        double polyxMin = Double.MAX_VALUE;
        double polyxMax = -1.7976931348623157E308;
        double polyyMin = Double.MAX_VALUE;
        double polyyMax = -1.7976931348623157E308;
        int i = 0;
        while ((long)i < poly.numRings) {
            j = 0;
            while ((long)j < poly.rings[i].numPoints) {
                Vec3d point = poly.rings[i].points[j];
                if (point.x < polyxMin) {
                    polyxMin = point.x;
                }
                if (point.x > polyxMax) {
                    polyxMax = point.x;
                }
                if (point.y < polyyMin) {
                    polyyMin = point.y;
                }
                if (point.y > polyyMax) {
                    polyyMax = point.y;
                }
                average.x += point.x;
                average.y += point.y;
                ++j;
            }
            numPoints = (int)((long)numPoints + poly.rings[i].numPoints);
            ++i;
        }
        average.x /= (double)numPoints;
        average.y /= (double)numPoints;
        centroid.x = (polyxMin + polyxMax) * 0.5;
        centroid.y = (polyyMin + polyyMax) * 0.5;
        if (poly.rings[0].numPoints <= 2L || this.yMin == this.yMax) {
            return centroid;
        }
        int n = 0;
        double[] work = new double[numPoints];
        int k = 0;
        while ((long)k < poly.numRings) {
            i = 0;
            while ((long)i < poly.rings[k].numPoints - 1L) {
                double y1 = poly.rings[k].points[i].y;
                double x1 = poly.rings[k].points[i].x;
                double y2 = poly.rings[k].points[i + 1].y;
                double x2 = poly.rings[k].points[i + 1].x;
                if (y1 > y2) {
                    double tempY = y1;
                    y1 = y2;
                    y2 = tempY;
                    double tempX = x1;
                    x1 = x2;
                    x2 = tempX;
                }
                if (centroid.y >= y1 && centroid.y < y2) {
                    newPoint.x = x1 + (centroid.y - y1) / (y2 - y1) * (x2 - x1);
                    if (n == 0) {
                        work[0] = newPoint.x;
                    } else if (newPoint.x >= work[n - 1]) {
                        work[n] = newPoint.x;
                    } else {
                        for (j = n; j > 0 && newPoint.x < work[j - 1]; --j) {
                            work[j] = work[j - 1];
                        }
                        work[j] = newPoint.x;
                    }
                    ++n;
                }
                ++i;
            }
            ++k;
        }
        switch (n) {
            case 0: {
                centroid.x = average.x;
                centroid.y = average.y;
                break;
            }
            case 2: 
            case 3: {
                centroid.x = (work[0] + work[1]) * 0.5;
                break;
            }
            default: {
                if ((n & 1) != 0) {
                    --n;
                }
                j = 0;
                for (i = 2; i < n; i += 2) {
                    if (!(work[i + 1] - work[i] > work[j + 1] - work[j])) continue;
                    j = i;
                }
                centroid.x = (work[j] + work[j + 1]) * 0.5;
            }
        }
        return centroid;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        BoundingBox box = bBoxAction.getElementBoundingBox();
        Vec3d min = bBoxAction.pt1;
        Vec3d max = bBoxAction.pt2;
        min.set(this.xMin, this.yMin, 0.0);
        max.set(this.xMax, this.yMax, 0.0);
        box.union(min);
        box.union(max);
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }
}

