/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AIndexedFaceSet;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IndexedFaceSetDetail;
import com.sas.graphics.util.vtk.MapDetail;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import com.sas.graphics.util.vtk.NumericVector;
import com.sas.graphics.util.vtk.PipedVector;
import com.sas.graphics.util.vtk.SelectDetail;
import com.sas.graphics.util.vtk.SelectEntry;
import com.sas.graphics.util.vtk.StringProperty;
import com.sas.graphics.util.vtk.StringVector;
import java.util.Hashtable;
import java.util.Stack;

public abstract class AMap
extends Element {
    private AInitAction tempIA = new AInitAction();
    protected AIndexedFaceSet ifs;
    public final NumericProperty region = new NumericProperty(this, false);
    public final StringProperty stringRegion = new StringProperty(this, false);
    public final NumericProperty segment = new NumericProperty(this, false);
    public final NumericProperty x = new NumericProperty();
    public final NumericProperty y = new NumericProperty();
    public final ColorProperty color = new ColorProperty();
    public final NumericProperty colorIndex = new NumericProperty();
    public final NumericProperty extrudeThickness = new NumericProperty();
    public final BooleanProperty extrudeOn = new BooleanProperty();
    public final ColorProperty edgeColor = new ColorProperty();
    public final BooleanProperty edgeOn = new BooleanProperty();
    private PipedVector faces;
    private NumericVector coordVector;
    private int numCoords;
    private Hashtable regionHashtable = new Hashtable();

    protected AMap(ATransform transform, AIndexedFaceSet ifs) {
        super(transform);
        this.ifs = ifs;
        ifs.edgeOn.connectFrom(this.edgeOn);
        ifs.edgeColor.connectFrom(this.edgeColor);
        ifs.coordX.connectFrom(this.x);
        ifs.coordY.connectFrom(this.y);
        ifs.color.connectFrom(this.color);
        ifs.colorIndex.connectFrom(this.colorIndex);
        ifs.extrudeThickness.connectFrom(this.extrudeThickness);
        ifs.extrudeOn.connectFrom(this.extrudeOn);
        ifs.extrudeVectorX.setValue(0.0);
        ifs.extrudeVectorY.setValue(0.0);
        ifs.extrudeVectorZ.setValue(1.0);
        ifs.setNormalPerVertex(false);
        ifs.normalX.setValue(0.0);
        ifs.normalY.setValue(0.0);
        ifs.normalZ.setValue(1.0);
        ifs.selectEnabled.setValue(true);
        ifs.selectDetailEnabled.setValue(true);
        this.coordVector = new NumericVector();
        ifs.coordIndex.connectFrom(this.coordVector);
    }

    @Override
    public void init(AInitAction initAction) {
        initAction.pushValueCount();
        this.x.init(initAction);
        this.y.init(initAction);
        this.region.init(initAction);
        this.stringRegion.init(initAction);
        this.segment.init(initAction);
        this.numCoords = initAction.getValueCount();
        initAction.popValueCount();
        super.init(initAction);
        if (!initAction.beenInitialized(this)) {
            this.createMap();
        }
        this.ifs.init(initAction);
    }

    protected void createMap() {
        boolean numeric = true;
        try {
            if (this.region.isConnected()) {
                numeric = true;
                if (this.faces == null || this.faces.getClass() == StringVector.class) {
                    this.faces = new NumericVector(60);
                } else {
                    this.faces.removeAllValues();
                }
            } else if (this.stringRegion.isConnected()) {
                numeric = false;
                if (this.faces == null || this.faces.getClass() == NumericVector.class) {
                    this.faces = new StringVector(60);
                } else {
                    this.faces.removeAllValues();
                }
            } else {
                return;
            }
            this.coordVector.removeAllValues();
            int numValues = this.numCoords;
            int currentNumericRegion = 0;
            String currentStringRegion = new String();
            int currentSegment = (int)this.segment.getValue(0);
            int c = 0;
            int s = 0;
            String stringC = new String();
            int first = 0;
            int interiorFirst = 0;
            boolean insideInterior = false;
            boolean lastObsMissing = false;
            this.coordVector.addValue(first);
            RegionDef regionDef = new RegionDef(0);
            if (numeric) {
                currentNumericRegion = (int)this.region.getValue(0);
                ((NumericVector)this.faces).addValue(currentNumericRegion);
                this.regionHashtable.put(new Integer(currentNumericRegion), regionDef);
            } else {
                currentStringRegion = this.stringRegion.getValue(0);
                ((StringVector)this.faces).addValue(currentStringRegion);
                this.regionHashtable.put(currentStringRegion, regionDef);
            }
            for (int i = 1; i < numValues; ++i) {
                boolean sameRegion;
                if (numeric) {
                    c = (int)this.region.getValue(i);
                    sameRegion = c == currentNumericRegion;
                } else {
                    stringC = this.stringRegion.getValue(i);
                    sameRegion = stringC.equals(currentStringRegion);
                }
                s = (int)this.segment.getValue(i);
                if (sameRegion) {
                    try {
                        this.x.getValue(i);
                        this.y.getValue(i);
                        lastObsMissing = false;
                        if (s == currentSegment) {
                            this.coordVector.addValue(i);
                            continue;
                        }
                        currentSegment = s;
                        if (insideInterior) {
                            this.coordVector.addValue(interiorFirst);
                            this.coordVector.addValue(-2.0);
                            insideInterior = false;
                        }
                        this.coordVector.addValue(first);
                        this.coordVector.addValue(-1.0);
                        this.coordVector.addValue(i);
                        first = i;
                        if (numeric) {
                            ((NumericVector)this.faces).addValue(currentNumericRegion);
                            continue;
                        }
                        ((StringVector)this.faces).addValue(currentStringRegion);
                    }
                    catch (MissingValueException e) {
                        if (!lastObsMissing) {
                            lastObsMissing = true;
                            if (insideInterior) {
                                this.coordVector.addValue(interiorFirst);
                                this.coordVector.addValue(-2.0);
                            }
                            this.coordVector.addValue(first);
                            this.coordVector.addValue(-2.0);
                            insideInterior = true;
                        }
                        interiorFirst = i + 1;
                    }
                    continue;
                }
                currentSegment = s;
                if (insideInterior) {
                    this.coordVector.addValue(interiorFirst);
                    this.coordVector.addValue(-2.0);
                    insideInterior = false;
                }
                this.coordVector.addValue(first);
                regionDef.endIndex = this.coordVector.size();
                this.coordVector.addValue(-1.0);
                this.coordVector.addValue(i);
                first = i;
                regionDef = new RegionDef(this.coordVector.size() - 1);
                if (numeric) {
                    currentNumericRegion = c;
                    ((NumericVector)this.faces).addValue(currentNumericRegion);
                    this.regionHashtable.put(new Integer(currentNumericRegion), regionDef);
                    continue;
                }
                currentStringRegion = stringC;
                ((StringVector)this.faces).addValue(currentStringRegion);
                this.regionHashtable.put(currentStringRegion, regionDef);
            }
            if (insideInterior) {
                this.coordVector.addValue(interiorFirst);
                this.coordVector.addValue(-2.0);
            }
            this.coordVector.addValue(first);
            regionDef.endIndex = this.coordVector.size() - 1;
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }

    public PipedVector getIdVector() {
        if (this.region.isConnected() && this.faces == null) {
            this.faces = new NumericVector(60);
        } else if (this.stringRegion.isConnected() && this.faces == null) {
            this.faces = new StringVector(60);
        }
        return this.faces;
    }

    public int getNumericRegionFromFace(int face) {
        if (this.region.isConnected()) {
            try {
                return (int)((NumericVector)this.faces).getValue(face);
            }
            catch (MissingValueException mve) {
                return -1;
            }
        }
        return -1;
    }

    public String getStringRegionFromFace(int face) {
        if (this.stringRegion.isConnected()) {
            try {
                return ((StringVector)this.faces).getValue(face);
            }
            catch (MissingValueException mve) {
                return new String();
            }
        }
        return new String();
    }

    public Vec3d getRegionCenter(int region) {
        return this.getRegionCenter(new Integer(region));
    }

    public Vec3d getRegionCenter(String region) {
        return this.getRegionCenter(region);
    }

    public NumericVector getRegionCoordIndices(int tempRegion) {
        if (!this.region.isConnected()) {
            return new NumericVector();
        }
        NumericVector coordIndexVector = new NumericVector();
        try {
            RegionDef regionDef = (RegionDef)this.regionHashtable.get(new Integer(tempRegion));
            for (int i = regionDef.beginIndex; i <= regionDef.endIndex; ++i) {
                coordIndexVector.addValue(this.coordVector.getValue(i));
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return coordIndexVector;
    }

    public NumericVector getRegionCoordIndices(String tempRegion) {
        if (!this.stringRegion.isConnected()) {
            return new NumericVector();
        }
        NumericVector coordIndexVector = new NumericVector();
        try {
            RegionDef regionDef = (RegionDef)this.regionHashtable.get(tempRegion);
            for (int i = regionDef.beginIndex; i <= regionDef.endIndex; ++i) {
                coordIndexVector.addValue(this.coordVector.getValue(i));
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return coordIndexVector;
    }

    public boolean isRegionNumeric() {
        return this.region.isConnected();
    }

    @Override
    public SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        int ifsIndex = startIndex + entryLength - 2;
        SelectEntry entry = (SelectEntry)nameStack.elementAt(ifsIndex);
        AIndexedFaceSet ifs = (AIndexedFaceSet)entry.getElement();
        IndexedFaceSetDetail ifsDetail = (IndexedFaceSetDetail)ifs.getSelectDetail(rawDetail, startIndex);
        int faceIndex = ifsDetail.getIndex();
        MapDetail mapDetail = new MapDetail(this, faceIndex);
        mapDetail.computeDetails();
        return mapDetail;
    }

    protected Vec3d getRegionCenter(Object regionKey) {
        Vec3d center;
        NumericVector coordIndexVector = new NumericVector();
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        double xVal = 0.0;
        double yVal = 0.0;
        int currentIndex = 0;
        double maxSize = 0.0;
        double tSize = 0.0;
        this.init(this.tempIA);
        RegionDef regionDef = (RegionDef)this.regionHashtable.get(regionKey);
        if (regionDef == null) {
            return null;
        }
        int maxBeginIndex = regionDef.beginIndex;
        int maxEndIndex = regionDef.endIndex;
        int currentBeginIndex = regionDef.beginIndex;
        try {
            int i;
            for (i = regionDef.beginIndex; i <= regionDef.endIndex; ++i) {
                currentIndex = (int)this.coordVector.getValue(i);
                if (i == currentBeginIndex) {
                    xMin = xMax = this.x.getValue(currentIndex);
                    yMin = yMax = this.y.getValue(currentIndex);
                }
                if (currentIndex == -1 || currentIndex == -2) {
                    tSize = Math.pow((xMax - xMin) * (xMax - xMin) + (yMax - yMin) * (yMax - yMin), 0.5);
                    if (tSize > maxSize) {
                        maxBeginIndex = currentBeginIndex;
                        maxEndIndex = i - 1;
                        maxSize = tSize;
                    }
                    currentBeginIndex = i + 1;
                    continue;
                }
                xVal = this.x.getValue(currentIndex);
                yVal = this.y.getValue(currentIndex);
                xMin = Math.min(xMin, xVal);
                xMax = Math.max(xMax, xVal);
                yMin = Math.min(yMin, yVal);
                yMax = Math.max(yMax, yVal);
            }
            tSize = Math.pow((xMax - xMin) * (xMax - xMin) + (yMax - yMin) * (yMax - yMin), 0.5);
            if (tSize > maxSize) {
                maxBeginIndex = currentBeginIndex;
                maxEndIndex = regionDef.endIndex;
                maxSize = tSize;
            }
            currentBeginIndex = i + 1;
            for (i = maxBeginIndex; i <= maxEndIndex; ++i) {
                coordIndexVector.addValue(this.coordVector.getValue(i));
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        if ((center = this.getCenterWithinPolygon(coordIndexVector)) != null) {
            try {
                int index = this.getFaceFromRegion(regionKey);
                if (this.extrudeOn.getValue(index)) {
                    center.z = this.extrudeThickness.getValue(index);
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return center;
    }

    private int getFaceFromRegion(Object key) {
        int result = -1;
        if (this.isRegionNumeric()) {
            NumericVector v = (NumericVector)this.faces;
            Integer io = (Integer)key;
            result = v.getIndexOf(io.doubleValue());
        }
        return result;
    }

    Vec3d getCenterWithinPolygon(NumericVector indices) {
        if (!this.x.isConnected() || !this.y.isConnected()) {
            return new Vec3d();
        }
        Vec3d centroid = new Vec3d();
        double xMin = 0.0;
        double xMax = 0.0;
        double yMin = 0.0;
        double yMax = 0.0;
        try {
            int j;
            double y1;
            double x1;
            int i;
            Vec3d average = new Vec3d();
            Vec3d newPoint = new Vec3d();
            int beginIndex = (int)indices.getValue(0);
            xMin = this.x.getValue(beginIndex);
            xMax = this.x.getValue(beginIndex);
            yMin = this.y.getValue(beginIndex);
            yMax = this.y.getValue(beginIndex);
            for (i = 0; i < indices.size(); ++i) {
                int currentIndex = (int)indices.getValue(i);
                if (currentIndex == -1) continue;
                x1 = this.x.getValue(currentIndex);
                y1 = this.y.getValue(currentIndex);
                if (x1 < xMin) {
                    xMin = x1;
                }
                if (x1 > xMax) {
                    xMax = x1;
                }
                if (y1 < yMin) {
                    yMin = y1;
                }
                if (y1 > yMax) {
                    yMax = y1;
                }
                average.x += x1;
                average.y += y1;
            }
            average.x /= (double)indices.size();
            average.y /= (double)indices.size();
            centroid.x = (xMin + xMax) * 0.5;
            centroid.y = (yMin + yMax) * 0.5;
            if (indices.size() <= 2 || yMin == yMax) {
                return centroid;
            }
            int n = 0;
            double[] work = new double[indices.size()];
            for (i = 0; i < indices.size() - 1; ++i) {
                int currentIndex1 = (int)indices.getValue(i);
                int currentIndex2 = (int)indices.getValue(i + 1);
                y1 = this.y.getValue(currentIndex1);
                x1 = this.x.getValue(currentIndex1);
                double y2 = this.y.getValue(currentIndex2);
                double x2 = this.x.getValue(currentIndex2);
                if (y1 > y2) {
                    double tempY = y1;
                    y1 = y2;
                    y2 = tempY;
                    double tempX = x1;
                    x1 = x2;
                    x2 = tempX;
                }
                if (!(centroid.y >= y1) || !(centroid.y < y2)) continue;
                newPoint.x = x1 + (centroid.y - y1) / (y2 - y1) * (x2 - x1);
                if (n == 0) {
                    work[0] = newPoint.x;
                } else if (newPoint.x >= work[n - 1]) {
                    work[n] = newPoint.x;
                } else {
                    for (j = n; j > 0 && newPoint.x < work[j - 1]; --j) {
                        work[j] = work[j - 1];
                    }
                    work[j] = newPoint.x;
                }
                ++n;
            }
            switch (n) {
                case 0: {
                    centroid.x = average.x;
                    centroid.y = average.y;
                    break;
                }
                case 2: 
                case 3: {
                    centroid.x = (work[0] + work[1]) * 0.5;
                    break;
                }
                default: {
                    if ((n & 1) != 0) {
                        --n;
                    }
                    j = 0;
                    for (i = 2; i < n; i += 2) {
                        if (!(work[i + 1] - work[i] > work[j + 1] - work[j])) continue;
                        j = i;
                    }
                    centroid.x = (work[j] + work[j + 1]) * 0.5;
                    break;
                }
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return centroid;
    }

    private class RegionDef {
        int beginIndex;
        int endIndex;

        RegionDef() {
        }

        RegionDef(int begin) {
            this.beginIndex = begin;
        }
    }
}

