/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.FilledLineConnector;
import com.sas.graphics.util.vtk.MissingValueException;

public abstract class ALineConnector
extends FilledLineConnector {
    public ALineConnector(ATransform transform) {
        super(transform);
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        this.beginPointX = Double.NaN;
        this.beginPointY = Double.NaN;
        this.beginPointZ = Double.NaN;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        int index = bBoxAction.getValueIndex();
        Vec3d point = bBoxAction.pt1;
        try {
            point.x = this.pointX.getValue(index);
            point.y = this.pointY.getValue(index);
            point.z = this.pointZ.getValue(index);
            BoundingBox box = bBoxAction.getElementBoundingBox();
            box.union(point);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
    }
}

