/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;
import java.awt.Color;
import java.awt.Image;
import java.util.Vector;

public abstract class AImage
extends Element {
    private Vector images = new Vector();
    public final NumericProperty whichImage = new NumericProperty(this, true);
    public final NumericProperty width = new NumericProperty(this, true);
    public final NumericProperty height = new NumericProperty(this, true);
    public final ColorProperty backgroundColor = new ColorProperty(this, true);
    public final BooleanProperty backgroundColorOn = new BooleanProperty(this, true);
    public final IntegerProperty imageScaleType = new IntegerProperty(this, true);
    public final BooleanProperty imageScaleOn = new BooleanProperty(this, true);
    public final IntegerProperty horizontalJustification = new IntegerProperty(this, true);
    public final IntegerProperty verticalJustification = new IntegerProperty(this, true);
    protected static Image waitImage;

    public AImage(ATransform transform) {
        super(transform);
        this.backgroundColorOn.setValue(false);
        this.backgroundColor.setValue(Color.white);
        this.width.setValue(0.1);
        this.height.setValue(0.1);
        this.imageScaleType.setValue(1);
        this.imageScaleOn.setValue(false);
        this.horizontalJustification.setValue(0);
        this.verticalJustification.setValue(0);
        waitImage = null;
    }

    public void addImage(Image aImage) {
        this.images.addElement(aImage);
    }

    public Image getImage(int i) {
        Image result = null;
        int size = this.images.size();
        if (size != 0) {
            if (i > size - 1) {
                i = size - 1;
            }
            result = (Image)this.images.elementAt(i);
        }
        return result;
    }

    public boolean removeImage(Image aImage) {
        return this.images.removeElement(aImage);
    }

    public void removeAllImages() {
        this.images.removeAllElements();
    }

    public int getImageCount() {
        return this.images.size();
    }

    public void setWaitImage(Image aImage) {
        waitImage = aImage;
    }

    public Image getWaitImage() {
        return waitImage;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d center = bBoxAction.pt1;
        Vec3d size = bBoxAction.pt2;
        double w = this.width.getValue(index);
        double h = this.height.getValue(index);
        center.z = 0.0;
        size.set(w, h, 0.0);
        switch (this.horizontalJustification.getValue(index)) {
            case 2: 
            case 3: {
                center.x = -(w / 2.0);
                break;
            }
            case 1: {
                center.x = 0.0;
                break;
            }
            case 0: {
                center.x = w / 2.0;
            }
        }
        switch (this.verticalJustification.getValue(index)) {
            case 0: {
                center.y = -(h / 2.0);
                break;
            }
            case 1: {
                center.y = 0.0;
                break;
            }
            case 2: 
            case 3: {
                center.y = h / 2.0;
            }
        }
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }
}

