/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.vtk.ATransform;
import com.sas.graphics.util.vtk.BooleanProperty;
import com.sas.graphics.util.vtk.ColorProperty;
import com.sas.graphics.util.vtk.Element;
import com.sas.graphics.util.vtk.IntegerProperty;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;

public abstract class ACylinder
extends Element {
    public final NumericProperty radius = new NumericProperty(this, true);
    public final NumericProperty height = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final ColorProperty edgeColor = new ColorProperty(this, true);
    public final BooleanProperty edgeOn = new BooleanProperty(this, true);
    public final BooleanProperty fillOn = new BooleanProperty(this, true);
    public final BooleanProperty sideVisible = new BooleanProperty(this, true);
    public final BooleanProperty sideEdgesVisible = new BooleanProperty(this, true);
    public final BooleanProperty topVisible = new BooleanProperty(this, true);
    public final BooleanProperty bottomVisible = new BooleanProperty(this, true);
    public final IntegerProperty precision = new IntegerProperty(this, true);
    public final IntegerProperty origin = new IntegerProperty(this, true);
    public static final int ORIGIN_CENTER = 0;
    public static final int ORIGIN_CENTER_LEFT = 1;
    public static final int ORIGIN_CENTER_RIGHT = 2;
    public static final int ORIGIN_CENTER_BOTTOM = 3;
    public static final int ORIGIN_CENTER_TOP = 4;
    protected static double[] x;
    protected static double[] z;
    protected static int lastPrecision;

    protected ACylinder(ATransform transform) {
        super(transform);
        this.radius.setValue(1.0);
        this.height.setValue(2.0);
        this.precision.setValue(16);
        this.sideVisible.setValue(true);
        this.sideEdgesVisible.setValue(false);
        this.topVisible.setValue(true);
        this.bottomVisible.setValue(true);
        this.origin.setValue(0);
        this.edgeOn.setValue(false);
        this.fillOn.setValue(true);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        Vec3d size = bBoxAction.pt1;
        Vec3d center = bBoxAction.pt2;
        double rad = this.radius.getValue(index);
        double hgt = this.height.getValue(index);
        size.set(rad * 2.0, hgt, rad * 2.0);
        ACylinder.computeCenter(rad, hgt, this.origin.getValue(index), center);
        BoundingBox box = bBoxAction.getElementBoundingBox();
        box.union(center, size);
    }

    public static void computeCenter(double radius, double height, int origin, Vec3d center) {
        double thgt = height / 2.0;
        double bhgt = -1.0 * thgt;
        switch (origin) {
            case 1: {
                center.set(radius, 0.0, 0.0);
                break;
            }
            case 2: {
                center.set(-radius, 0.0, 0.0);
                break;
            }
            case 3: {
                center.set(0.0, thgt, 0.0);
                break;
            }
            case 4: {
                center.set(0.0, bhgt, 0.0);
                break;
            }
            default: {
                center.set(0.0, 0.0, 0.0);
            }
        }
    }

    protected static void calculatePoints(int precision) {
        x = new double[precision + 1];
        z = new double[precision + 1];
        double angle = 0.0;
        for (int i = 0; i <= precision; ++i) {
            angle = (double)i / (double)precision * (Math.PI * 2);
            ACylinder.x[i] = Math.cos(angle);
            ACylinder.z[i] = -Math.sin(angle);
        }
    }

    static {
        lastPrecision = -1;
        x = null;
        z = null;
    }
}

