/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.vtk;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.vtk.AAxis;
import com.sas.graphics.util.vtk.AGrid;
import com.sas.graphics.util.vtk.ANetworkRoot;
import com.sas.graphics.util.vtk.AxisStyle;
import com.sas.graphics.util.vtk.GridStyle;
import com.sas.graphics.util.vtk.NumericMapper;
import com.sas.graphics.util.vtk.NumericPipe;
import com.sas.graphics.util.vtk.TextStyle;
import java.awt.Font;
import java.util.Vector;

public abstract class AAxisSet {
    protected Vector xAxes = new Vector();
    protected Vector yAxes = new Vector();
    protected Vector zAxes = new Vector();
    protected Vector polarAxes = new Vector();
    protected Vector[] axes = new Vector[]{this.xAxes, this.yAxes, this.zAxes, this.polarAxes};
    protected Vector floorGrids = new Vector();
    protected Vector sideGrids = new Vector();
    protected Vector backGrids = new Vector();
    protected ANetworkRoot networkRoot;
    protected Vec3d origin;
    protected Vec3d size;
    protected BoundingBox bbox;
    protected int prevAzimuthZone = -1;
    protected int prevInclineZone = -1;
    static final int initialZone = -1;
    protected static double radians2degrees = 57.29577951308232;
    protected boolean perspective = true;
    Font font4titles;
    private Vec3d yAxisNormal = Vec3d.getYAxis();
    private Vec3d negativeYAxisNormal = Vec3d.getNegativeYAxis();
    private Vec3d xAxisNormal = Vec3d.getXAxis();
    private Vec3d negativeXAxisNormal = Vec3d.getNegativeXAxis();
    private Vec3d zAxisNormal = Vec3d.getZAxis();
    private Vec3d negativeZAxisNormal = Vec3d.getNegativeZAxis();

    public AAxisSet() {
        this.origin = new Vec3d(0.0, 0.0, 0.0);
        this.size = new Vec3d(1.0, 1.0, 1.0);
    }

    protected void newXAxis(AAxis axis, NumericMapper aMapper) {
        int i;
        this.xAxes.addElement(axis);
        axis.setOrigin(this.origin.x);
        AxisStyle aStyle = axis.getStyle();
        aStyle.setAxisLineOn(this.floorGrids.size() == 0 && this.backGrids.size() == 0);
        TextStyle labelStyle = aStyle.getLabelStyle();
        labelStyle.setStagger(true);
        labelStyle.setFit(true);
        TextStyle titleStyle = aStyle.getTitleStyle();
        this.font4titles = FontManager.getFont((String)titleStyle.getFont().getName(), (int)1, (int)16);
        titleStyle.setFont(this.font4titles);
        titleStyle.setVerticalJustification(0);
        for (i = 0; i < this.backGrids.size(); ++i) {
            ((AGrid)this.backGrids.elementAt((int)i)).verticalLineOffset.connectFrom(aMapper.uniqueValue);
        }
        for (i = 0; i < this.floorGrids.size(); ++i) {
            ((AGrid)this.floorGrids.elementAt((int)i)).verticalLineOffset.connectFrom(aMapper.uniqueValue);
        }
    }

    protected void newYAxis(AAxis axis, NumericMapper aMapper) {
        int i;
        this.yAxes.addElement(axis);
        axis.setOrigin(this.origin.y);
        axis.setTitlePosition(2);
        AxisStyle aStyle = axis.getStyle();
        aStyle.setAxisLineOn(this.sideGrids.size() == 0 && this.backGrids.size() == 0);
        TextStyle labelStyle = aStyle.getLabelStyle();
        labelStyle.setStagger(false);
        labelStyle.setFit(false);
        TextStyle titleStyle = aStyle.getTitleStyle();
        if (this.font4titles == null) {
            this.font4titles = FontManager.getFont((String)titleStyle.getFont().getName(), (int)1, (int)16);
        }
        titleStyle.setFont(this.font4titles);
        titleStyle.setAngle(0.0);
        for (i = 0; i < this.backGrids.size(); ++i) {
            ((AGrid)this.backGrids.elementAt((int)i)).horizontalLineOffset.connectFrom(aMapper.uniqueValue);
        }
        for (i = 0; i < this.sideGrids.size(); ++i) {
            ((AGrid)this.sideGrids.elementAt((int)i)).horizontalLineOffset.connectFrom(aMapper.uniqueValue);
        }
    }

    protected void newZAxis(AAxis axis, NumericMapper aMapper) {
        int i;
        this.zAxes.addElement(axis);
        axis.setOrigin(this.origin.z);
        axis.setLabelOrientation(2);
        AxisStyle aStyle = axis.getStyle();
        aStyle.setAxisLineOn(this.sideGrids.size() == 0 && this.floorGrids.size() == 0);
        TextStyle labelStyle = aStyle.getLabelStyle();
        labelStyle.setStagger(true);
        labelStyle.setFit(true);
        TextStyle titleStyle = aStyle.getTitleStyle();
        if (this.font4titles == null) {
            this.font4titles = FontManager.getFont((String)titleStyle.getFont().getName(), (int)1, (int)16);
        }
        titleStyle.setFont(this.font4titles);
        for (i = 0; i < this.sideGrids.size(); ++i) {
            ((AGrid)this.sideGrids.elementAt((int)i)).verticalLineOffset.connectFrom(aMapper.uniqueValue);
        }
        for (i = 0; i < this.floorGrids.size(); ++i) {
            ((AGrid)this.floorGrids.elementAt((int)i)).horizontalLineOffset.connectFrom(aMapper.uniqueValue);
        }
    }

    protected void newPolar(AAxis axis, NumericMapper aMapper) {
        this.polarAxes.addElement(axis);
        axis.labels.connectFrom(aMapper.label);
        axis.labelOffset.connectFrom(aMapper.uniqueValue);
        axis.setLabelOrientation(1);
        switch (axis.getOrientation()) {
            case 1: {
                axis.setOrigin(this.origin.x);
                axis.setLength(Math.min(this.size.y, this.size.z));
                break;
            }
            case 2: {
                axis.setOrigin(this.origin.y);
                axis.setLength(Math.min(this.size.x, this.size.z));
                break;
            }
            case 3: {
                axis.setOrigin(this.origin.z);
                axis.setLength(Math.min(this.size.x, this.size.y));
            }
        }
        AxisStyle aStyle = axis.getStyle();
        aStyle.setAxisLineOn(true);
        aStyle.getLabelStyle().setStagger(false);
        aStyle.getLabelStyle().setFit(false);
        TextStyle titleStyle = aStyle.getTitleStyle();
        this.font4titles = FontManager.getFont((String)titleStyle.getFont().getName(), (int)1, (int)16);
        titleStyle.setFont(this.font4titles);
        titleStyle.setVerticalJustification(0);
    }

    protected void newFloorGrid(AGrid floorGrid, NumericMapper horizMap, NumericMapper vertMap) {
        this.floorGrids.addElement(floorGrid);
        floorGrid.selectEnabled.setValue(false);
        GridStyle floorStyle = new GridStyle();
        floorStyle.setBackgroundOn(true);
        floorStyle.setBorderOn(true);
        floorGrid.setStyle(floorStyle);
        floorGrid.setWidth(this.size.x);
        floorGrid.setHeight(this.size.z);
        floorGrid.setNormal(this.yAxisNormal);
        if (vertMap != null) {
            floorGrid.horizontalLineOffset.connectFrom(vertMap.uniqueValue);
        }
        if (horizMap != null) {
            floorGrid.verticalLineOffset.connectFrom(horizMap.uniqueValue);
        }
    }

    protected void newSideGrid(AGrid sideGrid, NumericMapper horizMap, NumericMapper vertMap) {
        this.sideGrids.addElement(sideGrid);
        sideGrid.selectEnabled.setValue(false);
        GridStyle sideGridStyle = new GridStyle();
        sideGridStyle.setBackgroundOn(true);
        sideGridStyle.setBorderOn(true);
        sideGrid.setStyle(sideGridStyle);
        sideGrid.setWidth(this.size.z);
        sideGrid.setHeight(this.size.y);
        sideGrid.setNormal(this.xAxisNormal);
        if (horizMap != null) {
            sideGrid.horizontalLineOffset.connectFrom(horizMap.uniqueValue);
        }
        if (vertMap != null) {
            sideGrid.verticalLineOffset.connectFrom(vertMap.uniqueValue);
        }
    }

    protected void newBackGrid(AGrid backGrid, NumericMapper horizMap, NumericMapper vertMap) {
        this.backGrids.addElement(backGrid);
        backGrid.selectEnabled.setValue(false);
        GridStyle backGridStyle = new GridStyle();
        backGridStyle.setBackgroundOn(true);
        backGridStyle.setBorderOn(true);
        backGrid.setStyle(backGridStyle);
        backGrid.setWidth(this.size.x);
        backGrid.setHeight(this.size.y);
        backGrid.setNormal(this.zAxisNormal);
        if (horizMap != null) {
            backGrid.verticalLineOffset.connectFrom(horizMap.uniqueValue);
        }
        if (vertMap != null) {
            backGrid.horizontalLineOffset.connectFrom(vertMap.uniqueValue);
        }
    }

    public void swapXandY() {
        AGrid grid;
        int i;
        Vector swapper = this.xAxes;
        this.xAxes = this.yAxes;
        this.yAxes = swapper;
        this.resetXaxes();
        this.resetYaxes();
        swapper = this.floorGrids;
        this.floorGrids = this.sideGrids;
        this.sideGrids = swapper;
        for (i = 0; i < this.floorGrids.size(); ++i) {
            grid = (AGrid)this.floorGrids.elementAt(i);
            grid.transform.translateX.setValue(0.0);
            grid.setHeight(grid.getWidth());
            grid.setWidth(this.size.x);
            this.transposeGrid(grid);
        }
        for (i = 0; i < this.sideGrids.size(); ++i) {
            grid = (AGrid)this.sideGrids.elementAt(i);
            grid.transform.translateY.setValue(0.0);
            grid.setWidth(grid.getHeight());
            grid.setHeight(this.size.y);
            this.transposeGrid(grid);
        }
        for (i = 0; i < this.backGrids.size(); ++i) {
            grid = (AGrid)this.backGrids.elementAt(i);
            this.transposeGrid(grid);
        }
        this.reconfigure(this.prevAzimuthZone, this.prevInclineZone);
    }

    public void swapXandZ() {
        AGrid grid;
        int i;
        Vector swapper = this.xAxes;
        this.xAxes = this.zAxes;
        this.zAxes = swapper;
        this.resetXaxes();
        this.resetZaxes();
        swapper = this.backGrids;
        this.backGrids = this.sideGrids;
        this.sideGrids = swapper;
        for (i = 0; i < this.backGrids.size(); ++i) {
            grid = (AGrid)this.backGrids.elementAt(i);
            grid.transform.translateX.setValue(0.0);
            grid.setWidth(this.size.x);
        }
        for (i = 0; i < this.sideGrids.size(); ++i) {
            grid = (AGrid)this.sideGrids.elementAt(i);
            grid.transform.translateZ.setValue(0.0);
            grid.setWidth(this.size.z);
        }
        for (i = 0; i < this.floorGrids.size(); ++i) {
            grid = (AGrid)this.floorGrids.elementAt(i);
            this.transposeGrid(grid);
        }
        this.reconfigure(this.prevAzimuthZone, this.prevInclineZone);
    }

    public void swapYandZ() {
        AGrid grid;
        int i;
        Vector swapper = this.zAxes;
        this.zAxes = this.yAxes;
        this.yAxes = swapper;
        this.resetYaxes();
        this.resetZaxes();
        swapper = this.floorGrids;
        this.floorGrids = this.backGrids;
        this.backGrids = swapper;
        for (i = 0; i < this.floorGrids.size(); ++i) {
            grid = (AGrid)this.floorGrids.elementAt(i);
            grid.transform.translateZ.setValue(0.0);
            grid.setHeight(this.size.z);
        }
        for (i = 0; i < this.backGrids.size(); ++i) {
            grid = (AGrid)this.backGrids.elementAt(i);
            grid.transform.translateY.setValue(0.0);
            grid.setHeight(this.size.y);
        }
        for (i = 0; i < this.sideGrids.size(); ++i) {
            grid = (AGrid)this.sideGrids.elementAt(i);
            this.transposeGrid(grid);
        }
        this.reconfigure(this.prevAzimuthZone, this.prevInclineZone);
    }

    private void resetXaxes() {
        for (int i = 0; i < this.xAxes.size(); ++i) {
            AAxis axis = (AAxis)this.xAxes.elementAt(i);
            axis.setOrientation(1);
            axis.setOrigin(this.origin.x);
            axis.setLength(this.size.x);
            axis.transform.translateX.setValue(0.0);
        }
    }

    private void resetYaxes() {
        for (int i = 0; i < this.yAxes.size(); ++i) {
            AAxis axis = (AAxis)this.yAxes.elementAt(i);
            axis.setOrientation(2);
            axis.setOrigin(this.origin.y);
            axis.setLength(this.size.y);
            axis.transform.translateY.setValue(0.0);
        }
    }

    private void resetZaxes() {
        for (int i = 0; i < this.zAxes.size(); ++i) {
            AAxis axis = (AAxis)this.zAxes.elementAt(i);
            axis.setOrientation(3);
            axis.setOrigin(this.origin.z);
            axis.setLength(this.size.z);
            axis.transform.translateZ.setValue(0.0);
        }
    }

    private void transposeGrid(AGrid grid) {
        if (grid.verticalLineOffset.isConnected()) {
            if (grid.horizontalLineOffset.isConnected()) {
                NumericPipe aPipe = (NumericPipe)grid.verticalLineOffset.getConnection();
                grid.verticalLineOffset.connectFrom((NumericPipe)grid.horizontalLineOffset.getConnection());
                grid.horizontalLineOffset.connectFrom(aPipe);
            } else {
                grid.horizontalLineOffset.connectFrom((NumericPipe)grid.verticalLineOffset.getConnection());
                grid.verticalLineOffset.disconnect();
            }
        } else if (grid.horizontalLineOffset.isConnected()) {
            grid.verticalLineOffset.connectFrom((NumericPipe)grid.horizontalLineOffset.getConnection());
            grid.horizontalLineOffset.disconnect();
        }
    }

    private int zone(double angle) {
        double a;
        return (int)((a += (a = angle % 360.0) < 0.0 ? 540.0 : 180.0) / 45.0) % 8;
    }

    public void setView(Vec3d eye, Vec3d focal) {
        double dx = eye.x - focal.x;
        double dy = eye.y - focal.y;
        double dz = eye.z - focal.z;
        this.setView(Math.atan2(dz, dx) * radians2degrees, Math.atan2(Math.sqrt(dx * dx + dz * dz), eye.y - focal.y) * radians2degrees, Math.sqrt(dx * dx + dy * dy + dz * dz));
    }

    public void setView(double azimuth, double incline, double distance) {
        int aZone = this.zone(azimuth);
        int iZone = this.zone(incline);
        if (aZone != this.prevAzimuthZone || iZone != this.prevInclineZone) {
            this.reconfigure(aZone, iZone);
            this.prevAzimuthZone = aZone;
            this.prevInclineZone = iZone;
        }
    }

    public void setBoundingBox(BoundingBox bb) {
        this.bbox = bb;
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    private int reverse(int justification) {
        if (justification == 1) {
            return justification;
        }
        if (justification == 0) {
            return 2;
        }
        return 0;
    }

    private void reconfigure(int azimuthZone, int inclineZone) {
        AGrid grid;
        int pos;
        double altitude;
        int just;
        double offset;
        AAxis axis;
        int i;
        double noIntersect = 1.0E-4;
        for (i = 0; i < this.xAxes.size(); ++i) {
            axis = (AAxis)this.xAxes.elementAt(i);
            if (azimuthZone >= 2 && azimuthZone <= 5) {
                offset = this.size.z + noIntersect;
                if (axis.getLabelOrientation() != 2) {
                    axis.setPrimary(false);
                }
            } else {
                offset = 0.0 - noIntersect;
                if (axis.getLabelOrientation() != 2) {
                    axis.setPrimary(true);
                }
            }
            just = 0;
            if (inclineZone > 3) {
                altitude = this.size.y + noIntersect;
                if (axis.getLabelOrientation() == 2) {
                    axis.setPrimary(false);
                } else {
                    just = 3;
                }
            } else {
                altitude = -noIntersect;
                if (axis.getLabelOrientation() == 2) {
                    axis.setPrimary(true);
                }
            }
            axis.transform.translateZ.setValue(offset);
            axis.transform.translateY.setValue(altitude);
            axis.getStyle().getLabelStyle().setVerticalJustification(just);
            axis.getStyle().getTitleStyle().setVerticalJustification(just);
            switch (azimuthZone) {
                default: {
                    pos = 1;
                    just = 1;
                    break;
                }
                case 1: {
                    pos = 0;
                    just = 2;
                    break;
                }
                case 2: {
                    pos = 0;
                    if (axis.getLabelOrientation() == 2) {
                        just = 0;
                        break;
                    }
                    just = 2;
                    break;
                }
                case 6: {
                    pos = 2;
                    just = 0;
                    break;
                }
                case 5: {
                    pos = 2;
                    just = axis.getLabelOrientation() == 2 ? 2 : 0;
                }
            }
            axis.setTitlePosition(pos);
            axis.getStyle().getLabelStyle().setHorizontalJustification(just);
            axis.getStyle().getTitleStyle().setHorizontalJustification(just);
        }
        for (i = 0; i < this.yAxes.size(); ++i) {
            axis = (AAxis)this.yAxes.elementAt(i);
            offset = azimuthZone < 4 ? 0.0 : this.size.x;
            axis.transform.translateX.setValue(offset);
            if (inclineZone > 3) {
                pos = 0;
                just = 0;
            } else {
                pos = 2;
                just = 3;
            }
            axis.setTitlePosition(pos);
            axis.getStyle().getTitleStyle().setVerticalJustification(just);
            offset = 0.0;
            switch (azimuthZone) {
                case 6: {
                    offset = this.size.z;
                    axis.setPrimary(false);
                    just = 0;
                    axis.setLabelOrientation(3);
                    break;
                }
                case 7: {
                    offset = this.size.z;
                    axis.setPrimary(false);
                    just = 0;
                    axis.setLabelOrientation(1);
                    break;
                }
                case 2: {
                    axis.setPrimary(true);
                    just = 2;
                    axis.setLabelOrientation(3);
                    break;
                }
                case 3: {
                    axis.setPrimary(true);
                    just = 2;
                    axis.setLabelOrientation(1);
                    break;
                }
                case 0: {
                    offset = this.size.z;
                    axis.setPrimary(true);
                    just = 0;
                    axis.setLabelOrientation(1);
                    break;
                }
                case 1: {
                    offset = this.size.z;
                    axis.setPrimary(false);
                    just = 2;
                    axis.setLabelOrientation(3);
                    break;
                }
                case 4: {
                    axis.setPrimary(false);
                    just = 2;
                    axis.setLabelOrientation(1);
                    break;
                }
                default: {
                    axis.setPrimary(true);
                    just = 0;
                    axis.setLabelOrientation(3);
                }
            }
            axis.transform.translateZ.setValue(offset);
            axis.getStyle().getLabelStyle().setHorizontalJustification(just);
        }
        for (i = 0; i < this.zAxes.size(); ++i) {
            axis = (AAxis)this.zAxes.elementAt(i);
            offset = azimuthZone > 3 ? this.size.x : 0.0;
            altitude = inclineZone > 3 ? this.size.y : 0.0;
            axis.transform.translateX.setValue(offset);
            axis.transform.translateY.setValue(altitude);
            if (axis.getLabelOrientation() == 2) {
                axis.setPrimary(inclineZone < 4);
            } else {
                axis.setPrimary(azimuthZone < 4);
            }
            switch (azimuthZone) {
                case 7: {
                    pos = 0;
                    if (axis.getLabelOrientation() == 2) {
                        just = 2;
                        break;
                    }
                    just = 0;
                    break;
                }
                case 4: {
                    pos = 2;
                    if (axis.getLabelOrientation() == 2) {
                        just = 0;
                        break;
                    }
                    just = 2;
                    break;
                }
                default: {
                    pos = 1;
                    just = 1;
                    break;
                }
                case 0: {
                    pos = 0;
                    just = 0;
                    break;
                }
                case 3: {
                    pos = 2;
                    just = 2;
                }
            }
            axis.setTitlePosition(pos);
            axis.getStyle().getLabelStyle().setHorizontalJustification(just);
            axis.getStyle().getTitleStyle().setHorizontalJustification(just);
        }
        for (i = 0; i < this.polarAxes.size(); ++i) {
            offset = 0.0;
            axis = (AAxis)this.polarAxes.elementAt(i);
            boolean reversible = axis.getLabelOrientation() == axis.getOrientation();
            axis.setTitlePosition(2);
            axis.getStyle().getTitleStyle().setHorizontalJustification(1);
            switch (axis.getOrientation()) {
                case 1: {
                    boolean secondary = azimuthZone < 4;
                    double d = offset = secondary ? this.size.x : 0.0;
                    if (!reversible) break;
                    axis.setPrimary(!secondary);
                    break;
                }
                case 2: {
                    boolean secondary = inclineZone > 3;
                    double d = offset = secondary ? this.size.y : 0.0;
                    if (!reversible) break;
                    axis.setPrimary(!secondary);
                    break;
                }
                default: {
                    boolean secondary = azimuthZone < 2 || azimuthZone > 5;
                    double d = offset = secondary ? this.size.z : 0.0;
                    if (!reversible) break;
                    axis.setPrimary(!secondary);
                }
            }
            axis.setOrigin(offset);
        }
        for (i = 0; i < this.sideGrids.size(); ++i) {
            grid = (AGrid)this.sideGrids.elementAt(i);
            if (azimuthZone < 4) {
                grid.transform.translateX.setValue(this.size.x);
                grid.setNormal(this.negativeXAxisNormal);
                continue;
            }
            grid.transform.translateX.setValue(0.0);
            grid.setNormal(this.xAxisNormal);
        }
        for (i = 0; i < this.backGrids.size(); ++i) {
            grid = (AGrid)this.backGrids.elementAt(i);
            if (azimuthZone < 2 || azimuthZone > 5) {
                grid.transform.translateZ.setValue(this.size.z);
                grid.setNormal(this.negativeZAxisNormal);
                continue;
            }
            grid.transform.translateZ.setValue(0.0);
            grid.setNormal(this.zAxisNormal);
        }
        for (i = 0; i < this.floorGrids.size(); ++i) {
            grid = (AGrid)this.floorGrids.elementAt(i);
            if (inclineZone > 3) {
                grid.transform.translateY.setValue(this.size.y);
                grid.setNormal(this.negativeYAxisNormal);
                continue;
            }
            grid.transform.translateY.setValue(0.0);
            grid.setNormal(this.yAxisNormal);
        }
        this.networkRoot.build();
    }

    public void setPerspective(boolean trueorfalse) {
        this.perspective = trueorfalse;
    }

    public boolean isPerspective() {
        return this.perspective;
    }

    public void setOrigin(double x, double y, double z) {
        int i;
        this.origin.set(x, y, z);
        for (i = 0; i < this.xAxes.size(); ++i) {
            ((AAxis)this.xAxes.elementAt(i)).setOrigin(x);
        }
        for (i = 0; i < this.yAxes.size(); ++i) {
            ((AAxis)this.yAxes.elementAt(i)).setOrigin(y);
        }
        for (i = 0; i < this.zAxes.size(); ++i) {
            ((AAxis)this.zAxes.elementAt(i)).setOrigin(z);
        }
    }

    public void setSize(double xSize, double ySize, double zSize) {
        this.size.set(xSize, ySize, zSize);
    }

    protected double getGreatestDimension() {
        return Math.max(this.size.x, Math.max(this.size.y, this.size.z));
    }
}

