/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.WireLegend;

class WireLegend2
extends WireLegend {
    protected boolean planeGridLineVisible = true;
    protected float maxSize = 0.0f;

    public WireLegend2(Mapper aMapper) {
        super(aMapper);
    }

    @Override
    protected void addGeometry(Channel ch) {
        if (this.planeGridLineVisible) {
            super.addGeometry(ch);
        }
    }

    @Override
    protected void addValues(Channel ch, Vec3f startPt, String majorJustify, String minorJustify) {
        boolean skip;
        int inc;
        if (this.incrementVector.y != 0.0f && !this.hideTickMark) {
            this.tickSize = (float)ch.glGetTextWidth("--");
        }
        if (!this.valuesVisible) {
            this.vLegendOffset += this.tickSize;
            return;
        }
        Vec3f startPoint = new Vec3f(startPt);
        if (this.startingOffset != 0.0f) {
            Vec3f ov = new Vec3f(this.incrementVector);
            ov.normalize();
            ov.scale(-this.startingOffset);
            startPoint.add(ov);
        }
        if (majorJustify.equals("RIGHT")) {
            super.addValues(ch, startPt, majorJustify, minorJustify);
            return;
        }
        boolean toggle = true;
        int maxChars = this.valueStyle.getMaxChars();
        if (this.startingOffset != 0.0f) {
            Vec3f ov = new Vec3f(this.incrementVector);
            ov.normalize();
            ov.scale(-this.startingOffset);
            startPt.add(ov);
        }
        ch.glSelect2DFont(this.valueStyle.createFont());
        ch.glColor(this.valueStyle.getColor());
        float len = this.findMaxValueLength(ch, false);
        this.hLegendOffset += len + this.tickSize;
        if (this.valueHeight > this.incrementVector.y) {
            inc = (int)Math.ceil(this.valueHeight / this.incrementVector.y);
            skip = true;
        } else {
            inc = 1;
            skip = false;
        }
        this.valueHotspots = this.isValueHotspotsEnabled() ? new Blob[this.values.length] : null;
        for (int i = 0; i < this.values.length; ++i) {
            Vec3f currentPoint = new Vec3f(startPt);
            Vec3f increment = new Vec3f(this.incrementVector);
            if (this.continuous) {
                increment.normalize();
            }
            increment.scale(this.mapper.getMappedValue(this.values[i]));
            currentPoint.add(increment);
            int yunits = this.continuous ? (int)((double)(currentPoint.y / this.incrementVector.y) + 0.5) : (int)(((double)currentPoint.y - 0.5) / (double)this.incrementVector.y);
            if (i != this.values.length - 1 && skip && yunits % inc != 0) continue;
            ch.glBegin(1);
            ch.glVertex(currentPoint.x, currentPoint.y, currentPoint.z);
            ch.glVertex(currentPoint.x + this.tickSize, currentPoint.y, currentPoint.z);
            ch.glEnd();
            ch.glTextAlign(0, 1);
            if (this.valueHotspots != null) {
                Bbox bbox = new Bbox();
                ch.glGetText2DBbox(this.formattedValues[i].trim(), (double)currentPoint.x + 1.5 * (double)this.tickSize, currentPoint.y, currentPoint.z, this.rotAngle, bbox);
                this.valueHotspots[i] = this.label != null && this.isLabelValueHotspotsEnabled() ? Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim(), this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.label.trim(), this.formattedValues[i].trim()}, new int[]{this.getLabelHotspotID(), this.getValueHotspotID()}, bbox) : Blob.newBlob(ch, new String[]{this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.formattedValues[i].trim()}, new int[]{this.getValueHotspotID()}, bbox);
            }
            ch.gl2DText(this.formattedValues[i].trim(), (double)currentPoint.x + 1.5 * (double)this.tickSize, currentPoint.y, currentPoint.z);
        }
    }

    @Override
    protected void addLabel(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify, boolean flipEndDirection) {
        this.labelHotspots = null;
        if (this.label != null) {
            String labelTrim = this.label.trim();
            int labelDigits = labelTrim.length();
            if (labelDigits > this.labelStyle.getMaxChars()) {
                labelDigits = WireLegend2.ClippingIndex(labelTrim, this.labelStyle.getMaxChars());
                labelTrim = labelTrim.substring(0, labelDigits);
            }
            ch.glSelect2DFont(this.labelStyle.createFont());
            ch.glColor(this.labelStyle.getColor());
            float labelLen = (float)ch.glGetTextWidth(labelTrim);
            Vec3f location = new Vec3f(startPoint);
            Vec3f vec = new Vec3f(this.incrementVector);
            if (this.labelPosition == 1) {
                vec.scale((float)this.intervals / 2.0f);
                location.add(vec);
                vec = new Vec3f(this.endVector);
                vec.normalize();
                if (flipEndDirection) {
                    vec.scale(-1.0f);
                }
                vec.scale(this.vLegendOffset);
                location.add(vec);
                this.vLegendOffset += this.labelHeight;
            } else {
                double maxLen = (double)(this.maxSize + this.hLegendOffset) + this.distortX;
                while ((double)labelLen > maxLen) {
                    labelDigits = WireLegend2.ClippingIndex(labelTrim, labelDigits - 1);
                    labelTrim = labelTrim.substring(0, labelDigits);
                    labelLen = (float)ch.glGetTextWidth(labelTrim);
                    if (labelDigits > this.labelStyle.minChars) continue;
                }
                Vec3f end = new Vec3f(this.endVector);
                end.normalize();
                if (majorJustify.equals("BEGIN")) {
                    if (labelLen / 2.0f > this.hLegendOffset) {
                        end.scale(-this.hLegendOffset);
                    } else {
                        end.scale(-labelLen / 2.0f);
                    }
                } else if (majorJustify.equals("END")) {
                    if (labelLen / 2.0f > this.hLegendOffset) {
                        end.scale(this.hLegendOffset);
                    } else {
                        end.scale(labelLen / 2.0f);
                    }
                }
                location.add(end);
                this.vLegendOffset = this.labelHeight + this.valueHeight / 2.0f;
                if (this.continuous && this.incrementVector.y != 0.0f && startPoint.y != 0.0f) {
                    vec.scale((float)this.intervals + this.origin.y);
                } else if (this.continuous && this.incrementVector.x != 0.0f && startPoint.x != 0.0f) {
                    vec.scale((float)this.intervals + this.origin.x);
                } else {
                    vec.scale(this.intervals);
                }
                location.add(vec);
                vec = new Vec3f(this.incrementVector);
                vec.normalize();
                if (this.vLabelOffset > 0.0f) {
                    vec.scale(this.vLabelOffset);
                } else {
                    vec.scale(this.valueHeight / 2.0f);
                }
                location.add(vec);
                location.z = (float)(-this.zSize);
            }
            ch.glColor(this.labelStyle.getColor());
            if (majorJustify.equals("BEGIN")) {
                ch.glTextAlign(0, 2);
            } else if (majorJustify.equals("END")) {
                ch.glTextAlign(2, 2);
            } else if (this.labelPosition == 1) {
                ch.glTextAlign(1, 0);
            } else {
                ch.glTextAlign(0, 3);
            }
            Object object = this.labelHotspots = this.isLabelValueHotspotsEnabled() || this.isLabelHotspotsEnabled() ? new Blob[1] : null;
            if (this.labelHotspots != null) {
                Bbox bbox = new Bbox();
                ch.glGetText2DBbox(labelTrim, location.x, location.y, location.z, this.rotAngleLabel, bbox);
                this.labelHotspots[0] = Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim()}, new String[]{this.label.trim()}, new int[]{this.getLabelHotspotID()}, bbox);
            }
            ch.gl2DText(labelTrim, location.x, location.y, location.z);
        }
    }
}

