/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ChartElementData;
import com.sas.graphics.util.visualize.DataModel;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.View;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import com.sas.table.StaticTableInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public abstract class Visualization
implements Serializable {
    static final long serialVersionUID = 3259308343722784722L;
    public static final String RB_KEY = "Visualization.";
    protected int width;
    protected int height;
    protected int leftMargin;
    protected int rightMargin;
    protected int topMargin;
    protected int bottomMargin;
    protected float xSize;
    protected float ySize;
    protected float zSize;
    protected float aspect;
    protected float yTitleSize;
    protected float blankSpaceSize;
    protected float xMinLegendSize;
    protected float xMaxLegendSize;
    protected float yMinLegendSize;
    protected float yMaxLegendSize;
    protected float zMinLegendSize;
    protected float zMaxLegendSize;
    protected float xColorLegendSize;
    protected float yColorLegendSize;
    protected String title;
    protected TextStyle titleStyle;
    protected static final int DEFAULT_TITLE_FONT_SIZE = 18;
    protected static final int DEFAULT_TITLE_MAX_CHARS = 128;
    protected static final int DEFAULT_TITLE_MIN_CHARS = 64;
    public static final int DEFAULT_THRESHOLD = 500;
    protected int titleFontPixels;
    protected int leftLegendPixels;
    protected int rightLegendPixels;
    protected int topLegendPixels;
    protected int bottomLegendPixels;
    protected int blankSpacePixels;
    protected int xSizePixels;
    protected int ySizePixels;
    protected static final Color DEFAULT_START_COLOR = new Color(1.0f, 1.0f, 0.0f);
    protected static final Color DEFAULT_END_COLOR = new Color(1.0f, 0.0f, 0.0f);
    protected static final int MIN_WINDOW_SIZE = 240;
    protected static final int MAX_WINDOW_SIZE = 1000;
    public static final int INTERPOLATED_COLOR_MAPPING = 1;
    public static final int TABLE_COLOR_MAPPING = 2;
    protected int colorMapping;
    protected float[] mapValues;
    protected Vector mapColors;
    protected boolean defaultColors;
    protected boolean transparent;
    private static final Color DEFAULT_BACKGROUND_COLOR = SystemColor.window;
    protected Color backgroundColor;
    protected Image backgroundImage;
    protected boolean imageScale;
    protected boolean imageTile;
    protected int imageX0;
    protected int imageY0;
    protected double ambientLightAmount = 0.3;
    protected double diffuseLightAmount = 0.8;
    private static final Color DEFAULT_EDGE_COLOR = Color.gray;
    protected Color edgeColor;
    protected Color feedbackBackgroundColor = new Color(253, 251, 208);
    protected Color feedbackTextColor = Color.black;
    public static final int TWO_DIMENSION = 0;
    public static final int TWO_AND_HALF_DIMENSION = 1;
    public static final int THREE_DIMENSION = 2;
    protected int depthUser;
    protected int depth;
    protected DataModel dataUser;
    protected DataModel data;
    public static final int NO_PICK = 0;
    public static final int FIRST_ENTER_PICK = 1;
    public static final int MOUSE_TIP_PICK = 2;
    protected static final String CENTERTAG = "CTAG";
    protected int pickMode;
    protected boolean doubleBuffer = true;
    public static final int RESOLUTION_HIGH = 0;
    public static final int RESOLUTION_MEDIUM = 1;
    public static final int RESOLUTION_LOW = 2;
    protected int resolution;
    protected int maxObservations;
    protected int numObservations;
    public static final int SCROLL_NONE = 0;
    public static final int SCROLL_UP = 1;
    public static final int SCROLL_DOWN = 2;
    public static final int SCROLL_UP_N_DOWN = 3;
    public static final int DATA_LEFT = 0;
    public static final int DATA_RIGHT = 1;
    public static final int DATA_XPAN = 2;
    public static final int DATA_UP = 3;
    public static final int DATA_DOWN = 4;
    public static final int DATA_YPAN = 5;
    public static final int DATA_FRONT = 6;
    public static final int DATA_BACK = 7;
    public static final int DATA_ZPAN = 8;
    public static final int DATA_NONE = 9;
    protected static final int LABEL_SEGMENT = 0;
    protected static final int LEGEND_SEGMENT = 1;
    protected static final int TITLE_SEGMENT = 2;
    protected static final int OBSERVATION_SEGMENT = 3;
    protected static final int OBSERVATION_SEGMENT2 = 4;
    protected static final int COLOR_LEGEND_LABEL = 5;
    protected static final int COLOR_LEGEND_BODY = 6;
    protected static final int FOOTNOTE_SEGMENT = 7;
    protected static final int AXES_SEGMENT = 8;
    protected static final int SCROLLBAR_SEGMENT = 9;
    protected static final int REFLINE_SEGMENT = 10;
    protected boolean showStatistic;
    protected boolean displayChartType;
    protected int serialVersion;
    private transient Stack hitStack;
    protected transient Stack pickList;
    private transient String[] lastPicked;
    private transient boolean scrollFlag;
    protected transient double scaleFactor;
    protected boolean DEBUG = true;
    protected boolean missingRetained;
    protected String missingSymbol;
    protected transient boolean validVisualization = false;
    public transient String footnote;
    protected transient boolean frequencyPlot = false;
    protected transient int savedDependentStat;
    protected transient boolean simpleGeometry;
    protected transient boolean depthSort;
    protected boolean forceSimpleGeometry;
    protected int thresholdSize;
    protected View view;
    protected transient boolean viewFlag;
    protected transient boolean dirty;
    protected transient boolean buildDone;
    protected float xSizeMin;
    protected float xSizeMax;
    protected float ySizeMin;
    protected float ySizeMax;
    protected float zSizeMin;
    protected float zSizeMax;
    protected transient float verticalSpaceSize;
    protected transient boolean standardView;
    protected boolean dataMode;

    public Visualization() {
        this((String)null);
    }

    public Visualization(String aTitle) {
        this.zSize = 0.0f;
        this.ySize = 0.0f;
        this.xSize = 0.0f;
        this.aspect = 0.75f;
        this.title = aTitle != null ? new String(aTitle) : null;
        this.titleStyle = new TextStyle(18);
        this.titleStyle.setBold(true);
        this.titleStyle.setMaxChars(128);
        this.titleStyle.setMinChars(64);
        this.titleStyle.setSizeRange(18.0);
        this.colorMapping = 1;
        this.defaultColors = true;
        this.transparent = false;
        this.backgroundColor = DEFAULT_BACKGROUND_COLOR;
        this.backgroundImage = null;
        this.imageScale = true;
        this.imageTile = false;
        this.imageX0 = 0;
        this.imageY0 = 0;
        this.edgeColor = DEFAULT_EDGE_COLOR;
        this.data = this.dataUser = new DataModel();
        this.depthUser = 1;
        this.depth = 1;
        this.pickMode = 1;
        this.lastPicked = null;
        this.scaleFactor = 0.0;
        this.resolution = 1;
        this.maxObservations = 0;
        this.numObservations = 0;
        this.showStatistic = false;
        this.displayChartType = false;
        this.missingRetained = true;
        this.missingSymbol = "Missing";
        this.forceSimpleGeometry = true;
        this.thresholdSize = 500;
        this.view = new View();
        this.viewFlag = false;
        this.dataMode = false;
        this.serialVersion = 2;
        this.resetClickedItems();
    }

    public Visualization(Visualization aVisualization) {
        this.xSize = aVisualization.xSize;
        this.ySize = aVisualization.ySize;
        this.zSize = aVisualization.zSize;
        this.xSizeMin = aVisualization.xSizeMin;
        this.ySizeMin = aVisualization.ySizeMin;
        this.zSizeMin = aVisualization.zSizeMin;
        this.xSizeMax = aVisualization.xSizeMax;
        this.ySizeMax = aVisualization.ySizeMax;
        this.zSizeMax = aVisualization.zSizeMax;
        this.aspect = aVisualization.aspect;
        this.leftMargin = aVisualization.leftMargin;
        this.rightMargin = aVisualization.rightMargin;
        this.topMargin = aVisualization.topMargin;
        this.bottomMargin = aVisualization.bottomMargin;
        this.title = aVisualization.title;
        this.titleStyle = new TextStyle(aVisualization.titleStyle);
        this.colorMapping = aVisualization.colorMapping;
        this.mapColors = aVisualization.mapColors;
        this.defaultColors = aVisualization.defaultColors;
        this.transparent = aVisualization.transparent;
        this.backgroundColor = aVisualization.backgroundColor;
        this.backgroundImage = aVisualization.backgroundImage;
        this.imageScale = aVisualization.imageScale;
        this.imageTile = aVisualization.imageTile;
        this.imageX0 = aVisualization.imageX0;
        this.imageY0 = aVisualization.imageY0;
        this.edgeColor = aVisualization.edgeColor;
        this.data = this.dataUser = aVisualization.dataUser;
        this.depth = this.depthUser = aVisualization.depthUser;
        this.pickMode = aVisualization.pickMode;
        this.scaleFactor = 0.0;
        this.resolution = aVisualization.resolution;
        this.maxObservations = aVisualization.maxObservations;
        this.numObservations = aVisualization.numObservations;
        this.showStatistic = aVisualization.showStatistic;
        this.displayChartType = aVisualization.displayChartType;
        this.missingRetained = aVisualization.missingRetained;
        this.missingSymbol = aVisualization.missingSymbol;
        this.forceSimpleGeometry = aVisualization.forceSimpleGeometry;
        this.thresholdSize = aVisualization.thresholdSize;
        this.view = aVisualization.view;
        this.serialVersion = aVisualization.serialVersion;
        this.dataMode = aVisualization.dataMode;
        this.resetClickedItems();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.serialVersion < 2) {
            this.ambientLightAmount = 0.3;
            this.diffuseLightAmount = 0.8;
            this.serialVersion = 2;
        }
    }

    protected boolean depthValid(int depthIn) {
        return depthIn >= 0 && depthIn <= 2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String aTitle) {
        this.title = aTitle;
    }

    public TextStyle getTitleStyle() {
        return this.titleStyle;
    }

    public void setTitleStyle(TextStyle aStyle) {
        this.titleStyle = aStyle;
    }

    public void setRectangularData(StaticTableInterface rectangularDataIn) {
        this.dataUser.setRectangularData(rectangularDataIn);
        if (this.view == null) {
            this.view = new View();
        }
        this.view.resetView();
        this.viewFlag = false;
    }

    public StaticTableInterface getRectangularData() {
        return this.dataUser.getRectangularData();
    }

    public void invalidateVisualization() {
        this.validVisualization = false;
    }

    public void setDepth(int depthIn) {
        if (this.depth == depthIn) {
            return;
        }
        if (this.depthValid(depthIn)) {
            this.depthUser = depthIn;
            this.depth = depthIn;
            this.dirty = true;
        }
    }

    public int getDepth() {
        return this.depthUser;
    }

    public int getColorMapping() {
        return this.colorMapping;
    }

    public void setColorMapping(int type) {
        this.colorMapping = type == 1 ? 1 : 2;
    }

    public void setColorMapping(int type, Color[] colors, float[] values) {
        this.setColorMapping(type);
        this.mapColors = new Vector();
        for (int i = 0; i < colors.length; ++i) {
            this.mapColors.addElement(colors[i]);
        }
        this.mapValues = values;
        this.defaultColors = false;
    }

    public Vector getMapColors() {
        return this.mapColors;
    }

    public void setMapColors(Color[] colors) {
        this.mapColors = new Vector();
        for (int i = 0; i < colors.length; ++i) {
            this.mapColors.addElement(colors[i]);
        }
        this.defaultColors = false;
    }

    public void setMapColors(Vector mapColorsIn) {
        this.mapColors = mapColorsIn;
        this.defaultColors = false;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean aBoolean) {
        this.transparent = aBoolean;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColorIn) {
        this.backgroundColor = backgroundColorIn;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image backgroundImageIn) {
        this.backgroundImage = backgroundImageIn;
    }

    public void setBackgroundImage(Image image, boolean scale, boolean tile, int x, int y) {
        this.backgroundImage = image;
        this.imageScale = scale;
        this.imageTile = tile;
        this.imageX0 = x;
        this.imageY0 = y;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColorIn) {
        this.edgeColor = edgeColorIn;
    }

    public double getTitleFontSize() {
        return this.titleStyle.getSize();
    }

    public void setTitleFontSize(int aInt) {
        this.titleStyle.setSize(aInt);
    }

    public int getPickMode() {
        if (this.pickMode == 1 && (this.is3DPieChart() || this.is3DScatterPlot() || this.isRiserChart())) {
            this.pickMode = 2;
        }
        return this.pickMode;
    }

    public void setPickMode(int aInt) {
        if (aInt != 1 || !this.is3DPieChart() && !this.is3DScatterPlot() && !this.isRiserChart()) {
            this.pickMode = aInt;
        }
    }

    public boolean isPickDoubleBuffered() {
        return this.doubleBuffer;
    }

    public void setPickDoubleBuffered(boolean doubleBuffered) {
        this.doubleBuffer = doubleBuffered;
    }

    public int getMaxObservations() {
        return this.maxObservations;
    }

    public void setMaxObservations(int aInt) {
        this.maxObservations = aInt;
    }

    public boolean isShowStatistic() {
        return this.showStatistic;
    }

    public void setShowStatistic(boolean show) {
        this.showStatistic = show;
    }

    public boolean isDisplayChartType() {
        return this.displayChartType;
    }

    public void setDisplayChartType(boolean show) {
        this.displayChartType = show;
    }

    public void setThresholdSize(int sizeIn) {
        this.thresholdSize = sizeIn;
    }

    public int getThresholdSize() {
        return this.thresholdSize;
    }

    public boolean isForceSimpleGeometry() {
        return this.forceSimpleGeometry;
    }

    public boolean isSimpleGeometry() {
        return this.simpleGeometry;
    }

    public void setForceSimpleGeometry(boolean flag) {
        this.forceSimpleGeometry = flag;
    }

    public boolean isSubsetDataMode() {
        return this.dataMode;
    }

    public void setSubsetDataMode(boolean flag) {
        this.dataMode = flag;
    }

    public boolean validData() {
        if (this.dataUser.getColumnCount() < 1) {
            return false;
        }
        if (this.dataUser.getRowCount() < 1) {
            return false;
        }
        this.dataUser.resetReferences();
        return true;
    }

    public abstract boolean validVariables(boolean var1);

    public abstract void resetVariables(boolean var1);

    protected abstract void validateVariables();

    protected abstract void processDataModel();

    protected abstract void createMappers();

    protected abstract void initializeMappers();

    public Variable[] getAnalysisVariables() {
        return null;
    }

    public Variable[] getClassifierVariables() {
        return null;
    }

    protected abstract void addObservations(Channel var1);

    protected abstract void addLegends(Channel var1);

    protected abstract void addColorLegends(Channel var1);

    protected abstract void setProjection(Channel var1);

    protected abstract void setGeometryProjection(Channel var1);

    protected abstract void setInitialViewpoint(Channel var1);

    public abstract void showChart(Channel var1, Graphics var2);

    public abstract void drawChart(Channel var1, Graphics var2);

    protected void removeLegends() {
    }

    protected void setStraightViewpoint(Channel ch) {
    }

    protected void addAxes(Channel ch) {
    }

    protected void addReferenceLines(Channel ch) {
    }

    protected void addDataScrollbar(Channel ch) {
    }

    protected void setProjection(Channel ch, int depth) {
        int saveDepth = this.depth;
        this.depth = depth;
        this.setProjection(ch);
        this.depth = saveDepth;
    }

    public synchronized void makeModel(Channel ch) {
        if (ch == null) {
            return;
        }
        if (this.view == null) {
            this.view = new View();
        }
        this.data = this.dataUser;
        if (this.maxObservations == 0) {
            this.data.setMaxObservations(Integer.MAX_VALUE);
        } else {
            this.data.setMaxObservations(this.maxObservations);
        }
        this.data.unknownRowCount = 0;
        this.validVisualization = false;
        if (!this.validData()) {
            this.validVisualization = false;
            return;
        }
        try {
            if (!this.validVariables(true)) {
                this.validVisualization = false;
                return;
            }
            this.validVariables(false);
            this.validVisualization = true;
        }
        catch (VisualizationException e) {
            this.validVisualization = false;
            System.out.println(e.getMessage());
            return;
        }
        catch (ClassCastException e) {
            this.validVisualization = false;
            return;
        }
        if (this.dataUser.getRowCount() != this.numObservations) {
            this.view.resetView();
            this.numObservations = this.dataUser.getRowCount();
        }
        this.validateVariables();
        this.postProcessVariables();
        try {
            this.processDataModel();
        }
        catch (OutOfMemoryError e) {
            this.invalidateVisualization(ch);
            System.out.println(RB.getStringResource(RB_KEY, "outOfMem.txt"));
        }
        catch (ClassCastException e) {
            this.validVisualization = false;
            return;
        }
    }

    protected void postProcessVariables() {
        if (this.dataUser.isDerivedFromMDDB()) {
            Variable[] analysisVariables = this.getAnalysisVariables();
            Variable[] classifierVariables = this.getClassifierVariables();
            if (classifierVariables != null && !this.dataUser.isSummable(analysisVariables)) {
                boolean found = false;
                for (int ii = classifierVariables.length - 1; !found && ii >= 0; --ii) {
                    if (classifierVariables[ii] == null) continue;
                    found = this.dataUser.chooseAuxVariables(classifierVariables[ii]);
                }
            }
        }
    }

    public synchronized void makeChart(Channel ch) {
        if (ch == null) {
            return;
        }
        this.simpleGeometry = false;
        this.depthSort = false;
        this.dirty = true;
        this.standardView = false;
        this.buildDone = false;
        this.initializeChannel(ch);
        this.addBackground(ch);
        if (!this.validVisualization) {
            if (this.displayChartType) {
                ch.glNewList(2L, true);
                this.addTitle(ch);
                ch.glEndList();
            }
            this.buildDone = true;
            return;
        }
        this.computeScaleFactor();
        this.adjustAspect(ch);
        this.createMappers();
        this.initializeMappers();
        this.removeLegends();
        if (this.depth != 0) {
            ch.glEnable(3);
        }
        this.buildObservationList(ch);
        ch.glDisable(3);
        ch.glViewport(0, 0, (int)(1.1 * (double)this.xSizePixels), (int)(1.06 * (double)this.ySizePixels));
        this.setProjection(ch);
        this.setInitialViewpoint(ch);
        this.resetLegendSizes(ch);
        ch.glNewList(10L, true);
        this.addReferenceLines(ch);
        ch.glEndList();
        ch.glNewList(9L, true);
        this.addDataScrollbar(ch);
        ch.glEndList();
        ch.glNewList(0L, true);
        this.addLegends(ch);
        ch.glEndList();
        this.setViewport(ch);
        this.setStandardView(ch);
        ch.glNewList(2L, true);
        this.addTitle(ch);
        ch.glEndList();
        ch.glNewList(7L, true);
        this.addFootnote(ch);
        ch.glEndList();
        ch.glNewList(6L, true);
        this.addColorLegends(ch);
        this.addZeroReferenceLines(ch);
        ch.glEndList();
        ch.glNewList(5L, true);
        this.addColorLegendLabels(ch);
        ch.glEndList();
        ch.glNewList(1L, true);
        ch.glCallList(5L);
        ch.glCallList(6L);
        ch.glEndList();
        this.setLegendBoundingBoxes(ch);
        this.setFinalView(ch);
        this.resetLegendSizes(ch);
        ch.glNewList(10L);
        this.addReferenceLines(ch);
        ch.glEndList();
        ch.glNewList(9L);
        this.addDataScrollbar(ch);
        ch.glEndList();
        ch.glNewList(0L);
        this.addLegends(ch);
        ch.glEndList();
        ch.glNewList(8L, true);
        this.addAxes(ch);
        ch.glEndList();
        this.setFinalView(ch);
        this.addLegendHotspots(ch);
        this.addElementHotspots(ch);
        this.buildDone = true;
    }

    public void makeTitle(Channel ch) {
        this.initializeChannel(ch);
        ch.glNewList(2L, true);
        this.addTitle(ch);
        ch.glEndList();
    }

    protected void parseProbeInfo(String[] lastPicked, String[] descriptors, String[] values) {
    }

    protected void resetClickedItems() {
    }

    protected static String _getClickedValue(DataModel dm, int index, Variable variable, DataModel dmFormatter) {
        String value = null;
        if (index >= 0) {
            if (dmFormatter != null) {
                value = dm.getString(variable, index);
                if (value != "0") {
                    value = dmFormatter.format(variable, value);
                }
            } else {
                value = dm.getPrimaryString(variable, index);
            }
        }
        return value == "0" ? null : value;
    }

    protected synchronized void buildObservationList(Channel ch) {
        ch.glNewList(3L, true);
        if (this.edgeColor != null) {
            ch.glPolygonMode(4);
        }
        this.addObservations(ch);
        if (this.edgeColor != null) {
            ch.glPolygonMode(3);
        }
        ch.glEndList();
    }

    public synchronized boolean isPickableLocation(Channel ch, int x, int y) {
        if (ch == null || !this.validVisualization || this.simpleGeometry || this.dirty) {
            return false;
        }
        return this.isPickableHit(ch, x, y);
    }

    private boolean isPickableHit(Channel ch, int x, int y) {
        if (this.hitStack == null) {
            this.hitStack = new Stack();
        } else {
            this.hitStack.removeAllElements();
        }
        ch.gluPickMatrix(x, y, 1, 1);
        ch.glDisable(3);
        ch.glRenderMode(1);
        ch.glSelectBuffer(this.hitStack);
        if (this.depthSort) {
            ch.glEnable(4);
        }
        ch.glCallList(3L, false);
        if (this.depthSort) {
            ch.glDisable(4);
        }
        boolean hit = ch.glRenderMode(0);
        ch.glEnable(3);
        return hit;
    }

    public void buildPickList(Channel ch, int x, int y, int w, int h) {
        if (this.pickList == null) {
            this.pickList = new Stack();
        } else {
            this.pickList.removeAllElements();
        }
        ch.gluPickMatrix(x - w / 2, y - h / 2, w, h);
        ch.glDisable(3);
        ch.glRenderMode(1);
        ch.glSelectBuffer(this.pickList);
        if (this.dirty) {
            this.setGeometryProjection(ch);
        }
        ch.glCallList(3L, this.dirty);
        ch.glRenderMode(0);
        if (this.depth != 2 && this.dirty) {
            this.setProjection(ch);
        }
        ch.glEnable(3);
    }

    public synchronized void pickChart(Channel ch, int x, int y) {
        if (ch == null || !this.validVisualization || this.dirty) {
            return;
        }
        if (this.isPickableHit(ch, x, y) && !this.hitStack.empty()) {
            String[] strs = (String[])this.hitStack.pop();
            String[] descriptors = new String[strs.length];
            String[] values = new String[strs.length];
            this.parseProbeInfo(strs, descriptors, values);
        } else {
            this.resetClickedItems();
        }
    }

    protected ChartElementData parseChartElementData(String[] lastPicked) {
        return null;
    }

    public synchronized ChartElementData pickChartData(Channel ch, int x, int y) {
        if (ch == null || !this.validVisualization || this.dirty) {
            return null;
        }
        if (this.isPickableHit(ch, x, y)) {
            String[] strs = (String[])this.hitStack.pop();
            return this.parseChartElementData(strs);
        }
        return null;
    }

    public synchronized void probeChart(Channel ch, int x, int y) {
        if (ch == null || !this.validVisualization || this.pickMode == 0 || this.simpleGeometry || this.dirty) {
            return;
        }
        boolean hit = this.isPickableHit(ch, x, y);
        if (!hit) {
            if (this.pickMode == 2 || this.isRiserChart() || this.is3DScatterPlot() || this.is3DPieChart() || this.lastPicked != null) {
                ch.glRefresh();
                this.lastPicked = null;
            }
            return;
        }
        try {
            Graphics g;
            Object hitObj;
            while (!((hitObj = this.hitStack.pop()) instanceof String[])) {
            }
            String[] strs = (String[])hitObj;
            if (!(this.pickMode != 1 || this.isRiserChart() || this.is3DScatterPlot() || this.is3DPieChart())) {
                boolean sameAsLastPicked = true;
                if (this.lastPicked == null || strs.length != this.lastPicked.length) {
                    sameAsLastPicked = false;
                } else {
                    for (int i = 0; i < strs.length; ++i) {
                        if (strs[i] == null || strs[i].equals(this.lastPicked[i])) continue;
                        sameAsLastPicked = false;
                    }
                }
                if (sameAsLastPicked) {
                    return;
                }
                this.lastPicked = strs;
            }
            if (this.doubleBuffer) {
                ch.setBackbuffer(1);
                ch.copyBuffer(0);
                g = ch.getBackbufferGC();
            } else {
                ch.glRefresh();
                g = ch.getGraphics();
            }
            if (g == null) {
                return;
            }
            int centerx = x;
            int centery = y;
            if (!(this.pickMode != 1 || this.isRiserChart() || this.is3DScatterPlot() || this.is3DPieChart())) {
                for (int i = 0; i < strs.length; ++i) {
                    if (strs[i] == null || !strs[i].equals(CENTERTAG)) continue;
                    double[] dc = new double[]{DoubleData.valueOf((String)strs[i + 1]), DoubleData.valueOf((String)strs[i + 2]), DoubleData.valueOf((String)strs[i + 3])};
                    ch.gluProject(dc, dc);
                    centerx = (int)dc[0];
                    centery = (int)dc[1];
                    break;
                }
            }
            String[] descriptors = new String[strs.length];
            String[] values = new String[strs.length];
            this.parseProbeInfo(strs, descriptors, values);
            g.setFont(new Font("SERIF", 0, 12));
            int maxVarLen = -1;
            int maxNumLen = -1;
            int numRows = 0;
            for (int i = 0; i < strs.length; ++i) {
                if (values[i] == null || values[i].trim().equals("")) continue;
                ++numRows;
                if (g.getFontMetrics().stringWidth(descriptors[i].trim()) > maxVarLen) {
                    maxVarLen = g.getFontMetrics().stringWidth(descriptors[i].trim());
                }
                if (g.getFontMetrics().stringWidth(values[i].trim()) <= maxNumLen) continue;
                maxNumLen = g.getFontMetrics().stringWidth(values[i].trim());
            }
            int indent = g.getFontMetrics().stringWidth("XX");
            int maxStringWidth = maxVarLen + indent + maxNumLen;
            int fontH = g.getFontMetrics().getHeight();
            boolean lineEnabled = true;
            int cursorOffset = lineEnabled ? 20 : 0;
            int th = numRows * fontH + 5;
            int tw = maxStringWidth + 5 + 2;
            int ty = Math.max(this.topMargin, centery - th - cursorOffset);
            int tx = Math.max(this.leftMargin, centerx - (lineEnabled ? tw / 2 : 0));
            if (tx + tw > this.width - this.rightMargin) {
                tx = Math.max(0, this.width - tw - 1 - this.rightMargin);
            }
            if (ty + th > this.height - this.bottomMargin) {
                ty = Math.max(0, this.height - th - 1 - this.bottomMargin);
            }
            if (centerx >= tx && centerx <= tx + tw && centery >= ty && centery <= ty + th) {
                if ((tx = tx + tw / 2 < centerx ? centerx - tw - cursorOffset : centerx + cursorOffset) + tw > this.width) {
                    tx = Math.max(0, this.width - tw - 1);
                }
                if (centerx >= tx && centerx <= tx + tw && (ty = centery + cursorOffset) + th > this.height) {
                    ty = Math.max(0, this.height - th - 1);
                }
            }
            g.setColor(this.feedbackBackgroundColor);
            g.fillRect(tx, ty, tw, th);
            g.setColor(this.feedbackTextColor);
            g.drawRect(tx, ty, tw, th);
            int row = 1;
            for (int i = 0; i < strs.length; ++i) {
                if (values[i] == null || values[i].trim().equals("")) continue;
                g.drawString(descriptors[i].trim(), tx + 5, ty + row * fontH);
                g.drawString(values[i].trim(), tx + 5 + maxVarLen + indent, ty + row * fontH);
                ++row;
            }
            if (lineEnabled && (centerx < tx || centerx > tx + tw || centery < ty || centery > ty + th)) {
                Point l1 = new Point(centerx, centery);
                Point l2 = new Point();
                if (l1.x < tx) {
                    l2.x = tx - 1;
                } else {
                    int n = l2.x = l1.x > tx + tw ? tx + tw : tx + tw / 2;
                }
                l2.y = l1.y < ty ? ty - 1 : (l1.y > ty + th ? ty + th : ty + th / 2);
                g.setColor(Color.white);
                g.drawLine(l1.x - 1, l1.y, l2.x - 1, l2.y);
                g.setColor(Color.green);
                g.drawLine(l1.x, l1.y, l2.x, l2.y);
                g.setColor(Color.black);
                g.drawLine(l1.x + 1, l1.y, l2.x + 1, l2.y);
            }
            if (!this.doubleBuffer) {
                g.dispose();
            }
            if (this.doubleBuffer) {
                ch.glRefresh();
                ch.setBackbuffer(0);
            }
        }
        catch (EmptyStackException e) {
            ch.glRefresh();
            this.lastPicked = null;
        }
    }

    public synchronized void referenceLine(Channel ch, int x, int y) {
    }

    protected void initializeChannel(Channel ch) {
        this.width = ch.getWidth();
        this.height = ch.getHeight();
        ch.glDisable(4);
        if (this.edgeColor != null) {
            ch.glEdgeColor(this.edgeColor);
        }
        ch.glEnable(0);
        ch.glEnable(1);
        this.resetState(ch);
        this.hitStack = new Stack();
        this.pickList = new Stack();
        if (this.transparent) {
            ch.setBackbuffer(2);
            ch.copyBuffer(0);
        }
        ch.gluLookAt(0.0, 0.0, 0.0, View.DEFAULT_DISTANCE, 0.0, 0.0, 0.0);
        ch.gluPerspective(View.DEFAULT_FOV, View.DEFAULT_ASPECT, View.MIN_DISTANCE, View.MAX_DISTANCE);
        this.setViewport(ch);
        ch.glDisable(3);
        double[] d = new double[3];
        double[] pos = new double[4];
        d[1] = d[2] = this.ambientLightAmount;
        d[0] = d[2];
        ch.glLight(17, 0, d);
        d[1] = d[2] = this.ambientLightAmount * 0.5;
        d[0] = d[2];
        ch.glLight(18, 0, d);
        d[1] = d[2] = this.diffuseLightAmount;
        d[0] = d[2];
        ch.glLight(17, 1, d);
        ch.glLight(18, 1, d);
        d[2] = 0.0;
        d[1] = 0.0;
        d[0] = 0.0;
        ch.glLight(17, 2, d);
        pos[0] = -0.3f;
        pos[1] = -0.6f;
        pos[2] = -1.0;
        pos[3] = 0.0;
        ch.glLight(17, 3, pos);
        ch.glEnable(17);
        pos[0] = 0.3f;
        pos[1] = 0.6f;
        pos[2] = 1.0;
        pos[3] = 0.0;
        ch.glLight(18, 3, pos);
        ch.glEnable(18);
    }

    protected void resetState(Channel ch) {
        this.yTitleSize = 0.0f;
        this.xMaxLegendSize = 0.0f;
        this.xMinLegendSize = 0.0f;
        this.yMaxLegendSize = 0.0f;
        this.yMinLegendSize = 0.0f;
        this.zMaxLegendSize = 0.0f;
        this.zMinLegendSize = 0.0f;
        this.yColorLegendSize = 0.0f;
        this.xColorLegendSize = 0.0f;
        this.titleFontPixels = 0;
        this.rightLegendPixels = 0;
        this.leftLegendPixels = 0;
        this.bottomLegendPixels = 0;
        this.topLegendPixels = 0;
        this.ySizePixels = 0;
        this.xSizePixels = 0;
        this.blankSpaceSize = 0.0f;
        this.verticalSpaceSize = 0.0f;
        ch.glDeleteList(3L);
        ch.glDeleteList(0L);
        ch.glDeleteList(1L);
        ch.glDeleteList(8L);
        ch.glDeleteList(2L);
        ch.glDeleteList(4L);
        ch.glDeleteList(5L);
        ch.glDeleteList(5L);
        ch.glDeleteList(7L);
        ch.glDeleteList(10L);
        this.removeLegends();
    }

    protected abstract void estimateLegendPixelSize(Channel var1);

    protected void adjustAspect(Channel ch) {
        this.scaleText(ch);
        this.estimateLegendPixelSize(ch);
        if (this.title != null) {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.titleStyle.createFont());
            this.titleFontPixels = fm.getHeight();
            this.topLegendPixels += this.titleFontPixels;
        }
        if (this.footnote != null) {
            this.bottomLegendPixels += 12 + this.blankSpacePixels;
        }
        int minXSizePixels = this.width / 4;
        int minYSizePixels = this.height / 4;
        this.xSizePixels = this.width - this.leftMargin - this.rightMargin - this.leftLegendPixels - this.rightLegendPixels;
        this.ySizePixels = this.height - this.topMargin - this.bottomMargin - this.topLegendPixels - this.bottomLegendPixels;
        if (this.xSizePixels < minXSizePixels) {
            this.rightMargin = Math.max(this.rightMargin, this.xSizePixels + this.rightMargin - minXSizePixels);
            this.xSizePixels = minXSizePixels;
        }
        if (this.ySizePixels < minYSizePixels) {
            this.bottomMargin = this.ySizePixels + this.bottomMargin - minYSizePixels;
            this.ySizePixels = minYSizePixels;
        }
        this.aspect = (float)this.ySizePixels / (float)this.xSizePixels;
    }

    protected void addBackground(Channel ch) {
        if (!this.transparent) {
            ch.setBackgroundColor(this.backgroundColor);
            int style = -1;
            if (this.backgroundImage != null) {
                style = this.imageScale ? 0 : (this.imageTile ? 1 : (this.imageX0 > 0 && this.imageY0 > 0 ? 2 : 3));
                ch.setBackgroundImage(this.backgroundImage, style);
                ch.setBackgroundImagePosition(this.imageX0, this.imageY0);
            }
        } else {
            Component cmp = ch.getComponent();
            if (cmp.getParent() == null) {
                ch.setBackgroundColor(this.getBackgroundColor());
            } else {
                ch.setBackgroundColor(cmp.getParent().getBackground());
            }
            ch.setBackbuffer(2);
            ch.clearBGC();
            ch.setBackbuffer(0);
            ch.clearBGC();
        }
    }

    protected void addTitle(Channel ch) {
        if (this.title == null) {
            return;
        }
        ch.glColor(this.titleStyle.color);
        ch.glSelect2DFont(this.titleStyle.createFont());
        ch.glTextAlign(1, 0);
        ch.gl2DText(this.title, (this.width - this.leftMargin - this.rightMargin) / 2, 0.97 * (double)this.height - (double)this.topMargin - (double)this.bottomMargin, 0.0);
        this.yTitleSize = (float)ch.glGetTextHeight();
    }

    public void addFootnote(Channel ch) {
        if (this.footnote == null) {
            return;
        }
        ch.glColor(this.feedbackTextColor);
        ch.glSelect2DFont(new Font("SANS", 3, 12));
        ch.glTextAlign(0, 3);
        ch.gl2DText(this.footnote, (this.width - this.leftMargin - this.rightMargin) / 2, 0.03 * (double)this.height, 0.0);
        this.yColorLegendSize += (float)(12 + this.blankSpacePixels);
    }

    protected void addZeroReferenceLines(Channel ch) {
    }

    protected void scaleText(Channel ch) {
        this.titleStyle.curSize = this.titleStyle.isScalable() ? this.titleStyle.getSize() + this.titleStyle.getSizeRange() * this.scaleFactor : this.titleStyle.getSize();
    }

    protected void setViewport(Channel ch) {
        ch.glViewport(this.leftMargin, this.topMargin, this.width - this.leftMargin - this.rightMargin, this.height - this.topMargin - this.bottomMargin);
    }

    protected void setLegendBoundingBoxes(Channel ch) {
    }

    protected void addElementHotspots(Channel ch) {
    }

    protected boolean isLegendHotspotsActive() {
        return false;
    }

    protected void addLegendHotspots(Channel ch) {
        if (this.isLegendHotspotsActive()) {
            this.resetLegendSizes(ch);
            ch.glNewList(0L, true);
            this.addLegends(ch);
            ch.glEndList();
        }
    }

    public void beginScrolling(Channel ch, int x, int y) {
        this.scrollFlag = this.isRegionPicked(x, y);
    }

    public void doScrolling(Channel ch, int x, int y, int prevx, int prevy) {
        if (this.scrollFlag) {
            this.scrollRegion(ch, x, y, prevx, prevy);
        }
    }

    public void doDataScrolling(Channel ch, int x, int y, int prevx, int prevy) {
    }

    public void stopScrolling(Channel ch, int x, int y) {
        this.scrollFlag = false;
    }

    public synchronized boolean isScrollableLocation(Channel ch, int x, int y) {
        if (ch == null || !this.validVisualization) {
            return false;
        }
        return this.isRegionPicked(x, y);
    }

    public synchronized int isDataLocation(Channel ch, int x, int y) {
        return 9;
    }

    public void stopDataScrolling(Channel ch) {
    }

    protected boolean isRegionPicked(int x, int y) {
        return false;
    }

    public synchronized int getScrollableDirection(Channel ch, int x, int y) {
        if (!this.isScrollableLocation(ch, x, y)) {
            return 0;
        }
        float thumb = this.getScrollableThumb();
        if (thumb == 0.0f) {
            return 2;
        }
        if (thumb == 1.0f) {
            return 1;
        }
        return 3;
    }

    protected float getScrollableThumb() {
        return 0.0f;
    }

    protected void scrollRegion(Channel ch, int x, int y, int prevx, int prevy) {
    }

    public void beginRotating(Channel ch) {
    }

    public void doRotating(Channel ch, int x, int y, int prevx, int prevy) {
        if (this.depth != 2 || this.dirty || Math.abs(x - prevx) < 2 && Math.abs(y - prevy) < 2) {
            return;
        }
        double delta = (double)(prevx - x) * 360.0 / (double)this.width;
        if (delta != 0.0) {
            if ((delta += this.view.dRot) + this.view.rotation < 0.0) {
                delta += 360.0;
            } else if (delta + this.view.rotation > 360.0) {
                delta -= 360.0;
            }
            this.view.dRot = delta;
        }
        if ((delta = (double)(prevy - y) * 360.0 / (double)this.height) != 0.0) {
            this.view.dTilt = (delta += this.view.dTilt) + this.view.tilt < -90.0 ? -90.0 - this.view.tilt : (delta + this.view.tilt > 90.0 ? 90.0 - this.view.tilt : delta);
        }
        this.setInitialViewpoint(ch);
        this.resetLegendSizes(ch);
        ch.glNewList(9L, true);
        this.addDataScrollbar(ch);
        ch.glEndList();
        ch.glNewList(0L, true);
        this.addLegends(ch);
        ch.glEndList();
        ch.glNewList(8L, true);
        this.addAxes(ch);
        ch.glEndList();
        this.dirty = true;
        this.showChart(ch, null);
    }

    public void doZooming(Channel ch, int x, int y, int prevx, int prevy) {
        this.doZooming(ch, y, prevy);
    }

    public void doZooming(Channel ch, int y, int prevy) {
        if (this.depth != 2 || this.dirty || Math.abs(y - prevy) < 2) {
            return;
        }
        double delta = (double)(y - prevy) * this.view.distance / (double)this.height / 2.0 + this.view.dDist;
        this.view.dDist = Math.max(View.MIN_DISTANCE - this.view.distance, Math.min(delta, View.MAX_DISTANCE - this.view.distance));
        this.setInitialViewpoint(ch);
        this.resetLegendSizes(ch);
        ch.glNewList(9L, true);
        this.addDataScrollbar(ch);
        ch.glEndList();
        ch.glNewList(0L, true);
        this.addLegends(ch);
        ch.glEndList();
        this.dirty = true;
        this.showChart(ch, null);
    }

    public void doPanning(Channel ch, int x, int y, int prevx, int prevy) {
        if (this.depth != 2 || this.dirty || Math.abs(x - prevx) < 2 && Math.abs(y - prevy) < 2) {
            return;
        }
        double deltax = (float)(2 * (prevx - x)) * this.xSize / (float)this.xSizePixels;
        double deltay = (float)(-2 * (prevy - y)) * this.ySize / (float)this.ySizePixels;
        double[] screenx = new double[3];
        double[] screeny = new double[3];
        screenx = ch.gluGetScreenX();
        screeny = ch.gluGetScreenY();
        this.view.dXCent += deltax * screenx[0] + deltay * screeny[0];
        this.view.dYCent += deltax * screenx[1] + deltay * screeny[1];
        this.view.dZCent += deltax * screenx[2] + deltay * screeny[2];
        this.setInitialViewpoint(ch);
        this.dirty = true;
        this.showChart(ch, null);
    }

    public void stopRotating(Channel ch) {
        if (this.depth == 0 || this.dirty) {
            return;
        }
        this.showChart(ch, null);
    }

    public synchronized boolean isMovableViewpoint(Channel ch) {
        if (ch == null || !this.validVisualization) {
            return false;
        }
        return this.depth != 0;
    }

    public void setIndents(int left, int right, int top, int bottom) {
        this.leftMargin = left;
        this.rightMargin = right;
        this.topMargin = top;
        this.bottomMargin = bottom;
    }

    private void computeScaleFactor() {
        double w1 = this.width - this.leftMargin - this.rightMargin - 240;
        double w2 = 760.0;
        this.scaleFactor = Math.max(0.0, Math.min(1.0, w1 / w2));
    }

    protected void addColorLegendLabels(Channel ch) {
    }

    public void setResolution(int resolutionIn) {
        this.resolution = resolutionIn;
    }

    public int getResolution() {
        return this.resolution;
    }

    protected static Object getRawObject(Class type, String stringObject) {
        if (type == null || stringObject == null) {
            return null;
        }
        if (type == Integer.class) {
            return Integer.valueOf(stringObject);
        }
        if (type == Float.class) {
            return new Float(FloatData.valueOf((String)stringObject));
        }
        if (type == Double.class) {
            return new Double(DoubleData.valueOf((String)stringObject));
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(stringObject);
        }
        if (type == BigInteger.class) {
            return new BigInteger(stringObject);
        }
        return stringObject;
    }

    protected static Object[] getPickedValues(boolean formatted, Stack pickList, int offset, DataModel dm, Variable variable) {
        if (pickList == null || variable == null) {
            return null;
        }
        Object stackObject = null;
        Vector valVector = new Vector();
        Enumeration e = pickList.elements();
        while (e.hasMoreElements()) {
            stackObject = e.nextElement();
            if (stackObject == null || !(stackObject instanceof String[])) continue;
            valVector.addElement(stackObject);
        }
        Enumeration v = valVector.elements();
        Object[] vals = new Object[valVector.size()];
        int j = 0;
        while (v.hasMoreElements()) {
            String[] str = (String[])v.nextElement();
            vals[j] = str[offset];
            ++j;
        }
        if (formatted) {
            return dm.format(variable, (String[])vals);
        }
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = Visualization.getRawObject(dm.getType(variable.indexIn), (String)vals[i]);
        }
        return vals;
    }

    protected void defaultResponseVariable(IndependentVariable iv, DependentVariable dv) {
        this.frequencyPlot = false;
        this.savedDependentStat = 1;
        if (dv == null || dv.index == -1) {
            if (dv.index == -1) {
                this.savedDependentStat = dv.statistic;
            }
            if (dv == null) {
                dv = new DependentVariable();
            }
            dv.indexIn = iv.indexIn;
            dv.index = iv.index;
            dv.statistic = 3;
            this.frequencyPlot = true;
        }
    }

    protected void resetResponseVariable(DependentVariable dv) {
        if (this.frequencyPlot && dv.statistic == 3) {
            dv.statistic = this.savedDependentStat;
        }
    }

    public void invalidateVisualization(Channel ch) {
        this.resetState(ch);
        this.validVisualization = false;
    }

    public boolean isRiserChart() {
        return false;
    }

    public boolean is3DScatterPlot() {
        return false;
    }

    public boolean is3DPieChart() {
        return false;
    }

    protected float getObliqueXOffset() {
        return 0.0f;
    }

    public boolean isNoneVariable(Variable variable) {
        return variable == null || variable.index == -1;
    }

    public boolean isMissingRetained() {
        return this.missingRetained;
    }

    public void setMissingRetained(boolean retained) {
        this.missingRetained = retained;
    }

    public String getMissingSymbol() {
        return this.missingSymbol;
    }

    public void setMissingSymbol(String symbol) {
        this.missingSymbol = symbol;
    }

    public void resetView(Channel ch) {
        this.view.resetView();
        if (this.validVisualization && !this.dirty) {
            this.setInitialViewpoint(ch);
            ch.glNewList(10L, true);
            this.addReferenceLines(ch);
            ch.glEndList();
            ch.glNewList(0L, true);
            this.addLegends(ch);
            ch.glEndList();
            ch.glNewList(8L, true);
            this.addAxes(ch);
            ch.glEndList();
            this.dirty = true;
            this.showChart(ch, null);
        }
    }

    protected void computeView(Channel ch) {
        double yfac = this.ySize / (float)this.ySizePixels;
        double cosx = Math.sin(this.view.rotation * Math.PI / 180.0) * (double)this.zSize;
        double siny = Math.sin(this.view.tilt * Math.PI / 180.0) * (double)this.zSize;
        if (siny < 0.0) {
            siny *= -1.0;
        }
        if (cosx < 0.0) {
            cosx *= -1.0;
        }
        double xMin = (double)(-this.xMinLegendSize - this.blankSpaceSize) - 0.5 * cosx;
        double xMax = (double)(this.xSize + this.xMaxLegendSize + this.blankSpaceSize) + 1.5 * cosx;
        double yMin = (double)(-this.yMinLegendSize) - (double)this.yColorLegendSize * yfac - siny;
        double yMax = (double)(this.ySize + this.yMaxLegendSize) + (double)this.yTitleSize * yfac + siny;
        double xIndent = (double)0.03f * (xMax - xMin);
        double yIndent = (double)0.03f * (yMax - yMin);
        double dx = xMax - xMin + 2.0 * xIndent;
        double dy = yMax - yMin + 2.0 * yIndent;
        this.view.aspect = dx / dy;
        this.view.fov = View.DEFAULT_FOV;
        this.view.distance = dy / Math.tan(Math.PI * this.view.fov / 180.0);
        this.view.xCenter = (xMax + xMin) * 0.5;
        this.view.yCenter = (yMax + yMin) * 0.5;
        this.view.zCenter = (double)(-this.zSize) * 0.5;
    }

    protected void setStandardView(Channel ch) {
        if (!this.standardView) {
            if (this.depth == 0) {
                ch.glOrtho(0.0, this.width - this.leftMargin - this.rightMargin, 0.0, this.height - this.topMargin - this.bottomMargin, -this.width, 0.5);
            } else {
                ch.glOblique(0.0, this.width - this.leftMargin - this.rightMargin, 0.0, this.height - this.topMargin - this.bottomMargin, -this.width, 0.5, 0.5, 45.0);
            }
            ch.gluLookAt(0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.0);
            this.standardView = true;
        }
    }

    protected boolean isDataSubsetted() {
        return false;
    }

    protected void setFinalView(Channel ch) {
        this.setProjection(ch);
        this.setInitialViewpoint(ch);
        this.standardView = false;
    }

    protected void rebuildChart(Channel ch) {
        float savedColorLeg = this.yColorLegendSize;
        float savedTitle = this.yTitleSize;
        this.dirty = true;
        this.buildDone = false;
        ch.glEnable(3);
        this.buildObservationList(ch);
        this.xMaxLegendSize = 0.0f;
        this.xMinLegendSize = 0.0f;
        this.yMaxLegendSize = 0.0f;
        this.yMinLegendSize = 0.0f;
        this.verticalSpaceSize = 0.0f;
        this.blankSpaceSize = 0.0f;
        this.yTitleSize = 0.0f;
        this.yColorLegendSize = 0.0f;
        ch.glViewport(0, 0, (int)(1.1 * (double)this.xSizePixels), (int)(1.06 * (double)this.ySizePixels));
        this.setProjection(ch);
        if (this.depth == 2) {
            this.setInitialViewpoint(ch);
        }
        ch.glDisable(3);
        this.resetLegendSizes(ch);
        ch.glNewList(10L);
        this.addReferenceLines(ch);
        ch.glEndList();
        ch.glNewList(9L);
        this.addDataScrollbar(ch);
        ch.glEndList();
        ch.glNewList(0L);
        this.addLegends(ch);
        ch.glEndList();
        this.yColorLegendSize = savedColorLeg;
        this.yTitleSize = savedTitle;
        this.setViewport(ch);
        this.setFinalView(ch);
        this.resetLegendSizes(ch);
        ch.glNewList(10L, true);
        this.addReferenceLines(ch);
        ch.glEndList();
        ch.glNewList(9L, true);
        this.addDataScrollbar(ch);
        ch.glEndList();
        ch.glNewList(0L, true);
        this.addLegends(ch);
        ch.glEndList();
        ch.glNewList(8L, true);
        this.addAxes(ch);
        ch.glEndList();
        this.setFinalView(ch);
        this.buildDone = true;
        this.showChart(ch, null);
    }

    public void resetGraphSize() {
        this.xSizeMax = 0.0f;
        this.xSizeMin = 0.0f;
        this.ySizeMax = 0.0f;
        this.ySizeMin = 0.0f;
        this.zSizeMax = 0.0f;
        this.zSizeMin = 0.0f;
    }

    protected void resetLegendSizes(Channel ch) {
        this.xMinLegendSize = 0.0f;
        this.xMaxLegendSize = 0.0f;
        this.yMinLegendSize = 0.0f;
        this.yMaxLegendSize = 0.0f;
    }

    public void setElementHotspotsEnabled(boolean flag) {
    }

    public boolean isElementHotspotsEnabled() {
        return false;
    }

    public Blob[] getElementHotspots() {
        return null;
    }
}

