/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import java.io.Serializable;

public class Vec3f
implements Serializable {
    static final long serialVersionUID = -6494000240181181686L;
    public static final Vec3f xAxis = new Vec3f(1.0f, 0.0f, 0.0f);
    public static final Vec3f yAxis = new Vec3f(0.0f, 1.0f, 0.0f);
    public static final Vec3f zAxis = new Vec3f(0.0f, 0.0f, 1.0f);
    public float x;
    public float y;
    public float z;

    public Vec3f() {
    }

    public Vec3f(float anx, float ay, float az) {
        this.x = anx;
        this.y = ay;
        this.z = az;
    }

    public Vec3f(Vec3f aVec3f) {
        this.x = aVec3f.x;
        this.y = aVec3f.y;
        this.z = aVec3f.z;
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void add(Vec3f increment) {
        this.x += increment.x;
        this.y += increment.y;
        this.z += increment.z;
    }

    public void scale(float m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
    }

    public void normalize() {
        float length = this.length();
        if (length != 0.0f) {
            this.x /= length;
            this.y /= length;
            this.z /= length;
        }
    }

    public float dot(Vec3f otherVector) {
        float result = this.x * otherVector.x + this.y * otherVector.y + this.z * otherVector.z;
        return result;
    }

    public float angle(Vec3f otherVector) {
        float thisLength = this.length();
        float otherLength = otherVector.length();
        float angle = thisLength == 0.0f || otherLength == 0.0f ? 0.0f : (float)Math.acos(this.dot(otherVector) / (thisLength * otherLength));
        return angle;
    }

    public Vec3f cross(Vec3f otherVector) {
        Vec3f result = new Vec3f(this.y * otherVector.z - this.z * otherVector.y, this.z * otherVector.x - this.x * otherVector.z, this.x * otherVector.y - this.y * otherVector.x);
        return result;
    }
}

