/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.visualize.TidyContinuousMapper;

class TidyContinuousMapper2
extends TidyContinuousMapper {
    protected TidyContinuousMapper2() {
        this(1, 0.0f, 1.0f);
    }

    protected TidyContinuousMapper2(int intervalCount) {
        this(intervalCount, 0.0f, 1.0f);
    }

    protected TidyContinuousMapper2(int intervalCount, float mappedMinIn, float mappedMaxIn) {
        super(intervalCount, mappedMinIn, mappedMaxIn);
    }

    protected TidyContinuousMapper2(int intervalCount, float vMinIn, float vMaxIn, float mappedMinIn, float mappedMaxIn) {
        super(intervalCount, vMinIn, vMaxIn, mappedMinIn, mappedMaxIn);
    }

    @Override
    protected void adjustMinMax() {
        if (this.fixedIntervals) {
            return;
        }
        double logTen = Math.log(10.0);
        this.adjusted = true;
        if (this.vMinMaxLocked) {
            return;
        }
        if (this.vMin == this.vMax) {
            if (this.vMin != 0.0f) {
                this.vMin = 0.0f;
            } else {
                return;
            }
        }
        double rawInterval = (this.vMax - this.vMin) / (float)this.intervals;
        if (this.vMin > 0.0f && (double)this.vMin > rawInterval) {
            this.vMin = (float)((double)this.vMin - rawInterval);
        }
        if (this.vMin > 0.0f && (double)this.vMin < rawInterval / 2.0) {
            this.vMin = 0.0f;
        }
        double logMin = Math.floor(Math.log(this.vMin) / logTen);
        this.vMin = (float)Math.pow(10.0, logMin);
        rawInterval = (this.vMax - this.vMin) / (float)this.intervals;
        double logInterval = Math.log(rawInterval) / logTen;
        logInterval = Math.ceil(logInterval);
        double step = Math.pow(10.0, logInterval);
        double step2 = step / 2.0;
        while ((double)this.vMax < (double)this.vMin + step2 * (double)this.intervals) {
            step = step2;
            step2 = step / 2.0;
        }
        this.vMax = (float)((double)this.vMin + (double)this.intervals * step);
    }
}

