/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.visualize.Mapper;
import java.util.Vector;

class SortedDiscreteMapper
extends Mapper {
    protected Vector values;
    protected float mappedValueStart;
    protected float mappedValueIncrement;
    public static final int ADD_TO_FIRST = -1;
    public static final int ADD_BY_ORDER = 0;
    public static final int ADD_TO_LAST = 1;
    protected boolean addToFirst = false;
    protected boolean addToLast = false;

    protected SortedDiscreteMapper() {
        this(0.0f, 1.0f);
    }

    protected SortedDiscreteMapper(float mappedValueStartIn) {
        this(mappedValueStartIn, 1.0f);
    }

    protected SortedDiscreteMapper(float mappedValueStartIn, float mappedValueIncrementIn) {
        this.mappedValueStart = mappedValueStartIn;
        this.mappedValueIncrement = mappedValueIncrementIn;
        this.values = new Vector();
    }

    @Override
    protected void addValue(String value) {
        this.binarySearch(value);
    }

    @Override
    protected void addValue(String value, int type) {
        this.binarySearch(value, type);
    }

    @Override
    protected float getMappedValue(String value) {
        int index = this.binarySearch(value);
        float v = this.mappedValueStart + (float)index * this.mappedValueIncrement;
        return v;
    }

    @Override
    protected int getIntervalCount() {
        return this.values.size();
    }

    @Override
    protected String[] getValueLabels() {
        int size = this.values.size();
        String[] labels = new String[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = (String)this.values.elementAt(i);
        }
        return labels;
    }

    protected int binarySearch(String value) {
        int index;
        int size = this.values.size();
        if (size == 0) {
            this.values.addElement(value);
            index = 0;
        } else {
            int compare;
            int left = 0;
            int right = size - 1;
            if (this.addToFirst) {
                compare = value.compareTo((String)this.values.elementAt(0));
                if (compare == 0) {
                    return 0;
                }
                ++left;
            }
            if (this.addToLast) {
                compare = value.compareTo((String)this.values.elementAt(size - 1));
                if (compare == 0) {
                    return size - 1;
                }
                --right;
            }
            if (left > right) {
                index = left;
                this.values.insertElementAt(value, index);
            } else {
                int i;
                do {
                    if ((compare = value.compareTo((String)this.values.elementAt(i = (left + right) / 2))) < 0) {
                        right = i - 1;
                        continue;
                    }
                    left = i + 1;
                } while (compare != 0 && left <= right);
                if (compare == 0) {
                    index = i;
                } else {
                    index = Math.max(left, right);
                    this.values.insertElementAt(value, index);
                }
            }
        }
        return index;
    }

    protected int binarySearch(String value, int type) {
        int index;
        int size = this.values.size();
        if (size == 0) {
            this.values.addElement(value);
            index = 0;
            if (type == -1) {
                this.addToFirst = true;
            } else if (type == 1) {
                this.addToLast = true;
            }
        } else {
            int left = 0;
            int right = size - 1;
            if (type == -1) {
                index = 0;
                if (!this.addToFirst) {
                    this.values.insertElementAt(value, index);
                    this.addToFirst = true;
                }
            } else if (type == 1) {
                if (!this.addToLast) {
                    this.values.addElement(value);
                    this.addToLast = true;
                }
                index = this.values.size() - 1;
            } else {
                if (this.addToFirst) {
                    ++left;
                }
                if (this.addToLast) {
                    --right;
                }
                if (left > right) {
                    index = left;
                    this.values.insertElementAt(value, index);
                } else {
                    int i;
                    int compare;
                    do {
                        if ((compare = value.compareTo((String)this.values.elementAt(i = (left + right) / 2))) < 0) {
                            right = i - 1;
                            continue;
                        }
                        left = i + 1;
                    } while (compare != 0 && left <= right);
                    if (compare == 0) {
                        index = i;
                    } else {
                        index = Math.max(left, right);
                        this.values.insertElementAt(value, index);
                    }
                }
            }
        }
        return index;
    }
}

