/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.visualize.Mapper;
import java.util.Vector;

class ReverseDataDiscreteMapper
extends Mapper {
    protected Vector values;
    protected float mappedValueStart;
    protected float mappedValueIncrement;

    protected ReverseDataDiscreteMapper() {
        this(0.0f, 1.0f);
    }

    protected ReverseDataDiscreteMapper(float mappedValueStartIn) {
        this(mappedValueStartIn, 1.0f);
    }

    protected ReverseDataDiscreteMapper(float mappedValueStartIn, float mappedValueIncrementIn) {
        this.mappedValueStart = mappedValueStartIn;
        this.mappedValueIncrement = mappedValueIncrementIn;
        this.values = new Vector();
    }

    @Override
    protected void addValue(String value) {
        if (!this.values.contains(value)) {
            this.values.insertElementAt(value, 0);
        }
    }

    @Override
    protected float getMappedValue(String value) {
        int index = this.values.indexOf(value);
        float v = this.mappedValueStart + (float)index * this.mappedValueIncrement;
        return v;
    }

    @Override
    protected int getIntervalCount() {
        return this.values.size();
    }

    @Override
    protected String[] getValueLabels() {
        int size = this.values.size();
        String[] labels = new String[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = (String)this.values.elementAt(i);
        }
        return labels;
    }
}

