/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.ContinuousMapper;
import com.sas.graphics.util.visualize.DiscreteMapper;
import com.sas.graphics.util.visualize.Legend;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.lang.DoubleData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.Serializable;

public class ReferenceLine
implements Serializable {
    static final long serialVersionUID = 9111350297544800993L;
    protected static final int DEFAULT_LABEL_FONT_SIZE = 9;
    protected static final int DEFAULT_LABEL_MIN_CHARS = 4;
    protected static final int DEFAULT_LABEL_MAX_CHARS = 16;
    public static final int HREF_LINE = 1;
    public static final int VREF_LINE = 2;
    private static final Vec3f originDefault = new Vec3f(0.0f, 0.0f, 0.0f);
    private static final Vec3f endVectorDefault = Vec3f.zAxis;
    private static final Color colorDefault = Color.gray;
    public Vec3f origin;
    public Vec3f endVector;
    public Vec3f paddingVector;
    public int lineDirection;
    public boolean clipRef;
    public int numGroups;
    public float xSizeMin;
    public float xSizeMax;
    public float ySizeMin;
    public float ySizeMax;
    public boolean scrollData;
    protected Color lineColor;
    protected int lineStyle;
    protected TextStyle labelStyle;
    protected Mapper mapper;
    protected float[] dValues;
    protected String[] cValues;
    protected String[] rLabels;
    protected String[] formattedValues;

    public ReferenceLine() {
        this(null);
    }

    public ReferenceLine(Mapper aMapper) {
        this.mapper = aMapper;
        this.dValues = null;
        this.cValues = null;
        this.formattedValues = null;
        this.rLabels = null;
        this.origin = originDefault;
        this.endVector = endVectorDefault;
        this.paddingVector = new Vec3f(0.0f, 0.0f, 0.0f);
        this.lineDirection = 2;
        this.clipRef = false;
        this.numGroups = 1;
        this.xSizeMin = 0.0f;
        this.ySizeMin = 0.0f;
        this.xSizeMax = 0.0f;
        this.ySizeMax = 0.0f;
        this.scrollData = false;
        this.lineColor = colorDefault;
        this.labelStyle = new TextStyle(9, 4, 16);
        this.labelStyle.setColor(colorDefault);
    }

    public void attachMapper(Mapper aMapper) {
        this.mapper = aMapper;
    }

    public void setValues(float[] values) {
        this.dValues = values;
    }

    public void setValues(String[] values) {
        this.cValues = values;
    }

    public void setLabels(String[] labels) {
        this.rLabels = labels;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color c) {
        this.lineColor = c;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int s) {
        this.lineStyle = s;
    }

    public void setLabelStyle(TextStyle aStyle) {
        this.labelStyle = aStyle;
    }

    public TextStyle getLabelStyle() {
        return this.labelStyle;
    }

    public float getMaxLabelWidth(Channel ch) {
        float width = 0.0f;
        if (this.lineDirection == 1) {
            return width;
        }
        ch.glSelect2DFont(this.labelStyle.createFont());
        if (this.mapper instanceof ContinuousMapper) {
            if (this.dValues == null) {
                return width;
            }
            for (int i = 0; i < this.dValues.length; ++i) {
                float w;
                if (this.rLabels != null && i < this.rLabels.length && this.rLabels[i] != null) {
                    w = (float)ch.glGetTextWidth(this.rLabels[i]);
                } else {
                    String s = DoubleData.toString((double)this.dValues[i]);
                    w = (float)ch.glGetTextWidth(s);
                }
                if (!(w > width)) continue;
                width = w;
            }
        } else {
            if (this.cValues == null) {
                return width;
            }
            for (int i = 0; i < this.cValues.length; ++i) {
                float w;
                String str = this.rLabels != null && i < this.rLabels.length && this.rLabels[i] != null ? this.rLabels[i].trim() : (this.cValues[i] == null ? null : this.cValues[i].trim());
                if (str == null) {
                    w = 0.0f;
                } else {
                    if (str.length() > this.labelStyle.getMaxChars()) {
                        int index = Legend.ClippingIndex(str, this.labelStyle.getMaxChars());
                        str = index != 0 ? str.substring(0, index) : str.substring(0, this.labelStyle.getMaxChars());
                    }
                    w = (float)ch.glGetTextWidth(str);
                }
                if (!(w > width)) continue;
                width = w;
            }
        }
        width = (float)((double)width + ch.glGetTextWidth("T") / 3.0);
        return width;
    }

    public float getMaxLabelHeight(Channel ch) {
        if (this.lineDirection == 2) {
            return 0.0f;
        }
        ch.glSelect2DFont(this.labelStyle.createFont());
        float height = this.mapper instanceof ContinuousMapper && this.dValues == null ? 0.0f : (this.mapper instanceof DiscreteMapper && this.cValues == null ? 0.0f : (float)ch.glGetTextHeight());
        return height;
    }

    public int getMaxLabelPixelWidth(Channel ch) {
        int width = 0;
        if (this.lineDirection == 1) {
            return width;
        }
        Graphics g = ch.getGraphics();
        FontMetrics fm = g.getFontMetrics(this.labelStyle.createFont());
        if (this.dValues != null) {
            for (int i = 0; i < this.dValues.length; ++i) {
                int w;
                if (this.rLabels != null && i < this.rLabels.length && this.rLabels[i] != null) {
                    w = fm.stringWidth(this.rLabels[i]);
                } else {
                    String s = DoubleData.toString((double)this.dValues[i]);
                    w = fm.stringWidth(s);
                }
                if (w <= width) continue;
                width = w;
            }
        } else if (this.cValues != null) {
            for (int i = 0; i < this.cValues.length; ++i) {
                int w = this.rLabels != null && i < this.rLabels.length && this.rLabels[i] != null ? fm.stringWidth(this.rLabels[i]) : (this.cValues[i] == null ? 0 : fm.stringWidth(this.cValues[i]));
                if (w <= width) continue;
                width = w;
            }
        }
        width = (int)((double)width + (double)fm.stringWidth("T") / 3.0);
        g.dispose();
        return width;
    }

    public int getMaxLabelPixelHeight(Channel ch) {
        if (this.lineDirection == 2) {
            return 0;
        }
        Graphics g = ch.getGraphics();
        FontMetrics fm = g.getFontMetrics(this.labelStyle.createFont());
        int height = fm.getHeight();
        g.dispose();
        return height;
    }

    public void addGeometry(Channel ch) {
        if (this.mapper == null) {
            return;
        }
        ch.glColor(this.lineColor);
        if (this.mapper instanceof ContinuousMapper) {
            if (this.dValues == null) {
                return;
            }
            for (int i = 0; i < this.dValues.length; ++i) {
                float value;
                try {
                    value = ((ContinuousMapper)this.mapper).getMappedValue2(this.dValues[i]);
                }
                catch (Exception e) {
                    continue;
                }
                for (int j = 0; j < this.numGroups; ++j) {
                    float v = value + (float)(j * (this.mapper.getIntervalCount() + 1));
                    if (this.isLineClipped(v)) continue;
                    this.adjustValue(v);
                    this.buildOneReferenceLine(ch, v);
                }
            }
        } else {
            if (this.cValues == null) {
                return;
            }
            for (int i = 0; i < this.cValues.length; ++i) {
                float value;
                try {
                    value = ((DiscreteMapper)this.mapper).getMappedValue2(this.cValues[i]);
                }
                catch (Exception e) {
                    continue;
                }
                for (int j = 0; j < this.numGroups; ++j) {
                    float v = value + (float)(j * (this.mapper.getIntervalCount() + 1));
                    if (this.isLineClipped(v)) continue;
                    this.adjustValue(v);
                    this.buildOneReferenceLine(ch, v);
                }
            }
        }
    }

    protected void addLabels(Channel ch) {
        String label;
        Vec3f endpt;
        Vec3f startpt;
        if (this.mapper == null) {
            return;
        }
        ch.glColor(this.labelStyle.color);
        ch.glSelect2DFont(this.labelStyle.createFont());
        float textHeight = (float)ch.glGetTextHeight();
        if (this.lineDirection == 1) {
            ch.glTextAlign(1, 3);
            startpt = new Vec3f(this.origin);
            startpt.add(this.endVector);
            endpt = new Vec3f(startpt.x, startpt.y + textHeight, startpt.z);
        } else {
            ch.glTextAlign(0, 1);
            startpt = new Vec3f(this.origin);
            startpt.add(this.endVector);
            Vec3f spaceVector = new Vec3f((float)ch.glGetTextWidth("T") / 3.0f, 0.0f, 0.0f);
            startpt.add(spaceVector);
            endpt = new Vec3f(startpt.x + textHeight, startpt.y, startpt.z);
        }
        if (this.mapper instanceof ContinuousMapper) {
            if (this.dValues == null) {
                return;
            }
            for (int i = 0; i < this.dValues.length; ++i) {
                float value;
                try {
                    value = ((ContinuousMapper)this.mapper).getMappedValue2(this.dValues[i]);
                }
                catch (Exception e) {
                    continue;
                }
                label = this.rLabels == null || i >= this.rLabels.length || this.rLabels[i] == null ? DoubleData.toString((double)this.dValues[i]) : this.rLabels[i];
                for (int j = 0; j < this.numGroups; ++j) {
                    float v = value + (float)(j * (this.mapper.getIntervalCount() + 1));
                    if (this.isLineClipped(v)) continue;
                    this.adjustValue(v);
                    this.buildOneReferenceLineLabel(ch, startpt, endpt, v, label);
                }
            }
        } else {
            if (this.cValues == null) {
                return;
            }
            for (int i = 0; i < this.cValues.length; ++i) {
                float value;
                try {
                    value = ((DiscreteMapper)this.mapper).getMappedValue2(this.cValues[i]);
                }
                catch (Exception e) {
                    continue;
                }
                label = this.rLabels == null || i >= this.rLabels.length || this.rLabels[i] == null ? this.cValues[i] : this.rLabels[i];
                for (int j = 0; j < this.numGroups; ++j) {
                    float v = value + (float)(j * (this.mapper.getIntervalCount() + 1));
                    if (this.isLineClipped(v)) continue;
                    this.adjustValue(v);
                    this.buildOneReferenceLineLabel(ch, startpt, endpt, v, label);
                }
            }
        }
    }

    private boolean isLineClipped(float value) {
        boolean clip = false;
        if (this.scrollData) {
            if (this.lineDirection == 1) {
                if (value < this.xSizeMin || value > this.xSizeMax) {
                    clip = true;
                }
            } else if (value < this.ySizeMin || value > this.ySizeMax) {
                clip = true;
            }
        }
        return clip;
    }

    private float adjustValue(float v) {
        if (!this.scrollData) {
            return v;
        }
        v = this.lineDirection == 1 ? (v -= this.xSizeMin) : (v -= this.ySizeMin);
        return v;
    }

    private void buildOneReferenceLine(Channel ch, float value) {
        Vec3f startpt = new Vec3f(this.origin);
        Vec3f endpt = new Vec3f(this.origin);
        endpt.add(this.endVector);
        Vec3f incrementVector = this.lineDirection == 1 ? new Vec3f(value - this.origin.x, 0.0f, 0.0f) : new Vec3f(0.0f, value - this.origin.y, 0.0f);
        startpt.add(incrementVector);
        startpt.add(this.paddingVector);
        endpt.add(incrementVector);
        endpt.add(this.paddingVector);
        ch.glBegin(1);
        if (this.clipRef) {
            ch.glVertex(startpt.x, startpt.y, startpt.z);
            ch.glVertex(startpt.x, startpt.y, endpt.z);
            ch.glVertex(endpt.x, endpt.y, endpt.z);
        } else {
            ch.glVertex(startpt.x, startpt.y, startpt.z);
            ch.glVertex(endpt.x, endpt.y, startpt.z);
            ch.glVertex(endpt.x, endpt.y, endpt.z);
        }
        ch.glEnd();
    }

    private void buildOneReferenceLineLabel(Channel ch, Vec3f startpt, Vec3f endpt, float value, String label) {
        Vec3f incrementVector = this.lineDirection == 1 ? new Vec3f(value - this.origin.x, 0.0f, 0.0f) : new Vec3f(0.0f, value - this.origin.y, 0.0f);
        Vec3f pt1 = new Vec3f(startpt);
        pt1.add(incrementVector);
        pt1.add(this.paddingVector);
        ch.glSelect2DFont(this.labelStyle.createFont());
        String str = label.trim();
        if (this.mapper instanceof DiscreteMapper && str.length() > this.labelStyle.getMaxChars()) {
            int index = Legend.ClippingIndex(str, this.labelStyle.getMaxChars());
            str = index != 0 ? str.substring(0, index) : str.substring(0, this.labelStyle.getMaxChars());
        }
        ch.gl2DText(str, pt1.x, pt1.y, pt1.z);
    }
}

