/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Axis;
import com.sas.graphics.util.visualize.AxisLegend;
import com.sas.graphics.util.visualize.AxisStyle;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.ContinuousMapper;
import com.sas.graphics.util.visualize.DataCell;
import com.sas.graphics.util.visualize.DataModel;
import com.sas.graphics.util.visualize.DataModelProcessor;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.DependentVariable2;
import com.sas.graphics.util.visualize.DiscreteColorLegend2;
import com.sas.graphics.util.visualize.DiscreteColorLegendStyle;
import com.sas.graphics.util.visualize.DiscreteColorMapper;
import com.sas.graphics.util.visualize.DiscreteColorMarkerMapper2;
import com.sas.graphics.util.visualize.DiscreteMapper;
import com.sas.graphics.util.visualize.ExtendedShapes;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.ReverseSortedDiscreteMapper;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.SortedDiscreteMapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.TidyContinuousMapper;
import com.sas.graphics.util.visualize.TidyContinuousMapper2;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.Visualization;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.graphics.util.visualize.WireLegend;
import com.sas.graphics.util.visualize.WireLegend2;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;

public class Overlay2
extends Visualization
implements Serializable {
    static final long serialVersionUID = 6053142807408383664L;
    public static final String RB_KEY = "Chart.";
    static final int SOUTH_LEFT = 1;
    static final int SOUTH_CENTER = 2;
    static final int SOUTH_RIGHT = 3;
    static final int EAST_UP = 4;
    static final int EAST_DOWN = 5;
    static final int[] COLOR_LABELS = new int[]{19, 20};
    static final int[] COLOR_LEGENDS = new int[]{21, 22};
    private static final double DEFAULT_GEOMETRY_SIZE = 0.4;
    private static final double DEFAULT_MARKER_SIZE = 0.5;
    private static final double DEFAULT_LINE_WIDTH = 0.1;
    private static final double DEFAULT_SIZE_SCALE = 1.0;
    protected DataModel segData;
    protected IndependentVariable columnVariable;
    protected AxisStyle columnLegendStyleUser;
    protected AxisStyle columnLegendStyle;
    protected IndependentVariable groupVariable;
    protected AxisStyle groupLegendStyleUser;
    protected AxisStyle groupLegendStyle;
    protected AxisStyle heightLegendStyle2;
    protected AxisStyle heightLegendStyle;
    protected DependentVariable2[] heightVariables;
    protected int leftAxis;
    protected int rightAxis;
    protected transient int mappedLeft;
    protected transient int mappedRight;
    protected IndependentVariable subgroupVariable;
    protected DiscreteColorLegendStyle overlayLegendStyle;
    protected double markerSize;
    protected double lineWidth;
    protected String leftUserHeightLabel;
    protected String rightUserHeightLabel;
    private double sizeScale;
    protected double geometrySize;
    private boolean absoluteSize;
    private int absoluteMarkerSize;
    private int absoluteJoinSize;
    protected boolean backplaneVisible;
    private static final Color DEFAULT_BACKPLANE_COLOR = Color.lightGray;
    protected Color backplaneColor;
    protected Color backplaneEdgeColor;
    private int missingMarker = 10;
    private Color missingColor = Color.gray;
    protected transient Mapper columnMapper;
    protected transient Mapper groupMapper;
    protected transient Mapper[] heightMappers;
    protected transient DiscreteColorMapper subgroupMapper;
    protected transient DiscreteColorMarkerMapper2 markerMapper;
    protected transient float numRows = 0.0f;
    protected transient float numColumns = 0.0f;
    protected transient DiscreteColorLegend2 subgroupLegend;
    protected transient boolean subgroupLegendScroll;
    protected transient Rectangle subgroupLegendBox;
    protected transient DiscreteColorLegend2 markerLegend;
    protected transient boolean markerLegendScroll;
    protected transient Rectangle markerLegendBox;
    protected transient int currentLegend;
    protected transient String clickedColumn;
    protected transient String clickedHeight;
    protected transient String clickedSubGroup;
    protected transient String clickedMarker;
    protected transient String clickedGroup;
    protected transient double distortX = 0.0;
    protected transient double distortY = 0.0;
    protected transient DependentVariable2 segHeight;
    protected transient int segIndex;
    protected transient IndependentVariable segColumnVariable;
    protected transient IndependentVariable segGroupVariable;
    protected transient Variable[] classifierVariableList;
    protected transient boolean segmentChart = false;
    protected transient boolean fakeHeight = false;
    protected transient boolean[] joins;
    protected transient boolean[] marks;
    protected transient AxisLegend columnLegend;
    protected transient WireLegend2 leftLegend;
    protected transient WireLegend2 rightLegend;
    protected transient String[] groupValues;
    private transient Hashtable groupTable;
    protected transient int dataModeState;
    protected float savedCols;
    protected boolean columnValueHotspotsEnabled;
    protected transient Blob[] columnValueHotspots;
    protected boolean groupValueHotspotsEnabled;
    protected transient Blob[] groupValueHotspots;
    protected boolean subgroupValueHotspotsEnabled;
    protected transient Blob[] subgroupValueHotspots;
    protected boolean variableHotspotsEnabled;
    protected Blob columnVariableHotspot;
    protected Blob leftHeightVariableHotspot;
    protected Blob rightHeightVariableHotspot;
    protected int[] mapShapes = null;
    private transient float offset;

    public Overlay2() {
        this((String)null);
    }

    public Overlay2(String title) {
        super(title);
        this.maxObservations = 0;
        this.columnVariable = new IndependentVariable();
        this.columnLegendStyle = this.columnLegendStyleUser = new AxisStyle();
        this.columnLegendStyle.setIntervals(10);
        this.groupLegendStyle = this.groupLegendStyleUser = new AxisStyle();
        this.groupLegendStyle.grid.setVisible(false);
        this.groupLegendStyle.setValueStyle(new TextStyle(this.groupLegendStyle.getLabelStyle()));
        this.heightVariables = null;
        this.heightLegendStyle = new AxisStyle();
        this.heightLegendStyle.axisType = 1;
        this.heightLegendStyle.intervals = 10;
        this.heightLegendStyle2 = new AxisStyle(this.heightLegendStyle);
        this.leftAxis = 1;
        this.rightAxis = 2;
        this.groupVariable = new IndependentVariable();
        this.subgroupVariable = new IndependentVariable();
        this.overlayLegendStyle = new DiscreteColorLegendStyle();
        this.overlayLegendStyle.position = 3;
        this.segmentChart = false;
        this.segHeight = null;
        this.segColumnVariable = null;
        this.segGroupVariable = null;
        this.segIndex = -1;
        this.classifierVariableList = null;
        this.currentLegend = -1;
        this.mapColors = DiscreteColorMapper.getMappedColors(this.overlayLegendStyle.getColorScheme());
        this.markerSize = 0.5;
        this.lineWidth = 0.1;
        this.geometrySize = 0.4;
        this.sizeScale = 1.0;
        this.leftUserHeightLabel = null;
        this.rightUserHeightLabel = null;
        this.absoluteSize = false;
        this.absoluteMarkerSize = 10;
        this.absoluteJoinSize = 5;
        this.backplaneVisible = true;
        this.backplaneColor = DEFAULT_BACKPLANE_COLOR;
        this.backplaneEdgeColor = new Color(255 - this.backplaneColor.getRed(), 255 - this.backplaneColor.getGreen(), 255 - this.backplaneColor.getBlue());
        this.savedCols = 0.0f;
        this.columnValueHotspotsEnabled = false;
        this.groupValueHotspotsEnabled = false;
        this.subgroupValueHotspotsEnabled = false;
    }

    public Overlay2(Overlay2 aOverlay) {
        super(aOverlay);
        this.columnVariable = aOverlay.columnVariable;
        this.columnLegendStyleUser = aOverlay.columnLegendStyleUser;
        this.columnLegendStyle = aOverlay.columnLegendStyleUser;
        this.groupVariable = aOverlay.groupVariable;
        this.groupLegendStyleUser = aOverlay.groupLegendStyleUser;
        this.groupLegendStyle = aOverlay.groupLegendStyleUser;
        this.heightLegendStyle = aOverlay.heightLegendStyle;
        this.heightLegendStyle2 = aOverlay.heightLegendStyle2;
        this.heightVariables = aOverlay.heightVariables;
        this.leftAxis = aOverlay.leftAxis;
        this.rightAxis = aOverlay.rightAxis;
        this.subgroupVariable = aOverlay.subgroupVariable;
        this.overlayLegendStyle = aOverlay.overlayLegendStyle;
        this.mapColors = DiscreteColorMapper.getMappedColors(this.overlayLegendStyle.getColorScheme());
        this.geometrySize = aOverlay.geometrySize;
        this.lineWidth = aOverlay.lineWidth;
        this.markerSize = aOverlay.markerSize;
        this.sizeScale = aOverlay.sizeScale;
        this.leftUserHeightLabel = aOverlay.leftUserHeightLabel;
        this.rightUserHeightLabel = aOverlay.rightUserHeightLabel;
        this.absoluteSize = aOverlay.absoluteSize;
        this.absoluteMarkerSize = aOverlay.absoluteMarkerSize;
        this.absoluteJoinSize = aOverlay.absoluteJoinSize;
        this.segmentChart = aOverlay.segmentChart;
        this.currentLegend = -1;
        this.backplaneVisible = aOverlay.backplaneVisible;
        this.backplaneColor = aOverlay.backplaneColor;
        this.backplaneEdgeColor = aOverlay.backplaneEdgeColor;
        this.savedCols = aOverlay.savedCols;
        this.columnValueHotspotsEnabled = aOverlay.columnValueHotspotsEnabled;
        this.groupValueHotspotsEnabled = aOverlay.groupValueHotspotsEnabled;
        this.subgroupValueHotspotsEnabled = aOverlay.subgroupValueHotspotsEnabled;
    }

    public int[] getMapShapes() {
        return this.mapShapes;
    }

    public void setMapShapes(int[] shapes) {
        if (shapes != null) {
            this.mapShapes = shapes;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.serialVersion == 0) {
            AxisStyle tmpStyle;
            this.heightLegendStyle2 = tmpStyle = new AxisStyle(this.heightLegendStyle);
            this.serialVersion = 1;
        }
    }

    public IndependentVariable getColumnVariable() {
        return this.columnVariable;
    }

    public void setColumnVariable(IndependentVariable v) {
        this.columnVariable = v;
        if (this.columnVariable == null) {
            this.columnVariable = new IndependentVariable();
            this.columnVariable.setIndex(-1);
        }
        this.xSizeMax = 0.0f;
        this.xSizeMin = 0.0f;
    }

    public AxisStyle getColumnLegendStyle() {
        return this.columnLegendStyleUser;
    }

    public void setColumnLegendStyle(AxisStyle aLegendStyle) {
        this.columnLegendStyleUser = aLegendStyle;
    }

    public IndependentVariable getGroupVariable() {
        return this.groupVariable;
    }

    public void setGroupVariable(IndependentVariable v) {
        this.groupVariable = v;
        if (this.groupVariable == null) {
            this.groupVariable = new IndependentVariable();
            this.groupVariable.setIndex(-1);
        }
    }

    public AxisStyle getGroupLegendStyle() {
        return this.groupLegendStyleUser;
    }

    public void setGroupLegendStyle(AxisStyle aLegendStyle) {
        this.groupLegendStyleUser = aLegendStyle;
    }

    public AxisStyle getHeightLegendStyle() {
        return this.heightLegendStyle;
    }

    public AxisStyle getHeightLegendStyle2() {
        return this.heightLegendStyle2;
    }

    public void setHeightLegendStyle(AxisStyle aLegendStyle) {
        this.heightLegendStyle = aLegendStyle;
    }

    public void setHeightLegendStyle2(AxisStyle aLegendStyle) {
        this.heightLegendStyle2 = aLegendStyle;
    }

    public DependentVariable2[] getHeightVariables() {
        return this.heightVariables;
    }

    public String[] getHeightVariablesName(boolean designTime) {
        if (this.heightVariables == null) {
            return null;
        }
        int len = this.heightVariables.length;
        int actLen = 0;
        for (int i = 0; i < len; ++i) {
            if (this.heightVariables[i].index == -1) continue;
            ++actLen;
        }
        String[] names = new String[actLen];
        actLen = 0;
        if (this.validVisualization) {
            for (int i = 0; i < len; ++i) {
                if (this.heightVariables[i].automatic && !designTime) {
                    this.fakeHeight = true;
                    int index = this.heightVariables[i].index;
                    if (index == -1) continue;
                    this.heightVariables[i].automatic = designTime;
                    this.heightVariables[i].name = this.data.getDataColumnName(index);
                    this.heightVariables[i].label = this.data.getDataColumnLabel(index);
                }
                names[actLen] = this.data.getShortName(this.heightVariables[i].index);
                ++actLen;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                names[i] = this.heightVariables[i].getName();
            }
        }
        return names;
    }

    public void setHeightVariables(DependentVariable2[] v) {
        this.heightVariables = v;
    }

    public int readjustHeight(int maxHeight) {
        int i;
        int oldLen = this.heightVariables == null ? 0 : this.heightVariables.length;
        int len = oldLen >= maxHeight ? maxHeight : Math.min(3, maxHeight);
        DependentVariable2[] newVars = len == 0 ? null : new DependentVariable2[len];
        int max = Math.min(oldLen, len);
        for (i = 0; i < max; ++i) {
            newVars[i] = this.heightVariables[i];
        }
        while (i < len) {
            newVars[i] = new DependentVariable2();
            newVars[i].scale = i + 1;
            ++i;
        }
        this.heightVariables = newVars;
        return len;
    }

    public void setLeftHeightAxis(int index) {
        this.leftAxis = index;
    }

    public int getLeftHeightAxis() {
        return this.leftAxis;
    }

    public void setRightHeightAxis(int index) {
        this.rightAxis = index;
    }

    public int getRightHeightAxis() {
        return this.rightAxis;
    }

    public IndependentVariable getSubGroupVariable() {
        return this.subgroupVariable;
    }

    public void setSubGroupVariable(IndependentVariable v) {
        this.subgroupVariable = v;
        if (this.subgroupVariable == null) {
            this.subgroupVariable = new IndependentVariable();
            this.subgroupVariable.setIndex(-1);
        }
    }

    public DiscreteColorLegendStyle getOverlayLegendStyle() {
        return this.overlayLegendStyle;
    }

    public void setOverlayLegendStyle(DiscreteColorLegendStyle aLegendStyle) {
        this.overlayLegendStyle = aLegendStyle;
        if (this.defaultColors) {
            this.mapColors = DiscreteColorMapper.getMappedColors(aLegendStyle.getColorScheme());
        }
    }

    public double getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(double markerSizeIn) {
        this.markerSize = markerSizeIn;
    }

    public double getLineSize() {
        return this.lineWidth;
    }

    public void setLineSize(double joinSizeIn) {
        this.lineWidth = joinSizeIn;
    }

    public boolean isAbsoluteSize() {
        return this.absoluteSize;
    }

    public void setAbsoluteSize(boolean absolute) {
        this.absoluteSize = absolute;
    }

    public int getAbsoluteMarkerSize() {
        return this.absoluteMarkerSize;
    }

    public void setAbsoluteMarkerSize(int size) {
        this.absoluteMarkerSize = size;
    }

    public int getAbsoluteJoinSize() {
        return this.absoluteJoinSize;
    }

    public void setAbsoluteJoinSize(int size) {
        this.absoluteJoinSize = size;
    }

    public String getLeftUserHeightLabel() {
        return this.leftUserHeightLabel;
    }

    public void setLeftUserHeightLabel(String aLabel) {
        this.leftUserHeightLabel = aLabel;
    }

    public String getRightUserHeightLabel() {
        return this.rightUserHeightLabel;
    }

    public void setRightUserHeightLabel(String aLabel) {
        this.rightUserHeightLabel = aLabel;
    }

    public boolean isBackplaneVisible() {
        return this.backplaneVisible;
    }

    public void setBackplaneVisible(boolean aBoolean) {
        this.backplaneVisible = aBoolean;
    }

    public Color getBackplaneColor() {
        return this.backplaneColor;
    }

    public void setBackplaneColor(Color backplaneColorIn) {
        this.backplaneColor = backplaneColorIn;
        this.backplaneEdgeColor = new Color(255 - this.backplaneColor.getRed(), 255 - this.backplaneColor.getGreen(), 255 - this.backplaneColor.getBlue());
    }

    public boolean isFakeHeight() {
        return this.fakeHeight;
    }

    public void setFakeHeight(boolean flag) {
        this.fakeHeight = flag;
    }

    public void setColumnValueHotspotsEnabled(boolean flag) {
        this.columnValueHotspotsEnabled = flag;
    }

    public boolean isColumnValueHotspotsEnabled() {
        return this.columnValueHotspotsEnabled;
    }

    public Blob[] getColumnValueHotspots() {
        return this.columnValueHotspots;
    }

    public void setGroupValueHotspotsEnabled(boolean flag) {
        this.groupValueHotspotsEnabled = flag;
    }

    public boolean isGroupValueHotspotsEnabled() {
        return this.groupValueHotspotsEnabled;
    }

    public Blob[] getGroupValueHotspots() {
        return this.groupValueHotspots;
    }

    public void setSubGroupValueHotspotsEnabled(boolean flag) {
        this.subgroupValueHotspotsEnabled = flag;
    }

    public boolean isSubGroupValueHotspotsEnabled() {
        return this.subgroupValueHotspotsEnabled;
    }

    public Blob[] getSubGroupValueHotspots() {
        return this.subgroupValueHotspots;
    }

    public void setVariableHotspotsEnabled(boolean flag) {
        this.variableHotspotsEnabled = flag;
    }

    public boolean isVariableHotspotsEnabled() {
        return this.variableHotspotsEnabled;
    }

    @Override
    protected boolean isLegendHotspotsActive() {
        return this.isColumnValueHotspotsEnabled() || this.isSubGroupValueHotspotsEnabled() || this.isGroupValueHotspotsEnabled() || this.isVariableHotspotsEnabled() || super.isLegendHotspotsActive();
    }

    public Blob[] getVariableHotspots() {
        int count = this.columnVariableHotspot == null ? 0 : 1;
        count += this.leftHeightVariableHotspot == null ? 0 : 1;
        if ((count += this.rightHeightVariableHotspot == null ? 0 : 1) < 1) {
            return null;
        }
        Blob[] variableHotspots = new Blob[count];
        count = 0;
        if (this.columnVariableHotspot != null) {
            variableHotspots[count++] = this.columnVariableHotspot;
        }
        if (this.leftHeightVariableHotspot != null) {
            variableHotspots[count++] = this.leftHeightVariableHotspot;
        }
        if (this.rightHeightVariableHotspot != null) {
            variableHotspots[count++] = this.rightHeightVariableHotspot;
        }
        return variableHotspots;
    }

    @Override
    public boolean validData() {
        if (this.dataUser.getColumnCount() < 2) {
            return false;
        }
        return this.dataUser.getRowCount() >= 1;
    }

    @Override
    public boolean validVariables(boolean checkOnly) {
        int i;
        if (!this.dataUser.findIndex(this.columnVariable, checkOnly) || !this.dataUser.findIndex(this.subgroupVariable, checkOnly)) {
            return false;
        }
        if (!this.dataUser.findIndex(this.groupVariable, checkOnly)) {
            return false;
        }
        if (this.fakeHeight) {
            try {
                for (i = 0; i < this.heightVariables.length; ++i) {
                    this.heightVariables[i].reset();
                    if (this.dataUser.findIndex(this.heightVariables[i], checkOnly)) continue;
                    this.heightVariables = null;
                    this.fakeHeight = false;
                    return true;
                }
            }
            catch (VisualizationException e) {
                this.heightVariables = null;
                this.fakeHeight = false;
                return true;
            }
        }
        if (this.heightVariables != null) {
            for (i = 0; i < this.heightVariables.length; ++i) {
                if (this.dataUser.findIndex(this.heightVariables[i], checkOnly)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void resetVariables(boolean indexOnly) {
        if (this.columnVariable == null) {
            this.columnVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.columnVariable.reset();
        } else {
            this.columnVariable.setAutomatic(true);
        }
        if (this.subgroupVariable == null) {
            this.subgroupVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.subgroupVariable.reset();
        } else {
            this.subgroupVariable.setAutomatic(true);
        }
        if (this.groupVariable == null) {
            this.groupVariable = new IndependentVariable();
        } else if (indexOnly) {
            this.groupVariable.reset();
        } else {
            this.groupVariable.setAutomatic(true);
        }
        if (this.heightVariables != null) {
            for (int i = 0; i < this.heightVariables.length; ++i) {
                if (this.heightVariables[i] == null) {
                    this.heightVariables[i] = new DependentVariable2();
                    continue;
                }
                if (indexOnly) {
                    this.heightVariables[i].reset();
                    continue;
                }
                this.heightVariables[i].setAutomatic(true);
            }
        }
        this.segmentChart = false;
        this.fakeHeight = false;
        this.xSizeMax = 0.0f;
        this.xSizeMin = 0.0f;
    }

    @Override
    protected void validateVariables() {
        int i;
        int i2;
        this.data.resetReferences();
        this.classifierVariableList = null;
        if (!this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 3);
        }
        if (!this.subgroupVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.subgroupVariable, 3);
        }
        if (this.groupVariable != null) {
            if (this.groupVariable.isAutomatic()) {
                if (this.data.isDerivedFromMDDB()) {
                    this.data.chooseVariable((Variable)this.groupVariable, 2);
                } else {
                    this.groupVariable.index = -1;
                    this.groupVariable.indexIn = -1;
                }
            } else {
                this.data.chooseVariable((Variable)this.groupVariable, 3);
            }
        }
        if (this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 2);
            if (this.isNoneVariable(this.columnVariable)) {
                if (this.data.isDerivedFromMDDB()) {
                    if (!this.isNoneVariable(this.groupVariable) && this.groupVariable.isAutomatic()) {
                        this.columnVariable.index = this.groupVariable.index;
                        this.columnVariable.indexIn = this.groupVariable.indexIn;
                        this.groupVariable.index = -1;
                        this.groupVariable.indexIn = -1;
                    }
                    if (this.isNoneVariable(this.columnVariable) && !this.isNoneVariable(this.subgroupVariable)) {
                        this.columnVariable.index = this.subgroupVariable.index;
                        this.columnVariable.indexIn = this.subgroupVariable.indexIn;
                    }
                    if (this.isNoneVariable(this.columnVariable)) {
                        this.data.chooseVariable(this.columnVariable, 2, true);
                    }
                } else {
                    this.data.chooseVariable((Variable)this.columnVariable, 3);
                }
            }
        }
        if (this.isNoneVariable(this.columnVariable)) {
            throw new VisualizationException(RB.getStringResource("Visualization.categoryVariable.ex.txt"));
        }
        this.segmentChart = false;
        this.segHeight = null;
        this.segIndex = -1;
        if (this.heightVariables != null && this.heightVariables.length > 0) {
            for (i2 = 0; i2 < this.heightVariables.length; ++i2) {
                if (this.heightVariables[i2].chartType != 3) continue;
                if (!this.segmentChart) {
                    this.segmentChart = true;
                    this.segIndex = i2;
                    continue;
                }
                this.heightVariables[i2].chartType = 1;
            }
        } else {
            int count = 0;
            for (i = 0; i < this.data.getColumnCount(); ++i) {
                if (!this.data.isContinuous(i) || i == this.columnVariable.index) continue;
                ++count;
            }
            count = Math.max(1, Math.min(3, count));
            this.heightVariables = new DependentVariable2[count];
            for (i = 0; i < this.heightVariables.length; ++i) {
                this.heightVariables[i] = new DependentVariable2();
                this.heightVariables[i].scale = i + 1;
            }
            this.heightVariables[0].chartType = 3;
            this.segmentChart = true;
            this.segIndex = 0;
        }
        for (i2 = 0; i2 < this.heightVariables.length; ++i2) {
            if (this.heightVariables[i2].isAutomatic()) continue;
            this.data.chooseVariable((Variable)this.heightVariables[i2], 1);
        }
        for (i2 = 0; i2 < this.heightVariables.length; ++i2) {
            if (!this.heightVariables[i2].isAutomatic()) continue;
            this.data.chooseVariable((Variable)this.heightVariables[i2], 1);
        }
        boolean responseLocated = false;
        for (i = 0; i < this.heightVariables.length; ++i) {
            responseLocated |= !this.isNoneVariable(this.heightVariables[i]);
        }
        if (!responseLocated && this.heightVariables.length > 0) {
            this.data.chooseVariable(this.heightVariables[this.segmentChart ? this.segIndex : 0], 1, true);
        }
        this.defaultResponseVariable(this.columnVariable, this.heightVariables[0]);
        if (this.segmentChart) {
            this.segHeight = new DependentVariable2(this.heightVariables[this.segIndex]);
            if (this.data.isSummable(this.heightVariables)) {
                if (this.subgroupVariable.isAutomatic()) {
                    this.data.chooseVariable((Variable)this.subgroupVariable, this.data.isDerivedFromMDDB() ? 2 : 3);
                    if (this.isNoneVariable(this.subgroupVariable)) {
                        this.subgroupVariable.indexIn = this.columnVariable.indexIn;
                        this.subgroupVariable.index = this.columnVariable.index;
                    }
                }
            } else {
                this.subgroupVariable.index = -1;
                this.subgroupVariable.indexIn = -1;
            }
        } else if (this.subgroupVariable.isAutomatic()) {
            this.subgroupVariable.index = -1;
            this.subgroupVariable.indexIn = -1;
        }
        boolean[] usedScales = new boolean[12];
        for (i = 0; i < 12; ++i) {
            usedScales[i] = false;
        }
        for (i = 0; i < this.heightVariables.length; ++i) {
            usedScales[this.heightVariables[i].scale - 1] = true;
        }
        DependentVariable2.usedScales = usedScales;
    }

    @Override
    protected void postProcessVariables() {
    }

    private void postProcessVariables2(Variable[] classifierVariables, Variable[] analysisVariables) {
        if (this.dataUser.isDerivedFromMDDB() && classifierVariables != null && !this.dataUser.isSummable(analysisVariables)) {
            boolean found = false;
            for (int ii = classifierVariables.length - 1; !found && ii >= 0; --ii) {
                if (classifierVariables[ii] == null) continue;
                found = this.dataUser.chooseAuxVariables(classifierVariables[ii]);
            }
        }
    }

    @Override
    protected void processDataModel() {
        Variable[] responses = new DependentVariable2[this.heightVariables.length];
        for (int i = 0; i < this.heightVariables.length; ++i) {
            responses[i] = this.heightVariables[i];
        }
        if (this.segmentChart) {
            this.segColumnVariable = this.copy(this.columnVariable);
            this.segGroupVariable = this.copy(this.groupVariable);
            IndependentVariable[] segClassifiers = new IndependentVariable[]{this.segColumnVariable, this.subgroupVariable, this.segGroupVariable};
            DependentVariable[] segResponses = new DependentVariable2[]{this.segHeight};
            Variable[] orderedSegClassifiers = new Variable[]{this.segGroupVariable, this.segColumnVariable, this.subgroupVariable};
            this.postProcessVariables2(orderedSegClassifiers, responses);
            DataModelProcessor dmp1 = new DataModelProcessor(this.dataUser);
            dmp1.ignoreEntireRow = false;
            dmp1.showStatistic = this.showStatistic;
            this.segData = dmp1.process(segClassifiers, segResponses);
        } else {
            this.segGroupVariable = null;
            this.segColumnVariable = null;
            this.segHeight = null;
        }
        int savedStats = 0;
        IndependentVariable[] classifiers = new IndependentVariable[]{this.columnVariable, this.groupVariable, this.subgroupVariable};
        if (this.segmentChart) {
            if (!this.frequencyPlot) {
                savedStats = this.heightVariables[this.segIndex].statistic;
                this.heightVariables[this.segIndex].statistic = 7;
            }
            classifiers[2] = null;
        }
        if (this.segmentChart) {
            this.columnVariable.aux = this.segColumnVariable.aux;
            this.columnVariable.auxIn = this.segColumnVariable.auxIn;
        } else {
            Variable[] orderedClassifiers = new Variable[]{this.groupVariable, this.columnVariable, this.subgroupVariable};
            this.postProcessVariables2(orderedClassifiers, responses);
        }
        DataModelProcessor dmp = new DataModelProcessor(this.dataUser);
        dmp.ignoreEntireRow = false;
        dmp.showStatistic = this.showStatistic;
        this.data = dmp.process(classifiers, (DependentVariable[])responses);
        if (this.frequencyPlot) {
            for (int i = 0; i < this.heightVariables.length; ++i) {
                this.resetResponseVariable(this.heightVariables[i]);
            }
            if (this.segmentChart) {
                this.resetResponseVariable(this.segHeight);
            }
        } else if (this.segmentChart) {
            this.heightVariables[this.segIndex].statistic = savedStats;
        }
    }

    @Override
    protected void createMappers() {
        if (this.heightLegendStyle2 == null) {
            this.heightLegendStyle2 = new AxisStyle(this.heightLegendStyle);
        }
        this.assignColumnMapper(true);
        this.assignGroupMapper();
        this.assignHeightMapper();
        this.assignMarkerMapper();
        this.assignSubGroupMapper();
    }

    protected void assignColumnMapper(boolean forceDiscrete) {
        if (this.isVariableNotSet(this.columnVariable)) {
            this.columnMapper = new ConstantMapper(1, 0.5f);
        } else if (!forceDiscrete && this.data.isContinuous(this.columnVariable)) {
            switch (this.columnVariable.sort) {
                case 0: 
                case 1: {
                    this.columnMapper = new TidyContinuousMapper(this.getColumnLegendStyle().getIntervals(), 0.0f, this.getColumnLegendStyle().getIntervals());
                    break;
                }
                case 2: {
                    this.columnMapper = new TidyContinuousMapper(this.getColumnLegendStyle().getIntervals(), this.getColumnLegendStyle().getIntervals(), 0.0f);
                    break;
                }
            }
            ((TidyContinuousMapper)this.columnMapper).setFixedIntervals(this.getColumnLegendStyle().isFixedIntervals());
        } else {
            switch (this.columnVariable.sort) {
                case 0: {
                    this.columnMapper = new DiscreteMapper(0.5f);
                    break;
                }
                case 1: {
                    this.columnMapper = new SortedDiscreteMapper(0.5f);
                    break;
                }
                case 2: {
                    this.columnMapper = new ReverseSortedDiscreteMapper(0.5f);
                    break;
                }
            }
        }
    }

    protected void assignGroupMapper() {
        if (this.isVariableNotSet(this.groupVariable)) {
            this.groupMapper = new ConstantMapper(1, 0.0f);
        } else {
            switch (this.groupVariable.sort) {
                case 0: {
                    this.groupMapper = new DiscreteMapper(0.0f);
                    break;
                }
                case 1: {
                    this.groupMapper = new SortedDiscreteMapper(0.0f);
                    break;
                }
                case 2: {
                    this.groupMapper = new ReverseSortedDiscreteMapper(0.0f);
                    break;
                }
            }
        }
    }

    protected void assignHeightMapper() {
        int i;
        float Hmax;
        int len = this.heightVariables == null ? 1 : this.heightVariables.length;
        int nCols = this.data.getUniqueObservations(this.columnVariable, null);
        if (this.isVariableNotSet(this.groupVariable)) {
            Hmax = (float)nCols * this.aspect;
        } else {
            int nGroups = 0;
            Hmax = 0.0f;
            for (int i2 = 0; i2 < len; ++i2) {
                nGroups = Math.max(nGroups, this.data.getUniqueObservations(this.groupVariable, this.heightVariables[i2]));
                Hmax = (float)((nCols + 1) * nGroups - 1) * this.aspect;
            }
        }
        if (this.heightVariables == null || !this.data.isContinuous(this.heightVariables[0])) {
            this.heightMappers = new Mapper[1];
            this.heightMappers[0] = new ConstantMapper(1, Hmax);
            return;
        }
        this.mappedLeft = Integer.MAX_VALUE;
        this.mappedRight = Integer.MAX_VALUE;
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        len = this.heightVariables.length;
        int size = 0;
        for (i = 0; i < len; ++i) {
            if (this.heightVariables[i].index == -1) continue;
            String key = String.valueOf(this.heightVariables[i].scale);
            if (ht.containsKey(key)) {
                try {
                    this.heightVariables[i].mappedScale = (Integer)ht.get(key);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.leftAxis == this.heightVariables[i].scale) {
                this.mappedLeft = size;
            } else if (this.rightAxis == this.heightVariables[i].scale) {
                this.mappedRight = size;
            }
            Integer obj = new Integer(size);
            ht.put(key, obj);
            this.heightVariables[i].mappedScale = size++;
        }
        len = size;
        if (this.mappedLeft == Integer.MAX_VALUE) {
            this.mappedLeft = this.mappedRight;
            for (i = 0; i < len; ++i) {
                if (this.heightVariables[i].mappedScale == this.mappedRight) continue;
                this.mappedLeft = this.heightVariables[i].mappedScale;
                break;
            }
        }
        if (this.mappedRight == Integer.MAX_VALUE) {
            for (i = 0; i < len; ++i) {
                if (this.heightVariables[i].mappedScale == this.mappedLeft) continue;
                this.mappedRight = this.heightVariables[i].mappedScale;
                break;
            }
        }
        if (this.mappedLeft == this.mappedRight) {
            this.mappedRight = Integer.MAX_VALUE;
        }
        if (this.segmentChart) {
            this.segHeight.mappedScale = this.heightVariables[this.segIndex].mappedScale;
        }
        this.heightMappers = new Mapper[len];
        boolean bothAxis = this.mappedLeft < len && this.mappedRight < len;
        for (int i3 = 0; i3 < len; ++i3) {
            if (i3 == this.mappedLeft) {
                this.heightMappers[i3] = new TidyContinuousMapper(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
                continue;
            }
            if (i3 == this.mappedRight && bothAxis) {
                if (this.heightLegendStyle2.isFixedDataRange()) {
                    this.heightMappers[i3] = new TidyContinuousMapper2(this.heightLegendStyle.getIntervals(), (float)this.heightLegendStyle2.getDataMinValue(), (float)this.heightLegendStyle2.getDataMaxValue(), 0.0f, Hmax);
                    continue;
                }
                this.heightMappers[i3] = new TidyContinuousMapper2(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
                continue;
            }
            this.heightMappers[i3] = new ContinuousMapper(1, 0.0f, Hmax);
        }
        if (this.segmentChart) {
            if (this.segHeight.mappedScale == this.mappedLeft && !this.heightLegendStyle.isFixedDataRange()) {
                this.heightMappers[this.segHeight.mappedScale].addValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
            } else if (this.segHeight.mappedScale == this.mappedRight && !this.heightLegendStyle2.isFixedDataRange()) {
                this.heightMappers[this.segHeight.mappedScale].addValue(DoubleData.toString((double)this.heightLegendStyle2.getOrigin()));
            }
        }
        ((TidyContinuousMapper)this.heightMappers[this.mappedLeft]).setFixedIntervals(this.heightLegendStyle.isFixedIntervals());
        if (this.heightMappers.length > this.mappedRight) {
            ((TidyContinuousMapper)this.heightMappers[this.mappedRight]).setFixedIntervals(this.heightLegendStyle2.isFixedIntervals());
        }
    }

    protected void assignSubGroupMapper() {
        if (!this.isVariableNotSet(this.subgroupVariable)) {
            if (this.defaultColors) {
                this.subgroupMapper = new DiscreteColorMapper();
                this.mapColors = this.subgroupMapper.getMappedColors();
                this.subgroupMapper.setColorScheme(this.overlayLegendStyle.getColorScheme());
            } else {
                this.subgroupMapper = new DiscreteColorMapper(this.mapColors);
            }
        } else {
            this.subgroupMapper = null;
        }
    }

    protected void assignMarkerMapper() {
        if (this.defaultColors) {
            this.markerMapper = new DiscreteColorMarkerMapper2();
            if (this.mapShapes != null) {
                this.markerMapper.setMappedShapes(this.mapShapes);
            }
            this.mapColors = this.markerMapper.getMappedColors();
            this.markerMapper.setColorScheme(this.overlayLegendStyle.getColorScheme());
        } else {
            this.markerMapper = new DiscreteColorMarkerMapper2();
            if (this.mapShapes != null) {
                this.markerMapper.setMappedShapes(this.mapShapes);
            }
        }
    }

    @Override
    protected void initializeMappers() {
        int i;
        int rowCount = this.data.getRowCount();
        int hCount = 0;
        String label = null;
        int len = this.heightVariables.length;
        boolean subgroup = !this.isVariableNotSet(this.subgroupVariable);
        boolean subAll = subgroup && !this.segmentChart;
        boolean[] invalidHeight = new boolean[len];
        for (i = 0; i < len; ++i) {
            invalidHeight[i] = this.isVariableNotSet(this.heightVariables[i]);
        }
        for (i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            if (this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable)) continue;
            if (subAll) {
                if (this.data.isValueMissing(this.subgroupVariable)) continue;
                this.subgroupMapper.addValue(this.data.getString(this.subgroupVariable), this.data.getPrimaryString(this.subgroupVariable));
            }
            for (int j = 0; j < len; ++j) {
                if (invalidHeight[j] || this.data.isValueMissing(this.heightVariables[j])) continue;
                ++hCount;
                int index = this.heightVariables[j].mappedScale;
                if (index == this.mappedLeft) {
                    if (this.heightLegendStyle.isFixedDataRange()) continue;
                    this.heightMappers[index].addValue(this.data.getString(this.heightVariables[j]));
                    continue;
                }
                if (index == this.mappedRight) {
                    if (this.heightLegendStyle2.isFixedDataRange()) continue;
                    this.heightMappers[index].addValue(this.data.getString(this.heightVariables[j]));
                    continue;
                }
                this.heightMappers[index].addValue(this.data.getString(this.heightVariables[j]));
            }
            this.columnMapper.addValue(this.data.getString(this.columnVariable), this.data.getPrimaryString(this.columnVariable));
            this.groupMapper.addValue(this.data.getString(this.groupVariable));
        }
        if (hCount == 0) {
            throw new VisualizationException(RB.getStringResource("Visualization.missingColumn.ex.txt"));
        }
        if (this.segmentChart) {
            int rowCount2 = this.segData.getRowCount();
            int mIndex = this.segHeight.mappedScale;
            hCount = 0;
            for (int i2 = 0; i2 < rowCount2; ++i2) {
                this.segData.setRow(i2);
                if (this.segData.isValueMissing(this.segColumnVariable) || this.segData.isValueMissing(this.segGroupVariable) || this.segData.isValueMissing(this.subgroupVariable) || this.segData.isValueMissing(this.segHeight)) continue;
                ++hCount;
                if (mIndex == this.mappedLeft && !this.heightLegendStyle.isFixedDataRange()) {
                    this.heightMappers[mIndex].addValue(this.segData.getString(this.segHeight));
                } else if (mIndex == this.mappedRight && !this.heightLegendStyle2.isFixedDataRange()) {
                    this.heightMappers[mIndex].addValue(this.segData.getString(this.segHeight));
                }
                if (subgroup) {
                    this.subgroupMapper.addValue(this.segData.getString(this.subgroupVariable), this.segData.getPrimaryString(this.subgroupVariable));
                }
                this.groupMapper.addValue(this.segData.getString(this.segGroupVariable));
                this.columnMapper.addValue(this.segData.getString(this.segColumnVariable), this.segData.getPrimaryString(this.segColumnVariable));
            }
        } else if (!subAll) {
            this.subgroupMapper = null;
        }
        if (this.heightLegendStyle.isFixedDataRange()) {
            this.heightMappers[this.mappedLeft].addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMinValue()));
            this.heightMappers[this.mappedLeft].addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMaxValue()));
        }
        this.joins = new boolean[len];
        this.marks = new boolean[len];
        for (int k = 0; k < len; ++k) {
            if (this.heightVariables[k].index == -1) continue;
            label = this.data.getName(this.heightVariables[k].index);
            this.markerMapper.addValue(label);
            this.joins[k] = this.isJoined(this.heightVariables[k]);
            this.marks[k] = this.isMarked(this.heightVariables[k]);
        }
        if (len > this.mappedRight && this.heightMappers[this.mappedRight] instanceof TidyContinuousMapper2) {
            TidyContinuousMapper2 cMapper = (TidyContinuousMapper2)this.heightMappers[this.mappedRight];
            int intervals = this.heightMappers[this.mappedLeft] instanceof TidyContinuousMapper ? ((TidyContinuousMapper)this.heightMappers[this.mappedLeft]).getAdjustedIntervalCount() : this.heightMappers[this.mappedLeft].getIntervalCount();
            cMapper.intervals = intervals;
            intervals = cMapper.getAdjustedIntervalCount();
        }
        if (this.subgroupMapper != null && this.markerMapper != null) {
            this.markerMapper.colorOffset = this.subgroupMapper.getIntervalCount();
        }
    }

    @Override
    protected void removeLegends() {
        this.columnLegend = null;
        this.leftLegend = null;
        this.rightLegend = null;
    }

    @Override
    protected void addLegends(Channel ch) {
        ch.glSelect2DFont(this.heightLegendStyle.valueStyle.createFont());
        float vsz = (float)ch.glGetTextHeight() / 2.0f;
        float bsz = (float)ch.glGetTextWidth(" ");
        ch.glSelect2DFont(this.heightLegendStyle2.valueStyle.createFont());
        float vsz2 = (float)ch.glGetTextHeight() / 2.0f;
        float bsz2 = (float)ch.glGetTextWidth(" ");
        this.verticalSpaceSize = Math.max(vsz, vsz2);
        this.blankSpaceSize = Math.max(bsz, bsz2);
        this.addBackPlanes(ch);
        this.addColumnLegends(ch);
        this.addHeightLegends(ch);
    }

    @Override
    protected void addColorLegends(Channel ch) {
        if (!this.overlayLegendStyle.getVisible()) {
            return;
        }
        boolean noScroll = this.overlayLegendStyle.getNoScroll();
        ch.glCallList(COLOR_LEGENDS[0]);
        ch.glCallList(COLOR_LEGENDS[1]);
        ch.glEndList();
        ch.glEnable(3);
        if (this.subgroupMapper != null && this.markerMapper != null) {
            float ys;
            float xs;
            float legHeight;
            float legWidth;
            ch.glNewList(COLOR_LEGENDS[0]);
            int pos1 = 3;
            int pos2 = 1;
            String[] markerValues = this.markerMapper.getValueLabels();
            String[] subgroupValues = this.subgroupMapper.getValueLabels();
            String[] formattedValues2 = this.dataUser.format((Variable)this.subgroupVariable, subgroupValues);
            if (formattedValues2 != null) {
                subgroupValues = formattedValues2;
            }
            if (this.overlayLegendStyle.defaultSize) {
                int i;
                legWidth = (0.92f * (float)this.width - (float)this.leftMargin - (float)this.rightMargin) / 2.0f - (float)(2 * this.blankSpacePixels);
                TextStyle ts = this.overlayLegendStyle.labelStyle;
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int labelFontPixels = fm.getHeight();
                ts = this.overlayLegendStyle.valueStyle;
                fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int valueFontPixels = fm.getHeight();
                int len = markerValues.length;
                double valueLenMarker = 0.0;
                double valueLenSubgroup = 0.0;
                for (i = 0; i < len; ++i) {
                    valueLenMarker = Math.max(valueLenMarker, (double)fm.stringWidth(markerValues[i].substring(0, Math.min(markerValues[i].length(), ts.maxChars))));
                }
                len = subgroupValues.length;
                for (i = 0; i < len; ++i) {
                    valueLenSubgroup = Math.max(valueLenSubgroup, (double)fm.stringWidth(subgroupValues[i].substring(0, Math.min(subgroupValues[i].length(), ts.maxChars))));
                }
                double numColsMarker = Math.floor((double)legWidth / (valueLenMarker += 1.33 * ch.glGetTextWidth("W")));
                double numRowsMarker = Math.ceil((double)markerValues.length / numColsMarker);
                double numColsSubgroup = Math.floor((double)legWidth / (valueLenSubgroup += 1.33 * ch.glGetTextWidth("W")));
                double numRowsSubgroup = Math.ceil((double)subgroupValues.length / numColsSubgroup);
                double numRows = Math.max(numRowsMarker, numRowsSubgroup);
                double maxNumRows = Math.floor(((double)this.height * 0.5 - 1.5 * (double)labelFontPixels) / (1.5 * (double)valueFontPixels));
                numRows = Math.min(maxNumRows, numRows);
                int oldsize = (int)Math.max(0.25 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
                if (!noScroll) {
                    numRows = 1.0;
                    oldsize = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
                }
                legHeight = (float)((double)labelFontPixels + numRows * 1.5 * (double)valueFontPixels);
                if (!noScroll) {
                    legHeight = (float)Math.max(0.2 * (double)this.ySizePixels, (double)(labelFontPixels + 2 * valueFontPixels));
                }
                this.ySizePixels += oldsize - (int)legHeight;
            } else {
                legWidth = (float)((double)this.width * this.overlayLegendStyle.width);
                legHeight = (float)((double)this.height * this.overlayLegendStyle.height);
            }
            if (this.overlayLegendStyle.position == 3) {
                xs = legWidth / (float)this.width;
                ys = legHeight / (float)this.height;
            } else {
                xs = (float)this.overlayLegendStyle.width;
                ys = (float)this.overlayLegendStyle.height / 2.0f;
                pos1 = 4;
                pos2 = 5;
            }
            if (this.segmentChart) {
                this.markerLegend = new DiscreteColorLegend2(this.markerMapper);
                this.markerLegend.segIndex = this.segIndex;
            } else {
                this.markerLegend = new DiscreteColorLegend2(this.markerMapper, true, false);
            }
            this.markerLegend.joins = this.joins;
            this.markerLegend.marks = this.marks;
            this.markerLegend.setLabel(RB.getStringResource(RB_KEY, "overlayLabel.txt"));
            this.markerLegend.values = markerValues;
            this.markerLegend.formattedValues = markerValues;
            this.resetColorLegend(ch, this.markerLegend, this.markerMapper, xs, ys, pos1);
            this.markerLegendScroll = this.markerLegend.isScrollable();
            ch.glEndList();
            ch.glNewList(COLOR_LEGENDS[1]);
            this.subgroupLegend = new DiscreteColorLegend2(this.subgroupMapper, false, true);
            this.subgroupLegend.values = this.subgroupMapper.getValueLabels();
            this.subgroupLegend.primaryValues = this.subgroupMapper.getPrimaryValueLabels();
            this.subgroupLegend.formattedValues = subgroupValues;
            if (this.isVariableNotSet(this.subgroupVariable)) {
                this.subgroupLegend.setLabel(RB.getStringResource(RB_KEY, "subgroupLabel.txt"));
            } else if (this.segmentChart) {
                this.subgroupLegend.setLabel(this.segData.getDisplayLabel(this.subgroupVariable));
            } else {
                this.subgroupLegend.setLabel(this.data.getDisplayLabel(this.subgroupVariable));
            }
            this.subgroupLegend.setValueHotspotsEnabled(this.isSubGroupValueHotspotsEnabled());
            this.subgroupLegend.setValueHotspotID(3);
            this.resetColorLegend(ch, this.subgroupLegend, this.subgroupMapper, xs, ys, pos2);
            this.subgroupValueHotspots = this.subgroupLegend.getValueHotspots();
            this.subgroupLegendScroll = this.subgroupLegend.isScrollable();
            this.yColorLegendSize += Math.max(this.markerLegend.vLegendOffset, this.subgroupLegend.vLegendOffset) + (float)this.blankSpacePixels;
        } else {
            float ys;
            float xs;
            String[] markerValues = this.markerMapper.getValueLabels();
            if (this.overlayLegendStyle.defaultSize) {
                float legWidth = this.xSizePixels;
                TextStyle ts = this.overlayLegendStyle.labelStyle;
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int labelFontPixels = fm.getHeight();
                ts = this.overlayLegendStyle.valueStyle;
                fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int valueFontPixels = fm.getHeight();
                int len = Math.min(6, markerValues.length);
                int valueLen = 0;
                for (int i = 0; i < len; ++i) {
                    valueLen = Math.max(valueLen, fm.stringWidth(markerValues[i].substring(0, Math.min(markerValues[i].length(), ts.maxChars))));
                }
                int numrows = (int)(legWidth / (float)((valueLen += (int)(1.5 * (double)valueFontPixels)) * markerValues.length));
                int oldsize = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
                float legHeight = numrows != 2 ? (float)Math.max(0.2 * (double)this.ySizePixels, (double)(labelFontPixels + 2 * valueFontPixels)) : (float)labelFontPixels + 3.2f * (float)valueFontPixels;
                this.ySizePixels += oldsize - (int)legHeight;
                xs = legWidth / (float)this.width;
                ys = legHeight / (float)this.height;
            } else {
                xs = (float)this.overlayLegendStyle.width;
                ys = (float)this.overlayLegendStyle.height;
            }
            int pos = 2;
            ch.glNewList(COLOR_LEGENDS[0]);
            this.markerLegend = new DiscreteColorLegend2(this.markerMapper);
            this.markerLegend.joins = this.joins;
            this.markerLegend.marks = this.marks;
            this.markerLegend.segIndex = this.segmentChart ? this.segIndex : -1;
            this.markerLegend.values = this.markerMapper.getValueLabels();
            this.markerLegend.formattedValues = this.markerLegend.values;
            this.markerLegend.setLabel(RB.getStringResource(RB_KEY, "overlayLabel.txt"));
            this.resetColorLegend(ch, this.markerLegend, this.markerMapper, xs, ys, pos);
            this.markerLegendScroll = this.markerLegend.isScrollable();
            ch.glEndList();
            if (this.overlayLegendStyle.position == 3) {
                this.yColorLegendSize += this.markerLegend.vLegendOffset + (float)this.blankSpacePixels;
            } else if (this.overlayLegendStyle.position == 0) {
                this.xColorLegendSize += this.markerLegend.hLegendOffset + (float)(2 * this.blankSpacePixels);
            }
            this.subgroupLegend = null;
            this.subgroupLegendBox = null;
            this.subgroupLegendScroll = false;
            ch.glNewList(COLOR_LEGENDS[1]);
        }
        if (this.edgeColor != null) {
            ch.glEdgeColor(this.edgeColor);
        }
    }

    private void resetColorLegend(Channel ch, DiscreteColorLegend2 legend, Mapper mapper, float xs, float ys, int position) {
        if (this.edgeColor != null) {
            legend.setEdgeColor(this.edgeColor);
        }
        Vec3f legPosition = new Vec3f();
        float legWidth = xs * (float)this.width;
        float legHeight = ys * (float)this.height;
        boolean noScroll = this.overlayLegendStyle.getNoScroll();
        if (noScroll) {
            legHeight = (float)((double)this.height * 0.5);
            legend.setSize(new Vec3f(legWidth, legHeight, 1.0f));
            legend.setIntervals(mapper.getIntervalCount());
            legend.valueStyle = this.overlayLegendStyle.valueStyle;
            legend.valueStyle.majorJustify = "LEFT";
            legend.valueStyle.minorJustify = "CENTER";
            legend.labelStyle = this.overlayLegendStyle.labelStyle;
            legHeight = legend.calculateHeight(ch);
        }
        legend.setPosition(this.overlayLegendStyle.position, new Vec3f(legWidth, legHeight, 1.0f), legPosition);
        legend.setSize(new Vec3f(legWidth, legHeight, 1.0f));
        ch.glSelect2DFont(this.overlayLegendStyle.labelStyle.createFont());
        double labelHeight = ch.glGetTextHeight();
        legend.setIntervals(mapper.getIntervalCount());
        legend.valueStyle = this.overlayLegendStyle.valueStyle;
        legend.valueStyle.majorJustify = "LEFT";
        legend.valueStyle.minorJustify = "CENTER";
        legend.labelStyle = this.overlayLegendStyle.labelStyle;
        legPosition.y = this.yColorLegendSize + (float)this.bottomMargin + legHeight + 0.03f * (float)this.height;
        legPosition.z = 0.0f;
        switch (position) {
            default: {
                legPosition.x = ((float)(this.width - this.leftMargin - this.rightMargin) - legWidth) / 2.0f;
                break;
            }
            case 1: {
                legPosition.x = (float)this.blankSpacePixels + 0.03f * (float)this.width;
                break;
            }
            case 3: {
                legPosition.x = 0.97f * (float)this.width - (float)this.leftMargin - (float)this.rightMargin - (float)this.blankSpacePixels - legWidth;
            }
        }
        legend.defaultSize = false;
        legend.addLegend(ch, this.overlayLegendStyle.getVisible());
    }

    @Override
    protected void addColorLegendLabels(Channel ch) {
        ch.glCallList(COLOR_LABELS[0]);
        ch.glCallList(COLOR_LABELS[1]);
        ch.glEndList();
        ch.glNewList(COLOR_LABELS[0]);
        if (this.markerLegend != null) {
            this.markerLegend.addLabelsBox(ch);
        }
        ch.glEndList();
        ch.glNewList(COLOR_LABELS[1]);
        if (this.subgroupLegend != null) {
            this.subgroupLegend.addLabelsBox(ch);
        }
    }

    @Override
    protected void addObservations(Channel ch) {
        int k;
        int j;
        int nPoints;
        int nSubGroups;
        boolean subgroup;
        boolean subgroupSet;
        boolean group;
        double mSize;
        double jSize;
        int i;
        int numUniqCols = this.columnMapper.getIntervalCount();
        int nGroups = this.groupMapper.getIntervalCount();
        this.numColumns = nGroups * (numUniqCols + 1) - 1;
        if (this.xSizeMin == this.xSizeMax || this.savedCols != this.numColumns) {
            this.xSizeMin = 0.0f;
            this.xSize = this.xSizeMax = this.numColumns;
            this.savedCols = this.numColumns;
        } else {
            this.xSize = this.xSizeMax - this.xSizeMin;
        }
        int nMappers = this.heightMappers.length;
        float Hmax = this.xSize * this.aspect;
        for (i = 0; i < nMappers; ++i) {
            if (this.heightMappers[i] instanceof TidyContinuousMapper) {
                ((TidyContinuousMapper)this.heightMappers[i]).adjusted = false;
            }
            if (this.heightMappers[i] instanceof ContinuousMapper) {
                ((ContinuousMapper)this.heightMappers[i]).mappedMax = Hmax;
                continue;
            }
            if (!(this.heightMappers[i] instanceof ConstantMapper)) continue;
            ((ConstantMapper)this.heightMappers[i]).mappedValue = Hmax;
        }
        this.ySizeMin = 0.0f;
        this.ySize = this.ySizeMax = Hmax;
        this.numRows = 1.0f;
        this.zSize = 1.0f;
        i = this.mappedLeft;
        boolean noaxis = false;
        if (nMappers < this.mappedLeft || this.heightMappers[this.mappedLeft] == null) {
            if (nMappers < this.mappedRight || this.heightMappers[this.mappedRight] == null) {
                noaxis = true;
            } else {
                i = this.mappedRight;
            }
        }
        double yGridSize = noaxis ? 1.0 : (this.heightMappers[i] instanceof TidyContinuousMapper ? (double)(this.ySize / (float)((TidyContinuousMapper)this.heightMappers[i]).getAdjustedIntervalCount()) : 1.0);
        if (nMappers > this.mappedRight && this.heightMappers[this.mappedRight] != null && this.heightMappers[this.mappedRight] instanceof TidyContinuousMapper2) {
            TidyContinuousMapper2 cMapper = (TidyContinuousMapper2)this.heightMappers[this.mappedRight];
            int intervals = this.heightMappers[this.mappedLeft] instanceof TidyContinuousMapper ? ((TidyContinuousMapper)this.heightMappers[this.mappedLeft]).getAdjustedIntervalCount() : this.heightMappers[this.mappedLeft].getIntervalCount();
            cMapper.intervals = intervals;
            intervals = cMapper.getAdjustedIntervalCount();
        }
        this.sizeScale = Math.min(1.0, yGridSize);
        float size = (float)(this.markerSize * this.sizeScale);
        if (this.absoluteSize) {
            jSize = (double)this.absoluteJoinSize * (double)this.ySize / (double)this.height;
            mSize = (double)this.absoluteMarkerSize * (double)this.ySize / (double)this.height;
        } else {
            jSize = this.lineWidth * this.sizeScale;
            mSize = size;
        }
        if (this.groupTable == null) {
            this.groupTable = new Hashtable();
        } else {
            this.groupTable.clear();
        }
        if (this.segmentChart) {
            this.addSegmentBars(ch);
        }
        Color color = Color.cyan;
        int rowCount = this.data.getRowCount();
        int dlen = 2;
        if (this.isVariableNotSet(this.groupVariable)) {
            group = false;
        } else if (this.groupVariable.index == this.columnVariable.index) {
            group = false;
        } else {
            group = true;
            ++dlen;
        }
        boolean bl = subgroupSet = !this.segmentChart && !this.isVariableNotSet(this.subgroupVariable);
        if (!subgroupSet) {
            subgroup = false;
        } else if (this.subgroupVariable.index == this.columnVariable.index) {
            subgroup = false;
        } else if (group && this.subgroupVariable.index == this.groupVariable.index) {
            subgroup = false;
        } else {
            subgroup = true;
            ++dlen;
        }
        String[] descriptors = new String[dlen + 1];
        char[] code = new char[dlen];
        code[0] = 99;
        descriptors[1] = this.data.getLabel(this.columnVariable);
        if (descriptors[1] == null || descriptors[1] == "") {
            descriptors[1] = RB.getStringResource(RB_KEY, "columnLabel.txt");
        }
        i = 1;
        if (group) {
            code[i] = 103;
            descriptors[++i] = this.data.getLabel(this.groupVariable);
            if (descriptors[i] == null || descriptors[i] == "") {
                descriptors[i] = RB.getStringResource(RB_KEY, "groupLabel.txt");
            }
        }
        if (subgroup) {
            code[i] = 115;
            descriptors[++i] = this.data.getLabel(this.subgroupVariable);
            if (descriptors[i] == null || descriptors[i] == "") {
                descriptors[i] = RB.getStringResource(RB_KEY, "overlayColorLabel.txt");
            }
        }
        code[dlen - 1] = 104;
        descriptors[0] = new String(code);
        int len = this.heightVariables.length;
        boolean nSubGroupSameAsLen = false;
        if (subgroupSet) {
            nSubGroups = this.subgroupMapper.getIntervalCount();
            boolean nostats = false;
            for (int c = 0; c < len; ++c) {
                if (this.heightVariables[c].chartType == 3 || this.heightVariables[c] == null || this.heightVariables[c].index == -1 || this.heightVariables[c].statistic != 0) continue;
                nostats = true;
                break;
            }
            nPoints = nostats ? rowCount : this.data.getUniqueObservations(this.columnVariable, this.subgroupVariable);
        } else {
            nSubGroups = 1;
            nPoints = rowCount;
            nSubGroupSameAsLen = true;
        }
        String[][][][][] labels = new String[len][nSubGroups][nGroups][nPoints][];
        int[][][] subgroupedPt = new int[len][nSubGroups][nGroups];
        Vec3f[][][][] thickLine = new Vec3f[len][nSubGroups][nGroups][nPoints];
        Color[] lineColor = subgroup ? new Color[nSubGroups] : new Color[len];
        int[] markers = new int[len];
        for (i = 0; i < len; ++i) {
            for (j = 0; j < nSubGroups; ++j) {
                for (k = 0; k < nGroups; ++k) {
                    subgroupedPt[i][j][k] = 0;
                }
            }
        }
        int nHeights = len;
        boolean[] validGroup = new boolean[nGroups];
        for (k = 0; k < nGroups; ++k) {
            validGroup[k] = false;
        }
        boolean r1 = false;
        int markerID = 0;
        float height = 0.0f;
        for (int c = 0; c < len; ++c) {
            if (this.heightVariables[c] == null || this.heightVariables[c].index == -1 || this.heightVariables[c].chartType == 3) continue;
            if (this.frequencyPlot) {
                descriptors[dlen] = RB.getStringResource(RB_KEY, "frequencyLabel.txt");
            } else {
                descriptors[dlen] = this.data.getLabel(this.heightVariables[c]);
                if (descriptors[dlen] == null || descriptors[dlen] == "") {
                    descriptors[dlen] = RB.getStringResource(RB_KEY, "heightLabel.txt");
                }
            }
            String name = this.data.getName(this.heightVariables[c].index);
            if (this.heightVariables[c].chartType == 2) {
                markers[c] = 10;
            } else {
                markerID = this.markerMapper.getMappedShape(name);
                markers[c] = markerID % 10;
            }
            int subgroupID = 0;
            if (!subgroupSet) {
                lineColor[c] = color = this.markerMapper.getMappedRGBColor(name);
            }
            for (i = 0; i < rowCount; ++i) {
                this.data.setRow(i);
                if (this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.heightVariables[c]) || this.data.isValueMissing(this.groupVariable)) continue;
                String colLabel = this.data.getString(this.columnVariable);
                String primaryColLabel = this.data.getPrimaryString(this.columnVariable);
                String grLabel = this.data.getString(this.groupVariable);
                String primaryGrLabel = this.data.getPrimaryString(this.groupVariable);
                j = (int)this.groupMapper.getMappedValue(grLabel);
                k = (int)this.columnMapper.getMappedValue(colLabel);
                validGroup[j] = true;
                int colID = k + j * (numUniqCols + 1);
                if ((float)colID < this.xSizeMin || (float)colID >= this.xSizeMax) continue;
                int index = this.heightVariables[c].mappedScale;
                height = this.heightMappers[index].getMappedValue(this.data.getString(this.heightVariables[c]));
                float locx = (float)colID + 0.5f;
                Vec3f location = new Vec3f(locx, height, -0.5f);
                index = this.heightVariables[c].mappedScale;
                String[] label = new String[3 * dlen + 5];
                label[0] = descriptors[0];
                label[1] = descriptors[1];
                label[2] = colLabel;
                label[3] = primaryColLabel;
                index = 4;
                if (group) {
                    label[index] = descriptors[2];
                    label[index + 1] = grLabel;
                    label[index + 2] = primaryGrLabel;
                    index += 3;
                    this.groupTable.put(grLabel, grLabel);
                }
                if (subgroup) {
                    label[index] = descriptors[dlen - 1];
                    label[index + 1] = this.data.getString(this.subgroupVariable);
                    label[index + 2] = this.data.getPrimaryString(this.subgroupVariable);
                    index += 3;
                }
                label[index] = descriptors[dlen];
                label[index + 1] = this.data.getString(this.heightVariables[c]);
                label[index + 2] = "" + c;
                label[index + 3] = "CTAG";
                label[index + 4] = FloatData.toString((float)location.x);
                label[index + 5] = FloatData.toString((float)location.y);
                label[index + 6] = FloatData.toString((float)location.z);
                if (subgroupSet) {
                    color = this.data.isValueMissing(this.subgroupVariable) ? this.missingColor : this.subgroupMapper.getMappedRGBColor(this.data.getString(this.subgroupVariable));
                    subgroupID = (int)this.subgroupMapper.getMappedValue(this.data.getString(this.subgroupVariable));
                    lineColor[subgroupID] = color;
                }
                thickLine[c][subgroupID][j][subgroupedPt[c][subgroupID][j]] = location;
                labels[c][subgroupID][j][k] = label;
                int[] nArray = subgroupedPt[c][subgroupID];
                int n = j;
                nArray[n] = nArray[n] + 1;
            }
        }
        int polygonMode = ch.getPolygonMode();
        for (int c = 0; c < len; ++c) {
            if (this.heightVariables[c] == null || this.heightVariables[c].index == -1 || this.heightVariables[c].chartType == 3) continue;
            for (i = 0; i < nSubGroups; ++i) {
                if (subgroupSet) {
                    if (lineColor[i] == null) continue;
                    color = lineColor[i];
                    ch.glColor(lineColor[i]);
                } else {
                    color = lineColor[c];
                    ch.glColor(lineColor[c]);
                }
                for (j = 0; j < nGroups; ++j) {
                    if (!validGroup[j]) continue;
                    if (this.joins[c] && subgroupedPt[c][i][j] > 1) {
                        ch.glPolygonMode(4);
                        if (this.edgeColor == null) {
                            ch.glEdgeColor(color);
                        }
                        boolean sort = false;
                        if (this.columnVariable.getSort() != 0) {
                            sort = true;
                        }
                        if (sort) {
                            Shapes.addThickLine(ch, thickLine[c][i][j], jSize, sort);
                        } else {
                            Shapes.addThickLine(ch, thickLine[c][i][j], jSize);
                        }
                        ch.glPolygonMode(polygonMode);
                    }
                    if (this.columnVariable.getSort() == 1) {
                        this.ascendSortLabels(labels[c][i][j]);
                    } else if (this.columnVariable.getSort() == 2) {
                        this.descendSortLabels(labels[c][i][j]);
                    }
                    k = -1;
                    for (int l = 0; l < numUniqCols; ++l) {
                        if (labels[c][i][j][l] == null) continue;
                        ++k;
                        ch.glPushName(labels[c][i][j][l]);
                        switch (markers[c]) {
                            default: {
                                ch.glPolygonMode(5);
                                Shapes.addCircle(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y, thickLine[c][i][j][k].z, jSize, 45.0);
                                ch.glPolygonMode(polygonMode);
                                break;
                            }
                            case 1: {
                                ExtendedShapes.addBox(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y, thickLine[c][i][j][k].z, mSize, mSize, mSize / this.sizeScale);
                                break;
                            }
                            case 8: {
                                ExtendedShapes.addCircle(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y, thickLine[c][i][j][k].z, mSize / 2.0, 45.0);
                                break;
                            }
                            case 2: {
                                ExtendedShapes.addCross(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y, thickLine[c][i][j][k].z, size, size);
                                break;
                            }
                            case 9: {
                                ExtendedShapes.addTriangle(ch, true, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y, thickLine[c][i][j][k].z, size, size);
                                break;
                            }
                            case 0: {
                                ch.glPolygonMode(3);
                                Shapes.setPrecision(16);
                                ExtendedShapes.addSphere(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y, thickLine[c][i][j][k].z, size / 2.0f);
                                ch.glPolygonMode(polygonMode);
                                break;
                            }
                            case 5: {
                                ch.glPolygonMode(3);
                                Shapes.setPrecision(16);
                                ExtendedShapes.addVCone(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y + size / 4.0f, thickLine[c][i][j][k].z, (double)size / 1.5, (double)size * 1.25);
                                ch.glPolygonMode(polygonMode);
                                break;
                            }
                            case 6: {
                                ch.glPolygonMode(3);
                                Shapes.setPrecision(16);
                                ExtendedShapes.addVCylinder(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y, thickLine[c][i][j][k].z, size / 2.0f, size);
                                ch.glPolygonMode(polygonMode);
                                break;
                            }
                            case 7: {
                                ExtendedShapes.addDiamond(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y, thickLine[c][i][j][k].z, size, size);
                                break;
                            }
                            case 3: {
                                ExtendedShapes.addPyramid(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y + size / 4.0f, thickLine[c][i][j][k].z, size, (double)size * 1.25);
                                break;
                            }
                            case 4: {
                                ExtendedShapes.addStar(ch, thickLine[c][i][j][k].x, thickLine[c][i][j][k].y, thickLine[c][i][j][k].z, (double)size / 1.33, size / 2.0f);
                            }
                        }
                        ch.glPopName();
                    }
                }
            }
        }
        int tableSize = this.groupTable.size();
        this.groupValues = new String[tableSize];
        Enumeration elements = this.groupTable.elements();
        i = 0;
        while (elements.hasMoreElements()) {
            this.groupValues[i++] = (String)elements.nextElement();
        }
    }

    protected void addSegmentBars(Channel ch) {
        int k;
        double height;
        int j;
        int i;
        String[] descriptors;
        int dlen;
        Mapper heightMapper = this.heightMappers[this.segHeight.mappedScale];
        boolean subgroupSameAsColumn = true;
        if (!this.isVariableNotSet(this.subgroupVariable) && this.subgroupVariable.index != this.columnVariable.index) {
            subgroupSameAsColumn = false;
        }
        boolean subgroup = this.subgroupMapper != null;
        boolean group = true;
        IndependentVariable subgroupVariable = subgroupSameAsColumn ? this.columnVariable : this.subgroupVariable;
        if (subgroupSameAsColumn) {
            if (this.groupVariable != null) {
                dlen = 4;
                descriptors = new String[5];
                descriptors[0] = "cght";
                descriptors[2] = this.data.getLabel(this.groupVariable);
                if (descriptors[2] == null || descriptors[2] == "") {
                    descriptors[2] = RB.getStringResource(RB_KEY, "groupLabel.txt");
                }
            } else {
                group = false;
                dlen = 3;
                descriptors = new String[4];
                descriptors[0] = "cht";
            }
            descriptors[1] = this.data.getLabel(this.columnVariable);
            if (descriptors[1] == null || descriptors[1] == "") {
                descriptors[1] = RB.getStringResource(RB_KEY, "columnLabel.txt");
            }
            descriptors[dlen - 1] = this.data.getDisplayLabel(this.segHeight);
            if (descriptors[dlen - 1] == null || descriptors[dlen - 1] == "") {
                descriptors[dlen - 1] = RB.getStringResource(RB_KEY, "segmentHeightLabel.txt");
            }
            descriptors[dlen] = RB.getStringResource(RB_KEY, "totalHeightLabel.txt");
        } else {
            if (this.groupVariable != null) {
                dlen = 5;
                descriptors = new String[6];
                descriptors[0] = "cgsht";
                descriptors[2] = this.data.getLabel(this.groupVariable);
                if (descriptors[2] == null || descriptors[2] == "") {
                    descriptors[2] = RB.getStringResource(RB_KEY, "groupLabel.txt");
                }
            } else {
                dlen = 4;
                group = false;
                descriptors = new String[5];
                descriptors[0] = "csht";
            }
            descriptors[1] = this.segData.getLabel(this.columnVariable);
            if (descriptors[1] == null || descriptors[1] == "") {
                descriptors[1] = RB.getStringResource(RB_KEY, "columnLabel.txt");
            }
            descriptors[dlen - 2] = this.segData.getLabel(subgroupVariable);
            if (descriptors[dlen - 2] == null || descriptors[dlen - 2] == "") {
                descriptors[dlen - 2] = RB.getStringResource(RB_KEY, "subgroupLabel.txt");
            }
            descriptors[dlen - 1] = this.segData.getDisplayLabel(this.segHeight);
            if (descriptors[dlen - 1] == null || descriptors[dlen - 1] == "") {
                descriptors[dlen - 1] = RB.getStringResource(RB_KEY, "segmentHeightLabel.txt");
            }
            descriptors[dlen] = RB.getStringResource(RB_KEY, "totalLabel.txt");
        }
        float heightOrigin = 0.0f;
        int numSegments = subgroup ? this.subgroupMapper.getIntervalCount() : 1;
        int nGroups = this.groupMapper.getIntervalCount();
        int numUniqColumns = this.columnMapper.getIntervalCount();
        DataCell[][][] cells = new DataCell[numUniqColumns][nGroups][numSegments];
        float[][] theight = new float[numUniqColumns][nGroups];
        for (i = 0; i < numUniqColumns; ++i) {
            for (j = 0; j < nGroups; ++j) {
                theight[i][j] = 0.0f;
            }
        }
        int rowCount = this.segData.getRowCount();
        for (int obs = 0; obs < rowCount; ++obs) {
            this.segData.setRow(obs);
            if (this.segData.isValueMissing(this.segColumnVariable) || this.segData.isValueMissing(this.segGroupVariable) || this.segData.isValueMissing(subgroupVariable) || this.segData.isValueMissing(this.segHeight)) continue;
            height = DoubleData.valueOf((String)this.segData.getString(this.segHeight));
            i = (int)this.columnMapper.getMappedValue(this.segData.getString(this.segColumnVariable));
            float colID = i + (j = (int)this.groupMapper.getMappedValue(this.segData.getString(this.segGroupVariable))) * (numUniqColumns + 1);
            if (colID < this.xSizeMin || colID >= this.xSizeMax) continue;
            int n = k = subgroup ? (int)this.subgroupMapper.getMappedValue(this.segData.getString(subgroupVariable)) : 0;
            if (cells[i][j][k] == null) {
                cells[i][j][k] = new DataCell(height);
                cells[i][j][k].accumulate(String.valueOf(obs));
            } else {
                cells[i][j][k].accumulate(height);
                cells[i][j][k].accumulate(", " + String.valueOf(obs));
            }
            float[] fArray = theight[i];
            int n2 = j;
            fArray[n2] = (float)((double)fArray[n2] + height);
        }
        if (!(heightMapper instanceof ConstantMapper)) {
            heightOrigin = heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.origin));
        }
        Vec3f location = new Vec3f();
        float xfudge = 0.0f;
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(32);
        String[][] thgtString = new String[numUniqColumns][nGroups];
        for (i = 0; i < numUniqColumns; ++i) {
            for (j = 0; j < nGroups; ++j) {
                thgtString[i][j] = nf.format(theight[i][j]);
            }
        }
        int polygonMode = ch.getPolygonMode();
        if (!subgroup) {
            String label = this.segData.getName(this.segHeight.index);
            ch.glColor(this.markerMapper.getMappedRGBColor(label));
        }
        double gSize = !this.absoluteSize ? this.geometrySize : (double)this.absoluteMarkerSize * (double)this.numColumns / (double)this.width;
        for (i = 0; i < numUniqColumns; ++i) {
            float altitude = 0.0f;
            for (j = 0; j < this.groupMapper.getIntervalCount(); ++j) {
                for (k = 0; k < numSegments; ++k) {
                    int obs;
                    if (cells[i][j][k] == null) continue;
                    int comma = cells[i][j][k].str.indexOf(44, 0);
                    if (comma > 0) {
                        String tmp = cells[i][j][k].str.substring(0, comma);
                        obs = Integer.valueOf(tmp.trim());
                    } else {
                        obs = Integer.valueOf(cells[i][j][k].str.trim());
                    }
                    this.segData.setRow(obs);
                    if (this.segData.isValueMissing(this.segColumnVariable) || this.segData.isValueMissing(this.segGroupVariable) || this.segData.isValueMissing(subgroupVariable) || this.segData.isValueMissing(this.segHeight)) continue;
                    String[] label = new String[3 * dlen + 5];
                    label[0] = descriptors[0];
                    label[1] = descriptors[1];
                    label[2] = this.segData.getString(this.segColumnVariable);
                    label[3] = this.segData.getPrimaryString(this.segColumnVariable);
                    int index = 4;
                    if (group) {
                        label[index] = descriptors[2];
                        label[index + 1] = this.segData.getString(this.segGroupVariable);
                        label[index + 2] = this.segData.getPrimaryString(this.segGroupVariable);
                        this.groupTable.put(label[index + 1], label[index + 1]);
                        index += 3;
                    }
                    if (!subgroupSameAsColumn) {
                        label[index] = descriptors[dlen - 2];
                        label[index + 1] = this.segData.getString(subgroupVariable);
                        label[index + 2] = this.segData.getPrimaryString(subgroupVariable);
                        index += 3;
                    }
                    label[index] = descriptors[dlen - 1];
                    label[index + 1] = nf.format(cells[i][j][k].sum);
                    label[index + 2] = "" + this.segIndex;
                    label[index + 3] = descriptors[dlen];
                    label[index + 4] = thgtString[i][j];
                    label[index + 5] = thgtString[i][j];
                    index += 6;
                    height = heightMapper.getMappedValue(DoubleData.toString((double)cells[i][j][k].sum)) - heightOrigin;
                    if (height <= (double)1.4E-45f && altitude > 0.0f) continue;
                    if (heightMapper instanceof ConstantMapper && numSegments != 0) {
                        height /= (double)numSegments;
                    }
                    location.x = xfudge + (float)i + 0.5f + (float)(j * (numUniqColumns + 1));
                    location.y = (float)((double)altitude + height / 2.0 + (double)heightOrigin);
                    location.z = -0.5f;
                    label[index] = "CTAG";
                    label[index + 1] = FloatData.toString((float)location.x);
                    label[index + 2] = FloatData.toString((float)location.y);
                    label[index + 3] = FloatData.toString((float)((float)((double)location.z + 0.5 * this.geometrySize)));
                    altitude = (float)((double)altitude + height);
                    ch.glPushName(label);
                    if (subgroup) {
                        ch.glColor(this.subgroupMapper.getMappedRGBColor(this.segData.getString(subgroupVariable)));
                    }
                    Shapes.addBox(ch, location.x, location.y, location.z, gSize, Math.abs(height), gSize);
                    ch.glPopName();
                }
                altitude = 0.0f;
            }
        }
        ch.glPolygonMode(polygonMode);
    }

    private Vec3f findEndVector(Vec3f p1, Vec3f p2, Vec3f p3) {
        float A1 = p2.y - p1.y;
        float B1 = p1.x - p2.x;
        float C1 = p2.x * p1.y - p2.y * p1.x;
        float actualLineWidth = (float)(this.lineWidth * this.sizeScale);
        float tmp = (float)Math.sqrt(A1 * A1 + B1 * B1);
        float N1 = C1 < 0.0f ? tmp : (C1 > 0.0f ? -tmp : (B1 > 0.0f ? tmp : -tmp));
        float a1 = A1 / N1;
        float b1 = B1 / N1;
        float c1 = C1 / B1 > 0.0f ? C1 / N1 + actualLineWidth : C1 / N1 - actualLineWidth;
        float A2 = p3.y - p2.y;
        float B2 = p2.x - p3.x;
        float C2 = p3.x * p2.y - p3.y * p2.x;
        tmp = (float)Math.sqrt(A2 * A2 + B2 * B2);
        float N2 = C2 < 0.0f ? tmp : (C2 > 0.0f ? -tmp : (B2 > 0.0f ? tmp : -tmp));
        float a2 = A2 / N2;
        float b2 = B2 / N2;
        float c2 = C2 / B2 > 0.0f ? C2 / N2 + actualLineWidth : C2 / N2 - actualLineWidth;
        float det = a1 * b2 - b1 * a2;
        if (det == 0.0f) {
            return new Vec3f(0.0f, actualLineWidth, 0.0f);
        }
        float x = (b1 * c2 - c1 * b2) / det;
        float y = (a2 * c1 - c2 * a1) / det;
        return new Vec3f(x - p2.x, y - p2.y, 0.0f);
    }

    protected void addColumnLegends(Channel ch) {
        int countGroups;
        if (this.xSizeMin == this.xSizeMax) {
            return;
        }
        if (!this.getColumnLegendStyle().isVisible()) {
            this.yMinLegendSize += 2.0f * this.blankSpaceSize;
            return;
        }
        boolean newLegend = this.columnLegend == null;
        boolean oneRow = this.getColumnLegendStyle().numRows == 1;
        boolean validGroup = !this.isNoneVariable(this.groupVariable);
        int numCols = this.columnMapper.getIntervalCount() + 1;
        String[] gValues = null;
        if (validGroup) {
            gValues = new String[this.groupMapper.getIntervalCount()];
            for (int k = 0; k < this.groupValues.length; ++k) {
                gValues[(int)this.groupMapper.getMappedValue((String)this.groupValues[k])] = this.groupValues[k];
            }
        }
        if (newLegend) {
            Vec3f incrementVector;
            Color geomColor;
            this.columnLegend = new WireLegend(this.columnMapper);
            this.columnLegend.origin = new Vec3f(this.xSizeMin, 0.0f, 0.0f);
            this.columnLegend.endVector = new Vec3f(0.0f, this.ySize, 0.0f);
            this.columnLegend.labelStyle = this.getColumnLegendStyle().labelStyle;
            if (validGroup) {
                this.columnLegend.labelStyle = this.getGroupLegendStyle().valueStyle;
            }
            this.columnLegend.labelPosition = 1;
            this.columnLegend.intervals = this.columnMapper.getIntervalCount();
            this.columnLegend.geomColor = geomColor = this.getColumnLegendStyle().grid.color;
            this.columnLegend.incrementVector = incrementVector = new Vec3f(1.0f, 0.0f, 0.0f);
            if (validGroup || this.getColumnLegendStyle().isHideLabel()) {
                this.columnLegend.setLabel(null);
            } else {
                this.columnLegend.setLabel(this.data.getDisplayLabel(this.columnVariable), this.data.getPrimaryLabel(this.columnVariable));
            }
            if (this.getColumnLegendStyle().numRows == 0) {
                this.columnLegend.valueStyle = this.getColumnLegendStyle().valueStyle;
            } else {
                TextStyle ts = new TextStyle(this.getColumnLegendStyle().valueStyle);
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int charWidth = fm.stringWidth("Z");
                int blankSpaces = fm.stringWidth("  ") * this.columnLegend.intervals;
                if (this.getColumnLegendStyle().numRows == 1) {
                    ts.maxChars = (this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals);
                    if (ts.maxChars < ts.minChars) {
                        ts.maxChars = ts.minChars;
                    }
                    this.columnLegend.oneRow = true;
                } else {
                    ts.maxChars = Math.max(ts.minChars, (2 * this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals));
                }
                this.columnLegend.valueStyle = ts;
            }
            this.columnLegend.valueStyle.setJustify("CENTER", "TOP");
            this.columnLegend.labelStyle.setJustify("CENTER", "TOP");
        } else {
            this.columnLegend.origin.x = this.xSizeMin;
            this.columnLegend.endVector.y = this.ySize;
        }
        String[] columnValues = this.columnMapper.getValueLabels();
        String[] primaryColumnValues = this.columnMapper.getPrimaryValueLabels();
        String[] formattedValues = this.dataUser.format((Variable)this.columnVariable, columnValues);
        if (formattedValues == null) {
            formattedValues = columnValues;
        }
        this.columnLegend.values = columnValues;
        this.columnLegend.primaryValues = primaryColumnValues;
        this.columnLegend.formattedValues = formattedValues;
        this.columnLegend.intervals = columnValues.length;
        this.columnLegend.startingOffset = this.xSizeMin % (float)numCols;
        int min = (int)Math.floor(this.xSizeMin / (float)numCols);
        int max = (int)Math.ceil((double)(this.xSizeMax / (float)numCols) + 0.001);
        boolean oneGroup = max == min + 1;
        this.columnLegend.origin.x = this.xSizeMin;
        this.columnValueHotspots = null;
        if (this.isColumnValueHotspotsEnabled()) {
            countGroups = max - min;
            int countCategories = countGroups * columnValues.length;
            this.columnValueHotspots = new Blob[countCategories];
        }
        this.groupValueHotspots = null;
        if (validGroup && this.isGroupValueHotspotsEnabled()) {
            countGroups = max - min;
            this.groupValueHotspots = new Blob[countGroups];
        }
        for (int i = min; i < max; ++i) {
            Blob[] labelHotspots;
            int j;
            if (oneGroup) {
                ((WireLegend)this.columnLegend).firstGridLineVisible = true;
                ((WireLegend)this.columnLegend).lastGridLineVisible = true;
                if (this.xSize != this.numColumns) {
                    this.columnLegend.intervals = (int)this.xSize;
                    String[] values = new String[(int)this.xSize];
                    String[] primaryValues = new String[(int)this.xSize];
                    String[] formColValues = new String[(int)this.xSize];
                    int ms = columnValues.length;
                    int pos = 0;
                    int colMin = (int)this.xSizeMin % numCols;
                    int colMax = (int)((float)colMin + this.xSize);
                    for (j = 0; j < ms; ++j) {
                        float val = this.columnMapper.getMappedValue(columnValues[j]);
                        if (val < (float)colMin || val >= (float)colMax) continue;
                        values[pos] = columnValues[j];
                        primaryValues[pos] = primaryColumnValues[j];
                        formColValues[pos] = formattedValues[j];
                        ++pos;
                    }
                    this.columnLegend.values = values;
                    this.columnLegend.primaryValues = primaryValues;
                    this.columnLegend.formattedValues = formColValues;
                }
            } else if (i == min) {
                int startCol = (int)(this.xSizeMin % (float)numCols);
                if (startCol == numCols - 1) {
                    this.columnLegend.values = columnValues;
                    this.columnLegend.primaryValues = primaryColumnValues;
                    this.columnLegend.formattedValues = formattedValues;
                    this.columnLegend.origin.x += 1.0f;
                    this.columnLegend.intervals = columnValues.length;
                    this.columnLegend.startingOffset = 0.0f;
                    continue;
                }
                if (startCol > 0) {
                    int curSize = numCols - startCol - 1;
                    int colMin = (int)(this.xSizeMin % (float)numCols);
                    String[] values = new String[curSize];
                    String[] primaryValues = new String[curSize];
                    String[] formColValues = new String[curSize];
                    int ms = columnValues.length;
                    int pos = 0;
                    for (int j2 = 0; j2 < ms; ++j2) {
                        float val = this.columnMapper.getMappedValue(columnValues[j2]);
                        if (val < (float)colMin) continue;
                        values[pos] = columnValues[j2];
                        primaryValues[pos] = primaryColumnValues[j2];
                        formColValues[pos] = formattedValues[j2];
                        ++pos;
                    }
                    this.columnLegend.intervals = curSize;
                    this.columnLegend.values = values;
                    this.columnLegend.primaryValues = primaryValues;
                    this.columnLegend.formattedValues = formColValues;
                }
                ((WireLegend)this.columnLegend).firstGridLineVisible = true;
                ((WireLegend)this.columnLegend).lastGridLineVisible = false;
            } else if (i == max - 1) {
                int endCol = (int)(this.xSizeMax % (float)numCols);
                if (endCol == 0) continue;
                if (endCol < numCols - 1) {
                    int curSize = Math.min(endCol, numCols - 1);
                    String[] values = new String[curSize];
                    String[] primaryValues = new String[curSize];
                    String[] formColValues = new String[curSize];
                    int ms = columnValues.length;
                    int pos = 0;
                    for (j = 0; j < ms; ++j) {
                        float val = this.columnMapper.getMappedValue(columnValues[j]);
                        if (val >= (float)endCol) continue;
                        values[pos] = columnValues[j];
                        primaryValues[pos] = primaryColumnValues[j];
                        formColValues[pos] = formattedValues[j];
                        ++pos;
                    }
                    this.columnLegend.values = values;
                    this.columnLegend.primaryValues = primaryValues;
                    this.columnLegend.formattedValues = formColValues;
                    this.columnLegend.intervals = curSize;
                }
                ((WireLegend)this.columnLegend).firstGridLineVisible = false;
                ((WireLegend)this.columnLegend).lastGridLineVisible = true;
            } else {
                ((WireLegend)this.columnLegend).firstGridLineVisible = false;
                ((WireLegend)this.columnLegend).lastGridLineVisible = false;
            }
            this.columnLegend.setValueHotspotsEnabled(this.isColumnValueHotspotsEnabled());
            this.columnLegend.setValueHotspotID(1);
            if (validGroup) {
                this.columnLegend.setLabel(gValues[i]);
                this.columnLegend.setLabelValueHotspotsEnabled(this.isColumnValueHotspotsEnabled());
                this.columnLegend.setLabelHotspotID(2);
            } else {
                this.columnLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
                this.columnLegend.setLabelHotspotID(1);
            }
            if (this.simpleGeometry && !this.data.isContinuous(this.columnVariable)) {
                this.columnLegend.addLegend(ch, false);
            } else {
                this.columnLegend.addLegend(ch, this.getColumnLegendStyle().grid.visible);
            }
            Blob[] valueHotspots = this.columnLegend.getValueHotspots();
            if (this.columnValueHotspots != null && valueHotspots != null) {
                int currentIndex = i * columnValues.length;
                for (int ii = 0; ii < valueHotspots.length; ++ii) {
                    this.columnValueHotspots[currentIndex + ii] = valueHotspots[ii];
                }
            }
            if ((labelHotspots = this.columnLegend.getLabelHotspots()) != null) {
                if (this.groupValueHotspots != null) {
                    this.groupValueHotspots[i] = labelHotspots[0];
                } else {
                    this.columnVariableHotspot = labelHotspots[0];
                }
            }
            if (i == min) {
                this.columnLegend.values = columnValues;
                this.columnLegend.primaryValues = primaryColumnValues;
                this.columnLegend.formattedValues = formattedValues;
                this.columnLegend.origin.x += (float)(this.columnLegend.intervals + 1);
                this.columnLegend.intervals = columnValues.length;
                this.columnLegend.startingOffset = 0.0f;
                continue;
            }
            this.columnLegend.origin.x += (float)(this.columnLegend.intervals + 1);
        }
        if (this.columnLegend.vLegendOffset > 0.0f) {
            this.yMinLegendSize += this.columnLegend.vLegendOffset + this.verticalSpaceSize;
        } else {
            this.xMinLegendSize += this.columnLegend.hLegendOffset + this.blankSpaceSize;
        }
    }

    protected void addHeightLegends(Channel ch) {
        String[] values;
        Color geomColor;
        if (!this.heightLegendStyle.isVisible() && !this.heightLegendStyle2.isVisible()) {
            return;
        }
        int numLegends = 0;
        int curIndex = 0;
        int index = 0;
        int num = 0;
        int len = this.heightVariables.length;
        String format = null;
        boolean left = false;
        boolean right = false;
        if (this.heightLegendStyle.isVisible() && this.heightMappers.length > this.mappedLeft && this.heightMappers[this.mappedLeft] != null) {
            left = true;
            ++numLegends;
        }
        if (this.heightLegendStyle2.isVisible() && this.heightMappers.length > this.mappedRight && this.heightMappers[this.mappedRight] != null) {
            right = true;
            ++numLegends;
        }
        if (numLegends == 0) {
            return;
        }
        boolean newLeft = this.leftLegend == null;
        boolean newRight = this.leftLegend == null;
        curIndex = this.mappedLeft;
        if (newLeft && left) {
            this.leftLegend = new WireLegend2(this.heightMappers[curIndex]);
            this.leftLegend.geomColor = geomColor = this.heightLegendStyle.grid.color;
            this.leftLegend.valueStyle = this.heightLegendStyle.valueStyle;
            this.leftLegend.labelStyle = this.heightLegendStyle.labelStyle;
            this.leftLegend.continuous = true;
            this.leftLegend.origin = new Vec3f(this.xSizeMin, 0.0f, 0.0f);
            this.leftLegend.endVector = new Vec3f(this.xSize, 0.0f, 0.0f);
            this.leftLegend.maxSize = numLegends == 1 ? this.xSize : this.xSize * 0.5f - this.blankSpaceSize;
            this.leftLegend.incrementVector = new Vec3f(0.0f, 0.0f, 0.0f);
            this.leftLegend.distortX = this.distortX;
            if (!this.heightLegendStyle.isVisible()) {
                this.leftLegend.addGeometry(ch);
                return;
            }
            this.leftLegend.valueStyle.majorJustify = "RIGHT";
            this.leftLegend.valueStyle.minorJustify = "CENTER";
            this.leftLegend.labelStyle.majorJustify = "BEGIN";
            this.leftLegend.labelStyle.minorJustify = "BOTTOM";
            this.leftLegend.labelPosition = 2;
        }
        if (left) {
            this.leftLegend.origin.x = this.xSizeMin;
            this.leftLegend.endVector.x = this.xSize;
            this.leftLegend.maxSize = numLegends == 1 ? this.xSize : this.xSize * 0.5f - this.blankSpaceSize;
            this.leftLegend.intervals = this.heightMappers[curIndex].getIntervalCount();
            this.leftLegend.incrementVector.y = this.ySize / (float)this.leftLegend.intervals;
            if (!this.heightLegendStyle.isVisible()) {
                this.leftLegend.addGeometry(ch);
                return;
            }
            values = this.heightMappers[curIndex].getValueLabels();
            this.leftLegend.values = values;
            for (int i = 0; i < len; ++i) {
                if (this.heightVariables[i].getIndex() == 0 || this.heightVariables[i].mappedScale != this.mappedLeft) continue;
                index = i;
                if (++num == 1) {
                    format = this.dataUser.getDataColumnFormat(this.heightVariables[i]);
                    continue;
                }
                if (this.dataUser.getDataColumnFormat(this.heightVariables[i]) != null && this.dataUser.getDataColumnFormat(this.heightVariables[i]).equals(format)) continue;
                format = null;
            }
            if (num > 1) {
                if (this.heightLegendStyle.isHideLabel() || this.leftUserHeightLabel == null) {
                    this.leftLegend.setLabel(null);
                } else {
                    this.leftLegend.setLabel(this.leftUserHeightLabel);
                }
                this.leftLegend.formattedValues = format == null ? values : this.dataUser.format((Variable)this.heightVariables[index], values);
            } else {
                if (this.heightLegendStyle.isHideLabel()) {
                    this.leftLegend.setLabel(null);
                } else if (this.leftUserHeightLabel != null) {
                    this.leftLegend.setLabel(this.leftUserHeightLabel);
                } else if (index == this.segIndex) {
                    this.leftLegend.setLabel(this.segData.getDisplayLabel(this.segHeight));
                } else {
                    this.leftLegend.setLabel(this.data.getDisplayLabel(this.heightVariables[index]));
                }
                String[] formattedValues = this.dataUser.format((Variable)this.heightVariables[index], values);
                this.leftLegend.formattedValues = formattedValues == null ? values : formattedValues;
            }
            this.leftLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
            this.leftLegend.setLabelHotspotID(5);
            this.leftLegend.vLabelOffset = this.yMaxLegendSize;
            this.leftLegend.addLegend(ch, this.heightLegendStyle.grid.visible);
            Blob[] b = this.leftLegend.getLabelHotspots();
            this.leftHeightVariableHotspot = b == null ? null : b[0];
            this.xMinLegendSize = this.leftLegend.hLegendOffset;
            this.yMaxLegendSize += this.leftLegend.vLegendOffset;
        }
        curIndex = this.mappedRight;
        if (newRight && right) {
            Vec3f incrementVector;
            this.rightLegend = new WireLegend2(this.heightMappers[curIndex]);
            this.rightLegend.planeGridLineVisible = false;
            this.rightLegend.geomColor = geomColor = this.heightLegendStyle2.grid.color;
            this.rightLegend.valueStyle = this.heightLegendStyle2.valueStyle;
            this.rightLegend.labelStyle = this.heightLegendStyle2.labelStyle;
            this.rightLegend.continuous = true;
            this.rightLegend.origin = new Vec3f(this.xSize, 0.0f, -1.0f);
            this.rightLegend.endVector = new Vec3f((float)this.distortX + this.xSizeMin, 0.0f, 0.0f);
            this.rightLegend.maxSize = numLegends == 1 ? this.xSize : this.xSize * 0.5f - this.blankSpaceSize;
            this.rightLegend.intervals = this.heightMappers[curIndex].getIntervalCount();
            this.rightLegend.incrementVector = incrementVector = new Vec3f(0.0f, this.ySize / (float)this.heightMappers[curIndex].getIntervalCount(), 0.0f);
            this.rightLegend.distortX = this.distortX;
            this.rightLegend.labelStyle.majorJustify = "END";
            this.rightLegend.labelStyle.minorJustify = "BOTTOM";
            this.rightLegend.labelPosition = 0;
        }
        if (right) {
            this.rightLegend.origin.x = this.xSize + this.xSizeMin;
            this.rightLegend.endVector.x = (float)this.distortX + this.xSizeMin;
            this.rightLegend.maxSize = numLegends == 1 ? this.xSize : this.xSize * 0.5f - this.blankSpaceSize;
            this.rightLegend.intervals = this.heightMappers[curIndex].getIntervalCount();
            this.rightLegend.incrementVector.y = this.ySize / (float)this.heightMappers[curIndex].getIntervalCount();
            values = this.heightMappers[curIndex].getValueLabels();
            this.rightLegend.values = values;
            num = 0;
            for (int i = 0; i < len; ++i) {
                if (this.heightVariables[i].getIndex() == 0 || this.heightVariables[i].mappedScale != this.mappedRight) continue;
                index = i;
                if (++num == 1) {
                    format = this.dataUser.getDataColumnFormat(this.heightVariables[i]);
                    continue;
                }
                if (this.dataUser.getDataColumnFormat(this.heightVariables[i]) != null && this.dataUser.getDataColumnFormat(this.heightVariables[i]).equals(format)) continue;
                format = null;
            }
            if (num > 1) {
                if (this.rightUserHeightLabel == null || this.heightLegendStyle2.isHideLabel()) {
                    this.rightLegend.setLabel("");
                } else {
                    this.rightLegend.setLabel(this.rightUserHeightLabel);
                }
                this.rightLegend.formattedValues = format == null ? values : this.dataUser.format((Variable)this.heightVariables[index], values);
            } else {
                if (this.heightLegendStyle2.isHideLabel()) {
                    this.rightLegend.setLabel(null);
                } else if (this.rightUserHeightLabel != null) {
                    this.rightLegend.setLabel(this.rightUserHeightLabel);
                } else if (index == this.segIndex) {
                    this.rightLegend.setLabel(this.segData.getDisplayLabel(this.segHeight));
                } else {
                    this.rightLegend.setLabel(this.data.getDisplayLabel(this.heightVariables[index]));
                }
                String[] formattedValues = this.dataUser.format((Variable)this.heightVariables[index], values);
                this.rightLegend.formattedValues = formattedValues == null ? values : formattedValues;
            }
            this.rightLegend.vLabelOffset = left ? this.leftLegend.vLabelOffset : this.yMaxLegendSize;
            this.rightLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
            this.rightLegend.setLabelHotspotID(5);
            this.rightLegend.addLegend(ch, this.heightLegendStyle2.grid.visible);
            Blob[] b = this.rightLegend.getLabelHotspots();
            Blob blob = this.rightHeightVariableHotspot = b == null ? null : b[0];
            if (!left || this.leftLegend.vLegendOffset <= 0.0f) {
                this.xMaxLegendSize = this.rightLegend.hLegendOffset;
                this.yMaxLegendSize += this.rightLegend.vLegendOffset;
            } else {
                this.xMaxLegendSize = this.rightLegend.hLegendOffset;
            }
        }
    }

    @Override
    protected void addAxes(Channel ch) {
        Axis heightAxis;
        float h2;
        float h1;
        int len = this.heightMappers.length;
        String value = DoubleData.toString((double)this.heightLegendStyle.getOrigin());
        boolean left = true;
        boolean right = true;
        if (len < this.mappedLeft || this.heightMappers[this.mappedLeft] == null) {
            left = false;
            h1 = 0.0f;
        } else {
            h1 = this.heightMappers[this.mappedLeft].getMappedValue(value);
        }
        if (len < this.mappedRight || this.heightMappers[this.mappedRight] == null) {
            right = false;
            h2 = 0.0f;
        } else {
            h2 = this.heightMappers[this.mappedRight].getMappedValue(value);
        }
        float height = Math.max(h1, h2);
        if (this.getColumnLegendStyle().axisType == 1) {
            Axis columnAxis = new Axis();
            columnAxis.origin = new Vec3f(this.xSizeMin, height, 0.0f);
            columnAxis.endVector = new Vec3f(this.xSize, 0.0f, 0.0f);
            columnAxis.color = this.getColumnLegendStyle().axisColor;
            columnAxis.addGeometry(ch);
        }
        if (left && this.heightLegendStyle.axisType == 1) {
            heightAxis = new Axis();
            heightAxis.origin = new Vec3f((float)this.getColumnLegendStyle().getOrigin() + this.xSizeMin, 0.0f, 0.0f);
            heightAxis.endVector = new Vec3f(0.0f, this.ySize, 0.0f);
            heightAxis.color = this.heightLegendStyle.axisColor;
            heightAxis.addGeometry(ch);
        }
        if (right && this.heightLegendStyle2.axisType == 1) {
            heightAxis = new Axis();
            heightAxis.origin = new Vec3f((float)this.getColumnLegendStyle().getOrigin() + this.xSize + this.xSizeMin, 0.0f, -1.0f);
            heightAxis.endVector = new Vec3f(0.0f, this.ySize, 0.0f);
            heightAxis.color = this.heightLegendStyle2.axisColor;
            heightAxis.addGeometry(ch);
        }
    }

    protected void addBackPlanes(Channel ch) {
        if (!this.backplaneVisible) {
            return;
        }
        double x0 = this.getColumnLegendStyle().getOrigin() + (double)this.xSizeMin;
        double y0 = this.heightLegendStyle.getOrigin();
        ch.glColor(this.backplaneColor);
        ch.glBegin(2);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0 + (double)this.xSize, y0, -1.0);
        ch.glVertex(x0 + (double)this.xSize, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, -1.0);
        ch.glEnd();
        ch.glBegin(2);
        ch.glVertex(x0, y0, 0.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, 0.0);
        ch.glEnd();
        ch.glBegin(2);
        ch.glVertex(x0, y0, 0.0);
        ch.glVertex(x0 + (double)this.xSize, y0, 0.0);
        ch.glVertex(x0 + (double)this.xSize, y0, -1.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0 + (double)this.xSize, y0, -1.0);
        ch.glVertex(x0 + (double)this.xSize, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x0, y0, 0.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, -1.0);
        ch.glVertex(x0, y0 + (double)this.ySize, 0.0);
        ch.glVertex(x0, y0, 0.0);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x0, y0, 0.0);
        ch.glVertex(x0 + (double)this.xSize, y0, 0.0);
        ch.glVertex(x0 + (double)this.xSize, y0, -1.0);
        ch.glVertex(x0, y0, -1.0);
        ch.glVertex(x0, y0, 0.0);
        ch.glEnd();
        if (this.depth == 1) {
            double[] front = new double[]{0.0, 0.0, 0.0};
            double[] back = new double[]{0.0, 0.0, -1.0};
            ch.gluProject(front, front);
            ch.gluProject(back, back);
            double[] origin = new double[]{0.0, 0.0, 0.0};
            ch.gluUnProject(origin, origin);
            double[] width_off = new double[]{back[0] - front[0], 0.0, 0.0};
            ch.gluUnProject(width_off, width_off);
            this.distortX = width_off[0] - origin[0];
            double[] height_off = new double[]{0.0, front[1] - back[1], 0.0};
            ch.gluUnProject(height_off, height_off);
            this.distortY = origin[1] - height_off[1];
        } else {
            this.distortX = 0.0;
            this.distortY = 0.0;
        }
    }

    @Override
    protected void scaleText(Channel ch) {
        boolean validGroup;
        super.scaleText(ch);
        TextStyle ts = this.getColumnLegendStyle().getLabelStyle();
        boolean bl = validGroup = !this.isNoneVariable(this.groupVariable);
        if (validGroup) {
            ts = this.getGroupLegendStyle().getValueStyle();
        }
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.getColumnLegendStyle().getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.heightLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.heightLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.heightLegendStyle2.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.heightLegendStyle2.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.overlayLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.overlayLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        int colCount = this.data.getColumnCount();
        boolean maxlen = false;
        double hmax = -1.7976931348623157E308;
        boolean validGroup = !this.isNoneVariable(this.groupVariable);
        TextStyle ts = this.getColumnLegendStyle().labelStyle;
        if (validGroup) {
            ts = this.getGroupLegendStyle().valueStyle;
        }
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm.getHeight();
        ts = this.getColumnLegendStyle().valueStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm.getHeight();
        this.blankSpacePixels = valueFontPixels / 2;
        if (this.heightLegendStyle.isVisible() || this.heightLegendStyle2.isVisible()) {
            for (int i = 0; i < colCount; ++i) {
                double tmp;
                if (!this.data.isContinuous(i) || i == this.columnVariable.index || !((tmp = this.data.getMaxValue(i)) > hmax)) continue;
                hmax = tmp;
            }
            double log10_hmax = Math.log(hmax) / Math.log(10.0);
            int ndigits = (int)Math.ceil(log10_hmax);
            float hMAX = ndigits > 0 ? (float)Math.pow(10.0, ndigits) - 1.0f : 1.0f - (float)Math.pow(10.0, ndigits);
            int hlen = fm.stringWidth(FloatData.toString((float)hMAX)) + 3 * valueFontPixels / 4;
            if (this.heightVariables != null) {
                this.leftLegendPixels = hlen;
                if (this.heightVariables.length > 1) {
                    for (int i = 0; i < this.heightVariables.length; ++i) {
                        if (this.heightVariables[i].getChartScale() != this.mappedRight || !this.heightLegendStyle2.isVisible()) continue;
                        this.rightLegendPixels = hlen;
                        break;
                    }
                }
            }
            if (this.leftLegendPixels != 0 && !this.heightLegendStyle.isHideLabel()) {
                this.topLegendPixels += labelFontPixels + this.blankSpacePixels;
            } else if (this.rightLegendPixels != 0 && !this.heightLegendStyle2.isHideLabel()) {
                this.topLegendPixels += labelFontPixels + this.blankSpacePixels;
            }
        }
        this.bottomLegendPixels = 2 * valueFontPixels + valueFontPixels / 2;
        if (!this.getColumnLegendStyle().isHideLabel()) {
            this.bottomLegendPixels += labelFontPixels + this.blankSpacePixels;
        }
        if (this.dataMode) {
            this.topLegendPixels += 4 * this.blankSpacePixels;
        }
        if (!this.overlayLegendStyle.getVisible()) {
            return;
        }
        ts = this.overlayLegendStyle.labelStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        labelFontPixels = fm.getHeight();
        ts = this.overlayLegendStyle.valueStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        valueFontPixels = fm.getHeight();
        int legHeight = (int)Math.max(0.1 * (double)this.height, (double)(labelFontPixels + 2 * valueFontPixels));
        this.bottomLegendPixels = this.overlayLegendStyle.defaultSize ? (this.bottomLegendPixels += (int)((float)legHeight + this.blankSpaceSize)) : (this.bottomLegendPixels += (int)(this.overlayLegendStyle.height * (double)this.height * 0.75 + (double)this.blankSpaceSize));
    }

    @Override
    protected void setProjection(Channel ch) {
        if (!this.validVisualization) {
            return;
        }
        double yfac = this.ySize / (float)this.ySizePixels;
        double xMin = -this.xMinLegendSize;
        double xMax = this.xSize + this.xMaxLegendSize + 0.1f;
        double yMin = (double)(-this.yMinLegendSize) - (double)this.yColorLegendSize * yfac;
        double yMax = (double)(this.ySize + this.yMaxLegendSize) + (double)this.yTitleSize * yfac;
        double xIndent = (double)0.08f * (xMax - xMin);
        double yIndent = (double)0.06f * (yMax - yMin);
        if (this.depth == 0) {
            ch.glOrtho(xMin - xIndent, xMax + xIndent, yMin - yIndent, yMax + yIndent, xMin - xIndent, xMax + xIndent);
        } else {
            double mSize = this.absoluteSize ? (double)Math.max(this.absoluteMarkerSize, this.absoluteJoinSize) * (double)this.ySize / (double)this.height : Math.max(this.markerSize, this.lineWidth) * this.sizeScale;
            double distort = mSize * Math.sin(0.7853981633974483);
            ch.glOblique(xMin - xIndent, xMax + xIndent + distort, yMin - yIndent, yMax + yIndent + distort, -100.0, 100.0, distort, 45.0);
        }
    }

    @Override
    protected void setGeometryProjection(Channel ch) {
    }

    @Override
    protected void setInitialViewpoint(Channel ch) {
        ch.gluLookAt(this.xSizeMin, 0.0, 0.0, 0.1f, 0.0, 0.0, 0.0);
    }

    @Override
    public synchronized void showChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        this.setViewport(ch);
        if (!this.transparent) {
            ch.clearBGC();
        } else {
            ch.copyBuffer(2);
        }
        if (this.validVisualization) {
            ch.glCallList(0L, this.dirty);
            ch.glCallList(8L, this.dirty);
            ch.glCallList(9L, this.dirty);
            ch.glCallList(3L, this.dirty);
            if (this.overlayLegendStyle.getVisible() && (this.subgroupLegendBox != null || this.markerLegendBox != null)) {
                this.setStandardView(ch);
                ch.glCallList(5L, this.dirty);
                if (this.markerLegendBox != null) {
                    if (!this.transparent) {
                        ch.clearBuffer(this.markerLegendBox);
                    } else {
                        ch.copyBuffer(this.markerLegendBox, 2);
                    }
                    ch.setClip(this.markerLegendBox);
                    ch.glCallList(COLOR_LEGENDS[0], this.dirty);
                    ch.resetClip();
                }
                if (this.subgroupLegendBox != null) {
                    if (!this.transparent) {
                        ch.clearBuffer(this.subgroupLegendBox);
                    } else {
                        ch.copyBuffer(this.subgroupLegendBox, 2);
                    }
                    ch.setClip(this.subgroupLegendBox);
                    ch.glCallList(COLOR_LEGENDS[1], this.dirty);
                    ch.resetClip();
                }
            }
        }
        this.setStandardView(ch);
        ch.glCallList(2L, this.dirty);
        ch.glCallList(7L, this.dirty);
        ch.glRefresh(g);
        this.setFinalView(ch);
        this.setViewport(ch);
        this.dirty = false;
    }

    @Override
    public synchronized void drawChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        int oldWidth = this.width;
        int oldHeight = this.height;
        this.width = ch.getWidth();
        this.height = ch.getHeight();
        this.setViewport(ch);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        if (this.validVisualization) {
            ch.glCallList(g, 0L);
            ch.glCallList(9L, this.dirty);
            ch.glEnable(4);
            ch.glCallList(g, 3L);
            ch.glDisable(4);
            if (this.overlayLegendStyle.getVisible() && this.markerLegendBox != null) {
                this.setStandardView(ch);
                ch.glCallList(g, 5L);
                if (this.markerLegendBox != null) {
                    if (!this.transparent) {
                        ch.clearBuffer(this.markerLegendBox);
                    } else {
                        ch.copyBuffer(this.markerLegendBox, 2);
                    }
                    ch.setClip(this.markerLegendBox);
                    ch.glCallList(g, COLOR_LEGENDS[0]);
                    ch.resetClip();
                }
                if (this.subgroupLegendBox != null) {
                    if (!this.transparent) {
                        ch.clearBuffer(this.subgroupLegendBox);
                    } else {
                        ch.copyBuffer(this.subgroupLegendBox, 2);
                    }
                    ch.setClip(this.subgroupLegendBox);
                    ch.glCallList(g, COLOR_LEGENDS[1]);
                    ch.resetClip();
                }
            }
        }
        if (this.width != oldWidth || this.height != oldHeight) {
            this.width = oldWidth;
            this.height = oldHeight;
        }
        this.setStandardView(ch);
        ch.glCallList(g, 2L);
        ch.glCallList(g, 7L);
        this.setViewport(ch);
        this.setFinalView(ch);
    }

    @Override
    protected boolean isRegionPicked(int x, int y) {
        boolean picked = false;
        if (this.markerLegendScroll && this.markerLegendBox.contains(x, y)) {
            picked = true;
            this.currentLegend = 0;
        }
        if (this.subgroupLegendScroll && this.subgroupLegendBox.contains(x, y)) {
            picked = true;
            this.currentLegend = 1;
        }
        if (!picked) {
            this.currentLegend = -1;
        }
        return picked;
    }

    @Override
    protected float getScrollableThumb() {
        if (this.currentLegend == 0) {
            return this.markerLegend.thumb;
        }
        if (this.currentLegend == 1) {
            return this.subgroupLegend.thumb;
        }
        return 0.0f;
    }

    @Override
    protected void scrollRegion(Channel ch, int x, int y, int prevx, int prevy) {
        Rectangle legendBox;
        DiscreteColorLegend2 legend;
        float dy;
        float dx;
        if (this.currentLegend == -1) {
            return;
        }
        if (this.currentLegend == 0) {
            dx = (float)(x - prevx) / (float)this.markerLegendBox.width;
            dy = (float)(y - prevy) / (float)this.markerLegendBox.height;
            legend = this.markerLegend;
            legendBox = this.markerLegendBox;
        } else {
            dx = (float)(x - prevx) / (float)this.subgroupLegendBox.width;
            dy = (float)(y - prevy) / (float)this.subgroupLegendBox.height;
            legend = this.subgroupLegend;
            legendBox = this.subgroupLegendBox;
        }
        this.setStandardView(ch);
        ch.glNewList(COLOR_LEGENDS[this.currentLegend], true);
        legend.moveThumb(ch, dx, dy);
        ch.glEndList();
        ch.glNewList(COLOR_LABELS[this.currentLegend], true);
        legend.addLabelsBox(ch);
        ch.glEndList();
        if (this.transparent) {
            ch.copyBuffer(legendBox, 2);
        } else {
            ch.clearBuffer(legendBox);
        }
        ch.setClip(legendBox);
        ch.glCallList(COLOR_LEGENDS[this.currentLegend]);
        ch.glCallList(COLOR_LABELS[this.currentLegend]);
        ch.resetClip();
        ch.glRefresh(legendBox);
        this.setFinalView(ch);
    }

    @Override
    protected void setLegendBoundingBoxes(Channel ch) {
        if (this.overlayLegendStyle.getVisible()) {
            if (this.subgroupLegend != null) {
                this.subgroupLegendBox = this.subgroupLegend.getBoundingBox(ch, true);
            }
            if (this.markerLegend != null) {
                this.markerLegendBox = this.markerLegend.getBoundingBox(ch, true);
            }
        }
    }

    private void ascendSortLabels(String[][] s) {
        int n = s.length;
        if (n <= 1) {
            return;
        }
        for (int j = 1; j < n; ++j) {
            if (s[j] == null) continue;
            String[] t = s[j];
            for (int i = j - 1; i >= 0 && s[i][0].compareTo(t[0]) > 0; --i) {
                s[i + 1] = s[i];
            }
            s[i + 1] = t;
        }
    }

    private void descendSortLabels(String[][] s) {
        int n = s.length;
        if (n <= 1) {
            return;
        }
        for (int j = 1; j < n; ++j) {
            if (s[j] == null) continue;
            String[] t = s[j];
            for (int i = j - 1; i >= 0 && s[i][0].compareTo(t[0]) < 0; --i) {
                s[i + 1] = s[i];
            }
            s[i + 1] = t;
        }
    }

    @Override
    protected void parseProbeInfo(String[] lastPicked, String[] descriptors, String[] values) {
        int len = lastPicked[0].length();
        String tag = lastPicked[0];
        block6: for (int i = 0; i < len; ++i) {
            switch (tag.charAt(i)) {
                default: {
                    descriptors[i] = lastPicked[3 * i + 1];
                    values[i] = this.dataUser.format((Variable)this.columnVariable, lastPicked[3 * i + 2]);
                    this.clickedColumn = lastPicked[3 * i + 3];
                    continue block6;
                }
                case 'g': {
                    descriptors[i] = lastPicked[3 * i + 1];
                    values[i] = this.dataUser.format((Variable)this.groupVariable, lastPicked[3 * i + 2]);
                    this.clickedGroup = lastPicked[3 * i + 3];
                    continue block6;
                }
                case 's': {
                    descriptors[i] = lastPicked[3 * i + 1];
                    values[i] = this.dataUser.format((Variable)this.subgroupVariable, lastPicked[3 * i + 2]);
                    this.clickedSubGroup = lastPicked[3 * i + 3];
                    continue block6;
                }
                case 'o': 
                case 't': {
                    descriptors[i] = lastPicked[3 * i + 1];
                    values[i] = lastPicked[3 * i + 2];
                    continue block6;
                }
                case 'h': {
                    descriptors[i] = lastPicked[3 * i + 1];
                    String[] vars = this.getHeightVariablesName(false);
                    int heightIndex = new Integer(lastPicked[3 * i + 3]);
                    values[i] = heightIndex >= 0 && heightIndex < this.heightVariables.length ? this.dataUser.format((Variable)this.heightVariables[heightIndex], lastPicked[3 * i + 2]) : lastPicked[3 * i + 2];
                    this.clickedHeight = lastPicked[3 * i + 2];
                }
            }
        }
    }

    @Override
    protected void resetClickedItems() {
        this.clickedColumn = null;
        this.clickedHeight = null;
        this.clickedSubGroup = null;
        this.clickedMarker = null;
        this.clickedGroup = null;
    }

    public String getClickedColumn(boolean formatted) {
        if (formatted && this.clickedColumn != null) {
            return this.dataUser.format((Variable)this.columnVariable, this.clickedColumn);
        }
        return this.clickedColumn;
    }

    public String getClickedHeight(boolean formatted) {
        if (formatted && this.subgroupVariable != null && this.clickedHeight != null) {
            return this.dataUser.format((Variable)this.heightVariables[0], this.clickedHeight);
        }
        return this.clickedHeight;
    }

    public String getClickedSubGroup(boolean formatted) {
        if (formatted && this.subgroupVariable != null && this.clickedSubGroup != null) {
            return this.dataUser.format((Variable)this.subgroupVariable, this.clickedSubGroup);
        }
        return this.clickedSubGroup;
    }

    public Object getClickedColumnValue() {
        return Visualization.getRawObject(this.data.getType(this.columnVariable), this.clickedColumn);
    }

    public String getClickedGroup(boolean formatted) {
        if (formatted && this.clickedGroup != null) {
            return this.dataUser.format((Variable)this.groupVariable, this.clickedGroup);
        }
        return this.clickedGroup;
    }

    public Object getClickedHeightValue() {
        return Visualization.getRawObject(this.data.getType(this.heightVariables[0]), this.clickedHeight);
    }

    public Object getClickedSubGroupValue() {
        return Visualization.getRawObject(this.data.getType(this.subgroupVariable), this.clickedSubGroup);
    }

    public Object getClickedGroupValue() {
        return Visualization.getRawObject(this.data.getType(this.groupVariable), this.clickedGroup);
    }

    public Object[] getPickedColumnValues(boolean formatted) {
        return Overlay2.getPickedValues(formatted, this.pickList, 0, this.dataUser, this.columnVariable);
    }

    public Object[] getPickedSubGroupValues(boolean formatted) {
        return Overlay2.getPickedValues(formatted, this.pickList, 1, this.dataUser, this.subgroupVariable);
    }

    public Object[] getPickedGroupValues(boolean formatted) {
        return Overlay2.getPickedValues(formatted, this.pickList, 2, this.dataUser, this.groupVariable);
    }

    public Object[] getPickedHeightValues(boolean formatted) {
        return Overlay2.getPickedValues(formatted, this.pickList, 4, this.dataUser, this.heightVariables[0]);
    }

    private IndependentVariable copy(IndependentVariable in) {
        if (in == null) {
            return null;
        }
        IndependentVariable iv = new IndependentVariable(in.name, in.label, in.sort);
        iv.index = in.index;
        iv.indexIn = in.indexIn;
        iv.automatic = in.automatic;
        iv.userLabel = in.userLabel;
        iv.hideLabel = in.hideLabel;
        return iv;
    }

    private boolean isVariableNotSet(Variable v) {
        return v == null || v.indexIn == -1;
    }

    private boolean isJoined(DependentVariable2 v) {
        return v.chartType == 1 || v.chartType == 2;
    }

    private boolean isMarked(DependentVariable2 v) {
        return v.chartType == 1 || v.chartType == 0;
    }

    @Override
    protected boolean depthValid(int depthIn) {
        return depthIn == 0 || depthIn == 1;
    }

    @Override
    public void doDataScrolling(Channel ch, int x, int y, int prevx, int prevy) {
        if (this.dataModeState == 9) {
            return;
        }
        boolean rebuild = false;
        double deltaX = 0.5 * (double)this.numColumns * (double)(x - prevx) / (double)this.xSizePixels;
        switch (this.dataModeState) {
            case 0: {
                this.offset = (float)((double)this.offset + deltaX);
                if (this.offset < 0.0f) {
                    while (this.offset < 0.0f) {
                        if (this.xSizeMin > 0.0f) {
                            this.xSizeMin -= 1.0f;
                            this.xSize += 1.0f;
                            rebuild = true;
                        }
                        this.offset += 0.5f;
                    }
                } else {
                    if (!(this.offset > 1.0f)) break;
                    while (this.offset > 1.0f) {
                        if (this.xSizeMin + 1.0f < this.xSizeMax) {
                            this.xSizeMin += 1.0f;
                            this.xSize -= 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                break;
            }
            default: {
                this.offset = (float)((double)this.offset + deltaX);
                if (this.offset < 0.0f) {
                    while (this.offset < 0.0f) {
                        if (this.xSizeMin > 0.0f) {
                            this.xSizeMin -= 1.0f;
                            this.xSizeMax -= 1.0f;
                            rebuild = true;
                        }
                        this.offset += 0.5f;
                    }
                } else {
                    if (!(this.offset > 1.0f)) break;
                    while (this.offset > 1.0f) {
                        if (this.xSizeMax < this.numColumns) {
                            this.xSizeMin += 1.0f;
                            this.xSizeMax += 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                break;
            }
            case 1: {
                this.offset = (float)((double)this.offset + deltaX);
                if (this.offset > 1.0f) {
                    while (this.offset > 1.0f) {
                        if (this.xSizeMax < this.numColumns) {
                            this.xSize += 1.0f;
                            this.xSizeMax += 1.0f;
                            rebuild = true;
                        }
                        this.offset -= 0.5f;
                    }
                }
                if (!(this.offset < 0.0f)) break;
                while (this.offset < 0.0f) {
                    if (this.xSizeMax > this.xSizeMin + 1.0f) {
                        this.xSize -= 1.0f;
                        this.xSizeMax -= 1.0f;
                        rebuild = true;
                    }
                    this.offset += 0.5f;
                }
                break block0;
            }
        }
        if (rebuild) {
            this.rebuildChart(ch);
        }
    }

    @Override
    public synchronized int isDataLocation(Channel ch, int x, int y) {
        this.dataModeState = 9;
        if (ch == null || !this.validVisualization || this.dirty) {
            return this.dataModeState;
        }
        Stack hitStack = new Stack();
        ch.gluPickMatrix(x, y, 1, 1);
        ch.glRenderMode(1);
        ch.glSelectBuffer(hitStack);
        ch.glCallList(9L, false);
        boolean hit = ch.glRenderMode(0);
        if (!hit || hitStack.isEmpty()) {
            return this.dataModeState;
        }
        String strs = (String)hitStack.pop();
        if (strs.equals("Left")) {
            this.dataModeState = 0;
        } else if (strs.equals("Right")) {
            this.dataModeState = 1;
        } else if (strs.equals("XPan")) {
            this.dataModeState = 2;
        }
        this.offset = 0.5f;
        return this.dataModeState;
    }

    @Override
    public void stopDataScrolling(Channel ch) {
        this.dataModeState = 9;
        this.offset = 0.5f;
    }

    @Override
    protected void addDataScrollbar(Channel ch) {
        if (!this.dataMode) {
            return;
        }
        ch.glSelect2DFont(this.heightLegendStyle.valueStyle.createFont());
        this.verticalSpaceSize = (float)ch.glGetTextHeight() / 2.0f;
        this.blankSpaceSize = (float)ch.glGetTextWidth(" ");
        this.addXDataScrollbar(ch);
    }

    protected void addXDataScrollbar(Channel ch) {
        Color mgray = Color.gray.brighter();
        int pmode = ch.getPolygonMode();
        ch.glPolygonMode(4);
        double xo = this.xSizeMin + this.xSizeMin / this.numColumns * this.xSize;
        double x1 = this.xSizeMin + this.xSizeMax / this.numColumns * this.xSize - 5.0f * this.blankSpaceSize;
        double zo = -1.0;
        if (x1 + (double)(5.0f * this.blankSpaceSize) > (double)this.xSizeMax) {
            x1 = this.xSizeMax - 5.0f * this.blankSpaceSize;
            if (xo + (double)(5.0f * this.blankSpaceSize) > x1) {
                xo = Math.max((double)this.xSizeMin, x1 - (double)(5.0f * this.blankSpaceSize));
            }
        } else if (xo + (double)(5.0f * this.blankSpaceSize) > x1) {
            double delta = Math.max(0.0, x1 - xo);
            xo = Math.max((double)this.xSizeMin, xo - ((double)(5.0f * this.blankSpaceSize) - delta) / 2.0);
            x1 = Math.min(xo + (double)(5.0f * this.blankSpaceSize), (double)(this.xSizeMax - 5.0f * this.blankSpaceSize));
        }
        ch.glColor(Color.gray);
        ch.glEdgeColor(Color.black);
        double yo = (double)this.ySize + 1.5 * (double)this.verticalSpaceSize;
        Shapes.addRectangle(ch, ((double)this.xSizeMin + xo) / 2.0, yo, zo, xo - (double)this.xSizeMin, 2.0f * this.verticalSpaceSize);
        Shapes.addRectangle(ch, ((double)this.xSizeMax + x1) / 2.0, yo, zo, (double)this.xSizeMax - x1, 2.0f * this.verticalSpaceSize);
        ch.glColor(Color.lightGray);
        ch.glEdgeColor(mgray);
        ch.glPushName("XPan");
        Shapes.addRectangle(ch, (xo + x1) / 2.0 + 2.5 * (double)this.blankSpaceSize, yo, zo, x1 - xo - 2.5 * (double)this.blankSpaceSize, 2.0f * this.verticalSpaceSize);
        ch.glEdgeColor(Color.gray);
        ch.glColor(mgray);
        ch.glLoadName("Left");
        Shapes.addRectangle(ch, xo + 2.5 * (double)this.blankSpaceSize, yo, zo, 5.0f * this.blankSpaceSize, 2.0f * this.verticalSpaceSize);
        ch.glColor(Color.white);
        ch.glBegin(1);
        ch.glVertex(xo + (double)(5.0f * this.blankSpaceSize), yo + (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, yo + (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo, yo - (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glColor(Color.black);
        ch.glBegin(1);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), yo + 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), yo - 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + (double)(2.0f * this.blankSpaceSize), yo, zo);
        ch.glVertex(xo + 0.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + 1.5 * (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + 0.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glVertex(xo + 1.5 * (double)this.blankSpaceSize, yo - 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + (double)(3.0f * this.blankSpaceSize), yo + 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + (double)(3.0f * this.blankSpaceSize), yo - 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + (double)(3.0f * this.blankSpaceSize), yo, zo);
        ch.glVertex(xo + 4.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(xo + 3.5 * (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(xo + 4.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glVertex(xo + 3.5 * (double)this.blankSpaceSize, yo - 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glEdgeColor(Color.gray);
        ch.glColor(mgray);
        ch.glLoadName("Right");
        Shapes.addRectangle(ch, x1 + 2.5 * (double)this.blankSpaceSize, yo, zo, 5.0f * this.blankSpaceSize, 2.0f * this.verticalSpaceSize);
        ch.glColor(Color.white);
        ch.glBegin(1);
        ch.glVertex(x1, yo + (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + (double)(5.0f * this.blankSpaceSize), yo + (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + (double)(5.0f * this.blankSpaceSize), yo - (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glColor(Color.black);
        ch.glBegin(1);
        ch.glVertex(x1 + (double)(2.0f * this.blankSpaceSize), yo + 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + (double)(2.0f * this.blankSpaceSize), yo - 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + (double)(2.0f * this.blankSpaceSize), yo, zo);
        ch.glVertex(x1 + 0.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + 1.5 * (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + 0.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glVertex(x1 + 1.5 * (double)this.blankSpaceSize, yo - 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + (double)(3.0f * this.blankSpaceSize), yo + 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + (double)(3.0f * this.blankSpaceSize), yo - 0.75 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + (double)(3.0f * this.blankSpaceSize), yo, zo);
        ch.glVertex(x1 + 4.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glEnd();
        ch.glBegin(1);
        ch.glVertex(x1 + 3.5 * (double)this.blankSpaceSize, yo + 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glVertex(x1 + 4.5 * (double)this.blankSpaceSize, yo, zo);
        ch.glVertex(x1 + 3.5 * (double)this.blankSpaceSize, yo - 0.5 * (double)this.verticalSpaceSize, zo);
        ch.glEnd();
        ch.glPopName();
        if (this.edgeColor != null) {
            ch.glEdgeColor(this.edgeColor);
        }
        ch.glPolygonMode(pmode);
        ch.glFrontFace(0);
        this.yMaxLegendSize += 3.0f * this.verticalSpaceSize;
    }

    public boolean isSegmentChart() {
        return this.segmentChart;
    }
}

