/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.DiscreteLegend;
import com.sas.graphics.util.visualize.ExtendedShapes;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.Vec3f;

class MarkerLegend
extends DiscreteLegend {
    double markerSize = 0.7;

    public MarkerLegend(Mapper aMapper) {
        super(aMapper);
    }

    void setMarkerSize(double aSize) {
        this.markerSize = aSize;
    }

    double setMarkerSize() {
        return this.markerSize;
    }

    @Override
    protected void addGeometry(Channel ch) {
        ch.glColor(this.geomColor);
        double sz = this.markerSize * (double)this.valueHeight;
        for (int i = 0; i < this.intervals; ++i) {
            int mappedValue = (int)this.mapper.getMappedValue(this.values[i]);
            if (mappedValue < this.start || mappedValue >= this.end) continue;
            Vec3f current = new Vec3f(this.incrementVector);
            Vec3f step = new Vec3f(this.stepVector.x, -this.stepVector.y, this.stepVector.z);
            current.scale((mappedValue - this.start) % this.maxNumColumns);
            step.scale((mappedValue - this.start) / this.maxNumColumns);
            current.add(step);
            double xo = (double)current.x + this.markerSize / 2.0;
            double yo = (double)current.y + this.markerSize / 2.0;
            double zo = (double)current.z + this.markerSize / 2.0;
            switch (mappedValue) {
                default: {
                    break;
                }
                case 1: {
                    ExtendedShapes.addBox(ch, xo, yo, zo, sz, sz, sz);
                    break;
                }
                case 8: {
                    ExtendedShapes.addCircle(ch, xo, yo, zo, sz / 2.0);
                    break;
                }
                case 2: {
                    ExtendedShapes.addCross(ch, xo, yo, zo, sz, sz);
                    break;
                }
                case 9: {
                    ExtendedShapes.addTriangle(ch, true, xo, yo, zo, sz, sz);
                    break;
                }
                case 0: {
                    ExtendedShapes.addSphere(ch, xo, yo, zo, sz / 2.0);
                    break;
                }
                case 5: {
                    ExtendedShapes.addVCone(ch, xo, yo, zo, sz / 2.0, sz);
                    break;
                }
                case 6: {
                    ExtendedShapes.addVCylinder(ch, xo, yo, zo, sz / 2.0, sz);
                    break;
                }
                case 7: {
                    ExtendedShapes.addDiamond(ch, xo, yo, zo, sz, sz);
                    break;
                }
                case 3: {
                    ExtendedShapes.addPyramid(ch, xo, yo, zo, sz, sz);
                    break;
                }
                case 4: {
                    ExtendedShapes.addStar(ch, xo, yo, zo, sz / 2.0, sz / 2.0);
                }
            }
            ch.glBegin(1);
            ch.glVertex(current.x, current.y, current.z);
            ch.glVertex(current.x + this.valueHeight, current.y, current.z);
            ch.glVertex(current.x + this.valueHeight, current.y + this.valueHeight, current.z);
            ch.glVertex(current.x, current.y + this.valueHeight, current.z);
            ch.glVertex(current.x, current.y, current.z);
            ch.glEnd();
        }
    }
}

