/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import java.util.Hashtable;

abstract class Mapper {
    private Hashtable primaryValues;

    Mapper() {
    }

    protected abstract void addValue(String var1);

    protected void addValue(String value, int type) {
    }

    protected void addValue(String value, String primaryValue) {
        this.addValue(value);
        if (value != null && primaryValue != null) {
            if (this.primaryValues == null) {
                this.primaryValues = new Hashtable();
            }
            this.primaryValues.put(value, primaryValue);
        }
    }

    protected void addValue(String value, int type, String primaryValue) {
        this.addValue(value, type);
        if (value != null && primaryValue != null) {
            if (this.primaryValues == null) {
                this.primaryValues = new Hashtable();
            }
            this.primaryValues.put(value, primaryValue);
        }
    }

    protected String getPrimaryValueLabel(String value) {
        String primaryValue = value != null && this.primaryValues != null ? (String)this.primaryValues.get(value) : value;
        return primaryValue == null ? value : primaryValue;
    }

    protected String[] getPrimaryValueLabels() {
        String[] values;
        String[] primaryValuesArray = values = this.getValueLabels();
        if (this.primaryValues != null && values != null) {
            primaryValuesArray = new String[values.length];
            for (int ii = 0; ii < primaryValuesArray.length; ++ii) {
                primaryValuesArray[ii] = this.getPrimaryValueLabel(values[ii]);
            }
        }
        return primaryValuesArray;
    }

    protected abstract float getMappedValue(String var1);

    protected abstract int getIntervalCount();

    protected String[] getValueLabels() {
        return null;
    }

    protected Object[] getValues(Class type) {
        return null;
    }
}

