/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.Vec3f;
import java.awt.Color;

public abstract class Legend {
    private static final Vec3f originDefault = new Vec3f(0.0f, 0.0f, 0.0f);
    private static final Color colorDefault = Color.black;
    public Vec3f origin;
    public String[] primaryValues;
    public String[] values;
    public String[] formattedValues;
    public TextStyle valueStyle;
    public Color geomColor;
    public int intervals;
    protected Mapper mapper;
    protected float valueHeight;
    protected float tickSize;
    protected float hLegendOffset;
    protected float vLegendOffset;
    protected boolean continuous = false;
    protected boolean hideTickMark;
    protected boolean valuesVisible;
    protected boolean valueHotspotsEnabled;
    protected int valueHotspotID;
    protected boolean labelValueHotspotsEnabled;
    protected boolean labelHotspotsEnabled;
    protected int labelHotspotID;
    protected transient Blob[] valueHotspots;
    protected transient Blob[] labelHotspots;

    public Legend(Mapper aMapper) {
        this.mapper = aMapper;
        this.origin = originDefault;
        this.valueStyle = new TextStyle();
        this.geomColor = colorDefault;
        this.intervals = 1;
        this.hLegendOffset = 0.0f;
        this.vLegendOffset = 0.0f;
        this.hideTickMark = false;
        this.valueHotspotsEnabled = false;
        this.labelHotspotsEnabled = false;
        this.labelValueHotspotsEnabled = false;
        this.valuesVisible = true;
    }

    public void setValues(String[] someValues) {
        this.values = someValues;
        this.intervals = someValues.length;
    }

    public void setPrimaryValues(String[] someValues) {
        this.primaryValues = someValues;
    }

    public void setFormattedValues(String[] someValues) {
        this.formattedValues = someValues;
    }

    public void setValueStyles(TextStyle aValueStyle) {
        this.valueStyle = aValueStyle;
    }

    public TextStyle getValueStyles() {
        return this.valueStyle;
    }

    public void setValueHotspotsEnabled(boolean newValueHotspotsEnabled) {
        this.valueHotspotsEnabled = newValueHotspotsEnabled;
        if (!this.valueHotspotsEnabled) {
            this.valueHotspots = null;
        }
    }

    public boolean isValueHotspotsEnabled() {
        return this.valueHotspotsEnabled;
    }

    public void setValueHotspotID(int newValueHotspotID) {
        this.valueHotspotID = newValueHotspotID;
    }

    public int getValueHotspotID() {
        return this.valueHotspotID;
    }

    public Blob[] getValueHotspots() {
        return this.valueHotspots;
    }

    public void setLabelValueHotspotsEnabled(boolean newLabelHotspotsEnabled) {
        this.labelValueHotspotsEnabled = newLabelHotspotsEnabled;
        if (!this.labelValueHotspotsEnabled) {
            this.labelHotspots = null;
        }
    }

    public void setLabelHotspotsEnabled(boolean newLabelHotspotsEnabled) {
        this.labelHotspotsEnabled = newLabelHotspotsEnabled;
        if (!this.labelHotspotsEnabled) {
            this.labelHotspots = null;
        }
    }

    public void setLabelHotspotID(int newLabelHotspotID) {
        this.labelHotspotID = newLabelHotspotID;
    }

    public int getLabelHotspotID() {
        return this.labelHotspotID;
    }

    public boolean isLabelValueHotspotsEnabled() {
        return this.labelValueHotspotsEnabled;
    }

    public boolean isLabelHotspotsEnabled() {
        return this.labelHotspotsEnabled;
    }

    public Blob[] getLabelHotspots() {
        return this.labelHotspots;
    }

    protected float findMaxValueLength(Channel ch, boolean clip) {
        if (!this.valuesVisible) {
            return 0.0f;
        }
        double maxlength = 0.0;
        int maxChars = this.valueStyle.getMaxChars();
        ch.glSelect2DFont(this.valueStyle.createFont());
        for (int i = 0; i < this.values.length; ++i) {
            double length = clip ? ch.glGetTextWidth(this.formattedValues[i].trim().substring(0, Math.min(maxChars, this.formattedValues[i].trim().length()))) : ch.glGetTextWidth(this.formattedValues[i].trim());
            if (!(length > maxlength)) continue;
            maxlength = length;
        }
        return (float)maxlength;
    }

    protected float findMaxValueLength(Channel ch) {
        double maxlength = 0.0;
        int maxChars = this.valueStyle.getMaxChars();
        if (!this.valuesVisible) {
            return 0.0f;
        }
        ch.glSelect2DFont(this.valueStyle.createFont());
        for (int i = 0; i < this.values.length; ++i) {
            double length = ch.glGetTextWidth(this.formattedValues[i].substring(0, Math.min(maxChars, this.formattedValues[i].length())));
            if (!(length > maxlength)) continue;
            maxlength = length;
        }
        return (float)maxlength;
    }

    public void addLegend(Channel ch, boolean visible) {
        this.vLegendOffset = 0.0f;
        this.hLegendOffset = 0.0f;
        ch.glSelect2DFont(this.valueStyle.createFont());
        this.valueHeight = this.valuesVisible ? (float)ch.glGetTextHeight() : 0.0f;
        this.tickSize = this.hideTickMark ? 0.0f : (float)ch.glGetTextHeight() / 2.0f;
        if (visible) {
            this.addGeometry(ch);
        }
        this.addValues(ch, this.origin, this.valueStyle.majorJustify, this.valueStyle.minorJustify);
    }

    protected static int ClippingIndex(String str, int max) {
        for (int i = max; i > 0; --i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return i;
        }
        return 0;
    }

    protected abstract void addValues(Channel var1, Vec3f var2, String var3, String var4);

    protected abstract void addGeometry(Channel var1);
}

