/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.Vec3f;
import java.util.Vector;

public class ExtendedShapes
extends Shapes {
    static final double DEG2RAD = Math.PI / 180;
    private static Vector starList;
    static Vector sphereList;

    protected static void addTriangle(Channel ch, boolean vertical, double x, double y, double z, double base, double height) {
        if (vertical) {
            if (base == 0.0) {
                ch.glBegin(1);
                ch.glVertex(x, y + height / 2.0, z);
                ch.glVertex(x, y - height / 2.0, z);
                ch.glEnd();
            } else if (height == 0.0) {
                ch.glBegin(1);
                ch.glVertex(x + base / 2.0, y, z);
                ch.glVertex(x - base / 2.0, y, z);
                ch.glEnd();
            } else {
                ch.glBegin(2);
                ch.glVertex(x - base / 2.0, y - height / 2.0, z);
                ch.glVertex(x + base / 2.0, y - height / 2.0, z);
                ch.glVertex(x, y + height / 2.0, z);
                ch.glEnd();
            }
        } else if (base == 0.0) {
            ch.glBegin(1);
            ch.glVertex(x + height / 2.0, y, z);
            ch.glVertex(x - height / 2.0, y, z);
            ch.glEnd();
        } else if (height == 0.0) {
            ch.glBegin(1);
            ch.glVertex(x, y + base / 2.0, z);
            ch.glVertex(x, y - base / 2.0, z);
            ch.glEnd();
        } else {
            ch.glBegin(2);
            ch.glVertex(x - height / 2.0, y + base / 2.0, z);
            ch.glVertex(x - height / 2.0, y - base / 2.0, z);
            ch.glVertex(x + height / 2.0, y, z);
            ch.glEnd();
        }
    }

    protected static void addStar(Channel ch, Vec3f p, double R, double height) {
        ExtendedShapes.addStar(ch, p.x, p.y, p.z, R, height);
    }

    static void createStarMesh() {
        double alpha = -1.5707963267948966;
        double delta = 1.2566370614359172;
        double beta = alpha + delta / 2.0;
        double r = Math.sin(delta / 4.0) / Math.sin(2.199114857512855);
        double[] px = new double[10];
        double[] py = new double[10];
        px[0] = -Math.cos(alpha);
        py[0] = -Math.sin(alpha);
        px[1] = -r * Math.cos(beta);
        py[1] = -r * Math.sin(beta);
        px[2] = -Math.cos(alpha + delta);
        py[2] = -Math.sin(alpha + delta);
        px[3] = -r * Math.cos(beta + delta);
        py[3] = -r * Math.sin(beta + delta);
        px[4] = -Math.cos(alpha + 2.0 * delta);
        py[4] = -Math.sin(alpha + 2.0 * delta);
        px[5] = -r * Math.cos(beta + 2.0 * delta);
        py[5] = -r * Math.sin(beta + 2.0 * delta);
        px[6] = -Math.cos(alpha + 3.0 * delta);
        py[6] = -Math.sin(alpha + 3.0 * delta);
        px[7] = -r * Math.cos(beta + 3.0 * delta);
        py[7] = -r * Math.sin(beta + 3.0 * delta);
        px[8] = -Math.cos(alpha + 4.0 * delta);
        py[8] = -Math.sin(alpha + 4.0 * delta);
        px[9] = -r * Math.cos(beta + 4.0 * delta);
        py[9] = -r * Math.sin(beta + 4.0 * delta);
        starList = new Vector();
        starList.addElement(px);
        starList.addElement(py);
    }

    protected static void addStar(Channel ch, double x, double y, double z, double R, double height) {
        if (starList == null) {
            ExtendedShapes.createStarMesh();
        }
        double[] sx = (double[])starList.elementAt(0);
        double[] sy = (double[])starList.elementAt(1);
        double[] px = new double[10];
        double[] py = new double[10];
        for (int i = 0; i < 10; ++i) {
            px[i] = R * sx[i];
            py[i] = R * sy[i];
        }
        double nx = 0.0;
        double ny = 0.0;
        double nz = -1.0;
        ch.glBegin(2);
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[9], y + py[9], z - height / 2.0);
        ch.glVertex(x + px[8], y + py[8], z - height / 2.0);
        ch.glVertex(x + px[7], y + py[7], z - height / 2.0);
        ch.glVertex(x + px[6], y + py[6], z - height / 2.0);
        ch.glVertex(x + px[5], y + py[5], z - height / 2.0);
        ch.glVertex(x + px[4], y + py[4], z - height / 2.0);
        ch.glVertex(x + px[3], y + py[3], z - height / 2.0);
        ch.glVertex(x + px[2], y + py[2], z - height / 2.0);
        ch.glVertex(x + px[1], y + py[1], z - height / 2.0);
        ch.glVertex(x + px[0], y + py[0], z - height / 2.0);
        ch.glBound();
        nx = -(py[0] - py[1]);
        ny = px[0] - px[1];
        nz = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[0], y + py[0], z + height / 2.0);
        ch.glVertex(x + px[0], y + py[0], z - height / 2.0);
        ch.glVertex(x + px[1], y + py[1], z - height / 2.0);
        ch.glVertex(x + px[1], y + py[1], z + height / 2.0);
        ch.glBound();
        nx = -(py[1] - py[2]);
        ny = px[1] - px[2];
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[1], y + py[1], z + height / 2.0);
        ch.glVertex(x + px[1], y + py[1], z - height / 2.0);
        ch.glVertex(x + px[2], y + py[2], z - height / 2.0);
        ch.glVertex(x + px[2], y + py[2], z + height / 2.0);
        ch.glBound();
        nx = -(py[2] - py[3]);
        ny = px[2] - px[3];
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[2], y + py[2], z + height / 2.0);
        ch.glVertex(x + px[2], y + py[2], z - height / 2.0);
        ch.glVertex(x + px[3], y + py[3], z - height / 2.0);
        ch.glVertex(x + px[3], y + py[3], z + height / 2.0);
        ch.glBound();
        nx = -(py[3] - py[4]);
        ny = px[3] - px[4];
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[3], y + py[3], z + height / 2.0);
        ch.glVertex(x + px[3], y + py[3], z - height / 2.0);
        ch.glVertex(x + px[4], y + py[4], z - height / 2.0);
        ch.glVertex(x + px[4], y + py[4], z + height / 2.0);
        ch.glBound();
        nx = -(py[4] - py[5]);
        ny = px[4] - px[5];
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[4], y + py[4], z + height / 2.0);
        ch.glVertex(x + px[4], y + py[4], z - height / 2.0);
        ch.glVertex(x + px[5], y + py[5], z - height / 2.0);
        ch.glVertex(x + px[5], y + py[5], z + height / 2.0);
        ch.glBound();
        nx = -(py[5] - py[6]);
        ny = px[5] - px[6];
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[5], y + py[5], z + height / 2.0);
        ch.glVertex(x + px[5], y + py[5], z - height / 2.0);
        ch.glVertex(x + px[6], y + py[6], z - height / 2.0);
        ch.glVertex(x + px[6], y + py[6], z + height / 2.0);
        ch.glBound();
        nx = -(py[6] - py[7]);
        ny = px[6] - px[7];
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[6], y + py[6], z + height / 2.0);
        ch.glVertex(x + px[6], y + py[6], z - height / 2.0);
        ch.glVertex(x + px[7], y + py[7], z - height / 2.0);
        ch.glVertex(x + px[7], y + py[7], z + height / 2.0);
        ch.glBound();
        nx = -(py[7] - py[8]);
        ny = px[7] - px[8];
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[7], y + py[7], z + height / 2.0);
        ch.glVertex(x + px[7], y + py[7], z - height / 2.0);
        ch.glVertex(x + px[8], y + py[8], z - height / 2.0);
        ch.glVertex(x + px[8], y + py[8], z + height / 2.0);
        ch.glBound();
        nx = -(py[8] - py[9]);
        ny = px[8] - px[9];
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[8], y + py[8], z + height / 2.0);
        ch.glVertex(x + px[8], y + py[8], z - height / 2.0);
        ch.glVertex(x + px[9], y + py[9], z - height / 2.0);
        ch.glVertex(x + px[9], y + py[9], z + height / 2.0);
        ch.glBound();
        nx = -(py[9] - py[0]);
        ny = px[9] - px[0];
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[9], y + py[9], z + height / 2.0);
        ch.glVertex(x + px[9], y + py[9], z - height / 2.0);
        ch.glVertex(x + px[0], y + py[0], z - height / 2.0);
        ch.glVertex(x + px[0], y + py[0], z + height / 2.0);
        ch.glBound();
        nx = 0.0;
        ny = 0.0;
        nz = 1.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x + px[0], y + py[0], z + height / 2.0);
        ch.glVertex(x + px[1], y + py[1], z + height / 2.0);
        ch.glVertex(x + px[2], y + py[2], z + height / 2.0);
        ch.glVertex(x + px[3], y + py[3], z + height / 2.0);
        ch.glVertex(x + px[4], y + py[4], z + height / 2.0);
        ch.glVertex(x + px[5], y + py[5], z + height / 2.0);
        ch.glVertex(x + px[6], y + py[6], z + height / 2.0);
        ch.glVertex(x + px[7], y + py[7], z + height / 2.0);
        ch.glVertex(x + px[8], y + py[8], z + height / 2.0);
        ch.glVertex(x + px[9], y + py[9], z + height / 2.0);
        ch.glEnd();
    }

    protected static void addSphere(Channel ch, Vec3f p, double R) {
        ExtendedShapes.addSphere(ch, p.x, p.y, p.z, R);
    }

    protected static void createSphereMesh() {
        sphereList = new Vector();
        int nLongitude = precision;
        int nLatitude = nLongitude / 2;
        for (int latitude = 0; latitude <= nLatitude; ++latitude) {
            double phi = -1.5707963267948966 + Math.PI * (double)latitude / (double)nLatitude;
            double cosPhi = Math.cos(phi);
            double sinPhi = Math.sin(phi);
            for (int longitude = 0; longitude <= nLongitude; ++longitude) {
                double theta = Math.PI * 2 * (double)longitude / (double)nLongitude;
                double[] v = new double[]{cosPhi * Math.cos(theta), cosPhi * Math.sin(theta), sinPhi};
                sphereList.addElement(v);
            }
        }
        sphereList.addElement(new Integer(precision));
    }

    protected static void addSphere(Channel ch, double x, double y, double z, double r) {
        if (sphereList == null) {
            ExtendedShapes.createSphereMesh();
        } else {
            Integer pInt = (Integer)sphereList.lastElement();
            if (pInt != precision) {
                ExtendedShapes.createSphereMesh();
            }
        }
        int nLongitude = precision;
        int nLatitude = nLongitude / 2;
        ch.glBegin(2);
        for (int latitude = 0; latitude < nLatitude; ++latitude) {
            for (int longitude = 0; longitude < nLongitude; ++longitude) {
                double[] v = (double[])sphereList.elementAt(latitude * (nLongitude + 1) + longitude);
                ch.glVertex(v[0] * r + x, v[1] * r + y, v[2] * r + z);
                double nx = v[0];
                double ny = v[1];
                double nz = v[2];
                v = (double[])sphereList.elementAt(latitude * (nLongitude + 1) + longitude + 1);
                ch.glVertex(v[0] * r + x, v[1] * r + y, v[2] * r + z);
                nx += v[0];
                ny += v[1];
                nz += v[2];
                v = (double[])sphereList.elementAt((latitude + 1) * (nLongitude + 1) + longitude + 1);
                ch.glVertex(v[0] * r + x, v[1] * r + y, v[2] * r + z);
                nx += v[0];
                ny += v[1];
                nz += v[2];
                v = (double[])sphereList.elementAt((latitude + 1) * (nLongitude + 1) + longitude);
                ch.glVertex(v[0] * r + x, v[1] * r + y, v[2] * r + z);
                ch.glNormal(nx += v[0], ny += v[1], nz += v[2]);
                ch.glBound();
            }
        }
        ch.glEnd();
    }

    protected static void addDiamond(Channel ch, Vec3f p, double base, double height) {
        ExtendedShapes.addDiamond(ch, p.x, p.y, p.z, base, height);
    }

    protected static void addDiamond(Channel ch, double x, double y, double z, double l, double h) {
        double l2 = l / 2.0;
        double alpha = l / h;
        ch.glBegin(2);
        ch.glVertex(x, y + h, z);
        ch.glVertex(x + l, y, z);
        ch.glVertex(x + l2, y, z - l);
        ch.glNormal(1.0, alpha, -0.5);
        ch.glBound();
        ch.glVertex(x, y - h, z);
        ch.glVertex(x + l2, y, z - l);
        ch.glVertex(x + l, y, z);
        ch.glNormal(1.0, -alpha, -0.5);
        ch.glBound();
        ch.glVertex(x + l2, y, z - l);
        ch.glVertex(x - l2, y, z - l);
        ch.glVertex(x, y + h, z);
        ch.glNormal(0.0, alpha, -1.0);
        ch.glBound();
        ch.glVertex(x, y - h, z);
        ch.glVertex(x - l2, y, z - l);
        ch.glVertex(x + l2, y, z - l);
        ch.glNormal(0.0, -alpha, -1.0);
        ch.glBound();
        ch.glVertex(x, y + h, z);
        ch.glVertex(x - l2, y, z - l);
        ch.glVertex(x - l, y, z);
        ch.glNormal(-1.0, alpha, -0.5);
        ch.glBound();
        ch.glVertex(x, y - h, z);
        ch.glVertex(x - l, y, z);
        ch.glVertex(x - l2, y, z - l);
        ch.glNormal(-1.0, -alpha, -0.5);
        ch.glBound();
        ch.glVertex(x, y + h, z);
        ch.glVertex(x - l, y, z);
        ch.glVertex(x - l2, y, z + l);
        ch.glNormal(-1.0, alpha, 0.5);
        ch.glBound();
        ch.glVertex(x, y - h, z);
        ch.glVertex(x - l2, y, z + l);
        ch.glVertex(x - l, y, z);
        ch.glNormal(-1.0, -alpha, 0.5);
        ch.glBound();
        ch.glVertex(x, y + h, z);
        ch.glVertex(x - l2, y, z + l);
        ch.glVertex(x + l2, y, z + l);
        ch.glNormal(0.0, alpha, 1.0);
        ch.glBound();
        ch.glVertex(x, y - h, z);
        ch.glVertex(x + l2, y, z + l);
        ch.glVertex(x - l2, y, z + l);
        ch.glNormal(0.0, -alpha, 1.0);
        ch.glBound();
        ch.glVertex(x, y + h, z);
        ch.glVertex(x + l2, y, z + l);
        ch.glVertex(x + l, y, z);
        ch.glNormal(1.0, alpha, 0.5);
        ch.glBound();
        ch.glVertex(x, y - h, z);
        ch.glVertex(x + l, y, z);
        ch.glVertex(x + l2, y, z + l);
        ch.glNormal(1.0, -alpha, 0.5);
        ch.glEnd();
    }

    protected static void addPyramid(Channel ch, Vec3f p, double base, double height) {
        ExtendedShapes.addPyramid(ch, p.x, p.y, p.z, base, height);
    }

    protected static void addPyramid(Channel ch, double x, double y, double z, double base, double height) {
        double l = base / 2.0;
        double h = height / 2.0;
        ch.glBegin(2);
        double nx = 0.0;
        double ny = -1.0;
        double nz = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x - l, y - h, z - l);
        ch.glVertex(x + l, y - h, z - l);
        ch.glVertex(x + l, y - h, z + l);
        ch.glVertex(x - l, y - h, z + l);
        ch.glBound();
        nx = 0.0;
        ny = h;
        nz = -l / 2.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x, y + h, z);
        ch.glVertex(x + l, y - h, z - l);
        ch.glVertex(x - l, y - h, z - l);
        ch.glBound();
        nx = l / 2.0;
        ny = h;
        nz = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x, y + h, z);
        ch.glVertex(x + l, y - h, z + l);
        ch.glVertex(x + l, y - h, z - l);
        ch.glBound();
        nx = -l / 2.0;
        ny = h;
        nz = 0.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x, y + h, z);
        ch.glVertex(x - l, y - h, z - l);
        ch.glVertex(x - l, y - h, z + l);
        ch.glBound();
        nx = 0.0;
        ny = h;
        nz = l / 2.0;
        ch.glNormal(nx, ny, nz);
        ch.glVertex(x, y + h, z);
        ch.glVertex(x - l, y - h, z + l);
        ch.glVertex(x + l, y - h, z + l);
        ch.glEnd();
    }

    protected static final Vec3f computeNormal(Vec3f p1, Vec3f p2, Vec3f p3) {
        Vec3f v1 = new Vec3f(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        Vec3f v2 = new Vec3f(p3.x - p2.x, p3.y - p2.y, p3.z - p2.z);
        return v1.cross(v2);
    }

    static {
        sphereList = null;
    }
}

