/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.WireLegend;

class ExtWireLegend
extends WireLegend {
    static final int TICK_ALONG_NEGY = 0;
    static final int TICK_ALONG_POSY = 1;
    static final int TICK_ALONG_NEGX = 2;
    static final int TICK_ALONG_POSX = 3;
    static final int TICK_ALONG_NEGZ = 4;
    static final int TICK_ALONG_POSZ = 5;
    protected Vec3f midVector;
    boolean valueAlongX = true;
    boolean fixLabelPos = false;
    int tickDir = 0;
    float[] screenX;
    float[] screenY;
    float[] screenZ;
    int valueID = -1;
    boolean viewMode;
    private float hlen;
    protected String[] allFormattedValues;

    public ExtWireLegend(Mapper aMapper) {
        super(aMapper);
    }

    @Override
    protected void addValues(Channel ch, Vec3f startPt, String majorJustify, String minorJustify) {
        int i;
        int num;
        double yLength;
        double xLength;
        Vec3f axis;
        int inc;
        boolean skip;
        Vec3f space1;
        boolean toggle = true;
        boolean twoRows = false;
        int maxChars = this.valueStyle.getMaxChars();
        boolean[] cskip = new boolean[this.values.length];
        Vec3f startPoint = new Vec3f(startPt);
        if (!this.valuesVisible) {
            this.vLegendOffset += this.tickSize;
            return;
        }
        if (this.startingOffset != 0.0f) {
            Vec3f ov = new Vec3f(this.incrementVector);
            ov.normalize();
            ov.scale(-this.startingOffset);
            startPoint.add(ov);
        }
        switch (this.tickDir) {
            default: {
                space1 = new Vec3f(-this.tickSize * this.screenY[0], -this.tickSize * this.screenY[1], -this.tickSize * this.screenY[2]);
                break;
            }
            case 1: {
                space1 = new Vec3f(this.tickSize * this.screenY[0], this.tickSize * this.screenY[1], this.tickSize * this.screenY[2]);
                break;
            }
            case 3: 
            case 5: {
                space1 = new Vec3f(this.tickSize * this.screenX[0], this.tickSize * this.screenX[1], this.tickSize * this.screenX[2]);
                break;
            }
            case 2: 
            case 4: {
                space1 = new Vec3f(-this.tickSize * this.screenX[0], -this.tickSize * this.screenX[1], -this.tickSize * this.screenX[2]);
            }
        }
        Vec3f space2 = this.valueAlongX ? (this.tickDir == 0 ? new Vec3f(-this.valueHeight * this.screenY[0], -this.valueHeight * this.screenY[1], -this.valueHeight * this.screenY[2]) : new Vec3f(this.valueHeight * this.screenY[0], this.valueHeight * this.screenY[1], this.valueHeight * this.screenY[2])) : null;
        ch.glPushMatrix();
        ch.glTranslate(startPoint.x, startPoint.y, startPoint.z);
        float axisLen = !this.continuous ? (float)this.intervals : this.incrementVector.length() * (float)this.intervals;
        Vec3f ev = new Vec3f(this.incrementVector);
        ev.scale((float)this.intervals / 2.0f);
        ch.glTranslate(ev.x, ev.y, ev.z);
        float len = this.findMaxValueLength(ch, !this.continuous);
        ch.glPopMatrix();
        ch.glColor(this.valueStyle.getColor());
        if (this.rotAngle != 0) {
            skip = false;
            inc = (int)Math.ceil(len / this.incrementVector.y);
            this.hLegendOffset = (float)((double)this.hLegendOffset + 1.2 * ch.glGetTextHeight());
        } else if (this.tickDir < 2) {
            if (this.valueAlongX) {
                float incLen = this.incrementVector.length();
                if (this.oneRow) {
                    inc = (int)Math.ceil(len / incLen);
                    this.vLegendOffset += this.tickSize + this.valueHeight;
                    skip = inc > 1;
                } else if (len > incLen) {
                    inc = (int)Math.ceil(len / (2.0f * incLen));
                    this.vLegendOffset += this.tickSize + 2.0f * this.valueHeight;
                    skip = true;
                    twoRows = true;
                    toggle = false;
                } else {
                    inc = 1;
                    this.vLegendOffset += this.tickSize + this.valueHeight;
                    skip = false;
                }
            } else {
                this.vLegendOffset += this.tickSize + this.valueHeight;
                axis = new Vec3f(this.incrementVector);
                axis.scale(this.intervals);
                xLength = Math.abs(axis.x * this.screenX[0] + axis.y * this.screenX[1] + axis.z * this.screenX[2]);
                int numX = (int)Math.max(1.0, xLength / (double)len + 0.5);
                yLength = 0.75 * (double)Math.abs(axis.x * this.screenY[0] + axis.y * this.screenY[1] + axis.z * this.screenY[2]);
                num = (int)Math.max((double)numX, yLength / (double)this.valueHeight + 0.5);
                inc = 1;
                skip = false;
                while (this.intervals > num * inc) {
                    ++inc;
                }
                skip = inc > 1;
            }
        } else {
            this.hLegendOffset += len + this.tickSize;
            axis = new Vec3f(this.incrementVector);
            axis.scale(this.intervals);
            xLength = Math.abs(axis.x * this.screenX[0] + axis.y * this.screenX[1] + axis.z * this.screenX[2]);
            int numx = (int)Math.max(1.0, xLength / (double)len + 0.5);
            yLength = Math.abs(axis.x * this.screenY[0] + axis.y * this.screenY[1] + axis.z * this.screenY[2]);
            num = (int)Math.max((double)numx, yLength / (double)this.valueHeight + 0.5);
            inc = 1;
            skip = false;
            while (this.intervals > num * inc) {
                ++inc;
            }
            skip = inc > 1;
        }
        this.hlen = len + this.tickSize;
        float xo = 0.0f;
        float yo = 0.0f;
        float zo = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.0f;
        float z1 = 0.0f;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float z2 = 0.0f;
        float x3 = 0.0f;
        float y3 = 0.0f;
        float z3 = 0.0f;
        int polygonMode = 0;
        if (this.viewMode) {
            float[] valwd = null;
            float[] valht = null;
            valwd = new float[]{len * this.screenX[0], len * this.screenX[1], len * this.screenX[2]};
            valht = new float[]{this.valueHeight * this.screenY[0], this.valueHeight * this.screenY[1], this.valueHeight * this.screenY[2]};
            if (majorJustify.equals("LEFT")) {
                x2 = x3 = valwd[0];
                y2 = y3 = valwd[1];
                z2 = z3 = valwd[2];
            } else if (majorJustify.equals("CENTER")) {
                xo = x1 = -valwd[0] / 2.0f;
                yo = y1 = -valwd[1] / 2.0f;
                zo = z1 = -valwd[2] / 2.0f;
                x2 = x3 = valwd[0] / 2.0f;
                y2 = y3 = valwd[1] / 2.0f;
                z2 = z3 = valwd[2] / 2.0f;
            } else {
                xo = x1 = -valwd[0];
                yo = y1 = -valwd[1];
                zo = z1 = -valwd[2];
            }
            if (minorJustify.equals("TOP")) {
                x1 -= valht[0];
                y1 -= valht[1];
                z1 -= valht[2];
                x2 -= valht[0];
                y2 -= valht[1];
                z2 -= valht[2];
            } else if (minorJustify.equals("CENTER")) {
                xo += valht[0] / 2.0f;
                yo += valht[1] / 2.0f;
                zo += valht[2] / 2.0f;
                x1 -= valht[0] / 2.0f;
                y1 -= valht[1] / 2.0f;
                z1 -= valht[2] / 2.0f;
                x2 -= valht[0] / 2.0f;
                y2 -= valht[1] / 2.0f;
                z2 -= valht[2] / 2.0f;
                x3 += valht[0] / 2.0f;
                y3 += valht[1] / 2.0f;
                z3 += valht[2] / 2.0f;
            } else {
                x1 += valht[0];
                y1 += valht[1];
                z1 += valht[2];
                x2 += valht[0];
                y2 += valht[1];
                z2 += valht[2];
            }
            polygonMode = ch.getPolygonMode();
            ch.glPolygonMode(2);
        } else {
            int major = majorJustify.equals("LEFT") ? 0 : (majorJustify.equals("CENTER") ? 1 : 2);
            int minor = minorJustify.equals("TOP") ? 0 : (minorJustify.equals("CENTER") ? 1 : 3);
            ch.glTextAlign(major, minor);
        }
        if (skip) {
            int max = this.values.length - 1;
            if (this.continuous) {
                cskip[max] = false;
                cskip[0] = false;
                int max2 = max - inc + 1;
                i = 0;
                for (i = 1; i < max2; ++i) {
                    cskip[i] = i % inc > 0;
                }
                while (i < max) {
                    cskip[i] = true;
                    ++i;
                }
            } else {
                for (i = 0; i <= max; ++i) {
                    int value = (int)((double)this.mapper.getMappedValue(this.values[i]) - 0.45);
                    cskip[i] = (value - (int)this.startingOffset) % inc > 0;
                }
            }
        }
        float norm = this.continuous && this.incrementVector.z != 0.0f ? (float)this.mapper.getIntervalCount() / 10.0f : 1.0f;
        for (i = 0; i < this.values.length; ++i) {
            if (skip && cskip[i]) continue;
            float mappedValue = this.mapper.getMappedValue(this.values[i]) * norm;
            Vec3f currentPoint = new Vec3f(startPoint);
            Vec3f increment = new Vec3f(this.incrementVector);
            if (this.continuous) {
                increment.normalize();
            }
            increment.scale(mappedValue);
            currentPoint.add(increment);
            int units = this.continuous ? (int)((double)(mappedValue * (float)this.intervals / axisLen) + 0.55) : (int)((double)mappedValue - 0.45);
            ch.glBegin(1);
            ch.glVertex(currentPoint.x, currentPoint.y, currentPoint.z);
            currentPoint.add(space1);
            ch.glVertex(currentPoint.x, currentPoint.y, currentPoint.z);
            ch.glEnd();
            if (this.viewMode) {
                ch.glBegin(2);
                ch.glVertex(currentPoint.x + xo, currentPoint.y + yo, currentPoint.z + zo);
                ch.glVertex(currentPoint.x + x1, currentPoint.y + y1, currentPoint.z + z1);
                ch.glVertex(currentPoint.x + x2, currentPoint.y + y2, currentPoint.z + z2);
                ch.glVertex(currentPoint.x + x3, currentPoint.y + y3, currentPoint.z + z3);
                ch.glEnd();
                continue;
            }
            if (twoRows) {
                boolean bl = toggle = (units - (int)this.startingOffset) / inc % 2 == 0;
            }
            if (!toggle) {
                currentPoint.add(space2);
            }
            if (this.rotAngle != 0) {
                ch.gl2DText(this.formattedValues[i].trim(), currentPoint.x, currentPoint.y, currentPoint.z, this.rotAngle);
                continue;
            }
            if (!this.continuous) {
                String str = this.formattedValues[i].trim();
                if (str.length() > maxChars) {
                    int index = ExtWireLegend.ClippingIndex(str, maxChars);
                    str = index != 0 ? str.substring(0, index) : str.substring(0, maxChars);
                }
                ch.gl2DText(str, currentPoint.x, currentPoint.y, currentPoint.z);
                continue;
            }
            ch.gl2DText(this.formattedValues[i].trim(), currentPoint.x, currentPoint.y, currentPoint.z);
        }
        if (this.viewMode) {
            ch.glPolygonMode(polygonMode);
        }
    }

    @Override
    protected void addLabel(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify, boolean flipEndDirection) {
        if (this.label != null) {
            float axisLen;
            Vec3f location;
            String labelTrim = this.label.trim();
            boolean labelPlane = false;
            int major = majorJustify.equals("LEFT") ? 0 : (majorJustify.equals("CENTER") ? 1 : 2);
            int minor = minorJustify.equals("TOP") ? 0 : (minorJustify.equals("CENTER") ? 1 : 3);
            int labelDigits = labelTrim.length();
            if (labelDigits > this.labelStyle.getMaxChars()) {
                labelDigits = ExtWireLegend.ClippingIndex(labelTrim, this.labelStyle.getMaxChars());
                labelTrim = labelTrim.substring(0, labelDigits);
            }
            float labelLen = (float)ch.glGetTextWidth(labelTrim);
            if (this.labelPosition == 1) {
                location = new Vec3f(this.origin);
                Vec3f vec = new Vec3f(this.incrementVector);
                vec.scale((float)this.intervals / 2.0f);
                location.add(vec);
                if (this.rotAngleLabel != 0) {
                    Vec3f dir = this.tickDir == 3 ? new Vec3f(this.screenX[0], this.screenX[1], this.screenX[2]) : new Vec3f(-this.screenX[0], -this.screenX[1], -this.screenX[2]);
                    if (this.labelLoc == 0.0f) {
                        dir.scale(this.hlen + this.tickSize);
                        this.hLegendOffset += this.labelHeight;
                    } else {
                        dir.scale(this.labelLoc);
                        this.hLegendOffset = this.labelLoc + this.labelHeight;
                    }
                    location.add(dir);
                } else {
                    Vec3f dir;
                    if (majorJustify.equals("CENTER")) {
                        dir = this.tickDir == 0 ? new Vec3f(-this.screenY[0], -this.screenY[1], -this.screenY[2]) : new Vec3f(this.screenY[0], this.screenY[1], this.screenY[2]);
                        dir.scale(this.vLegendOffset);
                    } else if (majorJustify.equals("LEFT")) {
                        dir = new Vec3f(this.screenX[0], this.screenX[1], this.screenX[2]);
                        if (this.labelLoc > 0.0f) {
                            dir.scale(this.labelLoc + this.tickSize);
                        } else {
                            dir.scale(this.hlen + this.tickSize);
                        }
                    } else {
                        dir = new Vec3f(-this.screenX[0], -this.screenX[1], -this.screenX[2]);
                        if (this.labelLoc > 0.0f) {
                            dir.scale(this.labelLoc + this.tickSize);
                        } else {
                            dir.scale(this.hlen + this.tickSize);
                        }
                    }
                    this.vLegendOffset += this.labelHeight + this.tickSize;
                    location.add(dir);
                }
            } else {
                double[] scr1 = new double[]{this.origin.x, this.origin.y, this.origin.z};
                double[] scr2 = new double[]{this.origin.x + this.midVector.x, this.origin.y + this.midVector.y, this.origin.z + this.midVector.z};
                ch.gluProject(scr1, scr1);
                ch.gluProject(scr2, scr2);
                Vec3f dir = new Vec3f(this.midVector);
                axisLen = dir.length();
                float totalLen = this.hLegendOffset;
                location = new Vec3f(this.origin);
                if (this.labelPosition == 0) {
                    if (this.incrementVector.y != 0.0f && !this.fixLabelPos) {
                        if (scr1[1] > scr2[1]) {
                            if (minor != 3) {
                                location.add(this.midVector);
                                labelPlane = true;
                                totalLen += this.midVector.x;
                            }
                        } else if (minor == 3) {
                            location.add(this.midVector);
                            totalLen += this.midVector.x;
                            labelPlane = true;
                        }
                    }
                    if (labelLen + this.tickSize > this.hLegendOffset) {
                        this.hLegendOffset = labelLen;
                    }
                } else {
                    if (this.incrementVector.y != 0.0f && !this.fixLabelPos) {
                        if (scr1[1] < scr2[1]) {
                            if (minor != 3) {
                                location.add(this.midVector);
                                totalLen += this.midVector.x;
                                labelPlane = true;
                            }
                        } else if (minor == 3) {
                            location.add(this.midVector);
                            totalLen += this.midVector.x;
                            labelPlane = true;
                        }
                    }
                    Vec3f vec = new Vec3f(this.incrementVector);
                    vec.scale(this.intervals);
                    if (this.continuous && this.incrementVector.y < startPoint.y) {
                        vec.add(this.origin);
                    }
                    if (minor == 3) {
                        Vec3f tickVec = new Vec3f(this.screenY[0], this.screenY[1], this.screenY[2]);
                        tickVec.scale(this.valueHeight / 4.0f);
                        vec.add(tickVec);
                    } else if (minor == 0) {
                        Vec3f tickVec = new Vec3f(this.screenY[0], this.screenY[1], this.screenY[2]);
                        tickVec.scale(-this.valueHeight / 2.0f);
                        vec.add(tickVec);
                    }
                    this.vLegendOffset += this.valueHeight / 2.0f + this.labelHeight;
                    location.add(vec);
                }
                if (major == 1) {
                    if (this.tickDir == 2 && labelLen / 2.0f > totalLen) {
                        major = 0;
                    }
                    if (this.tickDir == 3 && labelLen / 2.0f > totalLen) {
                        major = 2;
                    }
                }
            }
            axisLen = Math.abs(this.midVector.x * this.screenX[0] + this.midVector.y * this.screenX[1] + this.midVector.z * this.screenX[2]);
            if (major == 2) {
                if (this.tickDir == 2 || this.tickDir == 4) {
                    location.x -= this.tickSize * this.screenX[0];
                    location.y -= this.tickSize * this.screenX[1];
                    location.z -= this.tickSize * this.screenX[2];
                } else {
                    location.x += (this.hLegendOffset + axisLen * (float)labelPlane) * this.screenX[0];
                    location.y += (this.hLegendOffset + axisLen * (float)labelPlane) * this.screenX[1];
                    location.z += (this.hLegendOffset + axisLen * (float)labelPlane) * this.screenX[2];
                }
            } else if (major == 0) {
                if (this.tickDir == 2 || this.tickDir == 4) {
                    location.x -= (this.hLegendOffset + axisLen * (float)labelPlane) * this.screenX[0];
                    location.y -= (this.hLegendOffset + axisLen * (float)labelPlane) * this.screenX[1];
                    location.z -= (this.hLegendOffset + axisLen * (float)labelPlane) * this.screenX[2];
                } else {
                    location.x += this.tickSize * this.screenX[0];
                    location.y += this.tickSize * this.screenX[1];
                    location.z += this.tickSize * this.screenX[2];
                }
            }
            if ((labelPlane || major == 1) && this.vLabelOffset > 0.0f) {
                location.x += (this.vLabelOffset - this.valueHeight / 4.0f) * this.screenY[0];
                location.y += (this.vLabelOffset - this.valueHeight / 4.0f) * this.screenY[1];
                location.z += (this.vLabelOffset - this.valueHeight / 4.0f) * this.screenY[2];
            }
            ch.glColor(this.labelStyle.getColor());
            ch.glTextAlign(major, minor);
            if (this.rotAngleLabel != 0) {
                ch.gl2DText(labelTrim, location.x, location.y, location.z, this.rotAngleLabel);
            } else {
                ch.gl2DText(labelTrim, location.x, location.y, location.z);
            }
        }
    }

    @Override
    protected void addGeometry(Channel ch) {
        Vec3f startpt = new Vec3f(this.origin);
        Vec3f midpt = new Vec3f(this.origin);
        midpt.add(this.midVector);
        Vec3f endpt = new Vec3f(midpt);
        endpt.add(this.endVector);
        boolean endAdjust = false;
        ch.glColor(this.geomColor);
        Vec3f ev = new Vec3f(this.incrementVector);
        ev.normalize();
        if (!this.continuous) {
            if (this.firstGridLineVisible) {
                ch.glBegin(1);
                if (!this.threeDAxis) {
                    ch.glVertex(startpt.x, startpt.y, startpt.z);
                    ch.glVertex(startpt.x, startpt.y, startpt.z - 1.0f);
                    ch.glVertex(endpt.x, endpt.y, startpt.z - 1.0f);
                } else {
                    ch.glVertex(startpt.x, startpt.y, startpt.z);
                    ch.glVertex(midpt.x, midpt.y, midpt.z);
                    ch.glVertex(endpt.x, endpt.y, endpt.z);
                }
                ch.glEnd();
            }
            ev.scale(0.5f);
            startpt.add(ev);
            endpt.add(ev);
            midpt.add(ev);
            endAdjust = true;
        }
        for (int i = 0; i <= this.intervals; ++i) {
            if (!this.lastGridLineVisible && i == this.intervals) {
                return;
            }
            if (endAdjust && i == this.intervals) {
                ev.scale(-1.0f);
                startpt.add(ev);
                endpt.add(ev);
                midpt.add(ev);
            }
            ch.glBegin(1);
            if (!this.threeDAxis) {
                ch.glVertex(startpt.x, startpt.y, startpt.z);
                ch.glVertex(startpt.x, startpt.y, startpt.z - 1.0f);
                ch.glVertex(endpt.x, endpt.y, endpt.z - 1.0f);
            } else {
                ch.glVertex(startpt.x, startpt.y, startpt.z);
                ch.glVertex(midpt.x, midpt.y, midpt.z);
                ch.glVertex(endpt.x, endpt.y, endpt.z);
            }
            ch.glEnd();
            startpt.add(this.incrementVector);
            endpt.add(this.incrementVector);
            midpt.add(this.incrementVector);
        }
    }

    @Override
    public void addLegend(Channel ch, boolean visible) {
        Vec3f vorg;
        this.vLegendOffset = 0.0f;
        this.hLegendOffset = 0.0f;
        Vec3f ev1 = new Vec3f(this.origin);
        Vec3f ev2 = new Vec3f(this.incrementVector);
        ev2.scale(this.intervals / 2);
        ev1.add(ev2);
        ch.glPushMatrix();
        ch.glTranslate(ev1.x, ev1.y, ev1.z);
        ch.glSelect2DFont(this.labelStyle.createFont());
        this.labelHeight = (float)ch.glGetTextHeight();
        ch.glSelect2DFont(this.valueStyle.createFont());
        this.valueHeight = (float)ch.glGetTextHeight();
        double width = ch.glGetTextWidth("X");
        this.tickSize = this.hideTickMark ? 0.0f : (this.tickDir >= 2 ? (float)width : this.valueHeight / 2.0f);
        double[] screenx = ch.gluGetScreenX();
        this.screenX = new float[3];
        this.screenX[0] = (float)screenx[0];
        this.screenX[1] = (float)screenx[1];
        this.screenX[2] = (float)screenx[2];
        double[] screeny = ch.gluGetScreenY();
        this.screenY = new float[3];
        this.screenY[0] = (float)screeny[0];
        this.screenY[1] = (float)screeny[1];
        this.screenY[2] = (float)screeny[2];
        double[] screenz = ch.gluGetScreenZ();
        this.screenZ = new float[3];
        this.screenZ[0] = (float)screenz[0];
        this.screenZ[1] = (float)screenz[1];
        this.screenZ[2] = (float)screenz[2];
        ch.glPopMatrix();
        if (visible) {
            this.addGeometry(ch);
        }
        if (this.midVector.dot(this.incrementVector) != 0.0f) {
            vorg = new Vec3f(this.origin);
            vorg.add(this.midVector);
        } else {
            vorg = this.origin;
        }
        this.addValues(ch, vorg, this.valueStyle.majorJustify, this.valueStyle.minorJustify);
        ch.glSelect2DFont(this.labelStyle.createFont());
        this.addLabel(ch, this.origin, this.labelStyle.getMajorJustify(), this.labelStyle.getMinorJustify(), true);
    }

    @Override
    protected float findMaxLength(Channel ch, boolean clip) {
        ch.glPushMatrix();
        ch.glTranslate(this.origin.x, this.origin.y, this.origin.z);
        if (!this.continuous) {
            float axisLen = this.intervals;
        } else {
            float axisLen = this.incrementVector.length() * (float)this.intervals;
        }
        Vec3f ev = new Vec3f(this.incrementVector);
        ev.scale((float)this.intervals / 2.0f);
        ch.glTranslate(ev.x, ev.y, ev.z);
        ch.glSelect2DFont(this.valueStyle.createFont());
        float len = this.findMaxValueLength(ch, !this.continuous);
        ch.glPopMatrix();
        return len;
    }

    @Override
    protected float findMaxValueLength(Channel ch, boolean clip) {
        double maxlength = 0.0;
        int maxChars = this.valueStyle.getMaxChars();
        if (!this.valuesVisible) {
            return 0.0f;
        }
        if (this.valueID != -1) {
            maxlength = clip ? ch.glGetTextWidth("  " + this.allFormattedValues[this.valueID].trim().substring(0, Math.min(maxChars, this.allFormattedValues[this.valueID].trim().length()))) : ch.glGetTextWidth(this.allFormattedValues[this.valueID].trim());
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                String temp = this.formattedValues[i].trim();
                double length = clip ? ch.glGetTextWidth(temp.substring(0, Math.min(maxChars, temp.length()))) : ch.glGetTextWidth(temp);
                if (!(length > maxlength)) continue;
                this.valueID = i;
                maxlength = length;
            }
            if (this.values.length != this.allFormattedValues.length) {
                this.valueID = -1;
            }
        }
        return (float)(maxlength += ch.glGetTextWidth("  "));
    }

    @Override
    protected float findMaxValueLength(Channel ch) {
        double maxlength = 0.0;
        int maxChars = this.valueStyle.getMaxChars();
        if (!this.valuesVisible) {
            return 0.0f;
        }
        if (this.valueID != -1) {
            maxlength = ch.glGetTextWidth(this.formattedValues[this.valueID].trim().substring(0, Math.min(maxChars, this.formattedValues[this.valueID].length())));
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                double length = ch.glGetTextWidth(this.formattedValues[i].trim().substring(0, Math.min(maxChars, this.formattedValues[i].length())));
                if (!(length > maxlength)) continue;
                maxlength = length;
                this.valueID = i;
            }
        }
        return (float)(maxlength += ch.glGetTextWidth("  "));
    }
}

