/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.visualize.Mapper;
import java.util.Enumeration;
import java.util.Hashtable;

class DiscreteMapper
extends Mapper {
    protected Hashtable values;
    protected float mappedValue;
    protected float mappedValueIncrement;

    protected DiscreteMapper() {
        this(0.0f, 1.0f);
    }

    protected DiscreteMapper(float mappedValueIn) {
        this(mappedValueIn, 1.0f);
    }

    protected DiscreteMapper(float mappedValueIn, float mappedValueIncrementIn) {
        this.mappedValue = mappedValueIn;
        this.mappedValueIncrement = mappedValueIncrementIn;
        this.values = new Hashtable();
    }

    @Override
    protected void addValue(String value) {
        if (!this.values.containsKey(value)) {
            this.values.put(value, new Float(this.mappedValue));
            this.mappedValue += this.mappedValueIncrement;
        }
    }

    @Override
    protected float getMappedValue(String value) {
        Float f = (Float)this.values.get(value);
        return f.floatValue();
    }

    protected float getMappedValue2(String value) throws Exception {
        Float f = (Float)this.values.get(value);
        if (f == null) {
            throw new Exception("Invalid data");
        }
        return f.floatValue();
    }

    @Override
    protected int getIntervalCount() {
        return this.values.size();
    }

    @Override
    protected String[] getValueLabels() {
        int i = 0;
        String[] labels = new String[this.values.size()];
        Enumeration keys = this.values.keys();
        while (keys.hasMoreElements()) {
            labels[i++] = (String)keys.nextElement();
        }
        return labels;
    }
}

