/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.visualize.ColorMapper;
import com.sas.graphics.util.visualize.DiscreteMapper;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.SortedDiscreteMapper;
import java.awt.Color;
import java.util.Random;
import java.util.Vector;

class DiscreteColorMapper
extends ColorMapper {
    protected Mapper dMapper = new DiscreteMapper(0.0f, 1.0f);
    private Vector mappedColors;
    private boolean colorsMade;
    private int colorScheme;
    private int ncolors;

    protected DiscreteColorMapper() {
        this.colorScheme = 1;
        this.colorsMade = false;
    }

    protected DiscreteColorMapper(Vector amappedColors) {
        this.mappedColors = amappedColors;
        this.ncolors = this.mappedColors.size();
        this.colorScheme = -1;
        this.colorsMade = true;
    }

    protected final void setMappedColors(Vector amappedColors) {
        this.mappedColors = amappedColors;
        this.ncolors = this.mappedColors.size();
        this.colorScheme = -1;
        this.colorsMade = true;
    }

    @Override
    protected void addValue(String value) {
        this.dMapper.addValue(value);
    }

    @Override
    protected void addValue(String value, int type) {
        if (this.dMapper instanceof SortedDiscreteMapper) {
            this.dMapper.addValue(value, type);
        } else {
            this.dMapper.addValue(value);
        }
    }

    @Override
    protected float getMappedValue(String value) {
        return this.dMapper.getMappedValue(value);
    }

    @Override
    protected Color getMappedRGBColor(String value) {
        if (!this.colorsMade) {
            this.makeColors();
        }
        int key = (int)this.dMapper.getMappedValue(value) % this.ncolors;
        return (Color)this.mappedColors.elementAt(key);
    }

    protected Vector getMappedColors() {
        if (!this.colorsMade) {
            this.makeColors();
        }
        return this.mappedColors;
    }

    @Override
    protected String[] getValueLabels() {
        return this.dMapper.getValueLabels();
    }

    protected void setColorScheme(int cs) {
        this.colorScheme = cs;
        this.colorsMade = false;
    }

    protected int getColorScheme() {
        return this.colorScheme;
    }

    @Override
    protected int getIntervalCount() {
        return this.dMapper.getIntervalCount();
    }

    protected static final Vector getMappedColors(int index) {
        Vector<Color> mappedColors = new Vector<Color>();
        switch (index) {
            default: {
                mappedColors.addElement(new Color(0.0f, 0.0f, 0.7f));
                mappedColors.addElement(new Color(0.98f, 0.98f, 0.0f));
                mappedColors.addElement(new Color(0.98f, 0.0f, 0.0f));
                mappedColors.addElement(new Color(0.302f, 0.992f, 0.267f));
                mappedColors.addElement(new Color(0.663f, 0.2f, 0.761f));
                mappedColors.addElement(new Color(0.953f, 0.782f, 0.782f));
                mappedColors.addElement(new Color(0.98f, 0.002f, 0.5f));
                mappedColors.addElement(new Color(0.992f, 0.71f, 0.263f));
                mappedColors.addElement(new Color(0.094f, 0.459f, 0.212f));
                mappedColors.addElement(new Color(0.977f, 1.0f, 0.722f));
                mappedColors.addElement(new Color(0.463f, 0.0f, 0.463f));
                mappedColors.addElement(new Color(0.678f, 0.712f, 0.998f));
                mappedColors.addElement(new Color(0.998f, 0.533f, 0.333f));
                mappedColors.addElement(new Color(0.004f, 0.659f, 0.061f));
                mappedColors.addElement(new Color(0.934f, 0.587f, 0.992f));
                mappedColors.addElement(new Color(0.49f, 0.0f, 0.25f));
                mappedColors.addElement(new Color(0.659f, 0.996f, 0.659f));
                mappedColors.addElement(new Color(0.014f, 0.014f, 0.431f));
                mappedColors.addElement(new Color(0.843f, 0.377f, 0.031f));
                mappedColors.addElement(new Color(0.263f, 0.863f, 0.988f));
                mappedColors.addElement(new Color(0.992f, 0.71f, 0.263f));
                mappedColors.addElement(new Color(0.992f, 0.882f, 0.882f));
                mappedColors.addElement(new Color(0.996f, 0.847f, 0.004f));
                mappedColors.addElement(new Color(0.961f, 0.851f, 0.722f));
                break;
            }
            case 6: {
                mappedColors.addElement(new Color(-15493510));
                mappedColors.addElement(new Color(-12487248));
                mappedColors.addElement(new Color(-6997));
                mappedColors.addElement(new Color(-35984));
                mappedColors.addElement(new Color(-14661770));
                mappedColors.addElement(new Color(-2254037));
                mappedColors.addElement(new Color(-1683893));
                mappedColors.addElement(new Color(-5921371));
                mappedColors.addElement(new Color(-9090267));
                mappedColors.addElement(new Color(-2737604));
                mappedColors.addElement(new Color(-9925418));
                mappedColors.addElement(new Color(-1052689));
                mappedColors.addElement(new Color(-12303292));
                mappedColors.addElement(new Color(-4641748));
                mappedColors.addElement(new Color(-16744448));
                mappedColors.addElement(new Color(-139949));
                break;
            }
            case 0: {
                mappedColors.addElement(new Color(-32125));
                mappedColors.addElement(new Color(-16728657));
                mappedColors.addElement(new Color(-5404319));
                mappedColors.addElement(new Color(-3341463));
                mappedColors.addElement(new Color(-16739437));
                mappedColors.addElement(new Color(-1052689));
                mappedColors.addElement(new Color(-10783091));
                mappedColors.addElement(new Color(-16711681));
                mappedColors.addElement(new Color(-1281125));
                mappedColors.addElement(new Color(-13412992));
                mappedColors.addElement(new Color(-19387));
                mappedColors.addElement(new Color(-6908266));
                mappedColors.addElement(new Color(-16744320));
                mappedColors.addElement(new Color(-19276));
                mappedColors.addElement(new Color(-13733041));
                mappedColors.addElement(new Color(-23808));
                break;
            }
            case 8: {
                mappedColors.addElement(new Color(-65536));
                mappedColors.addElement(new Color(-11447809));
                mappedColors.addElement(new Color(-4882616));
                mappedColors.addElement(new Color(-10236061));
                mappedColors.addElement(new Color(-16776961));
                mappedColors.addElement(new Color(-6908266));
                mappedColors.addElement(new Color(-6422627));
                mappedColors.addElement(new Color(-33411));
                mappedColors.addElement(new Color(-8816129));
                mappedColors.addElement(new Color(-16777216));
                mappedColors.addElement(new Color(-256));
                mappedColors.addElement(new Color(-3407925));
                mappedColors.addElement(new Color(-2228224));
                mappedColors.addElement(new Color(-5460737));
                mappedColors.addElement(new Color(-16749056));
                mappedColors.addElement(new Color(-19276));
                break;
            }
            case 2: {
                mappedColors.addElement(new Color(-3195648));
                mappedColors.addElement(new Color(-8355840));
                mappedColors.addElement(new Color(-4408693));
                mappedColors.addElement(new Color(-13876447));
                mappedColors.addElement(new Color(-7424));
                mappedColors.addElement(new Color(-11488172));
                mappedColors.addElement(new Color(-5888977));
                mappedColors.addElement(new Color(-9862244));
                mappedColors.addElement(new Color(-16752896));
                mappedColors.addElement(new Color(-4098816));
                mappedColors.addElement(new Color(-11508090));
                mappedColors.addElement(new Color(-2105129));
                mappedColors.addElement(new Color(-10000793));
                mappedColors.addElement(new Color(-3418648));
                mappedColors.addElement(new Color(-3727305));
                mappedColors.addElement(new Color(-12544));
                break;
            }
            case 5: {
                mappedColors.addElement(new Color(-2434342));
                mappedColors.addElement(new Color(-12347447));
                mappedColors.addElement(new Color(-2899594));
                mappedColors.addElement(new Color(-14530427));
                mappedColors.addElement(new Color(-8355840));
                mappedColors.addElement(new Color(-5871309));
                mappedColors.addElement(new Color(-8073851));
                mappedColors.addElement(new Color(-7846645));
                mappedColors.addElement(new Color(-14188123));
                mappedColors.addElement(new Color(-1266496));
                mappedColors.addElement(new Color(-13934495));
                mappedColors.addElement(new Color(-798578));
                mappedColors.addElement(new Color(-4174729));
                mappedColors.addElement(new Color(-11365888));
                mappedColors.addElement(new Color(-12500671));
                mappedColors.addElement(new Color(-12544));
                break;
            }
            case 10: {
                mappedColors.addElement(new Color(-13210516));
                mappedColors.addElement(new Color(-2723981));
                mappedColors.addElement(new Color(-7594674));
                mappedColors.addElement(new Color(-5061232));
                mappedColors.addElement(new Color(-2730410));
                mappedColors.addElement(new Color(-8497617));
                mappedColors.addElement(new Color(-7558281));
                mappedColors.addElement(new Color(-14392991));
                mappedColors.addElement(new Color(-2713963));
                mappedColors.addElement(new Color(-2179440));
                mappedColors.addElement(new Color(-7380682));
                mappedColors.addElement(new Color(-6832778));
                mappedColors.addElement(new Color(-9921637));
                mappedColors.addElement(new Color(-1986641));
                mappedColors.addElement(new Color(-13480429));
                mappedColors.addElement(new Color(-8214103));
                break;
            }
            case 11: {
                mappedColors.addElement(new Color(-5896065));
                mappedColors.addElement(new Color(-10494077));
                mappedColors.addElement(new Color(-861543));
                mappedColors.addElement(new Color(-12231015));
                mappedColors.addElement(new Color(-256));
                mappedColors.addElement(new Color(-13313));
                mappedColors.addElement(new Color(-12030936));
                mappedColors.addElement(new Color(-1056769));
                mappedColors.addElement(new Color(-1245125));
                mappedColors.addElement(new Color(-5779457));
                mappedColors.addElement(new Color(-2859008));
                mappedColors.addElement(new Color(-49));
                mappedColors.addElement(new Color(-38504));
                mappedColors.addElement(new Color(-14408193));
                mappedColors.addElement(new Color(-5378636));
                mappedColors.addElement(new Color(-2059777));
                break;
            }
            case 1: {
                mappedColors.addElement(new Color(-14201675));
                mappedColors.addElement(new Color(-601600));
                mappedColors.addElement(new Color(-3727305));
                mappedColors.addElement(new Color(-13857247));
                mappedColors.addElement(new Color(-3446));
                mappedColors.addElement(new Color(-10323027));
                mappedColors.addElement(new Color(-1281125));
                mappedColors.addElement(new Color(-7680622));
                mappedColors.addElement(new Color(-3515267));
                mappedColors.addElement(new Color(-344765));
                mappedColors.addElement(new Color(-10830514));
                mappedColors.addElement(new Color(-4723457));
                mappedColors.addElement(new Color(-16453528));
                mappedColors.addElement(new Color(-6504476));
                mappedColors.addElement(new Color(-36096));
                mappedColors.addElement(new Color(-19754));
                break;
            }
            case 3: {
                mappedColors.addElement(new Color(-15778157));
                mappedColors.addElement(new Color(-256));
                mappedColors.addElement(new Color(-1214801));
                mappedColors.addElement(new Color(-2996356));
                mappedColors.addElement(new Color(-15313369));
                mappedColors.addElement(new Color(-7552));
                mappedColors.addElement(new Color(-6866431));
                mappedColors.addElement(new Color(-12738448));
                mappedColors.addElement(new Color(-7402828));
                mappedColors.addElement(new Color(-10418896));
                mappedColors.addElement(new Color(-277144));
                mappedColors.addElement(new Color(-3092272));
                mappedColors.addElement(new Color(-16294297));
                mappedColors.addElement(new Color(-2252466));
                mappedColors.addElement(new Color(-4842407));
                mappedColors.addElement(new Color(-11565691));
                mappedColors.addElement(new Color(-16760752));
                mappedColors.addElement(new Color(-8278635));
                mappedColors.addElement(new Color(-3747919));
                mappedColors.addElement(new Color(-2576460));
                break;
            }
            case 4: {
                mappedColors.addElement(Color.blue);
                mappedColors.addElement(Color.yellow);
                mappedColors.addElement(Color.red);
                mappedColors.addElement(Color.gray);
                mappedColors.addElement(Color.magenta);
                mappedColors.addElement(Color.green);
                mappedColors.addElement(Color.lightGray);
                mappedColors.addElement(Color.cyan);
                mappedColors.addElement(Color.orange);
                mappedColors.addElement(Color.darkGray);
                mappedColors.addElement(Color.pink);
            }
            case -1: 
            case 9: 
        }
        return mappedColors;
    }

    private void makeColors() {
        this.colorsMade = true;
        switch (this.colorScheme) {
            default: {
                this.mappedColors = DiscreteColorMapper.getMappedColors(this.colorScheme);
                this.ncolors = 24;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                this.mappedColors = DiscreteColorMapper.getMappedColors(this.colorScheme);
                this.ncolors = 16;
                break;
            }
            case 3: {
                this.mappedColors = DiscreteColorMapper.getMappedColors(this.colorScheme);
                this.ncolors = 20;
                break;
            }
            case 4: {
                this.mappedColors = DiscreteColorMapper.getMappedColors(this.colorScheme);
                this.ncolors = 10;
                break;
            }
            case -1: {
                break;
            }
            case 9: {
                int len = this.dMapper.getIntervalCount();
                this.mappedColors = new Vector();
                this.ncolors = len;
                int red = 0;
                int green = 0;
                int blue = 0;
                Random random = new Random();
                for (int i = 0; i < len; ++i) {
                    red = Math.abs(random.nextInt()) % 256;
                    green = Math.abs(random.nextInt()) % 256;
                    blue = Math.abs(random.nextInt()) % 256;
                    this.mappedColors.addElement(new Color(red, green, blue));
                }
            }
        }
    }
}

