/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ColorLegend;
import com.sas.graphics.util.visualize.ColorMapper;
import com.sas.graphics.util.visualize.DiscreteColorMapper;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.Shapes;
import com.sas.graphics.util.visualize.Vec3f;
import java.awt.Rectangle;

class DiscreteColorLegend
extends ColorLegend {
    protected int numRows = 1;
    protected int maxNumColumns = 1;
    protected int maxNumRows = 1;
    protected int numLabelChars;
    protected int start;
    protected int end;
    protected int numColumns;
    protected float thumb = 0.0f;
    protected double labelLength;
    protected Vec3f stepVector;
    protected boolean floor = false;
    protected boolean defaultSize = true;
    protected double spacingFactor = 1.0;
    protected double boxwidth;
    static final float FLOAT2INT_D = 1.0E-4f;

    public DiscreteColorLegend(DiscreteColorMapper aMapper) {
        super(aMapper);
    }

    public Rectangle getBoundingBox(Channel ch, boolean visible) {
        if (!visible) {
            return null;
        }
        double[] upperLeft = new double[3];
        double[] lowerRight = new double[3];
        upperLeft[2] = this.legendPosition.z;
        lowerRight[2] = this.legendPosition.z;
        switch (this.relativePosition) {
            default: {
                upperLeft[0] = this.legendPosition.x - (this.legendBodySize.x - this.hLegendOffset) / 2.0f;
                upperLeft[1] = this.legendPosition.y - this.labelHeight;
                break;
            }
            case 0: {
                upperLeft[0] = this.legendPosition.x;
                upperLeft[1] = this.legendPosition.y + (this.legendBodySize.y - this.vLegendOffset) / 2.0f - this.labelHeight;
            }
        }
        lowerRight[0] = upperLeft[0] + (double)this.legendBodySize.x;
        lowerRight[1] = upperLeft[1] - (double)this.legendBodySize.y + (double)this.labelHeight;
        upperLeft[2] = this.legendPosition.z;
        lowerRight[2] = this.legendPosition.z;
        if (this.floor) {
            ch.glRotate(-90.0, 1.0, 0.0, 0.0);
        }
        ch.gluProject(upperLeft, upperLeft);
        ch.gluProject(lowerRight, lowerRight);
        if (this.floor) {
            ch.glRotate(90.0, 1.0, 0.0, 0.0);
        }
        int xo = (int)upperLeft[0] + 2;
        int yo = (int)upperLeft[1] + 2;
        int dx = (int)lowerRight[0] - (int)upperLeft[0] - 2;
        int dy = (int)lowerRight[1] - (int)upperLeft[1] - 2;
        Rectangle box = new Rectangle(xo, yo, dx, dy);
        return box;
    }

    public void moveThumb(Channel ch, float dx, float dy) {
        Vec3f point = new Vec3f(this.origin);
        point.add(this.endVector);
        float incr = (float)this.maxNumRows * dy / (float)(this.numRows - this.maxNumRows);
        this.thumb -= incr;
        this.thumb = Math.min(1.0f, Math.max(0.0f, this.thumb));
        float act_start = this.thumb * (float)(this.numRows - this.maxNumRows);
        this.start = (int)Math.floor(act_start);
        ch.glPushMatrix();
        this.setOrientation(ch);
        ch.glPushMatrix();
        ch.glTranslate(0.0, -((float)this.start - act_start) * this.stepVector.y, 0.0);
        this.start *= this.maxNumColumns;
        this.end = Math.min(this.values.length, this.start + (this.maxNumRows + 1) * this.maxNumColumns);
        this.addValues(ch, point, this.valueStyle.majorJustify, this.valueStyle.minorJustify);
        this.addGeometry(ch);
        ch.glPopMatrix();
        this.addLabel(ch, point, this.labelStyle.majorJustify, this.labelStyle.minorJustify, false);
        this.drawBBox(ch);
        ch.glPopMatrix();
    }

    @Override
    protected void orientLegend(Channel ch) {
        if (this.floor) {
            ch.glRotate(-90.0, 1.0, 0.0, 0.0);
            ch.glSelect2DFont(this.labelStyle.createFont());
            this.labelHeight = (float)ch.glGetTextHeight();
            ch.glSelect2DFont(this.valueStyle.createFont());
            this.valueHeight = (float)ch.glGetTextHeight();
        }
        this.labelLength = (float)ch.glGetTextWidth("W");
        this.hLegendOffset = this.legendBodySize.x;
        this.vLegendOffset = this.legendBodySize.y;
        Vec3f vec = new Vec3f(this.legendPosition);
        this.incrementVector = new Vec3f(Vec3f.xAxis);
        this.stepVector = new Vec3f(Vec3f.yAxis);
        float len = this.findMaxValueLength(ch, true);
        this.boxwidth = 1.33 * ch.glGetTextWidth("W");
        len = (float)((double)len + 2.1 * this.boxwidth);
        ch.glSelect2DFont(this.labelStyle.createFont());
        String str = null;
        if (this.label != null) {
            str = this.label.trim();
            this.numLabelChars = Math.min(str.length(), this.labelStyle.maxChars);
            this.labelLength += this.spacingFactor * ch.glGetTextWidth(str.substring(0, this.numLabelChars));
        } else {
            this.labelLength = 0.0;
            this.numLabelChars = 0;
        }
        boolean maxsize = this.hLegendOffset >= len * (float)this.intervals;
        float tsize = this.hLegendOffset > len ? Math.min(this.hLegendOffset, len * (float)this.intervals) : len;
        if (this.defaultSize) {
            this.legendBodySize.x = (float)Math.max(this.labelLength + this.boxwidth, (double)tsize);
        } else if (str != null) {
            float tempSize = this.hLegendOffset;
            ch.glSelect2DFont(this.labelStyle.createFont());
            this.labelLength = ch.glGetTextWidth("W");
            float size = (float)((double)tempSize - this.boxwidth - this.labelLength);
            int i = str.length();
            while (ch.glGetTextWidth(str.substring(0, i)) * this.spacingFactor > (double)size && (i = DiscreteColorLegend.ClippingIndex(str, i - 1)) != 0) {
            }
            if (i == 0) {
                for (i = str.length(); i >= 0 && !(ch.glGetTextWidth(str.substring(0, i)) * this.spacingFactor < (double)size); --i) {
                }
            }
            this.numLabelChars = i;
            this.labelLength += this.spacingFactor * ch.glGetTextWidth(str.substring(0, this.numLabelChars));
        }
        this.hLegendOffset = Math.max(this.hLegendOffset, this.legendBodySize.x);
        this.stepVector.scale(1.5f * this.valueHeight);
        switch (this.relativePosition) {
            default: {
                if (maxsize) {
                    this.maxNumColumns = this.intervals;
                    this.numRows = 1;
                    this.maxNumRows = 1;
                } else {
                    this.maxNumColumns = Math.max(1, (int)(this.legendBodySize.x / len + 1.0E-4f));
                    this.maxNumColumns = Math.min(this.maxNumColumns, this.intervals);
                    this.maxNumRows = (int)Math.floor(((double)this.legendBodySize.y - 1.2 * (double)this.labelHeight) / (double)this.stepVector.y + 0.2);
                    this.numRows = (int)Math.ceil((double)this.intervals / (double)this.maxNumColumns);
                    this.maxNumRows = Math.max(this.maxNumRows, 1);
                    if (this.maxNumRows > this.numRows) {
                        this.maxNumRows = this.numRows;
                    }
                    while (this.numRows * (this.maxNumColumns - 1) >= this.intervals) {
                        --this.maxNumColumns;
                    }
                }
                this.incrementVector.scale(this.legendBodySize.x / (float)this.maxNumColumns);
                if (this.defaultSize) {
                    this.legendBodySize.x = (float)Math.max(this.labelLength + this.boxwidth, (double)((float)this.maxNumColumns * this.incrementVector.x));
                }
                this.legendBodySize.y = (float)((double)((float)this.maxNumRows * this.stepVector.y) + 1.2 * (double)this.labelHeight);
                ch.glTranslate((double)vec.x + this.boxwidth / 2.0 - (double)((this.legendBodySize.x - this.hLegendOffset) / 2.0f), (double)vec.y - 1.2 * (double)this.labelHeight - 1.2 * (double)this.valueHeight, vec.z);
                break;
            }
            case 0: {
                this.maxNumRows = (int)Math.floor(((double)this.legendBodySize.y - 1.2 * (double)this.labelHeight) / (double)this.stepVector.y + 0.2);
                this.maxNumColumns = 1;
                this.numRows = (int)Math.ceil((double)this.intervals / (double)this.maxNumColumns);
                if (this.maxNumRows > this.numRows) {
                    this.maxNumRows = this.numRows;
                }
                this.incrementVector.scale(this.legendBodySize.x / (float)this.maxNumColumns);
                if (this.defaultSize) {
                    this.legendBodySize.x = (float)this.maxNumColumns * this.incrementVector.x;
                    this.legendBodySize.y = (float)((double)((float)this.maxNumRows * this.stepVector.y) + 1.2 * (double)this.labelHeight);
                }
                ch.glTranslate((double)vec.x + this.boxwidth / 2.0, (double)vec.y - 1.2 * (double)this.labelHeight - 1.2 * (double)this.valueHeight + (double)((this.legendBodySize.y - this.vLegendOffset) / 2.0f), vec.z);
            }
        }
        this.start = 0;
        this.end = Math.min(this.values.length, this.maxNumColumns * this.maxNumRows);
        this.thumb = 0.0f;
    }

    protected int calculateHeight(Channel ch) {
        ch.glSelect2DFont(this.labelStyle.createFont());
        this.labelHeight = (float)ch.glGetTextHeight();
        this.labelLength = (float)ch.glGetTextWidth("W");
        ch.glSelect2DFont(this.valueStyle.createFont());
        this.valueHeight = (float)ch.glGetTextHeight();
        this.hLegendOffset = this.legendBodySize.x;
        this.vLegendOffset = this.legendBodySize.y;
        this.incrementVector = new Vec3f(Vec3f.xAxis);
        this.stepVector = new Vec3f(Vec3f.yAxis);
        float len = this.findMaxValueLength(ch, true);
        this.boxwidth = 1.33 * ch.glGetTextWidth("W");
        len = (float)((double)len + 2.1 * this.boxwidth);
        ch.glSelect2DFont(this.labelStyle.createFont());
        String str = null;
        if (this.label != null) {
            str = this.label.trim();
            this.numLabelChars = Math.min(str.length(), this.labelStyle.maxChars);
            this.labelLength += this.spacingFactor * ch.glGetTextWidth(str.substring(0, this.numLabelChars));
        } else {
            this.labelLength = 0.0;
            this.numLabelChars = 0;
        }
        boolean maxsize = this.hLegendOffset >= len * (float)this.intervals;
        float tsize = this.hLegendOffset > len ? Math.min(this.hLegendOffset, len * (float)this.intervals) : len;
        if (this.defaultSize) {
            this.legendBodySize.x = (float)Math.max(this.labelLength + this.boxwidth, (double)tsize);
        } else if (str != null) {
            float tempSize = this.hLegendOffset;
            ch.glSelect2DFont(this.labelStyle.createFont());
            this.labelLength = ch.glGetTextWidth("  ");
            float size = (float)((double)tempSize - this.boxwidth - this.labelLength);
            int i = str.length();
            while (ch.glGetTextWidth(str.substring(0, i)) * this.spacingFactor > (double)size && (i = DiscreteColorLegend.ClippingIndex(str, i - 1)) != 0) {
            }
            if (i == 0) {
                for (i = str.length(); i >= 0 && !(ch.glGetTextWidth(str.substring(0, i)) * this.spacingFactor < (double)size); --i) {
                }
            }
            this.numLabelChars = i;
            this.labelLength += this.spacingFactor * ch.glGetTextWidth(str.substring(0, this.numLabelChars));
        }
        this.hLegendOffset = Math.max(this.hLegendOffset, this.legendBodySize.x);
        this.stepVector.scale(1.5f * this.valueHeight);
        switch (this.relativePosition) {
            default: 
        }
        if (maxsize) {
            this.maxNumColumns = this.intervals;
            this.numRows = 1;
            this.maxNumRows = 1;
        } else {
            this.maxNumColumns = Math.max(1, (int)(this.legendBodySize.x / len + 1.0E-4f));
            this.maxNumColumns = Math.min(this.maxNumColumns, this.intervals);
            this.maxNumRows = (int)Math.floor(((double)this.legendBodySize.y - 1.2 * (double)this.labelHeight) / (double)this.stepVector.y + 0.2);
            this.numRows = (int)Math.ceil((double)this.intervals / (double)this.maxNumColumns);
            this.maxNumRows = Math.max(this.maxNumRows, 1);
            if (this.maxNumRows > this.numRows) {
                this.maxNumRows = this.numRows;
            }
            while (this.numRows * (this.maxNumColumns - 1) >= this.intervals) {
                --this.maxNumColumns;
            }
        }
        this.incrementVector.scale(this.legendBodySize.x / (float)this.maxNumColumns);
        if (this.defaultSize) {
            this.legendBodySize.x = (float)Math.max(this.labelLength + this.boxwidth, (double)((float)this.maxNumColumns * this.incrementVector.x));
        }
        this.legendBodySize.y = (float)((double)((float)this.maxNumRows * this.stepVector.y) + 1.2 * (double)this.labelHeight);
        return (int)this.legendBodySize.y;
    }

    @Override
    protected void addValues(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify) {
        ch.glColor(this.valueStyle.color);
        ch.glSelect2DFont(this.valueStyle.createFont());
        double valueLen = (double)this.incrementVector.x - 2.0 * this.boxwidth;
        ch.glTextAlign(0, 1);
        this.valueHotspots = this.isValueHotspotsEnabled() ? new Blob[this.values.length] : null;
        for (int i = 0; i < this.values.length; ++i) {
            float mappedValue = this.mapper.getMappedValue(this.values[i]);
            if (mappedValue < (float)this.start || mappedValue >= (float)this.end) continue;
            Vec3f increment = new Vec3f(this.incrementVector);
            Vec3f current = new Vec3f(increment);
            Vec3f step = new Vec3f(this.stepVector.x, -this.stepVector.y, this.stepVector.z);
            current.scale((int)(mappedValue - (float)this.start) % this.maxNumColumns);
            step.scale((int)(mappedValue - (float)this.start) / this.maxNumColumns);
            current.add(step);
            String str = this.formattedValues[i].trim();
            int maxChars = str.length() - 1;
            while (ch.glGetTextWidth(str) > valueLen && (maxChars = DiscreteColorLegend.ClippingIndex(str, maxChars)) != 0) {
                str = str.substring(0, maxChars);
                --maxChars;
            }
            if (maxChars == 0) {
                maxChars = str.length();
                while (ch.glGetTextWidth(str) > valueLen && maxChars >= 2) {
                    str = str.substring(0, --maxChars);
                }
            }
            if (this.valueHotspots != null) {
                Bbox bbox = new Bbox();
                ch.glGetText2DBbox(str, (double)current.x + 1.4 * this.boxwidth, current.y + this.valueHeight / 2.0f, current.z, 0, bbox);
                this.valueHotspots[i] = Blob.newBlob(ch, new String[]{this.primaryValues != null ? this.primaryValues[i].trim() : this.values[i].trim()}, new String[]{this.formattedValues[i].trim()}, new int[]{this.valueHotspotID}, bbox);
            }
            ch.gl2DText(str, (double)current.x + 1.4 * this.boxwidth, current.y + this.valueHeight / 2.0f, current.z);
        }
    }

    @Override
    protected void addLabel(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify, boolean flipEndDirection) {
    }

    protected void addLabelsBox(Channel ch) {
        ch.glPushMatrix();
        this.setOrientation(ch);
        this.addLabel(ch);
        this.drawBBox(ch);
        ch.glPopMatrix();
    }

    protected void addLabel(Channel ch) {
        if (this.label != null) {
            double yo = 1.2 * (double)this.valueHeight + 0.7 * (double)this.labelHeight;
            ch.glColor(this.labelStyle.color);
            ch.glSelect2DFont(this.labelStyle.createFont());
            ch.glTextAlign(1, 1);
            ch.gl2DText(this.label.trim().substring(0, this.numLabelChars), this.labelLength / 2.0, yo, 0.0);
            this.labelHotspots = null;
            if (this.isLabelValueHotspotsEnabled() || this.isLabelHotspotsEnabled()) {
                this.labelHotspots = new Blob[1];
                Bbox bbox = new Bbox();
                ch.glGetText2DBbox(this.label.trim().substring(0, this.numLabelChars), this.labelLength / 2.0, yo, 0.0, 0, bbox);
                this.labelHotspots[0] = Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim()}, new String[]{this.label.trim()}, new int[]{this.getLabelHotspotID()}, bbox);
            }
        }
    }

    @Override
    protected void addGeometry(Channel ch) {
        int polygonMode = ch.getPolygonMode();
        ch.glPolygonMode(4);
        ch.glEdgeColor(this.geomColor);
        if (!this.floor) {
            ch.glNormal(0.0, 0.0, 1.0);
        }
        DiscreteColorMapper cMapper = (DiscreteColorMapper)this.mapper;
        for (int i = 0; i < this.values.length; ++i) {
            float mappedValue = ((Mapper)cMapper).getMappedValue(this.values[i]);
            if (mappedValue < (float)this.start || mappedValue >= (float)this.end) continue;
            Vec3f current = new Vec3f(this.incrementVector);
            Vec3f step = new Vec3f(this.stepVector.x, -this.stepVector.y, this.stepVector.z);
            current.scale((int)(mappedValue - (float)this.start) % this.maxNumColumns);
            step.scale((int)(mappedValue - (float)this.start) / this.maxNumColumns);
            current.add(step);
            ch.glColor(((ColorMapper)cMapper).getMappedRGBColor(this.values[i]));
            Shapes.addRectangle(ch, (double)current.x + this.boxwidth / 2.0, current.y + this.valueHeight / 2.0f, current.z, this.boxwidth, this.valueHeight);
        }
        ch.glPolygonMode(polygonMode);
    }

    @Override
    protected void drawBBox(Channel ch) {
        double y1;
        double yo;
        double xo = -this.boxwidth / 2.0;
        double x1 = (double)this.legendBodySize.x + xo;
        if (this.label != null) {
            yo = (double)this.labelHeight * 0.7 + 1.2 * (double)this.valueHeight;
            y1 = yo - (double)this.legendBodySize.y + (double)(this.labelHeight / 2.0f);
        } else {
            yo = (double)this.labelHeight * 0.2 + 1.2 * (double)this.valueHeight;
            y1 = yo - (double)this.legendBodySize.y + 0.9 * (double)this.labelHeight;
        }
        ch.glColor(this.geomColor);
        ch.glBegin(1);
        ch.glVertex(0.0, yo, 0.0);
        ch.glVertex(xo, yo, 0.0);
        ch.glVertex(xo, y1, 0.0);
        ch.glVertex(x1, y1, 0.0);
        ch.glVertex(x1, yo, 0.0);
        if (x1 > this.labelLength) {
            ch.glVertex(this.labelLength, yo, 0.0);
        }
        ch.glEnd();
        if (!this.isScrollable()) {
            return;
        }
        double y2 = (yo + y1) / 2.0 - (double)this.valueHeight / 10.0;
        double w = 0.4 * this.boxwidth;
        double h = 0.5 * (double)this.valueHeight;
        double hGap = w / 2.0;
        double vGap = (double)this.valueHeight / 10.0;
        int pMode = ch.getPolygonMode();
        if ((double)this.thumb == 0.0) {
            ch.glPolygonMode(2);
        } else {
            ch.glPolygonMode(3);
        }
        ch.glColor(this.geomColor);
        ch.glBegin(2);
        ch.glVertex(x1 - w - hGap, y2 + vGap, 0.0);
        ch.glVertex(x1 - hGap, y2 + vGap, 0.0);
        ch.glVertex(x1 - w / 2.0 - hGap, y2 + h + vGap, 0.0);
        ch.glEnd();
        if ((double)this.thumb == 1.0) {
            ch.glPolygonMode(2);
        } else {
            ch.glPolygonMode(3);
        }
        ch.glColor(this.geomColor);
        ch.glBegin(2);
        ch.glVertex(x1 - hGap, y2 - vGap, 0.0);
        ch.glVertex(x1 - w - hGap, y2 - vGap, 0.0);
        ch.glVertex(x1 - w / 2.0 - hGap, y2 - h - vGap, 0.0);
        ch.glEnd();
        ch.glPolygonMode(pMode);
    }

    private void setOrientation(Channel ch) {
        if (this.floor) {
            ch.glRotate(-90.0, 1.0, 0.0, 0.0);
        }
        switch (this.relativePosition) {
            default: {
                ch.glTranslate((double)this.legendPosition.x + this.boxwidth / 2.0 - (double)((this.legendBodySize.x - this.hLegendOffset) / 2.0f), (double)this.legendPosition.y - 1.2 * (double)this.labelHeight - 1.2 * (double)this.valueHeight, this.legendPosition.z);
                break;
            }
            case 0: {
                ch.glTranslate((double)this.legendPosition.x + this.boxwidth / 2.0, (double)this.legendPosition.y - 1.2 * (double)this.labelHeight - 1.2 * (double)this.valueHeight + (double)((this.legendBodySize.y - this.vLegendOffset) / 2.0f), this.legendPosition.z);
            }
        }
    }

    public boolean isScrollable() {
        return this.numRows > this.maxNumRows;
    }

    public float getHeight() {
        return this.legendBodySize.y;
    }
}

