/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.MissingValues;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import com.sas.mdtable.MdTo2dTable;
import com.sas.table.FormatInterface;
import com.sas.table.StaticColumnInfoInterface;
import com.sas.table.StaticColumnLabelInterface;
import com.sas.table.StaticRowTemplateTableInterface;
import com.sas.table.StaticTableInterface;
import com.sas.table.TableException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class DataModel
implements Serializable {
    static final long serialVersionUID = 7426364612704410397L;
    public static final String MISSING_VALUE = "0";
    private static final String UNSUPPORTED_DATA_TYPE = "DataModel(TRAP):Unsupported Data Type";
    int maxObservations;
    private transient StaticRowTemplateTableInterface rectangularData;
    private transient int currentRow;
    private transient boolean[] varReference;
    protected transient int unknownRowCount;
    private transient NumberFormat nf;
    private transient NumberFormat pf;
    static final int NUMERIC = 1;
    static final int STRING = 2;
    static final int ANY = 3;

    private NumberFormat _getNumberFormat() {
        if (this.nf == null) {
            this.nf = NumberFormat.getNumberInstance(Locale.getDefault());
            this.nf.setMaximumFractionDigits(32);
            this.nf.setGroupingUsed(false);
        }
        return this.nf;
    }

    private NumberFormat _getPercentFormat() {
        if (this.pf == null) {
            this.pf = NumberFormat.getPercentInstance(Locale.getDefault());
        }
        return this.pf;
    }

    protected DataModel() {
        this(null);
    }

    protected DataModel(StaticTableInterface rectangularDataIn) {
        this.rectangularData = (StaticRowTemplateTableInterface)rectangularDataIn;
        this.currentRow = 0;
        this.maxObservations = Integer.MAX_VALUE;
        this.unknownRowCount = 0;
    }

    public int getMaxObservations() {
        return this.maxObservations;
    }

    public void setMaxObservations(int aInt) {
        this.maxObservations = aInt;
    }

    void setRectangularData(StaticTableInterface rectangularDataIn) {
        this.rectangularData = (StaticRowTemplateTableInterface)rectangularDataIn;
        this.resetReferences();
        this.currentRow = 0;
    }

    StaticTableInterface getRectangularData() {
        return this.rectangularData;
    }

    boolean isDerivedFromMDDB() {
        return this.rectangularData instanceof MdTo2dTable;
    }

    int getColumnCount() {
        try {
            if (this.rectangularData == null) {
                return 0;
            }
            return this.rectangularData.getColumnCount();
        }
        catch (TableException e) {
            return 0;
        }
    }

    int getUnknownRowCount() {
        int rows = 0;
        try {
            rows = this.rectangularData.countRows(0);
        }
        catch (TableException e) {
            return 0;
        }
        return rows;
    }

    int getRowCount() {
        try {
            if (this.rectangularData == null) {
                return 0;
            }
            int rows = this.rectangularData.getRowCount();
            if (rows > 0) {
                return Math.min(rows, this.maxObservations);
            }
            if (this.unknownRowCount == 0) {
                this.unknownRowCount = this.getUnknownRowCount();
            }
            return this.unknownRowCount;
        }
        catch (TableException e) {
            return 0;
        }
    }

    void resetReferences() {
        this.varReference = new boolean[this.getColumnCount()];
    }

    protected boolean isContinuous(Variable variable) {
        return this.getType(variable) != String.class;
    }

    String getDataColumnName(int columnIndex) {
        try {
            if (this.rectangularData instanceof StaticColumnInfoInterface) {
                StaticColumnInfoInterface info = (StaticColumnInfoInterface)this.rectangularData;
                String[] columnInfoNames = info.getColumnInfoNames();
                return (String)info.getColumnInfo(columnIndex + 1, columnInfoNames[0]);
            }
            return (String)((StaticColumnLabelInterface)this.rectangularData).getColumnLabel(columnIndex + 1);
        }
        catch (TableException e) {
            return null;
        }
    }

    String getDataColumnLabel(int columnIndex) {
        try {
            if (this.rectangularData instanceof StaticColumnInfoInterface) {
                StaticColumnInfoInterface info = (StaticColumnInfoInterface)this.rectangularData;
                String[] columnInfoNames = info.getColumnInfoNames();
                if (columnInfoNames.length > 1) {
                    String result = (String)info.getColumnInfo(columnIndex + 1, columnInfoNames[1]);
                    if (result == null || result.trim().equals("")) {
                        return null;
                    }
                    return result;
                }
                return null;
            }
            return null;
        }
        catch (TableException e) {
            return null;
        }
    }

    String getDataColumnFormat(int columnIndex) {
        try {
            if (this.rectangularData instanceof StaticColumnInfoInterface) {
                StaticColumnInfoInterface info = (StaticColumnInfoInterface)this.rectangularData;
                String[] columnInfoNames = info.getColumnInfoNames();
                if (columnInfoNames.length > 2) {
                    String result = (String)info.getColumnInfo(columnIndex + 1, columnInfoNames[2]);
                    if (result == null || result.trim().equals("")) {
                        return null;
                    }
                    return result;
                }
                return null;
            }
            return null;
        }
        catch (TableException e) {
            return null;
        }
    }

    String getDataColumnFormat(Variable variable) {
        if (variable == null) {
            return null;
        }
        if (variable instanceof DependentVariable) {
            DependentVariable depVar = (DependentVariable)variable;
            switch (depVar.getStatistic()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    return null;
                }
            }
        }
        int columnIndex = variable.getIndex() - 1;
        try {
            if (this.rectangularData instanceof StaticColumnInfoInterface) {
                StaticColumnInfoInterface info = (StaticColumnInfoInterface)this.rectangularData;
                String[] columnInfoNames = info.getColumnInfoNames();
                if (columnInfoNames.length > 2) {
                    String result = (String)info.getColumnInfo(columnIndex + 1, columnInfoNames[2]);
                    if (result == null || result.trim().equals("")) {
                        return null;
                    }
                    return result;
                }
                return null;
            }
            return null;
        }
        catch (TableException e) {
            return null;
        }
    }

    boolean matchVariable(Variable variable, int columnIndex) {
        if (this.isVariableMatched(variable, columnIndex)) {
            variable.indexIn = variable.index = columnIndex;
            return true;
        }
        return false;
    }

    boolean isVariableMatched(Variable variable, int columnIndex) {
        if (variable.name != null) {
            return variable.name.equalsIgnoreCase(this.getDataColumnName(columnIndex));
        }
        if (variable.label != null) {
            return variable.label.equalsIgnoreCase(this.getDataColumnName(columnIndex));
        }
        if (variable.indexIn >= 0) {
            return variable.indexIn == columnIndex;
        }
        return false;
    }

    boolean findIndex(Variable variable, boolean checkOnly) {
        boolean found;
        if (variable == null || variable.isAutomatic()) {
            return true;
        }
        if (variable.indexIn == -1 && variable.index == -1) {
            return true;
        }
        if (variable.name == null && variable.label == null && (variable.indexIn < 0 || variable.indexIn >= this.getColumnCount())) {
            MessageFormat formatter = new MessageFormat("");
            formatter.applyPattern(RB.getStringResource("DataModel.variableDef.ex.3.txt"));
            Object[] arg = new Object[]{new Integer(variable.indexIn + 1)};
            throw new VisualizationException(formatter.format(arg));
        }
        int columnCount = this.getColumnCount();
        if (!checkOnly) {
            found = false;
            for (int i = 0; !found && i < columnCount; ++i) {
                if (!this.matchVariable(variable, i)) continue;
                this.varReference[i] = true;
                found = true;
            }
        } else {
            found = false;
            for (int i = 0; !found && i < columnCount; ++i) {
                if (!this.isVariableMatched(variable, i)) continue;
                found = true;
            }
            if (!found) {
                MessageFormat formatter = new MessageFormat("");
                if (variable.name != null) {
                    formatter.applyPattern(RB.getStringResource("DataModel.variableDef.ex.1.txt"));
                    Object[] arg = new Object[]{variable.name};
                    throw new VisualizationException(formatter.format(arg));
                }
                if (variable.label != null) {
                    formatter.applyPattern(RB.getStringResource("DataModel.variableDef.ex.2.txt"));
                    Object[] arg = new Object[]{variable.label};
                    throw new VisualizationException(formatter.format(arg));
                }
            }
        }
        return found;
    }

    private boolean isValidColumnType(int columnIndex, int columnType) {
        return (this.isContinuous(columnIndex) ? columnType & 1 : columnType & 2) != 0;
    }

    void chooseVariable(Variable variable) {
        this.chooseVariable(variable, 3, false);
    }

    void chooseVariable(Variable variable, boolean continuousOnly) {
        this.chooseVariable(variable, continuousOnly ? 1 : 3, false);
    }

    void chooseVariable(Variable variable, int columnType) {
        this.chooseVariable(variable, columnType, false);
    }

    void chooseVariable(Variable variable, int columnType, boolean forceAutomatic) {
        if (variable != null) {
            variable.aux = null;
            variable.auxIn = null;
            if (variable.isAutomatic()) {
                int i;
                variable.index = -1;
                variable.indexIn = -1;
                int columnCount = this.getColumnCount();
                for (i = 0; i < columnCount; ++i) {
                    if (this.varReference[i] || !this.isValidColumnType(i, columnType)) continue;
                    variable.index = variable.indexIn = i;
                    this.varReference[i] = true;
                    break;
                }
                if (variable.indexIn == -1 && forceAutomatic) {
                    for (i = 0; i < columnCount; ++i) {
                        if (!this.isValidColumnType(i, columnType)) continue;
                        variable.index = variable.indexIn = i;
                        break;
                    }
                }
            } else if (variable.index == -1) {
                variable.indexIn = -1;
                variable.index = -1;
            } else if (this.isValidColumnType(variable.indexIn, columnType)) {
                this.varReference[variable.indexIn] = true;
            } else {
                MessageFormat formatter = new MessageFormat("");
                formatter.applyPattern(RB.getStringResource("DataModel.variableType.ex.txt"));
                Object[] arg = new Object[]{variable.name};
                throw new VisualizationException(formatter.format(arg));
            }
        }
    }

    boolean chooseAuxVariables(Variable variable) {
        boolean rc = false;
        if (variable != null && variable.index >= 0) {
            int count = 0;
            for (int ii = 0; ii < this.varReference.length; ++ii) {
                if (this.varReference[ii]) continue;
                if (this.isContinuous(ii)) break;
                ++count;
            }
            if (count > 0) {
                int[] aux = new int[count];
                count = 0;
                for (int ii = 0; ii < this.varReference.length; ++ii) {
                    if (this.varReference[ii]) continue;
                    if (this.isContinuous(ii)) break;
                    aux[count++] = ii;
                    this.varReference[ii] = true;
                }
                variable.aux = aux;
                variable.auxIn = aux;
            }
            rc = true;
        }
        return rc;
    }

    void setRow(int row) {
        if (row >= 0 && row < this.getRowCount()) {
            this.currentRow = row;
        }
    }

    boolean isSummable(Variable[] variables) {
        if (variables != null) {
            for (int ii = 0; ii < variables.length; ++ii) {
                if (this.isSummable(variables[ii])) continue;
                return false;
            }
        }
        return true;
    }

    boolean isSummable(Variable variable) {
        if (variable != null && variable.indexIn >= 0 && this.rectangularData instanceof MdTo2dTable) {
            return ((MdTo2dTable)this.rectangularData).isColumnSummable(variable.indexIn + 1);
        }
        return true;
    }

    String getString(Variable variable) {
        return this._getString(variable, this.currentRow, true);
    }

    String getPrimaryString(Variable variable) {
        return this._getString(variable, this.currentRow, false);
    }

    String getString(Variable variable, int rowIndex) {
        return this._getString(variable, rowIndex, true);
    }

    String getPrimaryString(Variable variable, int rowIndex) {
        return this._getString(variable, rowIndex, false);
    }

    private String _getString(Variable variable, int rowIndex, boolean auxEnabled) {
        String result = MISSING_VALUE;
        if (variable != null) {
            String auxResult;
            result = this._getString(rowIndex, variable.index);
            if (result == UNSUPPORTED_DATA_TYPE) {
                Class type = this.getType(variable);
                if (type != null) {
                    MessageFormat formatter = new MessageFormat("");
                    formatter.applyPattern(RB.getStringResource("DataModel.dataType.ex.1.txt"));
                    Object[] arg = new Object[]{type.toString(), variable.name};
                    throw new VisualizationException(formatter.format(arg));
                }
                result = null;
            } else if (result != null && auxEnabled && variable.aux != null && (auxResult = this._getAuxString(rowIndex, variable.aux)) != null) {
                result = (result == MISSING_VALUE ? "" : result.trim() + ".") + auxResult;
            }
        }
        return result;
    }

    String getString(int columnIndex) {
        String result = this._getString(this.currentRow, columnIndex);
        if (result == UNSUPPORTED_DATA_TYPE) {
            Class type = this.getType(columnIndex);
            if (type != null) {
                MessageFormat formatter = new MessageFormat("");
                formatter.applyPattern(RB.getStringResource("DataModel.dataType.ex.2.txt"));
                Object[] arg = new Object[]{type.toString(), new Integer(columnIndex + 1)};
                throw new VisualizationException(formatter.format(arg));
            }
            result = null;
        }
        return result;
    }

    private String _getString(int rowIndex, int columnIndex) {
        String result = UNSUPPORTED_DATA_TYPE;
        try {
            if (this.rectangularData == null || columnIndex == -1) {
                result = MISSING_VALUE;
            } else {
                Object obj = this.rectangularData.getCell(rowIndex + 1, columnIndex + 1);
                if (obj == null) {
                    result = MISSING_VALUE;
                } else {
                    Class type = this.rectangularData.getColumnClass(columnIndex + 1);
                    if (type == String.class) {
                        result = (String)obj;
                    } else if (type == Double.class) {
                        result = ((Double)obj).isNaN() ? MISSING_VALUE : this._getNumberFormat().format((Double)obj);
                    } else if (type == Integer.class) {
                        Integer i = (Integer)obj;
                        result = i.toString();
                    } else if (type == BigDecimal.class) {
                        BigDecimal bd = (BigDecimal)obj;
                        result = this._getNumberFormat().format(bd.doubleValue());
                    } else if (type == BigInteger.class) {
                        BigInteger bi = (BigInteger)obj;
                        result = bi.toString();
                    }
                }
            }
        }
        catch (TableException e) {
            return null;
        }
        return result == null ? MISSING_VALUE : result;
    }

    private String _getAuxString(int rowIndex, int[] columnIndex) {
        String result = null;
        if (columnIndex != null) {
            for (int ii = 0; ii < columnIndex.length; ++ii) {
                String temp = this._getString(rowIndex, columnIndex[ii]);
                if (temp == null || temp == MISSING_VALUE || temp == UNSUPPORTED_DATA_TYPE) continue;
                result = result == null ? temp.trim() : result + "." + temp.trim();
            }
        }
        return result;
    }

    String getName(Variable variable) {
        return this._getName(variable, true);
    }

    String getPrimaryName(Variable variable) {
        return this._getName(variable, false);
    }

    private String _getName(Variable variable, boolean auxEnabled) {
        String result = "";
        if (variable != null) {
            result = this._getName(variable.index);
            if (auxEnabled && variable.aux != null && result != null) {
                String auxNames = null;
                for (int ii = 0; ii < variable.aux.length; ++ii) {
                    String auxName = this.getName(variable.aux[ii]);
                    if (auxName == null) {
                        return null;
                    }
                    if (auxName.trim().equals("")) continue;
                    auxNames = auxNames == null ? auxName.trim() : auxNames + "." + auxName.trim();
                }
                if (auxNames != null) {
                    if ((result = result.trim()).equals("")) {
                        result = null;
                    }
                    result = result == null ? auxNames : result + "." + auxNames;
                }
            }
        }
        return result;
    }

    String getName(int columnIndex) {
        return this._getName(columnIndex);
    }

    private String _getName(int columnIndex) {
        String result = "";
        if (this.rectangularData != null && columnIndex >= 0) {
            try {
                if (this.rectangularData instanceof StaticColumnInfoInterface) {
                    StaticColumnInfoInterface info = (StaticColumnInfoInterface)this.rectangularData;
                    String[] columnInfoNames = info.getColumnInfoNames();
                    if (columnInfoNames.length > 1) {
                        result = (String)info.getColumnInfo(columnIndex + 1, columnInfoNames[1]);
                        if (result == null || result.trim().equals("")) {
                            result = (String)info.getColumnInfo(columnIndex + 1, columnInfoNames[0]);
                        }
                    } else {
                        result = (String)info.getColumnInfo(columnIndex + 1, columnInfoNames[0]);
                    }
                } else {
                    result = (String)((StaticColumnLabelInterface)this.rectangularData).getColumnLabel(columnIndex + 1);
                }
            }
            catch (TableException e) {
                return null;
            }
        }
        return result;
    }

    Class getType(Variable variable) {
        Class result;
        if (variable == null || variable.index == -1 || this.rectangularData == null) {
            result = null;
        } else {
            try {
                result = this.rectangularData.getColumnClass(variable.index + 1);
            }
            catch (TableException e) {
                return null;
            }
        }
        return result;
    }

    Class getType(int index) {
        Class result;
        if (index == -1 || this.rectangularData == null) {
            result = null;
        } else {
            try {
                result = this.rectangularData.getColumnClass(index + 1);
            }
            catch (TableException e) {
                return null;
            }
        }
        return result;
    }

    String appendString(String prefix, Variable variable) {
        String result = variable != null && variable.index != -1 ? prefix + this.getString(variable) : "";
        return result;
    }

    String appendString(String prefix, String value) {
        String result = value != null ? prefix + value : "";
        return result;
    }

    String getDisplayLabel(Variable variable) {
        String label = variable == null || variable.hideLabel ? null : (variable.userLabel == null || variable.userLabel.trim().equals("") ? this.getName(variable) : variable.userLabel);
        return label;
    }

    String getPrimaryLabel(Variable variable) {
        String label = null;
        if (variable != null) {
            label = variable.userLabel != null && !variable.userLabel.trim().equals("") ? variable.userLabel : this.getPrimaryName(variable);
        }
        return label;
    }

    String getLabel(Variable variable) {
        String label = variable == null ? null : (variable.userLabel == null || variable.userLabel.trim().equals("") ? this.getName(variable) : variable.userLabel);
        return label;
    }

    int getUniqueObservations(Variable classifier, Variable response) {
        Vector<String> v = new Vector<String>();
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String str;
            this.setRow(i);
            if (this.isValueMissing(classifier) || this.isValueMissing(response) || v.contains(str = this.getString(classifier))) continue;
            v.addElement(str);
        }
        return v.size();
    }

    protected boolean isOccurancesUnique(Variable variable) {
        int rowCount = this.getRowCount();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < rowCount; ++i) {
            this.setRow(i);
            if (this.isValueMissing(variable)) {
                return false;
            }
            if (v.contains(this.getString(variable))) {
                return false;
            }
            v.addElement(this.getString(variable));
        }
        return true;
    }

    protected boolean isContinuous(int columnIndex) {
        try {
            return this.rectangularData.getColumnClass(columnIndex + 1) != String.class;
        }
        catch (TableException e) {
            return false;
        }
    }

    int getContinuousColumnCount() {
        int count = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            try {
                if (this.rectangularData.getColumnClass(i) == String.class) continue;
                ++count;
                continue;
            }
            catch (TableException e) {
                return -1;
            }
        }
        return count;
    }

    double getMinValue(int index) {
        double min = Double.MAX_VALUE;
        try {
            Class type = this.rectangularData.getColumnClass(index + 1);
            for (int i = 1; i <= this.getRowCount(); ++i) {
                double cellValue;
                Object obj = this.rectangularData.getCell(i, index + 1);
                if (obj instanceof MissingValues) continue;
                if (type == Double.class) {
                    Double dCellValue = (Double)obj;
                    cellValue = dCellValue;
                } else if (type == Float.class) {
                    Float fCellValue = (Float)obj;
                    cellValue = fCellValue.floatValue();
                } else if (type == Integer.class) {
                    Integer iCellValue = (Integer)obj;
                    cellValue = iCellValue.intValue();
                } else if (type == BigDecimal.class) {
                    BigDecimal bd = (BigDecimal)obj;
                    cellValue = bd.doubleValue();
                } else if (type == BigInteger.class) {
                    BigInteger bi = (BigInteger)obj;
                    cellValue = bi.intValue();
                } else {
                    return Double.MAX_VALUE;
                }
                if (!(cellValue < min)) continue;
                min = cellValue;
            }
        }
        catch (TableException e) {
            return Double.MAX_VALUE;
        }
        return min;
    }

    double getMaxValue(int index) {
        double max = -1.7976931348623157E308;
        try {
            Class type = this.rectangularData.getColumnClass(index + 1);
            for (int i = 1; i <= this.getRowCount(); ++i) {
                double cellValue;
                Object obj = this.rectangularData.getCell(i, index + 1);
                if (obj == null || obj instanceof MissingValues) continue;
                if (type == Double.class) {
                    Double dCellValue = (Double)obj;
                    cellValue = dCellValue;
                } else if (type == Float.class) {
                    Float fCellValue = (Float)obj;
                    cellValue = fCellValue.floatValue();
                } else if (type == Integer.class) {
                    Integer iCellValue = (Integer)obj;
                    cellValue = iCellValue.intValue();
                } else if (type == BigDecimal.class) {
                    BigDecimal bd = (BigDecimal)obj;
                    cellValue = bd.doubleValue();
                } else if (type == BigInteger.class) {
                    BigInteger bi = (BigInteger)obj;
                    cellValue = bi.intValue();
                } else {
                    return -1.7976931348623157E308;
                }
                if (!(cellValue > max)) continue;
                max = cellValue;
            }
        }
        catch (TableException e) {
            return -1.7976931348623157E308;
        }
        return max;
    }

    boolean isValueMissing(Variable variable) {
        boolean isMissing = false;
        if (variable != null && variable.index != -1 && (isMissing = this.isValueMissing(variable.index)) && variable.aux != null) {
            isMissing = this._getAuxString(this.currentRow, variable.aux) == null;
        }
        return isMissing;
    }

    boolean isValueMissing(int columnIndex) {
        boolean isMissing = false;
        if (this.rectangularData != null) {
            try {
                Object obj = this.rectangularData.getCell(this.currentRow + 1, columnIndex + 1);
                isMissing = obj instanceof Double ? ((Double)obj).isNaN() : (obj instanceof Float ? ((Float)obj).isNaN() : obj == null || obj instanceof MissingValues);
            }
            catch (TableException e) {
                isMissing = true;
            }
        }
        return isMissing;
    }

    String[] format(Variable variable, String[] unformatted) {
        String[] labels;
        if (variable == null) {
            return null;
        }
        if (variable.aux != null) {
            return unformatted == null ? null : (String[])unformatted.clone();
        }
        if (variable instanceof DependentVariable) {
            DependentVariable depVar = (DependentVariable)variable;
            switch (depVar.getStatistic()) {
                case 3: 
                case 5: {
                    return null;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    String[] labels2 = new String[unformatted.length];
                    for (int i = 0; i < unformatted.length; ++i) {
                        double percent = DoubleData.valueOf((String)unformatted[i]);
                        labels2[i] = this._getPercentFormat().format(percent / 100.0);
                    }
                    return labels2;
                }
            }
        }
        if (!(this.rectangularData instanceof FormatInterface)) {
            return null;
        }
        FormatInterface formatter = (FormatInterface)this.rectangularData;
        try {
            Object[] values;
            if (variable.indexIn >= 0) {
                Class type = this.getType(variable.indexIn);
                if (type == Double.class) {
                    values = new Double[unformatted.length];
                    for (int i = 0; i < unformatted.length; ++i) {
                        values[i] = new Double(DoubleData.valueOf((String)unformatted[i]));
                    }
                } else if (type == Float.class) {
                    values = new Float[unformatted.length];
                    for (int i = 0; i < unformatted.length; ++i) {
                        values[i] = new Float(FloatData.valueOf((String)unformatted[i]));
                    }
                } else if (type == Integer.class) {
                    values = new Integer[unformatted.length];
                    for (int i = 0; i < unformatted.length; ++i) {
                        values[i] = Integer.valueOf(unformatted[i]);
                    }
                } else if (type == String.class) {
                    values = unformatted;
                } else if (type == BigDecimal.class) {
                    values = new BigDecimal[unformatted.length];
                    for (int i = 0; i < unformatted.length; ++i) {
                        values[i] = new BigDecimal(unformatted[i]);
                    }
                } else if (type == BigInteger.class) {
                    values = new BigInteger[unformatted.length];
                    for (int i = 0; i < unformatted.length; ++i) {
                        values[i] = new BigInteger(unformatted[i]);
                    }
                } else {
                    return null;
                }
                if (values == null || values.length < 1) {
                    return null;
                }
            } else {
                return null;
            }
            labels = formatter.formatValues(variable.indexIn + 1, values);
        }
        catch (TableException e) {
            return null;
        }
        return labels;
    }

    String format(Variable variable, String value) {
        String[] strOut;
        if (variable == null || variable.index == -1 || variable.indexIn < 0) {
            return null;
        }
        if (variable.aux != null && value != MISSING_VALUE) {
            return value;
        }
        if (variable instanceof DependentVariable) {
            DependentVariable depVar = (DependentVariable)variable;
            switch (depVar.getStatistic()) {
                case 3: 
                case 5: {
                    return value;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    double percent = DoubleData.valueOf((String)value);
                    return this._getPercentFormat().format(percent / 100.0);
                }
            }
        }
        Class type = this.getType(variable.indexIn);
        if (!(this.rectangularData instanceof FormatInterface)) {
            try {
                if ((type == Double.class || type == BigDecimal.class) && value != MISSING_VALUE) {
                    value = DoubleData.toString((double)DoubleData.valueOf((String)value));
                }
            }
            catch (NumberFormatException percent) {
                // empty catch block
            }
            return value;
        }
        Object[] strIn = new Object[]{type == Double.class ? new Double(DoubleData.valueOf((String)value)) : (type == Float.class ? new Float(FloatData.valueOf((String)value)) : (type == Integer.class ? Integer.valueOf(value) : (type == BigDecimal.class ? new BigDecimal(value) : (type == BigInteger.class ? new BigInteger(value) : value))))};
        FormatInterface formatter = (FormatInterface)this.rectangularData;
        try {
            strOut = formatter.formatValues(variable.indexIn + 1, strIn);
        }
        catch (TableException e) {
            return null;
        }
        return strOut != null && strOut.length > 0 ? strOut[0] : null;
    }

    String getShortName(int columnIndex) {
        if (columnIndex < 0) {
            return "";
        }
        try {
            String result;
            if (this.rectangularData instanceof StaticColumnInfoInterface) {
                StaticColumnInfoInterface info = (StaticColumnInfoInterface)this.rectangularData;
                String[] columnInfoNames = info.getColumnInfoNames();
                result = (String)info.getColumnInfo(columnIndex + 1, columnInfoNames[0]);
            } else {
                result = (String)((StaticColumnLabelInterface)this.rectangularData).getColumnLabel(columnIndex + 1);
            }
            return result;
        }
        catch (TableException e) {
            return null;
        }
    }
}

