/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.visualize.Mapper;
import com.sas.lang.FloatData;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;

class ContinuousMapper
extends Mapper {
    protected float vMin;
    protected float vMax;
    protected boolean vMinMaxInvalid;
    protected boolean vMinMaxLocked;
    protected float mappedMin;
    protected float mappedMax;
    protected int intervals;

    protected ContinuousMapper() {
        this(1, 0.0f, 1.0f);
    }

    protected ContinuousMapper(int intervalCount) {
        this(intervalCount, 0.0f, 1.0f);
    }

    protected ContinuousMapper(int intervalCount, float mappedMinIn, float mappedMaxIn) {
        this.intervals = intervalCount;
        this.vMinMaxInvalid = true;
        this.vMinMaxLocked = false;
        this.mappedMin = mappedMinIn;
        this.mappedMax = mappedMaxIn;
    }

    protected ContinuousMapper(int intervalCount, float vMinIn, float vMaxIn, float mappedMinIn, float mappedMaxIn) {
        this.intervals = intervalCount;
        this.vMin = vMinIn;
        this.vMax = vMaxIn;
        this.vMinMaxInvalid = false;
        this.vMinMaxLocked = true;
        this.mappedMin = mappedMinIn;
        this.mappedMax = mappedMaxIn;
    }

    @Override
    protected void addValue(String valueString) {
        this.addValue(FloatData.valueOf((String)valueString));
    }

    private void addValue(float v) {
        if (this.vMinMaxLocked) {
            return;
        }
        if (this.vMinMaxInvalid) {
            this.vMin = v;
            this.vMax = v;
            this.vMinMaxInvalid = false;
        } else {
            if (v < this.vMin) {
                this.vMin = v;
            }
            if (v > this.vMax) {
                this.vMax = v;
            }
        }
    }

    @Override
    protected float getMappedValue(String valueString) {
        Float value = new Float(FloatData.valueOf((String)valueString));
        if (value.isNaN()) {
            return 0.0f;
        }
        return this.getMappedValue(value.floatValue());
    }

    protected float getMappedValue(float v) {
        if (this.vMinMaxInvalid) {
            return v;
        }
        if (v <= this.vMin) {
            return this.mappedMin;
        }
        if (v >= this.vMax) {
            return this.mappedMax;
        }
        if (this.vMax == this.vMin) {
            return this.vMin;
        }
        float normalizedValue = (v - this.vMin) / (this.vMax - this.vMin);
        float mappedValue = this.mappedMin + (this.mappedMax - this.mappedMin) * normalizedValue;
        return mappedValue;
    }

    protected float getMappedValue2(float v) throws Exception {
        if (this.vMinMaxInvalid) {
            return v;
        }
        if (v < this.vMin) {
            throw new Exception("Invalid data");
        }
        if (v > this.vMax) {
            throw new Exception("Invalid data");
        }
        return this.getMappedValue(v);
    }

    @Override
    protected String[] getValueLabels() {
        String[] labels = new String[this.intervals + 1];
        float inc = (this.vMax - this.vMin) / (float)this.intervals;
        float value = this.vMin;
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.getDefault());
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(5);
        int i = 0;
        while (i <= this.intervals) {
            labels[i++] = nf.format(value);
            value += inc;
        }
        return labels;
    }

    @Override
    protected Object[] getValues(Class type) {
        Object[] values;
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            values = new Object[this.intervals + 1];
                            if (type != Double.class) break block5;
                            double inc = (this.vMax - this.vMin) / (float)this.intervals;
                            for (int i = 0; i <= this.intervals; ++i) {
                                values[i] = new Double((double)this.vMin + (double)i * inc);
                            }
                            break block6;
                        }
                        if (type != Float.class) break block7;
                        float inc = (this.vMax - this.vMin) / (float)this.intervals;
                        for (int i = 0; i <= this.intervals; ++i) {
                            values[i] = new Float(this.vMin + (float)i * inc);
                        }
                        break block6;
                    }
                    if (type != Integer.class) break block8;
                    int inc = (int)((this.vMax - this.vMin) / (float)this.intervals);
                    for (int i = 0; i <= this.intervals; ++i) {
                        values[i] = new Integer((int)this.vMin + i * inc);
                    }
                    break block6;
                }
                if (type != BigDecimal.class) break block9;
                double inc = (this.vMax - this.vMin) / (float)this.intervals;
                for (int i = 0; i <= this.intervals; ++i) {
                    values[i] = new BigDecimal((double)this.vMin + (double)i * inc);
                }
                break block6;
            }
            if (type != BigInteger.class) break block6;
            int inc = (int)((this.vMax - this.vMin) / (float)this.intervals);
            for (int i = 0; i <= this.intervals; ++i) {
                values[i] = BigInteger.valueOf((int)this.vMin + i * inc);
            }
        }
        return values;
    }

    @Override
    protected int getIntervalCount() {
        return this.intervals;
    }
}

