/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.visualize.ColorMapper;
import com.sas.graphics.util.visualize.ContinuousMapper;
import com.sas.lang.FloatData;
import java.awt.Color;

class ContinuousColorMapper
extends ColorMapper {
    private ContinuousMapper cMapper;
    private Color mappedMin;
    private Color mappedMax;

    protected ContinuousColorMapper() {
        this(1, new Color(0.0f, 0.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f));
    }

    protected ContinuousColorMapper(int intervalCount) {
        this(intervalCount, new Color(0.0f, 0.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f));
    }

    protected ContinuousColorMapper(int intervalCount, Color mappedMinIn, Color mappedMaxIn) {
        this.cMapper = new ContinuousMapper(intervalCount);
        this.mappedMin = mappedMinIn;
        this.mappedMax = mappedMaxIn;
    }

    protected ContinuousColorMapper(int intervalCount, float vMinIn, float vMaxIn, Color mappedMinIn, Color mappedMaxIn) {
        this.cMapper = new ContinuousMapper(intervalCount, vMinIn, vMaxIn, 0.0f, 1.0f);
        this.mappedMin = mappedMinIn;
        this.mappedMax = mappedMaxIn;
    }

    @Override
    protected void addValue(String value) {
        this.cMapper.addValue(value);
    }

    @Override
    protected float getMappedValue(String value) {
        return this.cMapper.getMappedValue(value);
    }

    @Override
    protected Color getMappedRGBColor(String valueString) {
        Float value = new Float(FloatData.valueOf((String)valueString));
        return this.getMappedRGBColor(value.floatValue());
    }

    protected Color getMappedRGBColor(float value) {
        float normalized = this.cMapper.getMappedValue(FloatData.toString((float)value));
        return new Color((float)this.mappedMin.getRed() / 255.0f + normalized * (float)(this.mappedMax.getRed() - this.mappedMin.getRed()) / 255.0f, (float)this.mappedMin.getGreen() / 255.0f + normalized * (float)(this.mappedMax.getGreen() - this.mappedMin.getGreen()) / 255.0f, (float)this.mappedMin.getBlue() / 255.0f + normalized * (float)(this.mappedMax.getBlue() - this.mappedMin.getBlue()) / 255.0f);
    }

    @Override
    protected String[] getValueLabels() {
        return this.cMapper.getValueLabels();
    }

    @Override
    protected Object[] getValues(Class type) {
        return this.cMapper.getValues(type);
    }

    @Override
    protected int getIntervalCount() {
        return this.cMapper.getIntervalCount();
    }
}

