/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ColorLegend;
import com.sas.graphics.util.visualize.ColorMapper;
import com.sas.graphics.util.visualize.ContinuousColorMapper;
import com.sas.graphics.util.visualize.Vec3f;

class ContinuousColorLegend
extends ColorLegend {
    protected int numPolygons;
    protected double legendWidth;
    protected double minValueLength;
    protected double maxValueLength;
    protected double blankSpace;
    protected int numLabelChars;
    protected double labelWidth;

    public ContinuousColorLegend(ColorMapper aMapper) {
        super(aMapper);
    }

    public void setNumPolygons(int aInt) {
        this.numPolygons = aInt;
    }

    @Override
    protected void orientLegend(Channel ch) {
        ch.glSelect2DFont(this.valueStyle.createFont());
        this.minValueLength = ch.glGetTextWidth("-" + this.formattedValues[0].trim() + "-");
        this.maxValueLength = ch.glGetTextWidth("-" + this.formattedValues[this.values.length - 1].trim() + "-");
        this.blankSpace = ch.glGetTextWidth("-");
        if (this.label == null) {
            this.vLegendOffset = this.labelHeight + this.valueHeight;
            this.numLabelChars = 0;
            this.labelWidth = 0.0;
            this.legendWidth = this.visBodySize.x / 4.0f;
        } else {
            this.vLegendOffset = 2.0f * this.labelHeight + this.valueHeight;
            double maxLabelSize = Math.max(0.0f, this.visBodySize.x - this.valueHeight);
            String str = this.label.trim();
            ch.glSelect2DFont(this.labelStyle.createFont());
            this.numLabelChars = str.length();
            if (this.numLabelChars > this.labelStyle.maxChars) {
                this.numLabelChars = this.labelStyle.maxChars;
                str = str.substring(0, this.numLabelChars);
            }
            double len = ch.glGetTextWidth("--");
            this.labelWidth = ch.glGetTextWidth(str) + len;
            while (this.labelWidth > maxLabelSize) {
                this.numLabelChars = ContinuousColorLegend.ClippingIndex(str, this.numLabelChars - 1);
                if (this.numLabelChars == 0) break;
                str = str.substring(0, this.numLabelChars);
                this.labelWidth = ch.glGetTextWidth(str) + len;
            }
            this.legendWidth = Math.max((double)(this.visBodySize.x / 4.0f), this.labelWidth + (double)this.valueHeight - this.minValueLength - this.maxValueLength);
        }
        Vec3f vec = new Vec3f(this.legendPosition);
        switch (this.relativePosition) {
            default: 
        }
        this.valueStyle.majorJustify = "RIGHT";
        this.valueStyle.minorJustify = "CENTER";
        if (this.label != null) {
            ch.glTranslate((double)vec.x - this.legendWidth / 2.0, vec.y - 2.0f * this.labelHeight - this.valueHeight / 2.0f, vec.z);
        } else {
            ch.glTranslate((double)vec.x - this.legendWidth / 2.0, vec.y - this.labelHeight - this.valueHeight / 2.0f, vec.z);
        }
    }

    @Override
    protected void addValues(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify) {
        ch.glColor(this.valueStyle.color);
        ch.glSelect2DFont(this.valueStyle.createFont());
        boolean oneColor = false;
        if (this.values.length == 2 && this.values[0] != null && this.values[1] != null && this.values[0].equals(this.values[1])) {
            oneColor = true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            Vec3f currentPoint = new Vec3f(startPoint);
            Vec3f increment = new Vec3f(this.incrementVector);
            increment.scale((float)this.legendWidth);
            if (oneColor) {
                increment.scale(i);
            } else {
                increment.scale(this.mapper.getMappedValue(this.values[i]));
            }
            currentPoint.add(increment);
            switch (this.relativePosition) {
                default: 
            }
            double gapWidth = 0.0;
            if (i == 0) {
                ch.glTextAlign(2, 1);
                gapWidth = (float)ch.glGetTextWidth("-");
            } else {
                ch.glTextAlign(0, 1);
                gapWidth = -((float)ch.glGetTextWidth("-"));
            }
            ch.gl2DText(" " + this.formattedValues[i].trim() + " ", (double)currentPoint.x - gapWidth, currentPoint.y - this.labelHeight / 2.0f, currentPoint.z);
        }
    }

    @Override
    protected void addLabel(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify, boolean flipEndDirection) {
        if (this.label == null) {
            return;
        }
        ch.glColor(this.labelStyle.color);
        ch.glSelect2DFont(this.labelStyle.createFont());
        Vec3f location = new Vec3f(startPoint);
        Vec3f vec = new Vec3f(this.incrementVector);
        switch (this.relativePosition) {
            default: 
        }
        vec.scale((float)(-this.minValueLength + (double)(this.valueHeight / 2.0f)));
        location.add(vec);
        ch.glTextAlign(1, 3);
        ch.gl2DText(this.label.trim().substring(0, this.numLabelChars), (double)location.x + this.labelWidth / 2.0, location.y + this.valueHeight / 4.0f, location.z);
        this.labelHotspots = null;
        if (this.isLabelValueHotspotsEnabled() || this.isLabelHotspotsEnabled()) {
            this.labelHotspots = new Blob[1];
            Bbox bbox = new Bbox();
            ch.glGetText2DBbox(this.label.trim().substring(0, this.numLabelChars), (double)location.x + this.labelWidth / 2.0, location.y + this.valueHeight / 4.0f, location.z, 0, bbox);
            this.labelHotspots[0] = Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim()}, new String[]{this.label.trim()}, new int[]{this.getLabelHotspotID()}, bbox);
        }
    }

    @Override
    protected void addGeometry(Channel ch) {
        ColorMapper cMapper = (ColorMapper)this.mapper;
        ContinuousColorMapper ccm = new ContinuousColorMapper(0, 0.0f, this.numPolygons - 1, cMapper.getMappedRGBColor(this.values[0]), cMapper.getMappedRGBColor(this.values[1]));
        Vec3f current = new Vec3f(this.origin);
        Vec3f inc = new Vec3f(this.incrementVector);
        inc.scale((float)(this.legendWidth / (double)this.numPolygons));
        int polygonMode = ch.getPolygonMode();
        ch.glPolygonMode(3);
        for (int i = 0; i < this.numPolygons; ++i) {
            ch.glBegin(2);
            ch.glColor(ccm.getMappedRGBColor(i));
            ch.glVertex(current.x, current.y, 0.0);
            ch.glVertex(current.x + inc.x, current.y, 0.0);
            ch.glVertex(current.x + inc.x, current.y + this.labelHeight, 0.0);
            ch.glVertex(current.x, current.y + this.labelHeight, 0.0);
            ch.glEnd();
            current.add(inc);
        }
        ch.glColor(this.geomColor);
        ch.glBegin(1);
        ch.glVertex(this.origin.x, this.origin.y, this.origin.z);
        ch.glVertex((double)this.origin.x + this.legendWidth, this.origin.y, this.origin.z);
        ch.glVertex((double)this.origin.x + this.legendWidth, this.origin.y + this.labelHeight, this.origin.z);
        ch.glVertex(this.origin.x, this.origin.y + this.labelHeight, this.origin.z);
        ch.glVertex(this.origin.x, this.origin.y, this.origin.z);
        ch.glEnd();
        ch.glPolygonMode(polygonMode);
    }

    @Override
    protected void drawBBox(Channel ch) {
        switch (this.relativePosition) {
            default: 
        }
        ch.glSelect2DFont(this.labelStyle.createFont());
        double descent = this.labelHeight / 2.0f;
        if (this.label == null) {
            descent = 0.0;
        }
        ch.glColor(this.geomColor);
        ch.glBegin(1);
        ch.glVertex(-this.minValueLength + (double)(this.valueHeight / 2.0f), (double)this.labelHeight + descent + (double)(this.valueHeight / 4.0f), 0.0);
        ch.glVertex(-this.minValueLength, (double)this.labelHeight + descent + (double)(this.valueHeight / 4.0f), 0.0);
        ch.glVertex(-this.minValueLength, -this.valueHeight / 4.0f, 0.0);
        ch.glVertex(this.legendWidth + this.maxValueLength, -this.valueHeight / 4.0f, 0.0);
        ch.glVertex(this.legendWidth + this.maxValueLength, (double)this.labelHeight + descent + (double)(this.valueHeight / 4.0f), 0.0);
        ch.glVertex(-this.minValueLength + (double)(this.valueHeight / 2.0f) + this.labelWidth, (double)this.labelHeight + descent + (double)(this.valueHeight / 4.0f), 0.0);
        ch.glEnd();
    }
}

