/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ColorMapper;
import com.sas.graphics.util.visualize.Legend;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.Vec3f;
import java.awt.Color;

abstract class ColorLegend
extends Legend {
    protected static final int LABEL_BEGIN_ALIGN = 0;
    protected static final int LABEL_MIDDLE_ALIGN = 1;
    protected static final int LABEL_END_ALIGN = 2;
    private static final Vec3f incrementVectorDefault = new Vec3f(Vec3f.xAxis);
    private static final Vec3f endVectorDefault = new Vec3f(Vec3f.zAxis);
    protected Vec3f incrementVector;
    protected Vec3f endVector;
    protected String label;
    protected String primaryLabel;
    protected TextStyle labelStyle;
    protected int labelPosition;
    protected float labelHeight;
    protected Color backgroundColor = Color.lightGray;
    protected Vec3f visBodySize;
    protected Vec3f legendPosition;
    protected Vec3f legendBodySize;
    protected int relativePosition = 3;

    public ColorLegend(ColorMapper aMapper) {
        super(aMapper);
        this.incrementVector = incrementVectorDefault;
        this.endVector = endVectorDefault;
        this.labelStyle = new TextStyle();
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
        this.primaryLabel = null;
    }

    public void setLabel(String aLabel, String aPrimaryLabel) {
        this.label = aLabel;
        this.primaryLabel = aPrimaryLabel;
    }

    public void setIntervals(int count) {
        this.intervals = count;
    }

    public void setStyles(TextStyle aValueStyle, TextStyle aLabelStyle) {
        this.valueStyle = aValueStyle;
        this.labelStyle = aLabelStyle;
    }

    public void setLabelStyles(TextStyle aLabelStyle) {
        this.labelStyle = aLabelStyle;
    }

    public TextStyle getLabelStyles() {
        return this.labelStyle;
    }

    public void scaleIncrementVector(float factor) {
        this.incrementVector.normalize();
        this.incrementVector.scale(factor);
    }

    public void setPosition(int aPosition, Vec3f aSize, Vec3f aOffset) {
        this.relativePosition = aPosition;
        this.visBodySize = aSize;
        this.legendPosition = aOffset;
    }

    public void setSize(Vec3f aSize) {
        this.legendBodySize = aSize;
    }

    public void setColors(Color aValuesColor, Color aLabelColor) {
        this.valueStyle.setColor(aValuesColor);
        this.labelStyle.setColor(aLabelColor);
    }

    @Override
    public void addLegend(Channel ch, boolean visible) {
        if (!visible) {
            return;
        }
        this.vLegendOffset = 0.0f;
        this.hLegendOffset = 0.0f;
        ch.glSelect2DFont(this.labelStyle.createFont());
        this.labelHeight = (float)ch.glGetTextHeight();
        ch.glSelect2DFont(this.valueStyle.createFont());
        this.valueHeight = (float)ch.glGetTextHeight();
        this.tickSize = this.valueHeight / 2.0f;
        switch (this.relativePosition) {
            default: {
                this.endVector = new Vec3f(Vec3f.yAxis);
                this.endVector.scale(this.labelHeight);
                this.incrementVector = new Vec3f(Vec3f.xAxis);
                break;
            }
            case 0: {
                this.incrementVector = new Vec3f(Vec3f.yAxis);
                this.endVector = new Vec3f(Vec3f.xAxis);
                this.endVector.scale(this.labelHeight);
            }
        }
        ch.glPushMatrix();
        this.orientLegend(ch);
        Vec3f point = new Vec3f(this.origin);
        point.add(this.endVector);
        this.addValues(ch, point, this.valueStyle.getMajorJustify(), this.valueStyle.getMinorJustify());
        this.addGeometry(ch);
        this.addLabel(ch, point, this.labelStyle.getMajorJustify(), this.labelStyle.getMinorJustify(), false);
        this.drawBBox(ch);
        ch.glPopMatrix();
    }

    protected void addLabel(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify, boolean flipEndDirection) {
        if (this.label != null) {
            Vec3f location = new Vec3f(startPoint);
            Vec3f vec = new Vec3f(this.incrementVector);
            if (this.labelPosition == 1) {
                vec.scale((float)this.intervals / 2.0f);
                location.add(vec);
                vec = new Vec3f(this.endVector);
                vec.normalize();
                if (flipEndDirection) {
                    vec.scale(-1.0f);
                }
                vec.scale(this.vLegendOffset);
                location.add(vec);
                this.vLegendOffset += this.labelHeight;
            } else {
                if (ch.glGetTextWidth(this.label.trim().substring(0, Math.min(this.labelStyle.getMaxChars(), this.label.trim().length()))) / 2.0 > (double)this.hLegendOffset) {
                    this.hLegendOffset = (float)ch.glGetTextWidth(this.label.trim().substring(0, Math.min(this.labelStyle.getMaxChars(), this.label.trim().length()))) / 2.0f;
                }
                this.vLegendOffset = this.valueHeight / 2.0f + this.labelHeight;
                vec.scale(this.intervals);
                location.add(vec);
                vec = new Vec3f(this.incrementVector);
                vec.normalize();
                vec.scale(this.valueHeight / 2.0f);
                vec.z += -1.0f;
                location.add(vec);
            }
            ch.glColor(this.labelStyle.getColor());
            if (majorJustify.equals("BEGIN")) {
                ch.glTextAlign(0, 2);
            } else if (majorJustify.equals("END")) {
                ch.glTextAlign(2, 2);
            } else if (this.labelPosition == 1) {
                ch.glTextAlign(1, 0);
            } else {
                ch.glTextAlign(1, 3);
            }
            ch.gl2DText(this.label.trim().substring(0, Math.min(this.labelStyle.getMaxChars(), this.label.trim().length())), location.x, location.y, location.z);
            this.labelHotspots = null;
            if (this.isLabelValueHotspotsEnabled() || this.isLabelHotspotsEnabled()) {
                this.labelHotspots = new Blob[1];
                Bbox bbox = new Bbox();
                ch.glGetText2DBbox(this.label.trim().substring(0, Math.min(this.labelStyle.getMaxChars(), this.label.trim().length())), location.x, location.y, location.z, 0, bbox);
                this.labelHotspots[0] = Blob.newBlob(ch, new String[]{this.primaryLabel != null ? this.primaryLabel.trim() : this.label.trim()}, new String[]{this.label.trim()}, new int[]{this.getLabelHotspotID()}, bbox);
            }
        }
    }

    @Override
    protected abstract void addGeometry(Channel var1);

    protected abstract void orientLegend(Channel var1);

    protected abstract void drawBBox(Channel var1);
}

