/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Bar;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.ContinuousColorLegend;
import com.sas.graphics.util.visualize.ContinuousColorLegendStyle;
import com.sas.graphics.util.visualize.ContinuousColorMapper;
import com.sas.graphics.util.visualize.DataModelProcessor;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.RB;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.TidyContinuousMapper;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.Visualization;
import com.sas.graphics.util.visualize.VisualizationException;
import com.sas.lang.DoubleData;
import com.sas.lang.FloatData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Vector;

public abstract class ColorBar
extends Bar
implements Serializable {
    static final long serialVersionUID = 1242743474888216144L;
    public static final String RB_KEY = "Chart.";
    protected DependentVariable colorVariable;
    protected ContinuousColorLegendStyle colorLegendStyle;
    protected transient ContinuousColorMapper colorMapper;
    protected transient int clickedObs;
    protected transient String clickedColumn;
    protected transient String clickedRow;
    protected transient String clickedHeight;
    protected transient String clickedColor;
    protected transient String clickedGroup;
    protected transient String colorLabel;
    protected transient String groupLabel;
    protected transient String heightLabel;
    protected transient String rowLabel;
    protected transient String columnLabel;
    private transient int colorLegendSizePixels;
    protected transient ContinuousColorLegend colorLegend;

    public ColorBar() {
        this((String)null);
    }

    public ColorBar(String title) {
        super(title);
        this.colorVariable = new DependentVariable();
        this.colorLegendStyle = new ContinuousColorLegendStyle();
    }

    public ColorBar(ColorBar aColorBar) {
        super(aColorBar);
        this.colorVariable = aColorBar.colorVariable;
        this.colorLegendStyle = aColorBar.colorLegendStyle;
    }

    public DependentVariable getColorVariable() {
        return this.colorVariable;
    }

    public void setColorVariable(DependentVariable v) {
        if (v == null) {
            this.colorVariable = new DependentVariable();
            this.colorVariable.setIndex(-1);
        } else {
            this.colorVariable = v;
        }
    }

    public ContinuousColorLegendStyle getColorLegendStyle() {
        return this.colorLegendStyle;
    }

    public void setColorLegendStyle(ContinuousColorLegendStyle aLegendStyle) {
        this.colorLegendStyle = aLegendStyle;
    }

    @Override
    public boolean validVariables(boolean checkOnly) {
        if (!super.validVariables(checkOnly)) {
            return false;
        }
        return this.dataUser.findIndex(this.colorVariable, checkOnly);
    }

    @Override
    public void resetVariables(boolean indexOnly) {
        super.resetVariables(indexOnly);
        if (this.colorVariable == null) {
            this.colorVariable = new DependentVariable();
        } else if (indexOnly) {
            this.colorVariable.reset();
        } else {
            this.colorVariable.setAutomatic(true);
        }
    }

    @Override
    protected void validateVariables() {
        this.data.resetReferences();
        if (!this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 3);
        }
        if (!this.heightVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.heightVariable, 1);
        }
        if (!this.colorVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.colorVariable, 1);
        } else {
            this.colorVariable.index = -1;
            this.colorVariable.indexIn = -1;
        }
        if (this.isRiserChart()) {
            this.groupVariable.index = -1;
            this.groupVariable.indexIn = -1;
            this.data.chooseVariable((Variable)this.rowVariable, 3);
        } else {
            this.rowVariable.index = -1;
            this.rowVariable.indexIn = -1;
            if (this.groupVariable.isAutomatic()) {
                if (this.data.isDerivedFromMDDB()) {
                    this.data.chooseVariable((Variable)this.groupVariable, 2);
                } else {
                    this.groupVariable.index = -1;
                    this.groupVariable.indexIn = -1;
                }
            } else {
                this.data.chooseVariable((Variable)this.groupVariable, 3);
            }
        }
        if (this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 2);
            if (this.isNoneVariable(this.columnVariable)) {
                if (this.data.isDerivedFromMDDB()) {
                    if (!this.isNoneVariable(this.groupVariable)) {
                        this.columnVariable.index = this.groupVariable.index;
                        this.columnVariable.indexIn = this.groupVariable.indexIn;
                        if (this.groupVariable.isAutomatic()) {
                            this.groupVariable.index = -1;
                            this.groupVariable.indexIn = -1;
                        }
                    } else if (!this.isNoneVariable(this.rowVariable)) {
                        this.columnVariable.index = this.rowVariable.index;
                        this.columnVariable.indexIn = this.rowVariable.indexIn;
                        if (this.rowVariable.isAutomatic()) {
                            this.rowVariable.index = -1;
                            this.rowVariable.indexIn = -1;
                        }
                    }
                } else {
                    this.data.chooseVariable((Variable)this.columnVariable, 3);
                }
            }
            if (this.isNoneVariable(this.columnVariable)) {
                this.data.chooseVariable(this.columnVariable, 2, true);
                if (this.isNoneVariable(this.columnVariable)) {
                    this.data.chooseVariable(this.columnVariable, 3, true);
                }
            }
        }
        if (this.heightVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.heightVariable, 1);
            if (this.isNoneVariable(this.heightVariable)) {
                if (!this.isNoneVariable(this.colorVariable)) {
                    this.heightVariable.indexIn = this.colorVariable.indexIn;
                    this.heightVariable.index = this.colorVariable.index;
                }
                if (this.isNoneVariable(this.heightVariable)) {
                    this.data.chooseVariable(this.heightVariable, 1, true);
                }
            }
        }
    }

    @Override
    protected void processDataModel() {
        DataModelProcessor dmp = new DataModelProcessor(this.dataUser);
        IndependentVariable[] classifiers = new IndependentVariable[2];
        if (this.isRiserChart()) {
            classifiers[0] = this.rowVariable;
            classifiers[1] = this.columnVariable;
        } else {
            classifiers[0] = this.columnVariable;
            classifiers[1] = this.groupVariable;
        }
        DependentVariable[] responses = new DependentVariable[]{this.heightVariable, this.colorVariable};
        dmp.showStatistic = this.showStatistic;
        dmp.missingRetained = this.missingRetained;
        dmp.missingSymbol = this.missingSymbol;
        this.data = dmp.process(classifiers, responses);
        this.resetResponseVariable(this.heightVariable);
        this.rowLabel = this.data.getLabel(this.rowVariable);
        if (this.rowLabel == null || this.rowLabel == "") {
            this.rowLabel = RB.getStringResource(RB_KEY, "rowLabel.txt");
        }
        this.columnLabel = this.data.getLabel(this.columnVariable);
        if (this.columnLabel == null || this.columnLabel == "") {
            this.columnLabel = RB.getStringResource(RB_KEY, "columnLabel.txt");
        }
        this.heightLabel = this.data.getLabel(this.heightVariable);
        if (this.heightLabel == null || this.heightLabel == "") {
            this.heightLabel = RB.getStringResource(RB_KEY, "heightLabel.txt");
        }
        if (!this.isNoneVariable(this.colorVariable)) {
            this.colorLabel = this.data.getLabel(this.colorVariable);
            if (this.colorLabel == null || this.colorLabel == "") {
                this.colorLabel = RB.getStringResource(RB_KEY, "colorLabel.txt");
            }
            if (this.colorLabel.equals(this.heightLabel)) {
                this.colorLabel = null;
            }
        }
        if (!this.isNoneVariable(this.groupVariable)) {
            this.groupLabel = this.data.getLabel(this.groupVariable);
            if (this.groupLabel == null || this.groupLabel == "") {
                this.groupLabel = RB.getStringResource(RB_KEY, "groupLabel.txt");
            }
            if (this.groupLabel.equals(this.columnLabel) || this.groupLabel.equals(this.rowLabel)) {
                this.groupLabel = null;
            }
        } else {
            this.groupLabel = null;
        }
    }

    @Override
    public Variable[] getAnalysisVariables() {
        return new Variable[]{this.heightVariable, this.colorVariable};
    }

    @Override
    public Variable[] getClassifierVariables() {
        return new Variable[]{this.rowVariable, this.groupVariable, this.columnVariable};
    }

    @Override
    protected void createMappers() {
        super.createMappers();
        this.assignColorMapper();
    }

    @Override
    protected void assignHeightMapper() {
        float Hmax;
        int nCols = this.data.getUniqueObservations(this.columnVariable, this.heightVariable);
        nCols = Math.min(nCols, this.data.getUniqueObservations(this.columnVariable, this.colorVariable));
        if (this.groupVariable == null || this.groupVariable.index == -1) {
            Hmax = (float)nCols * this.aspect;
        } else {
            int nGroups = this.data.getUniqueObservations(this.groupVariable, this.heightVariable);
            nGroups = Math.min(nGroups, this.data.getUniqueObservations(this.groupVariable, this.colorVariable));
            Hmax = (float)((nCols + 1) * nGroups - 1) * this.aspect;
        }
        if (this.heightVariable == null || this.heightVariable.index == -1) {
            this.heightMapper = new ConstantMapper(1, Hmax);
        } else {
            this.heightMapper = new TidyContinuousMapper(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
            this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        }
    }

    protected void assignColorMapper() {
        if (this.colorMapping == 1) {
            Color startColor = this.colorLegendStyle.getStartColor();
            Color endColor = this.colorLegendStyle.getEndColor();
            if (this.isNoneVariable(this.colorVariable)) {
                this.colorMapper = new ContinuousColorMapper(1, 0.0f, 0.0f, startColor, startColor);
                return;
            }
            if (this.mapValues == null) {
                this.colorMapper = new ContinuousColorMapper(1, startColor, endColor);
            } else if (this.mapValues.length < 2) {
                this.colorMapper = new ContinuousColorMapper(1, startColor, endColor);
                if (this.mapValues.length == 1) {
                    this.colorMapper.addValue(FloatData.toString((float)this.mapValues[0]));
                }
            } else {
                this.colorMapper = new ContinuousColorMapper(1, this.mapValues[0], this.mapValues[1], startColor, endColor);
            }
        } else {
            this.colorMapper = null;
        }
    }

    @Override
    protected void initializeMappers() {
        int rowCount = this.data.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.colorVariable) || this.data.isValueMissing(this.heightVariable)) continue;
            this.rowMapper.addValue(this.data.getString(this.rowVariable), this.data.getPrimaryString(this.rowVariable));
            this.columnMapper.addValue(this.data.getString(this.columnVariable), this.data.getPrimaryString(this.columnVariable));
            if (!this.heightLegendStyle.isFixedDataRange()) {
                this.heightMapper.addValue(this.data.getString(this.heightVariable));
            }
            this.groupMapper.addValue(this.data.getString(this.groupVariable));
            if (this.colorLegendStyle.isFixedDataRange()) continue;
            this.colorMapper.addValue(this.data.getString(this.colorVariable));
        }
        this.numGroups = this.groupMapper.getIntervalCount();
        if (this.heightLegendStyle.isFixedDataRange()) {
            this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMinValue()));
            this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getDataMaxValue()));
        }
        if (this.colorLegendStyle.isFixedDataRange()) {
            this.colorMapper.addValue(DoubleData.toString((double)this.colorLegendStyle.getDataMinValue()));
            this.colorMapper.addValue(DoubleData.toString((double)this.colorLegendStyle.getDataMaxValue()));
        }
        if (this.rowMapper.getIntervalCount() == 0 || this.columnMapper.getIntervalCount() == 0) {
            throw new VisualizationException(RB.getStringResource("Visualization.missingColumn.ex.txt"));
        }
    }

    @Override
    protected void removeLegends() {
        super.removeLegends();
        this.colorLegend = null;
    }

    @Override
    protected void addColorLegends(Channel ch) {
        ContinuousColorLegend legend;
        boolean newLegend;
        if (!this.colorLegendStyle.visible || this.isNoneVariable(this.colorVariable)) {
            return;
        }
        boolean bl = newLegend = this.colorLegend == null;
        if (newLegend) {
            legend = new ContinuousColorLegend(this.colorMapper);
            if (this.colorLegendStyle.getBorderColor() != null) {
                legend.geomColor = this.colorLegendStyle.getBorderColor();
            }
            legend.setLabel(this.data.getDisplayLabel(this.colorVariable));
            legend.setIntervals(this.colorMapper.getIntervalCount());
            legend.setNumPolygons(Math.min(20, Math.max(this.columnMapper.getIntervalCount(), 5)));
            String[] values = this.colorMapper.getValueLabels();
            String[] formattedValues = this.dataUser.format((Variable)this.colorVariable, values);
            legend.values = values;
            legend.formattedValues = formattedValues == null ? values : formattedValues;
            legend.valueStyle = this.colorLegendStyle.valueStyle;
            legend.labelStyle = this.colorLegendStyle.labelStyle;
            this.colorLegend = legend;
        } else {
            legend = this.colorLegend;
        }
        TextStyle ts = this.colorLegendStyle.labelStyle;
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm.getHeight();
        ts = this.colorLegendStyle.valueStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm.getHeight();
        float legWidth = this.xSizePixels;
        float legHeight = this.data.getDisplayLabel(this.colorVariable) != null ? (float)(2 * labelFontPixels + 3 * valueFontPixels / 4) : (float)(labelFontPixels + 3 * valueFontPixels / 4);
        legend.setPosition(this.colorLegendStyle.position, new Vec3f(legWidth, legHeight, legWidth), new Vec3f((float)(this.width - this.leftMargin - this.rightMargin) / 2.0f, this.yColorLegendSize + 0.03f * (float)this.height + legHeight, 0.0f));
        legend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
        legend.setLabelHotspotID(6);
        legend.addLegend(ch, this.colorLegendStyle.visible);
        this.yColorLegendSize += legend.vLegendOffset + (float)this.blankSpacePixels;
        Blob[] b = legend.getLabelHotspots();
        this.subgroupVariableHotspot = b == null ? null : b[0];
    }

    @Override
    protected void scaleText(Channel ch) {
        super.scaleText(ch);
        TextStyle ts = this.colorLegendStyle.getLabelStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.colorLegendStyle.getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
    }

    @Override
    protected void estimateLegendPixelSize(Channel ch) {
        super.estimateLegendPixelSize(ch);
        TextStyle ts = this.colorLegendStyle.labelStyle;
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int labelFontPixels = fm.getHeight();
        ts = this.colorLegendStyle.valueStyle;
        fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
        int valueFontPixels = fm.getHeight();
        if (this.colorLegendStyle.visible && !this.isNoneVariable(this.colorVariable)) {
            if (this.data.getDisplayLabel(this.colorVariable) != null) {
                this.colorLegendSizePixels = 2 * labelFontPixels + 3 * valueFontPixels / 4;
                this.bottomLegendPixels += this.colorLegendSizePixels + this.blankSpacePixels;
            } else {
                this.colorLegendSizePixels = labelFontPixels + 3 * valueFontPixels / 4;
                this.bottomLegendPixels += this.colorLegendSizePixels + this.blankSpacePixels;
            }
        }
    }

    @Override
    protected void parseProbeInfo(String[] lastPicked, String[] descriptors, String[] values) {
        this.resetClickedItems();
        int n = this.clickedObs = lastPicked == null || lastPicked[5] == null ? -1 : Integer.parseInt(lastPicked[5]);
        if (this.clickedObs >= 0) {
            String rowValue = this.data.getString(this.rowVariable, this.clickedObs);
            String columnValue = this.data.getString(this.columnVariable, this.clickedObs);
            String heightValue = this.data.getString(this.heightVariable, this.clickedObs);
            String colorValue = this.data.getString(this.colorVariable, this.clickedObs);
            String groupValue = this.data.getString(this.groupVariable, this.clickedObs);
            int ii = 0;
            if (this.rowLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.rowLabel;
                values[ii++] = this.dataUser.format((Variable)this.rowVariable, rowValue);
            }
            if (this.columnLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.columnLabel;
                values[ii++] = this.dataUser.format((Variable)this.columnVariable, columnValue);
            }
            if (this.heightLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.heightLabel;
                values[ii++] = this.dataUser.format((Variable)this.heightVariable, heightValue);
            }
            if (this.colorLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.colorLabel;
                values[ii++] = this.dataUser.format((Variable)this.colorVariable, colorValue);
            }
            if (this.groupLabel != null && descriptors.length > ii && values.length > ii) {
                descriptors[ii] = this.groupLabel;
                values[ii++] = this.dataUser.format((Variable)this.groupVariable, groupValue);
            }
        }
    }

    @Override
    protected void resetClickedItems() {
        this.clickedObs = -1;
        this.clickedRow = null;
        this.clickedColumn = null;
        this.clickedHeight = null;
        this.clickedColor = null;
        this.clickedGroup = null;
    }

    public String getClickedRow(boolean formatted) {
        return ColorBar._getClickedValue(this.data, this.clickedObs, this.rowVariable, formatted ? this.dataUser : null);
    }

    public String getClickedColumn(boolean formatted) {
        return ColorBar._getClickedValue(this.data, this.clickedObs, this.columnVariable, formatted ? this.dataUser : null);
    }

    public String getClickedHeight(boolean formatted) {
        return ColorBar._getClickedValue(this.data, this.clickedObs, this.heightVariable, formatted ? this.dataUser : null);
    }

    public String getClickedColor(boolean formatted) {
        return ColorBar._getClickedValue(this.data, this.clickedObs, this.colorVariable, formatted ? this.dataUser : null);
    }

    public String getClickedGroup(boolean formatted) {
        return ColorBar._getClickedValue(this.data, this.clickedObs, this.groupVariable, formatted ? this.dataUser : null);
    }

    public Object getClickedRowValue() {
        return Visualization.getRawObject(this.data.getType(this.rowVariable), this.getClickedRow(false));
    }

    public Object getClickedColumnValue() {
        return Visualization.getRawObject(this.data.getType(this.columnVariable), this.getClickedColumn(false));
    }

    public Object getClickedHeightValue() {
        return Visualization.getRawObject(this.data.getType(this.heightVariable), this.getClickedHeight(false));
    }

    public Object getClickedColorValue() {
        return Visualization.getRawObject(this.data.getType(this.colorVariable), this.getClickedColor(false));
    }

    public Object getClickedGroupValue() {
        return Visualization.getRawObject(this.data.getType(this.groupVariable), this.getClickedGroup(false));
    }

    private void resetLegendColors() {
        int ncolors = this.mapColors.size();
        if (ncolors > 0) {
            this.colorLegendStyle.setStartColor((Color)this.mapColors.elementAt(0));
        }
        if (ncolors > 1) {
            this.colorLegendStyle.setEndColor((Color)this.mapColors.elementAt(1));
        }
    }

    private void resetMapColors() {
        int ncolors = 0;
        if (this.mapColors != null) {
            ncolors = this.mapColors.size();
        } else {
            this.mapColors = new Vector();
        }
        if (ncolors > 0) {
            this.mapColors.setElementAt(this.colorLegendStyle.getStartColor(), 0);
        } else {
            this.mapColors.addElement(this.colorLegendStyle.getStartColor());
        }
        if (ncolors > 1) {
            this.mapColors.setElementAt(this.colorLegendStyle.getEndColor(), 1);
        } else {
            this.mapColors.addElement(this.colorLegendStyle.getEndColor());
        }
    }

    @Override
    public void setColorMapping(int type, Color[] colors, float[] values) {
        super.setColorMapping(type, colors, values);
        this.resetLegendColors();
    }

    @Override
    public void setMapColors(Color[] colors) {
        super.setMapColors(colors);
        this.resetLegendColors();
    }

    @Override
    public void setMapColors(Vector mapColorsIn) {
        super.setMapColors(mapColorsIn);
        this.resetLegendColors();
    }

    @Override
    public Vector getMapColors() {
        this.resetMapColors();
        return this.mapColors;
    }

    public Object[] getPickedRowValues(boolean formatted) {
        return ColorBar.getPickedValues(formatted, this.pickList, 0, this.dataUser, this.rowVariable);
    }

    public Object[] getPickedColumnValues(boolean formatted) {
        return ColorBar.getPickedValues(formatted, this.pickList, 1, this.dataUser, this.columnVariable);
    }

    public Object[] getPickedHeightValues(boolean formatted) {
        return ColorBar.getPickedValues(formatted, this.pickList, 2, this.dataUser, this.heightVariable);
    }

    public Object[] getPickedColorValues(boolean formatted) {
        return ColorBar.getPickedValues(formatted, this.pickList, 3, this.dataUser, this.colorVariable);
    }

    public Object[] getPickedGroupValues(boolean formatted) {
        return ColorBar.getPickedValues(formatted, this.pickList, 4, this.dataUser, this.groupVariable);
    }
}

