/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.AxisLegend;
import com.sas.graphics.util.visualize.AxisStyle;
import com.sas.graphics.util.visualize.Blob;
import com.sas.graphics.util.visualize.Cityscape;
import com.sas.graphics.util.visualize.ConstantMapper;
import com.sas.graphics.util.visualize.DataModelProcessor;
import com.sas.graphics.util.visualize.DependentVariable;
import com.sas.graphics.util.visualize.DiscreteMapper;
import com.sas.graphics.util.visualize.ExtWireLegend;
import com.sas.graphics.util.visualize.IndependentVariable;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.ReverseDataDiscreteMapper;
import com.sas.graphics.util.visualize.ReverseSortedDiscreteMapper;
import com.sas.graphics.util.visualize.SegmentedBar;
import com.sas.graphics.util.visualize.SortedDiscreteMapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.TidyContinuousMapper;
import com.sas.graphics.util.visualize.Variable;
import com.sas.graphics.util.visualize.Vec3f;
import com.sas.graphics.util.visualize.View;
import com.sas.graphics.util.visualize.WireLegend;
import com.sas.lang.DoubleData;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;

public abstract class Bar
extends Cityscape
implements Serializable {
    static final long serialVersionUID = 2922798919307613349L;
    protected IndependentVariable groupVariable;
    protected AxisStyle groupLegendStyleUser;
    protected AxisStyle groupLegendStyle;
    protected transient Mapper groupMapper;
    public static final int BOX_GEOMETRY_TYPE = 0;
    public static final int CYLINDER_GEOMETRY_TYPE = 1;
    public static final int CONE_GEOMETRY_TYPE = 2;
    public static final int PRISM_GEOMETRY_TYPE = 3;
    public static final int PENTAGON_GEOMETRY_TYPE = 4;
    public static final int HEXAGON_GEOMETRY_TYPE = 5;
    public static final int OCTAGON_GEOMETRY_TYPE = 6;
    public static final int STAR_GEOMETRY_TYPE = 7;
    public static final int SIMPLE_GEOMETRY_TYPE = 8;
    protected int geometryType;
    public static final float COLUMN_GROUP_TEXT_OFFSET = 0.5f;
    private static final float DEFAULT_GEOMETRY_SIZE = 0.7f;
    protected double geometrySize;
    protected boolean absoluteSize;
    protected int absoluteGeometrySize;
    protected transient AxisLegend groupLegend;
    protected transient String[] groupValues;
    protected boolean elementHotspotsEnabled;
    protected transient Blob[] elementHotspots;
    protected boolean forceGroupLabelsHorizontal = false;
    protected boolean forceGroupLabelsVertical = false;

    public Bar() {
        this((String)null);
    }

    public Bar(String title) {
        super(title);
        this.groupVariable = new IndependentVariable();
        this.groupLegendStyle = this.groupLegendStyleUser = new AxisStyle();
        this.groupLegendStyle.grid.setVisible(false);
        this.groupLegendStyle.setValueStyle(new TextStyle(this.groupLegendStyle.getLabelStyle()));
        this.geometrySize = 0.7f;
        this.geometryType = 0;
        this.absoluteSize = false;
        this.absoluteGeometrySize = 10;
        this.elementHotspotsEnabled = false;
    }

    public Bar(Bar aBar) {
        super(aBar);
        this.groupVariable = aBar.groupVariable;
        this.groupLegendStyleUser = aBar.groupLegendStyleUser;
        this.groupLegendStyle = aBar.groupLegendStyleUser;
        this.geometrySize = aBar.geometrySize;
        this.geometryType = aBar.geometryType;
        this.absoluteSize = aBar.absoluteSize;
        this.absoluteGeometrySize = aBar.absoluteGeometrySize;
        this.elementHotspotsEnabled = aBar.elementHotspotsEnabled;
    }

    public IndependentVariable getGroupVariable() {
        return this.groupVariable;
    }

    public void setGroupVariable(IndependentVariable v) {
        if (v == null) {
            this.groupVariable = new IndependentVariable();
            this.groupVariable.setIndex(-1);
        } else {
            this.groupVariable = v;
        }
        this.resetGraphSize();
    }

    public AxisStyle getGroupLegendStyle() {
        return this.groupLegendStyleUser;
    }

    public void setGroupLegendStyle(AxisStyle aLegendStyle) {
        this.groupLegendStyleUser = aLegendStyle;
    }

    public void setForceGroupLabelsHorizontal(boolean horizontal) {
        this.forceGroupLabelsHorizontal = horizontal;
    }

    public boolean getForceGroupLabelsHorizontal() {
        return this.forceGroupLabelsHorizontal;
    }

    public void setForceGroupLabelsVertical(boolean vertical) {
        this.forceGroupLabelsVertical = vertical;
    }

    public boolean getForceGroupLabelsVertical() {
        return this.forceGroupLabelsVertical;
    }

    public int getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(int geometryTypeIn) {
        switch (geometryTypeIn) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.geometryType = geometryTypeIn;
                break;
            }
            case 2: {
                if (this instanceof SegmentedBar) break;
                this.geometryType = geometryTypeIn;
                break;
            }
        }
    }

    public double getGeometrySize() {
        return this.geometrySize;
    }

    public void setGeometrySize(double geometrySizeIn) {
        this.geometrySize = geometrySizeIn;
    }

    public boolean isAbsoluteSize() {
        return this.absoluteSize;
    }

    public void setAbsoluteSize(boolean fixed) {
        this.absoluteSize = fixed;
    }

    public int getAbsoluteGeometrySize() {
        return this.absoluteGeometrySize;
    }

    public void setAbsoluteGeometrySize(int size) {
        this.absoluteGeometrySize = size;
    }

    @Override
    public boolean validVariables(boolean checkOnly) {
        if (!super.validVariables(checkOnly)) {
            return false;
        }
        return this.dataUser.findIndex(this.groupVariable, checkOnly);
    }

    @Override
    public void resetVariables(boolean indexOnly) {
        super.resetVariables(indexOnly);
        if (this.groupVariable == null) {
            this.groupVariable = new IndependentVariable();
        } else if (this.groupVariable == this.rowVariable) {
            this.groupVariable = new IndependentVariable();
            this.groupVariable.setIndex(-1);
        } else if (indexOnly) {
            this.groupVariable.reset();
        } else {
            this.groupVariable.setAutomatic(true);
        }
    }

    @Override
    protected void validateVariables() {
        this.data.resetReferences();
        if (!this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 3);
        }
        if (!this.heightVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.heightVariable, 1);
        }
        if (this.isRiserChart()) {
            this.data.chooseVariable((Variable)this.rowVariable, 3);
            this.groupVariable.index = -1;
            this.groupVariable.indexIn = -1;
        } else {
            this.rowVariable.index = -1;
            this.rowVariable.indexIn = -1;
            if (this.groupVariable.isAutomatic()) {
                if (this.data.isDerivedFromMDDB()) {
                    this.data.chooseVariable((Variable)this.groupVariable, 2);
                } else {
                    this.groupVariable.index = -1;
                    this.groupVariable.indexIn = -1;
                }
            } else {
                this.data.chooseVariable((Variable)this.groupVariable, 3);
            }
        }
        if (this.columnVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.columnVariable, 2);
            if (this.isNoneVariable(this.columnVariable)) {
                if (this.data.isDerivedFromMDDB() && !this.isNoneVariable(this.groupVariable) && this.groupVariable.isAutomatic()) {
                    this.columnVariable.index = this.groupVariable.index;
                    this.columnVariable.indexIn = this.groupVariable.indexIn;
                    this.groupVariable.index = -1;
                    this.groupVariable.indexIn = -1;
                } else {
                    this.data.chooseVariable((Variable)this.columnVariable, 3);
                }
            }
        }
        if (this.heightVariable.isAutomatic()) {
            this.data.chooseVariable((Variable)this.heightVariable, 1);
        }
    }

    @Override
    protected void processDataModel() {
        DataModelProcessor dmp = new DataModelProcessor(this.dataUser);
        IndependentVariable[] classifiers = new IndependentVariable[2];
        if (this.isRiserChart()) {
            classifiers[0] = this.rowVariable;
            classifiers[1] = this.columnVariable;
        } else {
            classifiers[0] = this.columnVariable;
            classifiers[1] = this.groupVariable;
        }
        DependentVariable[] responses = new DependentVariable[]{this.heightVariable};
        dmp.showStatistic = this.showStatistic;
        this.data = dmp.process(classifiers, responses);
        this.resetResponseVariable(this.heightVariable);
    }

    @Override
    protected void createMappers() {
        boolean forceDiscrete = true;
        this.assignRowMapper(forceDiscrete);
        this.assignColumnMapper(forceDiscrete);
        this.assignGroupMapper();
        this.assignHeightMapper();
    }

    @Override
    protected void assignHeightMapper() {
        float Hmax;
        int nCols = this.data.getUniqueObservations(this.columnVariable, this.heightVariable);
        if (this.isNoneVariable(this.groupVariable)) {
            Hmax = (float)nCols * this.aspect;
        } else {
            int nGroups = this.data.getUniqueObservations(this.groupVariable, this.heightVariable);
            Hmax = (float)((nCols + 1) * nGroups - 1) * this.aspect;
        }
        if (this.isNoneVariable(this.heightVariable)) {
            this.heightMapper = new ConstantMapper(1, Hmax);
        } else {
            this.heightMapper = new TidyContinuousMapper(this.heightLegendStyle.getIntervals(), 0.0f, Hmax);
            if (!this.heightLegendStyle.isFixedDataRange()) {
                this.heightMapper.addValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
            }
        }
    }

    protected void assignGroupMapper() {
        if (this.isNoneVariable(this.groupVariable)) {
            this.groupMapper = new ConstantMapper(1, 0.0f);
        } else {
            switch (this.groupVariable.sort) {
                case 0: {
                    this.groupMapper = new DiscreteMapper(0.0f);
                    break;
                }
                case 1: {
                    this.groupMapper = new SortedDiscreteMapper(0.0f);
                    break;
                }
                case 2: {
                    this.groupMapper = new ReverseSortedDiscreteMapper(0.0f);
                    break;
                }
                case 3: {
                    this.groupMapper = new ReverseDataDiscreteMapper(0.0f);
                    break;
                }
            }
        }
    }

    @Override
    protected void initializeMappers() {
        int rowCount = this.data.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.data.setRow(i);
            if (this.data.isValueMissing(this.rowVariable) || this.data.isValueMissing(this.columnVariable) || this.data.isValueMissing(this.groupVariable) || this.data.isValueMissing(this.heightVariable)) continue;
            this.rowMapper.addValue(this.data.getString(this.rowVariable), this.data.getPrimaryString(this.rowVariable));
            this.heightMapper.addValue(this.data.getString(this.heightVariable));
            this.groupMapper.addValue(this.data.getString(this.groupVariable));
            this.columnMapper.addValue(this.data.getString(this.columnVariable), this.data.getPrimaryString(this.columnVariable));
        }
        this.numGroups = this.groupMapper.getIntervalCount();
    }

    @Override
    protected void addColumnLegends(Channel ch) {
        int countGroups;
        if (this.xSizeMin == this.xSizeMax) {
            return;
        }
        boolean newLegend = this.columnLegend == null;
        boolean oneRow = this.columnLegendStyle.numRows == 1;
        boolean validGroup = !this.isNoneVariable(this.groupVariable);
        int numCols = this.columnMapper.getIntervalCount() + 1;
        double maxVLegendOffset = 0.0;
        boolean staggerLabels = false;
        boolean valuesVisible = this.columnLegendStyle.isValuesVisible();
        String[] gValues = null;
        float height = this.heightMapper.getMappedValue(DoubleData.toString((double)this.heightLegendStyle.getOrigin()));
        if (validGroup) {
            gValues = this.groupMapper.getValueLabels();
            double maxLength = 0.0;
            TextStyle tempStyle = this.getGroupLegendStyle().valueStyle;
            double maxChars = tempStyle.getMaxChars();
            ch.glSelect2DFont(tempStyle.createFont());
            double tempLength = 0.0;
            if (!valuesVisible && !this.forceGroupLabelsVertical) {
                for (int i = 0; i < gValues.length; ++i) {
                    tempLength = ch.glGetTextWidth(gValues[i].trim().substring(0, Math.min((int)maxChars, gValues[i].trim().length())));
                    if (!(tempLength > maxLength)) continue;
                    maxLength = tempLength;
                }
                if (maxLength > (double)this.columnMapper.getIntervalCount() + 0.5) {
                    staggerLabels = true;
                }
            }
        }
        String[] values = this.columnMapper.getValueLabels();
        String[] primaryValues = this.columnMapper.getPrimaryValueLabels();
        String[] formattedValues = this.dataUser.format((Variable)this.columnVariable, values);
        if (formattedValues == null) {
            formattedValues = values;
        }
        if (this.depth == 2) {
            ExtWireLegend legend;
            if (newLegend) {
                legend = new ExtWireLegend(this.columnMapper);
                this.columnLegend = legend;
                legend.labelStyle = validGroup ? this.getGroupLegendStyle().valueStyle : this.columnLegendStyle.labelStyle;
                legend.labelPosition = 1;
                this.columnLegend.intervals = this.columnMapper.getIntervalCount();
                this.columnLegend.valuesVisible = this.columnLegendStyle.valuesVisible;
                if (this.columnLegendStyle.numRows == 0) {
                    this.columnLegend.valueStyle = this.columnLegendStyle.valueStyle;
                } else {
                    TextStyle ts = new TextStyle(this.columnLegendStyle.valueStyle);
                    FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                    int charWidth = fm.stringWidth("W");
                    int blankSpaces = fm.stringWidth("W") * this.columnLegend.intervals;
                    if (this.columnLegendStyle.numRows == 1) {
                        ts.maxChars = (this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals);
                        if (ts.maxChars < ts.minChars) {
                            ts.maxChars = ts.minChars;
                        }
                        this.columnLegend.oneRow = true;
                    } else {
                        ts.maxChars = Math.max(ts.minChars, (2 * this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals));
                    }
                    this.columnLegend.valueStyle = ts;
                }
                legend.allFormattedValues = formattedValues;
            } else {
                legend = (ExtWireLegend)this.columnLegend;
            }
            boolean column = true;
            if (this.view.tilt + this.view.dTilt <= 0.0) {
                this.setNegTiltLegend(legend, oneRow);
            } else {
                this.setPosTiltLegend(legend, column, oneRow);
            }
        } else if (newLegend) {
            this.columnLegend = new WireLegend(this.columnMapper);
            this.columnLegend.origin = new Vec3f(this.xPadding + this.xSizeMin, this.ySizeMin, -this.zSizeMin);
            this.columnLegend.endVector = new Vec3f(0.0f, this.ySize + 2.0f * this.yPadding, 0.0f);
            this.columnLegend.labelStyle = this.columnLegendStyle.labelStyle;
            this.columnLegend.labelStyle = validGroup ? this.getGroupLegendStyle().valueStyle : this.columnLegendStyle.labelStyle;
            this.columnLegend.labelPosition = 1;
            this.columnLegend.intervals = this.columnMapper.getIntervalCount();
            this.columnLegend.valuesVisible = this.columnLegendStyle.valuesVisible;
            if (this.columnLegendStyle.numRows == 0) {
                this.columnLegend.valueStyle = this.columnLegendStyle.valueStyle;
            } else {
                TextStyle ts = new TextStyle(this.columnLegendStyle.valueStyle);
                FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(ts.createFont());
                int charWidth = fm.stringWidth("Z");
                int blankSpaces = fm.stringWidth("  ") * this.columnLegend.intervals;
                if (this.columnLegendStyle.numRows == 1) {
                    ts.maxChars = (this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals);
                    if (ts.maxChars < ts.minChars) {
                        ts.maxChars = ts.minChars;
                    }
                    this.columnLegend.oneRow = true;
                } else {
                    ts.maxChars = Math.max(ts.minChars, (2 * this.xSizePixels - blankSpaces) / (charWidth * this.columnLegend.intervals));
                }
                this.columnLegend.valueStyle = ts;
            }
            this.columnLegend.valueStyle.setJustify("CENTER", "TOP");
            this.columnLegend.labelStyle.setJustify("CENTER", "TOP");
        } else {
            this.columnLegend.origin.x = this.xSizeMin;
            this.columnLegend.origin.y = this.ySizeMin;
            this.columnLegend.origin.z = -this.zSizeMin;
            this.columnLegend.endVector.y = this.ySize + 2.0f * this.yPadding;
        }
        if (newLegend) {
            Vec3f incrementVector;
            Color geomColor;
            this.columnLegend.geomColor = geomColor = this.columnLegendStyle.grid.color;
            this.columnLegend.incrementVector = incrementVector = new Vec3f(1.0f, 0.0f, 0.0f);
            this.columnLegend.valuesVisible = this.columnLegendStyle.isValuesVisible();
            if (validGroup || this.columnLegendStyle.isHideLabel()) {
                this.columnLegend.setLabel(null);
            } else {
                this.columnLegend.setLabel(this.data.getDisplayLabel(this.columnVariable), this.data.getPrimaryLabel(this.columnVariable));
            }
        }
        if (this.isRiserChart() || this.depth == 2) {
            this.columnLegend.threeDAxis = true;
            this.columnLegend.xSize = this.xSize;
            this.columnLegend.ySize = this.ySize;
            this.columnLegend.zSize = this.zSize;
        }
        this.columnLegend.intervals = values.length;
        this.columnLegend.values = values;
        this.columnLegend.primaryValues = primaryValues;
        this.columnLegend.formattedValues = formattedValues;
        this.columnLegend.startingOffset = this.xSizeMin % (float)numCols;
        int min = (int)Math.floor(this.xSizeMin / (float)numCols);
        int max = (int)Math.ceil((double)(this.xSizeMax / (float)numCols) + 0.001);
        boolean oneGroup = max == min + 1;
        this.columnLegend.origin.x = this.xPadding + this.xSizeMin;
        this.columnValueHotspots = null;
        if (this.isColumnValueHotspotsEnabled()) {
            countGroups = max - min;
            int countCategories = countGroups * values.length;
            this.columnValueHotspots = new Blob[countCategories];
        }
        this.groupValueHotspots = null;
        if (validGroup && this.isGroupValueHotspotsEnabled()) {
            countGroups = max - min;
            this.groupValueHotspots = new Blob[countGroups];
        }
        this.columnVariableHotspot = null;
        for (int i = min; i < max; ++i) {
            Blob[] labelHotspots;
            int j;
            if (oneGroup) {
                ((WireLegend)this.columnLegend).firstGridLineVisible = true;
                ((WireLegend)this.columnLegend).lastGridLineVisible = true;
                if (this.xSize != this.numColumns) {
                    this.columnLegend.intervals = (int)this.xSize;
                    String[] columnValues = new String[(int)this.xSize];
                    String[] primaryColumnValues = new String[(int)this.xSize];
                    String[] formColValues = new String[(int)this.xSize];
                    int ms = values.length;
                    int pos = 0;
                    int colMin = (int)this.xSizeMin % numCols;
                    int colMax = (int)((float)colMin + this.xSize);
                    for (j = 0; j < ms; ++j) {
                        float val = this.columnMapper.getMappedValue(values[j]);
                        if (val < (float)colMin || val >= (float)colMax) continue;
                        columnValues[pos] = values[j];
                        primaryColumnValues[pos] = primaryValues[j];
                        formColValues[pos] = formattedValues[j];
                        ++pos;
                    }
                    this.columnLegend.values = columnValues;
                    this.columnLegend.primaryValues = primaryColumnValues;
                    this.columnLegend.formattedValues = formColValues;
                }
            } else if (i == min) {
                int startCol = (int)(this.xSizeMin % (float)numCols);
                if (startCol == numCols - 1) {
                    this.columnLegend.values = values;
                    this.columnLegend.primaryValues = primaryValues;
                    this.columnLegend.formattedValues = formattedValues;
                    this.columnLegend.origin.x += 1.0f;
                    this.columnLegend.intervals = values.length;
                    this.columnLegend.startingOffset = 0.0f;
                    continue;
                }
                if (startCol > 0) {
                    int curSize = numCols - startCol - 1;
                    int colMin = (int)(this.xSizeMin % (float)numCols);
                    this.columnLegend.intervals = curSize;
                    String[] columnValues = new String[curSize];
                    String[] primaryColumnValues = new String[curSize];
                    String[] formColValues = new String[curSize];
                    int ms = values.length;
                    int pos = 0;
                    for (int j2 = 0; j2 < ms; ++j2) {
                        float val = this.columnMapper.getMappedValue(values[j2]);
                        if (val < (float)colMin) continue;
                        columnValues[pos] = values[j2];
                        primaryColumnValues[pos] = primaryValues[j2];
                        formColValues[pos] = formattedValues[j2];
                        ++pos;
                    }
                    this.columnLegend.values = columnValues;
                    this.columnLegend.primaryValues = primaryColumnValues;
                    this.columnLegend.formattedValues = formColValues;
                }
                ((WireLegend)this.columnLegend).firstGridLineVisible = true;
                ((WireLegend)this.columnLegend).lastGridLineVisible = false;
            } else if (i == max - 1) {
                int endCol = (int)(this.xSizeMax % (float)numCols);
                if (endCol == 0) continue;
                if (endCol < numCols - 1) {
                    int curSize;
                    this.columnLegend.intervals = curSize = endCol;
                    String[] columnValues = new String[curSize];
                    String[] primaryColumnValues = new String[curSize];
                    String[] formColValues = new String[curSize];
                    int ms = values.length;
                    int pos = 0;
                    for (j = 0; j < ms; ++j) {
                        float val = this.columnMapper.getMappedValue(values[j]);
                        if (val >= (float)endCol) continue;
                        columnValues[pos] = values[j];
                        primaryColumnValues[pos] = primaryValues[j];
                        formColValues[pos] = formattedValues[j];
                        ++pos;
                    }
                    this.columnLegend.values = columnValues;
                    this.columnLegend.primaryValues = primaryColumnValues;
                    this.columnLegend.formattedValues = formColValues;
                }
                ((WireLegend)this.columnLegend).firstGridLineVisible = false;
                ((WireLegend)this.columnLegend).lastGridLineVisible = true;
            } else {
                ((WireLegend)this.columnLegend).firstGridLineVisible = false;
                ((WireLegend)this.columnLegend).lastGridLineVisible = false;
            }
            this.columnLegend.setValueHotspotsEnabled(this.isColumnValueHotspotsEnabled());
            this.columnLegend.setValueHotspotID(1);
            if (validGroup) {
                this.columnLegend.setLabelValueHotspotsEnabled(this.isColumnValueHotspotsEnabled());
                this.columnLegend.setLabelHotspotID(2);
                this.columnLegend.setLabel(null);
                for (int ii = 0; ii < gValues.length; ++ii) {
                    if ((float)i != this.groupMapper.getMappedValue(gValues[ii])) continue;
                    this.columnLegend.setLabel(gValues[ii]);
                    break;
                }
            } else {
                this.columnLegend.setLabelHotspotsEnabled(this.isVariableHotspotsEnabled());
                this.columnLegend.setLabelHotspotID(1);
            }
            if (validGroup && staggerLabels) {
                if (i % 2 == min % 2) {
                    this.columnLegend.setLabelStagger(false);
                } else {
                    this.columnLegend.setLabelStagger(true);
                }
            }
            if (validGroup && this.forceGroupLabelsVertical) {
                this.columnLegend.rotAngleLabel = 90;
                this.columnLegend.labelPosition = 4;
            } else {
                this.columnLegend.rotAngleLabel = 0;
            }
            if (this.simpleGeometry && !this.data.isContinuous(this.columnVariable)) {
                this.columnLegend.addLegend(ch, false);
            } else {
                this.columnLegend.addLegend(ch, this.columnLegendStyle.grid.visible);
            }
            if (validGroup && staggerLabels) {
                this.columnLegend.vLegendOffset += this.columnLegend.labelHeight;
            }
            Blob[] valueHotspots = this.columnLegend.getValueHotspots();
            if (this.columnValueHotspots != null && valueHotspots != null) {
                int currentIndex = i * values.length;
                for (int ii = 0; ii < valueHotspots.length; ++ii) {
                    this.columnValueHotspots[currentIndex + ii] = valueHotspots[ii];
                }
            }
            if ((labelHotspots = this.columnLegend.getLabelHotspots()) != null) {
                if (this.groupValueHotspots != null) {
                    this.groupValueHotspots[i] = labelHotspots[0];
                } else {
                    this.columnVariableHotspot = labelHotspots[0];
                }
            }
            if (i == min) {
                this.columnLegend.values = values;
                this.columnLegend.primaryValues = primaryValues;
                this.columnLegend.formattedValues = formattedValues;
                this.columnLegend.origin.x += (float)(this.columnLegend.intervals + 1);
                this.columnLegend.intervals = values.length;
                this.columnLegend.startingOffset = 0.0f;
            } else {
                this.columnLegend.origin.x += (float)(this.columnLegend.intervals + 1);
            }
            maxVLegendOffset = Math.max(maxVLegendOffset, (double)this.columnLegend.vLegendOffset);
        }
        if (this.columnLegend.vLegendOffset > 0.0f) {
            this.yMinLegendSize = (float)((double)this.yMinLegendSize + Math.max((double)this.columnLegend.vLegendOffset, maxVLegendOffset));
        } else {
            this.xMinLegendSize += this.columnLegend.hLegendOffset;
        }
        this.distortX *= this.geometrySize;
        this.distortY *= this.geometrySize;
    }

    @Override
    protected void scaleText(Channel ch) {
        super.scaleText(ch);
        TextStyle ts = this.getGroupLegendStyle().getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
        ts = this.getGroupLegendStyle().getValueStyle();
        ts.curSize = ts.isScalable() ? ts.getSize() + ts.getSizeRange() * this.scaleFactor : ts.getSize();
    }

    @Override
    protected void setProjection(Channel ch) {
        if (!this.validVisualization) {
            return;
        }
        if (this.depth == 2) {
            this.computeView(ch);
            ch.gluPerspective(this.view.fov, this.view.aspect, View.MIN_DISTANCE, View.MAX_DISTANCE);
            return;
        }
        double yfac = this.ySize / (float)this.ySizePixels;
        double xMin = -this.xMinLegendSize;
        double xMax = this.xSize + this.xMaxLegendSize;
        double yMin = (double)(-this.yMinLegendSize) - (double)this.yColorLegendSize * yfac;
        double yMax = (double)(this.ySize + this.yMaxLegendSize) + (double)this.yTitleSize * yfac;
        double xIndent = (double)0.03f * (xMax - xMin);
        double yIndent = (double)0.03f * (yMax - yMin);
        if (this.depth == 0) {
            ch.glOrtho(xMin - xIndent, xMax + xIndent, yMin - yIndent, yMax + yIndent, -1000.0, 1000.0);
        } else {
            double distort = 0.5;
            double alpha = 0.2;
            xIndent = 0.05 * (xMax + distort * (double)this.zSize - xMin);
            yIndent = 0.04 * (yMax + distort * (double)this.zSize - yMin);
            ch.glOblique(xMin - xIndent - distort * (double)this.zSize * alpha, xMax + xIndent + distort * (double)this.zSize * (1.0 - alpha), yMin - yIndent - distort * (double)this.zSize * alpha, yMax + yIndent + distort * (double)this.zSize * (1.0 - alpha), -100.0, 100.0, distort, 45.0);
        }
    }

    @Override
    protected void setGeometryProjection(Channel ch) {
        if (this.depth != 1 || this.geometryType == 0) {
            return;
        }
        if (this.isRiserChart()) {
            return;
        }
        double yfac = this.ySize / (float)this.ySizePixels;
        double xMin = -this.xMinLegendSize;
        double xMax = this.xSize + this.xMaxLegendSize;
        double yMin = (double)(-this.yMinLegendSize) - (double)this.yColorLegendSize * yfac;
        double yMax = (double)(this.ySize + this.yMaxLegendSize) + (double)this.yTitleSize * yfac;
        double distort = Math.sin(0.7853981633974483);
        double alpha = 0.2;
        double dx = xMax + distort - xMin;
        double dy = yMax + distort - yMin;
        double xIndent = 0.05 * dx;
        double yIndent = 0.04 * dy;
        double angle = 90.0;
        ch.glOblique(xMin - xIndent - distort * alpha, xMax + xIndent + distort * (1.0 - alpha), yMin - yIndent - distort * alpha, yMax + yIndent + distort * (1.0 - alpha), -100.0, 100.0, distort * distort, angle);
    }

    @Override
    public synchronized void showChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        if (!this.transparent) {
            ch.clearBGC();
        } else {
            ch.copyBuffer(2);
        }
        if (this.validVisualization) {
            boolean resetProj = this.dirty && this.depth == 1 && this.geometryType != 0;
            ch.glCallList(0L, this.dirty);
            ch.glCallList(8L, this.dirty);
            ch.glCallList(9L, this.dirty);
            if (this.clipReferenceLine) {
                ch.glCallList(10L, this.dirty);
            }
            if (resetProj) {
                this.setGeometryProjection(ch);
            }
            ch.glEnable(4);
            ch.glCallList(3L, this.dirty);
            ch.glDisable(4);
            if (!this.clipReferenceLine) {
                ch.glCallList(10L, this.dirty);
            }
            this.setStandardView(ch);
            ch.glCallList(1L, this.dirty);
        }
        this.setStandardView(ch);
        ch.glCallList(2L, this.dirty);
        ch.glCallList(7L, this.dirty);
        ch.glRefresh(g);
        this.dirty = false;
        this.setFinalView(ch);
    }

    @Override
    public synchronized void drawChart(Channel ch, Graphics g) {
        if (ch == null || !this.buildDone) {
            return;
        }
        this.width = ch.getWidth();
        this.height = ch.getHeight();
        this.setViewport(ch);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.width, this.height);
        if (this.validVisualization) {
            boolean resetProj = this.dirty && this.depth == 1 && this.geometryType != 0;
            ch.glCallList(g, 0L, this.dirty);
            ch.glCallList(g, 8L, this.dirty);
            if (this.clipReferenceLine) {
                ch.glCallList(g, 10L, this.dirty);
            }
            if (resetProj) {
                this.setGeometryProjection(ch);
            }
            ch.glCallList(g, 3L, this.dirty);
            if (!this.clipReferenceLine) {
                ch.glCallList(g, 10L, this.dirty);
            }
            this.setStandardView(ch);
            ch.glCallList(g, 1L, this.dirty);
        }
        this.setStandardView(ch);
        ch.glCallList(g, 2L, this.dirty);
        ch.glCallList(g, 7L, this.dirty);
        this.dirty = false;
        this.setFinalView(ch);
    }

    @Override
    protected void addZeroReferenceLines(Channel ch) {
        double x0 = this.columnLegendStyle.getOrigin();
        double y0 = this.heightLegendStyle.getOrigin();
        double zeroY = (double)this.heightMapper.getMappedValue("0") - y0;
        if (zeroY == 0.0) {
            return;
        }
        double xxSize = this.xSize + 2.0f * this.xPadding;
        double yySize = this.ySize + 2.0f * this.yPadding;
        double zzSize = this.zSize + 2.0f * this.zPadding;
        ch.glColor(this.heightLegendStyle.getGrid().getColor());
        ch.glBegin(1);
        ch.glVertex(x0, zeroY, 0.0);
        ch.glVertex(x0 + xxSize, zeroY, 0.0);
        ch.glVertex(x0 + xxSize, zeroY, -zzSize);
        ch.glEnd();
    }

    @Override
    public void setElementHotspotsEnabled(boolean flag) {
        this.elementHotspotsEnabled = flag;
    }

    @Override
    public boolean isElementHotspotsEnabled() {
        return this.elementHotspotsEnabled;
    }

    @Override
    public Blob[] getElementHotspots() {
        return this.elementHotspots;
    }

    @Override
    protected void addObservations(Channel ch) {
        this.addObservations(ch, true);
    }

    protected abstract void addObservations(Channel var1, boolean var2);

    @Override
    protected void addElementHotspots(Channel ch) {
        if (this.isElementHotspotsEnabled()) {
            this.addObservations(ch, false);
        }
    }
}

