/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.visualize;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.visualize.Legend;
import com.sas.graphics.util.visualize.Mapper;
import com.sas.graphics.util.visualize.TextStyle;
import com.sas.graphics.util.visualize.Vec3f;
import java.awt.Color;

public abstract class AxisLegend
extends Legend {
    protected static final int LABEL_BEGIN_ALIGN = 0;
    protected static final int LABEL_MIDDLE_ALIGN = 1;
    protected static final int LABEL_END_ALIGN = 2;
    protected static final int LABEL_END_GROUP_ALIGN_H = 3;
    protected static final int LABEL_END_GROUP_ALIGN_V = 4;
    private static final Vec3f incrementVectorDefault = new Vec3f(Vec3f.xAxis);
    private static final Vec3f endVectorDefault = new Vec3f(Vec3f.zAxis);
    private static final Color colorDefault = Color.black;
    private static final String justifyDefault = "CENTER";
    public Vec3f incrementVector = incrementVectorDefault;
    public Vec3f endVector = endVectorDefault;
    public String label;
    protected String primaryLabel;
    public TextStyle labelStyle = new TextStyle();
    public int labelPosition = 1;
    protected float labelHeight;
    protected boolean lastGridLineVisible = true;
    protected boolean oneRow = false;
    protected double distortX;
    protected int rotAngle = 0;
    protected int rotAngleLabel = 0;
    protected float labelLoc = 0.0f;
    protected boolean threeDAxis = false;
    protected double xSize = 1.0;
    protected double ySize = 1.0;
    protected double zSize = 1.0;
    protected float startingOffset = 0.0f;
    protected float vLabelOffset = 0.0f;
    protected float hLabelOffset = 0.0f;
    protected boolean labelStagger = false;

    public AxisLegend(Mapper aMapper) {
        super(aMapper);
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
        this.primaryLabel = null;
    }

    public void setLabel(String aLabel, String aPrimaryLabel) {
        this.label = aLabel;
        this.primaryLabel = aPrimaryLabel;
    }

    public void setLabelStagger(boolean stagger) {
        this.labelStagger = stagger;
    }

    public void setIntervals(int count) {
        this.intervals = count;
    }

    public void setStyles(TextStyle aValueStyle, TextStyle aLabelStyle) {
        this.valueStyle = aValueStyle;
        this.labelStyle = aLabelStyle;
    }

    public void setLabelStyles(TextStyle aLabelStyle) {
        this.labelStyle = aLabelStyle;
    }

    public TextStyle getLabelStyles() {
        return this.labelStyle;
    }

    public void scaleIncrementVector(float factor) {
        this.incrementVector.normalize();
        this.incrementVector.scale(factor);
    }

    public void setColors(Color aValuesColor, Color aLabelColor) {
        this.valueStyle.setColor(aValuesColor);
        this.labelStyle.setColor(aLabelColor);
    }

    @Override
    public void addLegend(Channel ch, boolean visible) {
        super.addLegend(ch, visible);
        ch.glSelect2DFont(this.labelStyle.createFont());
        this.labelHeight = (float)ch.glGetTextHeight();
        this.addLabel(ch, this.origin, this.labelStyle.getMajorJustify(), this.labelStyle.getMinorJustify(), true);
    }

    @Override
    protected void addValues(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify) {
        boolean skip;
        int inc;
        float len;
        boolean toggle = true;
        int valuesMaxChars = this.valueStyle.getMaxChars();
        ch.glSelect2DFont(this.valueStyle.createFont());
        ch.glColor(this.valueStyle.getColor());
        if (majorJustify.equals(justifyDefault)) {
            len = this.findMaxValueLength(ch, !this.continuous);
            if (this.oneRow) {
                inc = (int)Math.ceil(Math.ceil(len) / (double)this.incrementVector.x);
                this.vLegendOffset = (float)((double)this.vLegendOffset + ((double)this.tickSize + ch.glGetTextHeight()));
                skip = true;
            } else if (len > this.incrementVector.x) {
                inc = (int)Math.ceil(Math.ceil(len) / (double)(2.0f * this.incrementVector.x));
                this.vLegendOffset = (float)((double)this.vLegendOffset + ((double)this.tickSize + 2.0 * ch.glGetTextHeight()));
                skip = true;
            } else {
                inc = 1;
                this.vLegendOffset = (float)((double)this.vLegendOffset + ((double)this.tickSize + ch.glGetTextHeight()));
                skip = false;
            }
        } else {
            len = this.findMaxValueLength(ch, false);
            this.hLegendOffset += len;
            if (this.valueHeight > this.incrementVector.y) {
                inc = (int)Math.ceil(this.valueHeight / this.incrementVector.y);
                skip = true;
            } else {
                inc = 1;
                skip = false;
            }
        }
        for (int i = 0; i < this.values.length; ++i) {
            int yunits;
            Vec3f currentPoint = new Vec3f(startPoint);
            Vec3f increment = new Vec3f(this.incrementVector);
            if (this.continuous) {
                increment.normalize();
            }
            increment.scale(this.mapper.getMappedValue(this.values[i]));
            currentPoint.add(increment);
            if (majorJustify.equals("LEFT")) {
                yunits = this.continuous ? (int)((double)(currentPoint.y / this.incrementVector.y) + 0.5) : (int)(((double)currentPoint.y - 0.5) / (double)this.incrementVector.y);
                if (skip && yunits % inc != 0) continue;
                ch.glTextAlign(0, 2);
                ch.gl2DText(this.formattedValues[i].trim(), currentPoint.x, currentPoint.y, currentPoint.z);
                continue;
            }
            if (majorJustify.equals("RIGHT")) {
                yunits = this.continuous ? (int)((double)(currentPoint.y / this.incrementVector.y) + 0.5) : (int)(((double)currentPoint.y - 0.5) / (double)this.incrementVector.y);
                if (skip && yunits % inc != 0) continue;
                ch.glBegin(1);
                ch.glVertex(currentPoint.x - this.tickSize, currentPoint.y, currentPoint.z);
                ch.glVertex(currentPoint.x, currentPoint.y, currentPoint.z);
                ch.glEnd();
                ch.glTextAlign(2, 1);
                ch.gl2DText(this.formattedValues[i].trim(), (double)currentPoint.x - 1.5 * (double)this.tickSize, currentPoint.y, currentPoint.z);
                continue;
            }
            int xunits = this.continuous ? (int)((double)((currentPoint.x - startPoint.x) / this.incrementVector.x) + 0.5) : (int)(((double)(currentPoint.x - startPoint.x) - 0.5) / (double)this.incrementVector.x);
            if (xunits % inc != 0) continue;
            toggle = !skip ? true : xunits / inc % 2 == 0;
            ch.glBegin(1);
            ch.glVertex(currentPoint.x, currentPoint.y, currentPoint.z);
            ch.glVertex(currentPoint.x, currentPoint.y - this.tickSize, currentPoint.z);
            ch.glEnd();
            currentPoint.y = toggle ? (currentPoint.y -= this.tickSize) : (currentPoint.y -= this.tickSize + this.valueHeight);
            ch.glTextAlign(1, 0);
            if (!this.continuous) {
                String str = this.formattedValues[i].trim();
                if (str.length() > valuesMaxChars) {
                    int index = AxisLegend.ClippingIndex(str, valuesMaxChars);
                    str = index != 0 ? str.substring(0, index) : str.substring(0, valuesMaxChars);
                }
                ch.gl2DText(str, currentPoint.x, currentPoint.y, currentPoint.z);
                continue;
            }
            ch.gl2DText(this.formattedValues[i].trim(), currentPoint.x, currentPoint.y, currentPoint.z);
        }
    }

    protected void addLabel(Channel ch, Vec3f startPoint, String majorJustify, String minorJustify, boolean flipEndDirection) {
        if (this.label != null) {
            ch.glSelect2DFont(this.labelStyle.createFont());
            Vec3f location = new Vec3f(startPoint);
            Vec3f vec = new Vec3f(this.incrementVector);
            if (this.labelPosition == 1) {
                vec.scale((float)this.intervals / 2.0f);
                location.add(vec);
                vec = new Vec3f(this.endVector);
                vec.normalize();
                if (flipEndDirection) {
                    vec.scale(-1.0f);
                }
                vec.scale(this.vLegendOffset);
                location.add(vec);
                this.vLegendOffset += this.labelHeight;
            } else {
                if (ch.glGetTextWidth(this.label.trim().substring(0, Math.min(this.labelStyle.getMaxChars(), this.label.trim().length()))) / 2.0 > (double)this.hLegendOffset) {
                    this.hLegendOffset = (float)ch.glGetTextWidth(this.label.trim().substring(0, Math.min(this.labelStyle.getMaxChars(), this.label.trim().length()))) / 2.0f;
                }
                this.vLegendOffset = this.valueHeight / 2.0f + this.labelHeight;
                vec.scale(this.intervals);
                location.add(vec);
                vec = new Vec3f(this.incrementVector);
                vec.normalize();
                vec.scale(this.valueHeight / 2.0f);
                vec.z += -1.0f;
                location.add(vec);
            }
            ch.glColor(this.labelStyle.getColor());
            if (majorJustify.equals("BEGIN")) {
                ch.glTextAlign(0, 2);
            } else if (majorJustify.equals("END")) {
                ch.glTextAlign(2, 2);
            } else if (this.labelPosition == 1) {
                ch.glTextAlign(1, 0);
            } else {
                ch.glTextAlign(1, 3);
            }
            ch.gl2DText(this.label.trim().substring(0, Math.min(this.labelStyle.getMaxChars(), this.label.trim().length())), location.x, location.y, location.z);
        }
    }

    protected float findMaxLength(Channel ch, boolean clip) {
        return this.findMaxValueLength(ch, clip);
    }

    protected String findLongestValueString(Channel ch, boolean clip) {
        String longestString = " ";
        int maxChars = this.valueStyle.getMaxChars();
        if (this.formattedValues.length > 0) {
            longestString = clip ? this.truncateString(this.formattedValues[0], maxChars) : this.formattedValues[0].trim();
        }
        for (int i = 1; i < this.values.length; ++i) {
            String str;
            double longestStringWidthInPixels = ch.glGetTextWidth(longestString);
            if (clip) {
                str = this.truncateString(this.formattedValues[i], maxChars);
                if (str.length() <= longestString.length() && !(ch.glGetTextWidth(str) > longestStringWidthInPixels)) continue;
                longestString = str;
                continue;
            }
            str = this.formattedValues[i].trim();
            if (str.length() <= longestString.length() && !(ch.glGetTextWidth(str) > longestStringWidthInPixels)) continue;
            longestString = new String(str);
        }
        return longestString;
    }

    protected String truncateString(String str, int maxChars) {
        int numChars = 0;
        if ((str = str.trim()).length() <= maxChars) {
            return str;
        }
        String appendString = new String("...");
        int lastWordIndex = str.lastIndexOf(" ") + 1;
        numChars = maxChars - appendString.length();
        int sizeOfLastWord = str.length() - lastWordIndex;
        appendString = sizeOfLastWord < numChars ? appendString.concat(str.substring(lastWordIndex)) : appendString.concat(str.substring(lastWordIndex + (sizeOfLastWord - numChars + 2)));
        numChars = maxChars - appendString.length();
        String truncatedString = str.substring(0, numChars);
        truncatedString = truncatedString.concat(appendString);
        return truncatedString;
    }
}

