/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.jxd.Attribute;
import com.sas.graphics.util.jxd.AttributeStackFrame;
import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.BillBoardImage;
import com.sas.graphics.util.jxd.Capability;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.ClipBounds;
import com.sas.graphics.util.jxd.ColorGradient;
import com.sas.graphics.util.jxd.CustomMarkerInterface;
import com.sas.graphics.util.jxd.DisplayList;
import com.sas.graphics.util.jxd.EdgeColor;
import com.sas.graphics.util.jxd.FillColor;
import com.sas.graphics.util.jxd.J3Line;
import com.sas.graphics.util.jxd.J3Point;
import com.sas.graphics.util.jxd.J3Polygon;
import com.sas.graphics.util.jxd.J3Rectangle;
import com.sas.graphics.util.jxd.LightManager;
import com.sas.graphics.util.jxd.LineCapStyle;
import com.sas.graphics.util.jxd.LineWidth;
import com.sas.graphics.util.jxd.ListName;
import com.sas.graphics.util.jxd.ListReference;
import com.sas.graphics.util.jxd.Marker;
import com.sas.graphics.util.jxd.MarkerSize;
import com.sas.graphics.util.jxd.MarkerType;
import com.sas.graphics.util.jxd.NameTree;
import com.sas.graphics.util.jxd.Point4;
import com.sas.graphics.util.jxd.PointSize;
import com.sas.graphics.util.jxd.PolygonMode;
import com.sas.graphics.util.jxd.Primitive;
import com.sas.graphics.util.jxd.RasterText;
import com.sas.graphics.util.jxd.Ray;
import com.sas.graphics.util.jxd.ScanConvert;
import com.sas.graphics.util.jxd.Shape;
import com.sas.graphics.util.jxd.SoftGraphics;
import com.sas.graphics.util.jxd.Solid;
import com.sas.graphics.util.jxd.Stipple;
import com.sas.graphics.util.jxd.TexEnv;
import com.sas.graphics.util.jxd.TexImage;
import com.sas.graphics.util.jxd.TransInfo;
import com.sas.graphics.util.jxd.VertexSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class State {
    private static final Font defaultFont = new Font("sansserif", 0, 12);
    Point4 pt1 = new Point4();
    Point4 pt2 = new Point4();
    Point4 pt3 = new Point4();
    Point4 pt4 = new Point4();
    Point4 pt5 = new Point4();
    Point4 pt6 = new Point4();
    Point4[] ptArray = new Point4[4];
    ScanConvert.InterpolatedVertex vScanLeft = new ScanConvert.InterpolatedVertex();
    ScanConvert.InterpolatedVertex vScanRight = new ScanConvert.InterpolatedVertex();
    ScanConvert.Appearance appearance = new ScanConvert.Appearance();
    Graphics softGraphics = SoftGraphics.newSoftGraphics(this);
    ScanConvert scanConvert = new ScanConvert();
    Rectangle rt1 = new Rectangle();
    Rectangle rt2 = new Rectangle();
    Polygon tempPolygon = new Polygon();
    Ray tempRay = new Ray();
    Vector tempVector = new Vector();
    Image textBuffer;
    double[] tempTextWidth;
    double[] tempRasterInfo;
    double[] scratchDouble2 = new double[2];
    int currentPrimitiveMode;
    int[] scratchInt = new int[5];
    int[] scratchInt2 = new int[5];
    ReusableDouble scratchKey = new ReusableDouble();
    long greatestListName = -1L;
    int[] stippleHistory = new int[2];
    int[] stipplePattern;
    int depthTestAlgorithm = 2;
    boolean isZBufferingOn;
    static final int attribStackSize = 128;
    int attribStackTop = 0;
    AttributeStackFrame attribTop;
    AttributeStackFrame[] attribStack;
    protected boolean[] capabilities;
    Channel ch;
    Color color;
    float alpha;
    Color edgecolor;
    int cullface;
    int winding;
    int fillmode;
    Point4 normal;
    VertexSet pbuffer = null;
    Hashtable displayList = new Hashtable();
    DisplayList openDisplayList = null;
    int render_mode;
    LightManager lightMgr;
    float pointSize;
    int lineWidth;
    int capStyle;
    int[] wideLineX = new int[4];
    int[] wideLineY = new int[4];
    Color[] wideLineColor = new Color[4];
    float[] wideLineAlpha = new float[4];
    boolean edgeFlag = true;
    Vector fontMetricCache = new Vector();
    Point4 extrusionVector = new Point4(0.0, 0.0, 0.0, 0.0);
    Solid solid;
    int shadeModel = 0;
    int markerType = 1;
    int markerSize = 10;
    Vector customMarkers = null;
    int markerIdLast = 188;
    Stack selectbuffer;
    boolean hit;
    Primitive phit;
    Vector pickList = new Vector();
    Vector namePath = new Vector();
    Rectangle aperture = new Rectangle();
    NameTree nameRoot;
    NameTree currentName = this.nameRoot = new NameTree(null, null);
    private static final int nameStackSize = 1280;
    private int nameStackTop = 0;
    Object[] nameStack = new Object[1280];
    Vector feedbackBuffer;
    int feedbackType;
    Font font;
    int halign;
    int valign;
    Object affineTransform;
    static Image waitImage;
    Bbox clipBbox;
    Rectangle clipRect;
    static final int ARRAY_INCREMENT_SIZE = 64;
    int[] intarray;
    int[] swap = new int[64];
    Vector sortList;
    boolean sorted;
    int[] index;
    int sortsize;
    Image texImage;
    int texWrapS;
    int[] tempPixels;
    int texEnvMode;
    int texEnvStyle;
    int shadowOffsetX = 2;
    int shadowOffsetY = 2;
    float shadowTransparency = 0.5f;
    float shadowSoftness = 0.0f;
    Color shadowColor = Color.darkGray;
    J3Polygon polygonBuffer = new J3Polygon();
    J3Line lineBuffer = new J3Line();
    J3Point pointBuffer = new J3Point();
    J3Rectangle rectangleBuffer = new J3Rectangle();
    RasterText rasterTextBuffer;
    RasterText rasterTextBufferJava1 = null;
    RasterText rasterTextBufferJava2 = null;
    Marker markerBuffer = new Marker();
    static boolean isJava2;

    State(Channel ch) {
        int i;
        this.normal = new Point4(0.0, 0.0, 1.0, 0.0);
        this.ch = ch;
        this.font = defaultFont;
        this.capabilities = new boolean[16];
        this.capabilities[0] = false;
        this.capabilities[1] = true;
        this.capabilities[2] = false;
        this.capabilities[3] = true;
        this.capabilities[4] = true;
        this.capabilities[8] = false;
        this.capabilities[9] = false;
        this.capabilities[12] = false;
        this.capabilities[11] = false;
        this.capabilities[13] = false;
        this.capabilities[14] = false;
        this.cullface = 2;
        this.winding = 0;
        this.fillmode = 3;
        this.render_mode = 0;
        this.color = new Color(1.0f, 1.0f, 1.0f);
        this.edgecolor = new Color(0.0f, 0.0f, 0.0f);
        this.halign = 0;
        this.valign = 2;
        this.lightMgr = new LightManager(this);
        this.lineWidth = 1;
        this.capStyle = 0;
        waitImage = null;
        this.sortList = new Vector(64, 64);
        this.sortsize = 0;
        this.index = new int[64];
        this.intarray = new int[64];
        for (i = 0; i < 64; ++i) {
            this.intarray[i] = i;
        }
        this.setStipple(1, -256);
        this.ptArray[0] = new Point4();
        this.ptArray[1] = new Point4();
        this.ptArray[2] = new Point4();
        this.ptArray[3] = new Point4();
        this.capabilities[15] = true;
        this.rasterTextBuffer = this.rasterTextBufferJava1 = RasterText.newInstance(this);
        if (isJava2) {
            this.capabilities[15] = false;
            this.rasterTextBuffer = this.rasterTextBufferJava2 = RasterText.newInstance(this);
        }
        this.attribStack = new AttributeStackFrame[128];
        for (i = 0; i < 128; ++i) {
            this.attribStack[i] = new AttributeStackFrame();
        }
        this.attribStackTop = 0;
        this.attribTop = this.attribStack[this.attribStackTop];
        this.isZBufferingOn = this.isZBufferingOn();
    }

    static boolean isJava2() {
        return isJava2;
    }

    final boolean isDepthSortingOn() {
        return this.capabilities[4] && ((this.depthTestAlgorithm & 1) == 1 || (this.depthTestAlgorithm & 2) == 2);
    }

    final boolean isZBufferingOn() {
        return this.capabilities[4] && (this.depthTestAlgorithm & 4) == 4;
    }

    void setTexImage2D(Image pixels) {
        if (this.openDisplayList == null) {
            this.texImage = pixels;
        } else {
            this.openDisplayList.primitives.addElement(new TexImage(pixels));
        }
    }

    void setTexParameter(int pname, int param) {
        this.texWrapS = param;
    }

    public void setTexEnv(int target, int pname, int param) {
        if (this.openDisplayList == null) {
            switch (pname) {
                case 1: {
                    this.texEnvMode = param;
                    break;
                }
                case 2: {
                    this.texEnvStyle = param;
                }
            }
        } else {
            this.openDisplayList.primitives.addElement(new TexEnv(pname, param));
        }
    }

    int[] getTempPixelBuffer(int length) {
        if (this.tempPixels == null || this.tempPixels.length < length) {
            this.tempPixels = new int[length];
        }
        return this.tempPixels;
    }

    void reallocScratchInt(int size) {
        if (this.scratchInt == null || size > this.scratchInt.length) {
            int newLength = size;
            int[] newArray = new int[newLength];
            System.arraycopy(this.scratchInt, 0, newArray, 0, this.scratchInt.length);
            this.scratchInt = newArray;
            newArray = new int[newLength];
            System.arraycopy(this.scratchInt2, 0, newArray, 0, this.scratchInt2.length);
            this.scratchInt2 = newArray;
        }
    }

    void reallocScratchPtArray(int size) {
        if (this.ptArray == null || size > this.ptArray.length) {
            int newLength = size;
            int oldLength = this.ptArray.length;
            Point4[] newArray = new Point4[newLength];
            System.arraycopy(this.ptArray, 0, newArray, 0, this.ptArray.length);
            this.ptArray = newArray;
            for (int i = oldLength; i < newLength; ++i) {
                this.ptArray[i] = new Point4();
            }
        }
    }

    void setExtrusionVector(double x, double y, double z) {
        this.extrusionVector.set(x, y, z, 0.0);
    }

    DisplayList getDisplayList(long listName) {
        this.scratchKey.value = listName;
        return (DisplayList)this.displayList.get(this.scratchKey);
    }

    void CallList(Channel ch, Graphics bgc, long lid, boolean reComputeScreenCoordinates) {
        if (this.openDisplayList != null) {
            if (lid != this.openDisplayList.id) {
                this.openDisplayList.primitives.addElement(new ListReference(lid));
            }
        } else {
            DisplayList dl = this.getDisplayList(lid);
            if (dl == null) {
                return;
            }
            if (reComputeScreenCoordinates) {
                dl.computeScreen(ch);
            }
            this.Finish(bgc, dl);
        }
    }

    void NewList(long lid) {
        if (this.openDisplayList != null) {
            Debug.println((String)"Nested Display lists not allowed. glNewList() ignored.");
            return;
        }
        this.DeleteList(lid);
        DisplayList dl = new DisplayList(lid);
        this.displayList.put(new ReusableDouble((double)lid), dl);
        this.openDisplayList = dl;
    }

    boolean IsList(long lid) {
        return this.getDisplayList(lid) != null;
    }

    long GenLists(long listSize) {
        long result = this.greatestListName + 1L;
        this.greatestListName += listSize;
        return result;
    }

    void DeleteList(long lid) {
        this.scratchKey.value = lid;
        DisplayList dl = (DisplayList)this.displayList.remove(this.scratchKey);
        if (dl != null) {
            dl.primitives.removeAllElements();
        }
    }

    void EndList() {
        if (this.openDisplayList != null) {
            this.openDisplayList = null;
        } else {
            Debug.println((String)"No Display list is open. glEndList() ignored.");
        }
    }

    boolean isDisplayListOpen() {
        return this.openDisplayList != null;
    }

    Vector getOpenDisplayList() {
        return this.openDisplayList.primitives;
    }

    void EdgeFlag(boolean f) {
        this.edgeFlag = f;
    }

    void Bound() {
        if (this.openDisplayList == null) {
            this.polygonBuffer.end(this.ch);
            this.polygonBuffer.computeScreen(this.ch);
            this.polygonBuffer.render(this, this.ch.getBackbufferGC());
        } else {
            if (this.solid == null) {
                this.solid = new Solid();
            }
            J3Polygon p = this.polygonBuffer.copy();
            p.end(this.ch);
            this.solid.addPolygon(p);
        }
        this.polygonBuffer.removeAll();
    }

    void Color(Color color, float alpha) {
        this.color = color;
        this.alpha = alpha;
        if (this.openDisplayList == null) {
            this.color = color;
            this.alpha = alpha;
        } else {
            this.openDisplayList.primitives.addElement(new FillColor(color, alpha));
        }
    }

    void EdgeColor(Color c) {
        if (this.openDisplayList == null) {
            this.edgecolor = c;
        } else {
            EdgeColor ecs = new EdgeColor(c);
            this.openDisplayList.primitives.addElement(ecs);
        }
    }

    void CullFace(int face) {
        this.cullface = face;
    }

    void shadeModel(int shadeModel) {
        this.shadeModel = shadeModel;
    }

    void Enable(int cap) {
        if (this.openDisplayList == null || this.isNonDisplayListableCapability(cap)) {
            if (cap >= 17 && cap <= 24) {
                this.lightMgr.setEnabled(cap, true);
            } else {
                this.capabilities[cap] = true;
            }
            if (cap == 15) {
                this.rasterTextBuffer = this.rasterTextBufferJava1;
            }
            if (cap == 4) {
                this.isZBufferingOn = this.isZBufferingOn();
            }
        } else {
            this.openDisplayList.primitives.addElement(new Capability(cap, true));
        }
    }

    void Disable(int cap) {
        if (this.openDisplayList == null || this.isNonDisplayListableCapability(cap)) {
            if (cap >= 17 && cap <= 24) {
                this.lightMgr.setEnabled(cap, false);
            } else {
                this.capabilities[cap] = false;
            }
            if (cap == 15 && isJava2) {
                this.rasterTextBuffer = this.rasterTextBufferJava2;
            }
        } else {
            this.openDisplayList.primitives.addElement(new Capability(cap, false));
        }
    }

    private boolean isNonDisplayListableCapability(int cap) {
        return cap == 4 || cap == 0;
    }

    void PushAttrib(int mask) {
        if (this.openDisplayList == null) {
            AttributeStackFrame frame = this.attribStack[this.attribStackTop];
            frame.set(this);
            ++this.attribStackTop;
            if (this.attribStackTop >= 128) {
                throw new RuntimeException("Attribute stack overflow");
            }
            frame = this.attribStack[this.attribStackTop];
            frame.set(this);
        } else {
            this.openDisplayList.primitives.addElement(new Attribute(0));
        }
    }

    void PopAttrib() {
        if (this.openDisplayList == null) {
            AttributeStackFrame frame = this.attribStack[this.attribStackTop];
            frame.unReference();
            --this.attribStackTop;
            if (this.attribStackTop < 0) {
                throw new RuntimeException("Atribute stack underflow");
            }
            frame = this.attribStack[this.attribStackTop];
            frame.get(this);
        } else {
            this.openDisplayList.primitives.addElement(new Attribute(1));
        }
    }

    void FrontFace(int winding) {
        this.winding = winding;
    }

    void Begin(int mode) {
        this.currentPrimitiveMode = mode;
        switch (this.currentPrimitiveMode) {
            case 0: {
                this.pbuffer = this.pointBuffer;
                break;
            }
            case 1: {
                this.pbuffer = this.lineBuffer;
                break;
            }
            case 2: 
            case 3: {
                this.pbuffer = this.polygonBuffer;
                break;
            }
            case 4: {
                this.pbuffer = this.markerBuffer;
            }
        }
        this.pbuffer.removeAll();
    }

    void End(Graphics bgc) {
        if (this.pbuffer == null) {
            return;
        }
        if (this.openDisplayList == null) {
            if (bgc != null && this.pbuffer.getVertexCount(this) > 0) {
                this.pbuffer.end(this.ch);
                this.pbuffer.computeScreen(this.ch);
                this.pbuffer.render(this.ch.state, bgc);
            }
        } else {
            switch (this.currentPrimitiveMode) {
                case 4: {
                    this.ch.state.openDisplayList.primitives.addElement(this.markerBuffer.copy());
                    break;
                }
                case 0: {
                    ((J3Point)this.pbuffer).split(this.ch);
                    break;
                }
                case 1: {
                    ((J3Line)this.pbuffer).split(this.ch);
                    break;
                }
                case 2: {
                    J3Polygon p = null;
                    if (this.pbuffer.getVertexCount(this) > 0) {
                        p = this.polygonBuffer.copy();
                        p.end(this.ch);
                        if (this.solid != null) {
                            this.solid.addPolygon(p);
                        }
                    }
                    if (this.solid != null) {
                        this.ch.state.openDisplayList.primitives.addElement(this.solid);
                        this.solid = null;
                        break;
                    }
                    if (p == null) break;
                    this.ch.state.openDisplayList.primitives.addElement(p);
                    break;
                }
                case 3: {
                    if (this.pbuffer.getVertexCount(this) <= 0) break;
                    Primitive[] pList = ((J3Polygon)this.pbuffer).extrude(this);
                    for (int i = 0; i < pList.length; ++i) {
                        this.ch.state.openDisplayList.primitives.addElement(pList[i]);
                    }
                    break;
                }
            }
        }
        this.pbuffer = null;
    }

    void Finish(Graphics bgc, DisplayList dl) {
        block9: {
            int num;
            block7: {
                block8: {
                    num = dl.primitives.size();
                    if (this.render_mode != 1) break block7;
                    if (!this.isDepthSortingOn()) break block8;
                    this.pickList.removeAllElements();
                    this.makePickList(dl.primitives, bgc, this.pickList);
                    if (this.pickList.size() <= 0) break block9;
                    if (this.capabilities[4]) {
                        this.sortPickList(this.pickList);
                    }
                    this.makeSelectBuffer(this.pickList);
                    break block9;
                }
                this.selectWithoutSorting(dl.primitives, bgc);
                break block9;
            }
            if (this.isDepthSortingOn()) {
                int i;
                int length = this.intarray.length;
                if (num > length) {
                    int[] oldarray = this.intarray;
                    int newsize = num + 64;
                    this.intarray = new int[newsize];
                    System.arraycopy(oldarray, 0, this.intarray, 0, length);
                    for (i = length; i < newsize; ++i) {
                        this.intarray[i] = i;
                    }
                }
                Vector primitives = this.depthSort(dl);
                num = primitives.size();
                for (i = 0; i < num; ++i) {
                    Primitive primitive = (Primitive)primitives.elementAt(this.index[i]);
                    primitive.render(this, bgc);
                }
            } else {
                num = dl.primitives.size();
                for (int i = 0; i < num; ++i) {
                    Primitive primitive = (Primitive)dl.primitives.elementAt(i);
                    primitive.render(this, bgc);
                }
            }
        }
    }

    void InitNames() {
        if (this.openDisplayList == null) {
            this.currentName = this.nameRoot;
            this.nameStackTop = 0;
        } else {
            this.openDisplayList.primitives.addElement(new ListName(0));
        }
    }

    void LoadName(Object name) {
        if (this.openDisplayList == null) {
            if (this.isDepthSortingOn()) {
                NameTree parent = this.currentName.getParent();
                NameTree nt = parent.getChild(name);
                if (nt == null) {
                    nt = parent.addChild(name);
                }
                this.currentName = nt;
            } else {
                this.nameStack[this.nameStackTop] = name;
            }
        } else {
            this.openDisplayList.primitives.addElement(new ListName(1, name));
        }
    }

    void PopName() {
        if (this.openDisplayList == null) {
            if (this.isDepthSortingOn()) {
                NameTree parent = this.currentName.getParent();
                if (parent == null) {
                    Debug.println((String)"Name stack underflow.");
                } else {
                    this.currentName = this.currentName.getParent();
                }
            } else {
                --this.nameStackTop;
                if (this.nameStackTop < 0) {
                    throw new RuntimeException("Name stack underflow");
                }
            }
        } else {
            this.openDisplayList.primitives.addElement(new ListName(3));
        }
    }

    void PushName(Object name) {
        if (this.openDisplayList == null) {
            if (this.isDepthSortingOn()) {
                NameTree child = this.currentName.getChild(name);
                if (child == null) {
                    child = this.currentName.addChild(name);
                }
                this.currentName = child;
            } else {
                ++this.nameStackTop;
                if (this.nameStackTop >= 1280) {
                    throw new RuntimeException("Name stack overflow");
                }
                this.nameStack[this.nameStackTop] = name;
            }
        } else {
            this.openDisplayList.primitives.addElement(new ListName(2, name));
        }
    }

    void Normal(double x, double y, double z) {
        this.normal.x = x;
        this.normal.y = y;
        this.normal.z = z;
        if (this.capabilities[2]) {
            this.normal.normalize();
        }
    }

    void PickMatrix(int curx, int cury, int width, int height) {
        this.aperture.setBounds(curx, cury, width, height);
    }

    void PolygonMode(int fill) {
        if (this.openDisplayList == null) {
            this.fillmode = fill;
        } else {
            PolygonMode pm = new PolygonMode(fill);
            this.openDisplayList.primitives.addElement(pm);
        }
    }

    int getPolygonMode() {
        return this.fillmode;
    }

    void Select2DFont(Font newfont) {
        this.font = newfont;
    }

    void Select2DFont(String name, int style) {
        this.font = new Font(name, style, this.font.getSize());
    }

    void TextHeight(double height) {
        this.pt1.set(0.0, height, 0.0, 1.0);
        this.pt2.set(0.0, 0.0, 0.0, 1.0);
        this.ch.trans.Object2Window(this.pt1);
        this.ch.trans.Object2Window(this.pt2);
        this.pt2.sub(this.pt1);
        int size = (int)Math.sqrt(this.pt2.x * this.pt2.x + this.pt2.y * this.pt2.y);
        this.font = new Font(this.font.getName(), this.font.getStyle(), size);
    }

    void TextHeight(int size) {
        this.font = new Font(this.font.getName(), this.font.getStyle(), size);
    }

    void Alignment(int h, int v) {
        this.halign = h;
        this.valign = v;
    }

    int getRenderMode() {
        return this.render_mode;
    }

    boolean RenderMode(int mode) {
        boolean selections;
        int previousMode = this.render_mode;
        this.render_mode = mode;
        switch (previousMode) {
            case 2: {
                selections = false;
                break;
            }
            case 1: {
                selections = this.selectbuffer != null && this.selectbuffer.size() > 0;
                break;
            }
            default: {
                selections = false;
            }
        }
        switch (this.render_mode) {
            case 1: {
                if (this.selectbuffer == null) break;
                this.selectbuffer.removeAllElements();
                break;
            }
        }
        return selections;
    }

    boolean isSoftwareRender() {
        return this.ch.currentBuffer == 1;
    }

    void SelectBuffer(Stack buffer) {
        this.selectbuffer = buffer;
        this.selectbuffer.removeAllElements();
    }

    void feedbackBuffer(int type, Vector buffer) {
        this.feedbackBuffer = buffer;
        this.feedbackType = type;
        this.feedbackBuffer.removeAllElements();
    }

    void Rect(double x1, double y1, double x2, double y2, ColorGradient colorGradient) {
        if (this.openDisplayList == null) {
            this.rectangleBuffer.setCorners(x1, y1, x2, y2);
            this.rectangleBuffer.setColorGradient(colorGradient);
            this.rectangleBuffer.computeScreen(this.ch);
            this.rectangleBuffer.render(this, this.ch.getBackbufferGC());
        } else {
            J3Rectangle rect = new J3Rectangle();
            rect.setCorners(x1, y1, x2, y2);
            rect.setColorGradient(colorGradient);
            this.openDisplayList.primitives.addElement(rect);
        }
    }

    void Text2D(String string, double x, double y, double z, int angle, Color background, Color backgroundEdge) {
        if (this.openDisplayList == null) {
            this.rasterTextBuffer.setPosition(x, y, z);
            this.rasterTextBuffer.setBackgroundColor(background);
            this.rasterTextBuffer.setBackgroundEdgeColor(backgroundEdge);
            this.rasterTextBuffer.setString(string);
            this.rasterTextBuffer.setAngle(angle);
            this.rasterTextBuffer.setHorizontalAlignment(this.halign);
            this.rasterTextBuffer.setVerticalAlignment(this.valign);
            this.rasterTextBuffer.setFont(this.font);
            this.rasterTextBuffer.computeScreen(this.ch);
            this.rasterTextBuffer.render(this, this.ch.getBackbufferGC());
        } else {
            RasterText text = RasterText.newInstance(this, string, x, y, z, angle, background, backgroundEdge);
            text.setHorizontalAlignment(this.halign);
            text.setVerticalAlignment(this.valign);
            text.setFont(this.font);
            this.openDisplayList.primitives.addElement(text);
        }
    }

    void Image2D(Image img, double px, double py, double pz, int width, int height, Color bgColor) {
        BillBoardImage image = new BillBoardImage(this, img, px, py, pz, width, height, bgColor);
        image.setHorizontalAlignment(this.halign);
        image.setVerticalAlignment(this.valign);
        if (this.openDisplayList == null) {
            image.computeScreen(this.ch);
            image.render(this, this.ch.getBackbufferGC());
        } else {
            this.openDisplayList.primitives.addElement(image);
        }
    }

    void ImageWaitImage(Image aImage) {
        waitImage = aImage;
    }

    void Vertex(double x, double y, double z) {
        this.pbuffer.vertex(this.ch, x, y, z);
    }

    public void SetClipBounds(Bbox aClipBbox) {
        this.clipBbox = aClipBbox;
        if (this.openDisplayList == null) {
            if (aClipBbox == null) {
                this.clipBbox = null;
                this.clipRect = null;
            } else {
                this.clipRect = new Rectangle();
                this.projectClipBbox(this.clipRect);
            }
        } else {
            this.openDisplayList.primitives.addElement(new ClipBounds(aClipBbox));
        }
    }

    public Bbox GetClipBounds() {
        return this.clipBbox;
    }

    public void ClearClipBounds() {
        this.clipBbox = null;
    }

    private void projectClipBbox(Rectangle r) {
        TransInfo transInfo = this.ch.trans;
        Point4 screenClipMinCorner = this.pt1;
        Point4 screenClipMaxCorner = this.pt2;
        screenClipMinCorner = this.clipBbox.getBoxMinCorner();
        screenClipMaxCorner = this.clipBbox.getBoxMaxCorner();
        transInfo.Object2Window(screenClipMinCorner);
        transInfo.Object2Window(screenClipMaxCorner);
        int x = (int)(screenClipMinCorner.x > screenClipMaxCorner.x ? screenClipMaxCorner.x + 0.5 : screenClipMinCorner.x + 0.5);
        int y = (int)(screenClipMinCorner.y > screenClipMaxCorner.y ? screenClipMaxCorner.y + 0.5 : screenClipMinCorner.y + 0.5);
        int w = (int)(Math.abs(screenClipMaxCorner.x - screenClipMinCorner.x) + 0.5);
        int h = (int)(Math.abs(screenClipMinCorner.y - screenClipMaxCorner.y) + 0.5);
        r.setBounds(x, y, w + 1, h + 1);
    }

    public Rectangle applyWorldClip(Graphics bgc, Rectangle clip) {
        Rectangle originalClip = null;
        if (clip != null) {
            if (this.isSoftwareRender()) {
                originalClip = this.ch.getClip();
                this.ch.setClip(clip);
            } else {
                originalClip = bgc.getClipBounds();
                bgc.setClip(clip);
            }
        }
        return originalClip;
    }

    public void clearWorldClip(Graphics bgc, Rectangle clip, Rectangle previousClip) {
        if (clip != null) {
            if (this.isSoftwareRender()) {
                this.ch.setClip(previousClip);
            } else {
                bgc.setClip(previousClip);
            }
        }
    }

    public Rectangle ApplyClip(Rectangle clipRect, Rectangle target) {
        Rectangle result = target;
        if (clipRect != null) {
            result = clipRect.intersection(target);
        }
        return result;
    }

    public void setStipple(int factor, int mask) {
        int[] dashes = new int[16];
        int index = 0;
        int scanner = 32768;
        while (scanner > 0) {
            int bitcount = 0;
            while ((scanner & mask) != 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount > 0) {
                dashes[index++] = factor * bitcount;
            }
            bitcount = 0;
            while ((scanner & mask) == 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount <= 0) continue;
            dashes[index++] = -factor * bitcount;
        }
        int[] pattern = new int[index--];
        int i = 0;
        while (index >= 0) {
            pattern[i] = dashes[index];
            ++i;
            --index;
        }
        if (this.openDisplayList == null) {
            this.stipplePattern = pattern;
        } else {
            Stipple stipple = new Stipple(pattern);
            this.openDisplayList.primitives.addElement(stipple);
        }
    }

    public int addCustomMarker(CustomMarkerInterface marker) {
        int id;
        if (this.customMarkers == null) {
            this.customMarkers = new Vector();
        }
        this.customMarkers.addElement(marker);
        this.markerIdLast = id = 190 + this.customMarkers.size() - 1;
        return id;
    }

    public void markerType(int type) {
        if (type < 0 || type > this.markerIdLast) {
            return;
        }
        if (this.openDisplayList == null) {
            this.markerType = type;
        } else {
            this.openDisplayList.primitives.addElement(new MarkerType(type));
        }
    }

    public void markerSize(int size) {
        if (this.openDisplayList == null) {
            this.markerSize = size;
        } else {
            this.openDisplayList.primitives.addElement(new MarkerSize(size));
        }
    }

    public void lineWidth(float width) {
        if (this.openDisplayList == null) {
            this.lineWidth = (int)(width / 2.0f) + 1;
            this.lineWidth = (int)width;
        } else {
            LineWidth lw = new LineWidth(width);
            this.openDisplayList.primitives.addElement(lw);
        }
    }

    public void pointSize(float size) {
        if (this.openDisplayList == null) {
            this.pointSize = size;
        } else {
            this.openDisplayList.primitives.addElement(new PointSize(size));
        }
    }

    public void capStyle(int capStyle) {
        if (this.openDisplayList == null) {
            this.capStyle = capStyle;
        } else {
            this.openDisplayList.primitives.addElement(new LineCapStyle(capStyle));
        }
    }

    private void sortPickList(Vector pickList) {
        int i;
        int n = pickList.size();
        this.sortList.removeAllElements();
        for (i = 0; i < n; ++i) {
            this.sortList.addElement(pickList.elementAt(i));
        }
        this.depthSort();
        for (i = 0; i < n; ++i) {
            pickList.setElementAt(this.sortList.elementAt(this.index[i]), i);
        }
    }

    private void makeSelectBuffer(Vector pickList) {
        int pickCount = pickList.size();
        this.selectbuffer.removeAllElements();
        for (int i = 0; i < pickCount; ++i) {
            Shape p = (Shape)pickList.elementAt(i);
            NameTree name = p.getName();
            if (name == null) {
                Debug.println((String)p.toString());
            }
            this.namePath.removeAllElements();
            int nameCount = 0;
            NameTree nt = name;
            while (nt.getParent() != null) {
                ++nameCount;
                this.namePath.addElement(nt.getName());
                nt = nt.getParent();
            }
            if (nameCount > 0) {
                this.selectbuffer.push(new Integer(nameCount + 1));
            }
            nt = name;
            for (int j = 0; j < nameCount; ++j) {
                this.selectbuffer.push(this.namePath.elementAt(nameCount - j - 1));
            }
        }
    }

    Stack copyNameStack() {
        Stack<Object> sb = new Stack<Object>();
        sb.push(new Integer(this.nameStackTop + 1));
        for (int i = 1; i <= this.nameStackTop; ++i) {
            sb.push(this.nameStack[i]);
        }
        return sb;
    }

    void selectPrimitive(Primitive p) {
        this.selectbuffer.push(new Integer(this.nameStackTop + 1));
        for (int i = 1; i <= this.nameStackTop; ++i) {
            this.selectbuffer.push(this.nameStack[i]);
        }
    }

    private void selectWithoutSorting(Vector primitiveList, Graphics bgc) {
        int n = primitiveList.size();
        for (int i = 0; i < n; ++i) {
            Object o = primitiveList.elementAt(i);
            if (o instanceof ListReference) {
                ListReference lr = (ListReference)o;
                DisplayList dl = this.getDisplayList(lr.listName);
                if (dl == null) continue;
                this.selectWithoutSorting(dl.primitives, bgc);
                continue;
            }
            if (o instanceof ListName) {
                ListName l = (ListName)o;
                l.computeScreen(this.ch);
                continue;
            }
            if (!(o instanceof Shape)) continue;
            Shape s = (Shape)o;
            s.render(this, bgc);
        }
    }

    private void makePickList(Vector primitiveList, Graphics bgc, Vector pickList) {
        int n = primitiveList.size();
        for (int i = 0; i < n; ++i) {
            Rectangle a;
            Shape s;
            Object o = primitiveList.elementAt(i);
            if (o instanceof ListReference) {
                ListReference lr = (ListReference)o;
                DisplayList dl = this.getDisplayList(lr.listName);
                if (dl == null) continue;
                this.makePickList(dl.primitives, bgc, pickList);
                continue;
            }
            if (!(o instanceof Shape) || (s = (Shape)o).isClipped() || (a = s.intersectPickAperture(this.aperture, this)) == null || !s.pick(this, bgc, a)) continue;
            pickList.addElement(s);
        }
    }

    public void setDepthTestAlgorithm(int algorithm) {
        this.depthTestAlgorithm = algorithm;
        this.isZBufferingOn = this.isZBufferingOn();
    }

    private Vector depthSort(DisplayList dl) {
        int n = dl.primitives.size();
        if (n == 0) {
            return this.sortList;
        }
        this.sortList.removeAllElements();
        for (int i = 0; i < n; ++i) {
            Primitive p = (Primitive)dl.primitives.elementAt(i);
            p.insertToSortlist(this);
        }
        this.depthSort();
        return this.sortList;
    }

    private void depthSort() {
        int length = this.index.length;
        int n = this.sortList.size();
        if (n > length) {
            int newsize = n;
            if (n > this.intarray.length) {
                int[] oldarray = this.intarray;
                this.intarray = new int[newsize];
                System.arraycopy(oldarray, 0, this.intarray, 0, length);
                for (int i = length; i < newsize; ++i) {
                    this.intarray[i] = i;
                }
            }
            this.index = new int[newsize];
            System.arraycopy(this.intarray, 0, this.index, 0, n);
        } else {
            System.arraycopy(this.intarray, 0, this.index, 0, n);
        }
        switch (this.depthTestAlgorithm) {
            case 1: {
                State.indexSortZmax(this.sortList, this.index, n);
                break;
            }
            default: {
                State.indexSortZmin(this.sortList, this.index, n);
                this.secondDepthSort(this.sortList, this.index);
            }
        }
    }

    static void indexSortZmax(Vector slist, int[] index, int num) {
        int indxt;
        if (num < 2) {
            return;
        }
        int k = (num >> 1) + 1;
        int ir = num;
        while (true) {
            double q;
            Shape p;
            if (k > 1) {
                indxt = index[--k - 1];
                p = (Shape)slist.elementAt(indxt);
                q = p.getZmax();
            } else {
                indxt = index[ir - 1];
                p = (Shape)slist.elementAt(indxt);
                q = p.getZmax();
                index[ir - 1] = index[0];
                if (--ir == 1) break;
            }
            int i = k;
            int j = 2 * k;
            while (j <= ir) {
                Shape p2;
                double z2;
                Shape p1 = (Shape)slist.elementAt(index[j - 1]);
                double z1 = p1.getZmax();
                if (j < ir && (z1 < (z2 = (p2 = (Shape)slist.elementAt(index[j])).getZmax()) || z1 == z2 && p1.getZmax() < p2.getZmax())) {
                    ++j;
                    z1 = z2;
                    p1 = p2;
                }
                if (q < z1 || q == z1 && p.getZmax() < p1.getZmax()) {
                    index[i - 1] = index[j - 1];
                    i = j;
                    j += i;
                    continue;
                }
                j = ir + 1;
            }
            index[i - 1] = indxt;
        }
        index[0] = indxt;
    }

    static void indexSortZmin(Vector slist, int[] index, int num) {
        int indxt;
        if (num < 2) {
            return;
        }
        int k = (num >> 1) + 1;
        int ir = num;
        while (true) {
            double q;
            Shape p;
            if (k > 1) {
                indxt = index[--k - 1];
                p = (Shape)slist.elementAt(indxt);
                q = p.getZmin();
            } else {
                indxt = index[ir - 1];
                p = (Shape)slist.elementAt(indxt);
                q = p.getZmin();
                index[ir - 1] = index[0];
                if (--ir == 1) break;
            }
            int i = k;
            int j = 2 * k;
            while (j <= ir) {
                Shape p2;
                double z2;
                Shape p1 = (Shape)slist.elementAt(index[j - 1]);
                double z1 = p1.getZmin();
                if (j < ir && (z1 < (z2 = (p2 = (Shape)slist.elementAt(index[j])).getZmin()) || z1 == z2 && p1.getZmax() < p2.getZmax())) {
                    ++j;
                    z1 = z2;
                    p1 = p2;
                }
                if (q < z1 || q == z1 && p.getZmax() < p1.getZmax()) {
                    index[i - 1] = index[j - 1];
                    i = j;
                    j += i;
                    continue;
                }
                j = ir + 1;
            }
            index[i - 1] = indxt;
        }
        index[0] = indxt;
    }

    final void secondDepthSort(Vector list, int[] index) {
        int num = list.size();
        if (num < 2) {
            return;
        }
        if (num > this.swap.length) {
            this.swap = new int[num];
        }
        boolean redo = false;
        int max = num;
        int redoCount = 0;
        for (int i = 0; i < num; ++i) {
            Object o = list.elementAt(index[i]);
            if (!(o instanceof Shape)) continue;
            Shape sp = (Shape)o;
            for (int j = i + 1; j < num; ++j) {
                int k;
                Shape sq;
                o = list.elementAt(index[j]);
                if (!(o instanceof Shape) || sp == (sq = (Shape)o) || sp.test(sq, this) != 0) continue;
                this.swap[0] = index[j];
                int move = 1;
                int tag = j;
                sp = sq;
                for (k = j - 1; k > i; --k) {
                    sq = (Shape)list.elementAt(index[k]);
                    if (sp.test(sq, this) != 0) {
                        index[tag] = index[k];
                        --tag;
                        continue;
                    }
                    this.swap[move] = index[k];
                    ++move;
                    if (redoCount >= max) continue;
                    redo = true;
                }
                index[tag] = index[i];
                --tag;
                for (k = 0; k < move; ++k) {
                    index[tag] = this.swap[k];
                    --tag;
                }
                if (!redo) continue;
                --i;
                j = num;
                redo = false;
                ++redoCount;
            }
        }
    }

    public FontMetrics getFontMetrics(Graphics graphics, Font font) {
        FontMetrics fm;
        Object[] o;
        int n = this.fontMetricCache.size();
        for (int i = 0; i < n; ++i) {
            o = (Object[])this.fontMetricCache.elementAt(i);
            Graphics g = (Graphics)o[0];
            fm = (FontMetrics)o[1];
            if (g != graphics || fm.getFont() != font) continue;
            return fm;
        }
        if (n > 5) {
            this.fontMetricCache.removeElementAt(0);
        }
        o = new Object[2];
        o[0] = graphics;
        fm = graphics != null ? graphics.getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
        o[1] = fm;
        this.fontMetricCache.addElement(o);
        return fm;
    }

    public void setShadowOffset(int x, int y) {
        this.shadowOffsetX = x;
        this.shadowOffsetY = y;
    }

    public void setShadowSoftness(float t) {
        t = Math.min(t, 1.0f);
        this.shadowSoftness = t = Math.max(t, 0.0f);
    }

    public void setShadowTransparency(float t) {
        t = Math.min(t, 1.0f);
        this.shadowTransparency = t = Math.max(t, 0.0f);
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
    }

    static {
        isJava2 = false;
        isJava2 = System.getProperty("java.version").indexOf("1.1") != 0;
    }
}

