/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.ScanConvert;
import com.sas.graphics.util.jxd.SoftGraphicsInterface;
import com.sas.graphics.util.jxd.State;
import java.awt.Color;
import java.awt.Graphics;

class SoftGraphics {
    private State state;
    private Color color = Color.black;

    SoftGraphics() {
    }

    public void setState(State state) {
        this.state = state;
    }

    public static Graphics newSoftGraphics(State state) {
        Graphics g = null;
        try {
            g = state.isJava2() ? (Graphics)Class.forName("com.sas.graphics.util.jxd.SoftGraphicsJava2").newInstance() : (Graphics)Class.forName("com.sas.graphics.util.jxd.SoftGraphicsJava1").newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((SoftGraphicsInterface)((Object)g)).setState(state);
        return g;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        ScanConvert.bresenhamLine(this.state, 1, x1, y1, this.color, 1.0f, x2, y2, this.color, 1.0f);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int half = width / 2;
        int half1 = (width - 1) / 2;
        ScanConvert.bresenhamLine(this.state, 1, x, y + 1, this.color, 1.0f, x, y + height - 1, this.color, 1.0f);
        ScanConvert.bresenhamLine(this.state, 1, x + width, y + 1, this.color, 1.0f, x + width, y + height - 1, this.color, 1.0f);
        ScanConvert.bresenhamLine(this.state, 1, x + 1, y, this.color, 1.0f, x + width - 1, y, this.color, 1.0f);
        ScanConvert.bresenhamLine(this.state, 1, x + 1, y + height, this.color, 1.0f, x + width - 1, y + height, this.color, 1.0f);
    }
}

