/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Bbox;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.Point4;
import com.sas.graphics.util.jxd.RasterShape;
import com.sas.graphics.util.jxd.RasterTextJava1;
import com.sas.graphics.util.jxd.State;
import com.sas.graphics.util.jxd.TransInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;
import java.util.Vector;

abstract class RasterText
extends RasterShape {
    protected static final int multiLineOffsetIndex = 32;
    protected static char newline = (char)10;
    protected Font font;
    protected Vector stringVector = new Vector();
    protected String string;
    protected double[] textWidth;
    protected double maxTextWidth;
    protected int textLines;
    protected int angle;
    private static final String rasterTextJava1 = "com.sas.graphics.util.jxd.RasterTextJava1";
    private static final String rasterTextJava2 = "com.sas.graphics.util.jxd.RasterTextJava2";
    private static Class rasterTextJava2Class;
    protected int[] shadowJitterX = new int[]{1, -1, 3, 1, 0, 2, 0, 2, 1};
    protected int[] shadowJitterY = new int[]{1, -1, -1, -3, 0, 0, -2, -2, -1};
    protected double[] shadowShade = new double[]{1.2, 1.2, 1.2, 1.2f, 1.15, 1.15, 1.15, 1.15, 1.1};
    private static final int X = 0;
    private static final int Y = 1;

    RasterText() {
    }

    public abstract void setAngle(int var1);

    abstract double getWidth(State var1, Graphics var2, Font var3, String var4);

    abstract double getAscent(State var1, Graphics var2, Font var3);

    abstract double getHeight(State var1, Graphics var2, Font var3, String var4);

    abstract double getHeight(State var1, Graphics var2, Font var3);

    abstract double getDescent(State var1, Graphics var2, Font var3);

    @Override
    protected abstract double[] computeAlignmentInfo(State var1, Graphics var2, double var3, double var5);

    protected abstract double[] computeAlignmentInfo(State var1, Graphics var2, Vector var3, Font var4, int var5, int var6, double var7, double var9, double var11);

    protected abstract void softwareRender(State var1, Graphics var2, Color var3, double[] var4);

    protected abstract void render(State var1, Graphics var2, Color var3, double[] var4);

    static RasterText newInstance(State state, String str, double x, double y, double z, int aNangle, Color background, Color backgroundEdge) {
        RasterText rasterText = RasterText.newInstance(state);
        rasterText.setString(str);
        rasterText.setPosition(x, y, z);
        rasterText.setAngle(aNangle);
        rasterText.setBackgroundColor(background);
        rasterText.setBackgroundEdgeColor(backgroundEdge);
        return rasterText;
    }

    static RasterText newInstance(State state) {
        RasterText rasterText = null;
        try {
            if (state.capabilities[15]) {
                rasterText = new RasterTextJava1();
            } else {
                rasterText = (RasterText)rasterTextJava2Class.newInstance();
                rasterText.init(state);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return rasterText;
    }

    void init(State state) {
    }

    public void setFont(Font font) {
        this.font = font;
    }

    protected int getShadowAdditionalWidth() {
        return this.shadowOffsetX + 3;
    }

    protected int getShadowAdditionalHeight() {
        return this.shadowOffsetY + 3;
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.color = ch.state.color;
    }

    public void setString(String str) {
        this.stringVector = RasterText.makeMultiLine(str, this.stringVector);
        this.textLines = this.stringVector.size();
        this.textWidth = null;
    }

    void getBBox(String string, double x, double y, double z, int angle, Bbox bbox, State state, Graphics gc) {
        Point4 p1 = state.pt1;
        Point4 p2 = state.pt2;
        Point4 p3 = state.pt3;
        p1.set(x, y, z, 1.0);
        TransInfo trans = state.ch.trans;
        trans.Object2Window2(p1);
        Vector strings = new Vector();
        RasterText.makeMultiLine(string, strings);
        double[] info = this.computeAlignmentInfo(state, gc, strings, state.font, state.halign, state.valign, angle, p1.x, p1.y);
        Point4 p4 = state.pt4;
        Point4 p5 = state.pt5;
        double ix = info[0];
        double iy = info[4];
        double w = info[2];
        double h = info[3];
        p2.set(ix, iy, p1.z, 1.0);
        p3.set(ix, iy + h, p1.z, 1.0);
        p4.set(ix + w, iy + h, p1.z, 1.0);
        p5.set(ix + w, iy, p1.z, 1.0);
        trans.Window2Object(p2);
        trans.Window2Object(p3);
        trans.Window2Object(p4);
        trans.Window2Object(p5);
        bbox.makeEmpty();
        bbox.union(p2);
        bbox.union(p3);
        bbox.union(p4);
        bbox.union(p5);
    }

    private static void getWorldPixelCorners(TransInfo trans, Point4 ll, Point4 ur, int direction) {
        ll.set(0.0, 0.0, 0.0, 1.0);
        trans.Object2Window2(ll);
        if (direction == 0) {
            ur.set(ll.x + 1.0, ll.y, ll.z, 1.0);
        } else {
            ur.set(ll.x, ll.y - 1.0, ll.z, 1.0);
        }
        trans.Window2Object(ll);
        trans.Window2Object(ur);
    }

    static double getWorldPixelWidth(State state) {
        Point4 ll = state.pt1;
        Point4 ur = state.pt2;
        RasterText.getWorldPixelCorners(state.ch.trans, ll, ur, 0);
        ur.sub(ll);
        return ur.length();
    }

    static double getWorldPixelHeight(State state) {
        Point4 ll = state.pt1;
        Point4 ur = state.pt2;
        RasterText.getWorldPixelCorners(state.ch.trans, ll, ur, 1);
        ur.sub(ll);
        return ur.length();
    }

    protected static Vector makeMultiLine(String text, Vector lines) {
        int nlIndex = 0;
        lines.removeAllElements();
        if (text != null && text.length() > 0) {
            int i = 0;
            while (nlIndex >= 0) {
                nlIndex = text.indexOf(newline, i);
                String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                lines.addElement(line);
                i = 1 + nlIndex;
            }
        }
        return lines;
    }

    protected double[] getInfoBuffer(State state, int lineCount) {
        int infoLength = 32 + lineCount;
        if (state.tempRasterInfo == null || state.tempRasterInfo.length < infoLength) {
            state.tempRasterInfo = new double[infoLength];
        }
        return state.tempRasterInfo;
    }

    protected int index(int x, int y, int rowWidth) {
        return x + y * rowWidth;
    }

    protected void plantPixels(State state, int[] pixels, int left, int top, double z, int w, int h, float alpha) {
        int i = 0;
        int lastPixel = pixels[i] - 1;
        float lastR = 0.0f;
        float lastG = 0.0f;
        float lastB = 0.0f;
        float lastA = alpha;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = pixels[i];
                if (alpha < 1.0f) {
                    if (lastPixel != argb) {
                        lastR = (float)(argb >> 16 & 0xFF) / 255.0f;
                        lastG = (float)(argb >> 8 & 0xFF) / 255.0f;
                        lastB = (float)(argb & 0xFF) / 255.0f;
                        lastPixel = argb;
                    }
                    state.ch.plant(left + x, top + y, z, lastA, lastR, lastG, lastB);
                } else {
                    state.ch.plant(left + x, top + y, z, argb);
                }
                ++i;
            }
        }
    }

    protected void grabPixels(Image textBuffer, int w, int h, int[] pixels) {
        PixelGrabber pg = new PixelGrabber(textBuffer, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        if (this.textLines == 0) {
            return;
        }
        if (bgc == null) {
            return;
        }
        bgc.setFont(this.font);
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        double[] info = this.computeAlignmentInfo(state, bgc, this.screen.x, this.screen.y);
        if (state.isSoftwareRender()) {
            this.softwareRender(state, bgc, this.color, info);
        } else {
            this.render(state, bgc, this.color, info);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private int[] rotatePixels(int[] srcPixels, int[] destPixels, int w, int h, int anAngle, boolean hack, Color textColor, Color bgColor) {
        if (w * h != srcPixels.length || w * h != destPixels.length) {
            return null;
        }
        double tc = Double.NaN;
        double bgc = Double.NaN;
        if (textColor != null) {
            tc = textColor.getRGB();
        }
        if (bgColor != null) {
            bgc = bgColor.getRGB();
        }
        switch (anAngle) {
            default: {
                destPixels = srcPixels;
                break;
            }
            case 180: {
                for (int y = 0; y < h; ++y) {
                    int xmin = y * w;
                    int xmax = xmin + w;
                    int index = xmax - 1;
                    for (int x = xmin; x < xmax; ++x) {
                        this.setDestPixel(x, destPixels, srcPixels[0], srcPixels[index], tc, bgc, hack);
                        --index;
                    }
                }
                break;
            }
            case 270: {
                int index = 0;
                for (int x = 0; x < w; ++x) {
                    for (int y = h - 1; y >= 0; --y) {
                        this.setDestPixel(index, destPixels, srcPixels[0], srcPixels[y * w + x], tc, bgc, hack);
                        ++index;
                    }
                }
                break;
            }
            case 90: {
                int index = 0;
                for (int x = w - 1; x >= 0; --x) {
                    for (int y = 0; y < h; ++y) {
                        this.setDestPixel(index, destPixels, srcPixels[0], srcPixels[y * w + x], tc, bgc, hack);
                        ++index;
                    }
                }
            }
        }
        return destPixels;
    }

    private void setDestPixel(int index, int[] destPixels, int srcPixelZero, int rgb, double tc, double bgc, boolean hack) {
        destPixels[index] = !hack ? rgb : (rgb != srcPixelZero ? (!Double.isNaN(tc) ? (int)tc : rgb) : (Double.isNaN(bgc) ? rgb & 0xFFFFFF : (int)bgc));
    }

    static {
        try {
            if (State.isJava2) {
                rasterTextJava2Class = Class.forName(rasterTextJava2);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

