/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.Markers;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.CustomMarkerInterface;
import com.sas.graphics.util.jxd.Point4;
import com.sas.graphics.util.jxd.State;
import com.sas.graphics.util.jxd.VertexSet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

class Marker
extends VertexSet
implements Cloneable {
    private Color edgeColor;
    private int markerType;
    private int size = 8;

    Marker() {
    }

    public Marker copy() {
        Marker m = null;
        try {
            m = (Marker)this.clone();
            this.copyInit(m);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return m;
    }

    protected void copyInit(Marker m) {
        super.copyInit(m);
        m.allocScreen();
    }

    @Override
    public void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        if (state.isSoftwareRender()) {
            bgc = state.softGraphics;
        }
        for (int i = 0; i < this.vertexCount; ++i) {
            Color c = this.color;
            if (state.capabilities[0]) {
                c = this.colorPerVertex[i];
            }
            if (this.markerType < 189) {
                Markers.draw((Graphics)bgc, (Color)c, (Color)this.edgeColor, (int)this.markerType, (int)this.size, (int)this.xpoints[i], (int)this.ypoints[i]);
                continue;
            }
            CustomMarkerInterface marker = (CustomMarkerInterface)state.customMarkers.elementAt(this.markerType - 189 - 1);
            bgc.setColor(c);
            marker.paint(bgc, c, this.edgeColor, this.xpoints[i] - (this.size - 1) / 2, this.ypoints[i] - (this.size - 1) / 2, this.size, this.size);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        return aperture.intersects(this.bbox);
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.size = ch.state.markerSize;
        this.edgeColor = ch.state.edgecolor;
        this.markerType = ch.state.markerType;
        if (this.size > 1) {
            this.bbox.setBounds(this.bbox.x - this.size / 2, this.bbox.y - this.size / 2, this.bbox.width + this.size, this.bbox.height + this.size);
        }
    }

    @Override
    public Point4 getScreenCenter() {
        return this.dscr[0];
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        Point4[] t = state.ptArray;
        t[0].x = this.bbox.x;
        t[0].y = this.bbox.y;
        t[0].z = 0.0;
        t[1].x = this.bbox.x + this.bbox.width;
        t[1].y = this.bbox.y;
        t[1].z = 0.0;
        t[2].x = this.bbox.x + this.bbox.width;
        t[2].y = this.bbox.y + this.bbox.height;
        t[2].z = 0.0;
        t[3].x = this.bbox.x;
        t[3].y = this.bbox.y + this.bbox.height;
        t[3].z = 0.0;
        return t;
    }

    public int getVertexCount() {
        return 4;
    }
}

