/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.Light;
import com.sas.graphics.util.jxd.Point4;
import com.sas.graphics.util.jxd.Primitive;
import com.sas.graphics.util.jxd.State;
import java.awt.Graphics;

final class LightParameter
extends Primitive {
    private Light light;
    private int pname;
    private double dparam = Double.NaN;
    private Point4 pparam = new Point4();

    public LightParameter(Light l, int pname, Point4 param) {
        this.light = l;
        this.pname = pname;
        this.pparam.set(param);
    }

    public LightParameter(Light l, int pname, double param) {
        this.light = l;
        this.pname = pname;
        this.dparam = param;
    }

    @Override
    void computeScreen(Channel ch) {
        if (Double.isNaN(this.dparam)) {
            this.light.setParam(this.pname, this.pparam);
        } else {
            this.light.setParam(this.pname, this.dparam);
        }
        this.light.applyTransformations(ch.trans, this.pname);
    }

    @Override
    void render(State state, Graphics bgc) {
    }

    @Override
    boolean isClipped() {
        return false;
    }

    @Override
    void insertToSortlist(State state) {
    }
}

