/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.ColorGradient;
import com.sas.graphics.util.jxd.Point4;
import com.sas.graphics.util.jxd.ScanConvert;
import com.sas.graphics.util.jxd.Shape;
import com.sas.graphics.util.jxd.State;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;

class J3Rectangle
extends Shape {
    private Point4[] world = new Point4[2];
    private Point4[] screen = new Point4[2];
    private int fillmode;
    private boolean gradientFill;
    private ColorGradient colorGradient = null;
    private Color edgeColor;
    private Image texImage;
    private int texEnvMode;
    private int texEnvStyle;

    public J3Rectangle() {
        this.world[0] = new Point4();
        this.world[1] = new Point4();
        this.screen[0] = new Point4();
        this.screen[1] = new Point4();
    }

    @Override
    public int getVertexCount(State state) {
        return 4;
    }

    @Override
    public Point4 getScreenCenter() {
        return this.screen[0];
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        Point4[] t = state.ptArray;
        t[0].x = this.bbox.x;
        t[0].y = this.bbox.y;
        t[0].z = 0.0;
        t[1].x = this.bbox.x + this.bbox.width;
        t[1].y = this.bbox.y;
        t[1].z = 0.0;
        t[2].x = this.bbox.x + this.bbox.width;
        t[2].y = this.bbox.y + this.bbox.height;
        t[2].z = 0.0;
        t[3].x = this.bbox.x;
        t[3].y = this.bbox.y + this.bbox.height;
        t[3].z = 0.0;
        return t;
    }

    @Override
    public final void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        if (state.isSoftwareRender()) {
            this.softwareRender(state, bgc);
        } else {
            this.awtRender(state, bgc);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private void awtRender(State state, Graphics bgc) {
        switch (this.fillmode) {
            default: {
                bgc.setColor(this.color);
                bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                break;
            }
            case 2: {
                bgc.setColor(this.color);
                bgc.drawRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                break;
            }
            case 4: {
                bgc.setColor(this.color);
                bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                bgc.setColor(this.edgeColor);
                bgc.drawRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
            }
            case 5: 
        }
    }

    private void softwareRender(State state, Graphics bgc) {
        switch (this.fillmode) {
            default: {
                this.drawFill(state, bgc);
                this.drawTexture(state, bgc);
                this.drawShadow(state, bgc);
                break;
            }
            case 2: {
                this.drawOutline(state, bgc, this.color);
                break;
            }
            case 4: {
                this.drawFill(state, bgc);
                this.drawTexture(state, bgc);
                this.drawShadow(state, bgc);
                this.drawOutline(state, bgc, this.edgeColor);
            }
            case 5: 
        }
    }

    private void drawShadow(State state, Graphics bgc) {
        if (this.shadowEnabled) {
            int x;
            int extra;
            int y;
            float aInitial = 0.8f;
            float aEnd = 0.01f;
            int width = this.bbox.width;
            int height = this.shadowOffsetY;
            float aInc = (aEnd - aInitial) / (float)height;
            float a = aInitial;
            for (y = 0; y < height; ++y) {
                extra = y > this.shadowOffsetX ? this.shadowOffsetX : y;
                for (x = 0; x < width - this.shadowOffsetX + extra; ++x) {
                    state.ch.plant(this.bbox.x + this.shadowOffsetX + x, this.bbox.y + this.bbox.height + y, 0.0, a, 0.0f, 0.0f, 0.0f);
                }
                a += aInc;
            }
            width = this.shadowOffsetX;
            height = this.bbox.height;
            aInc = (aEnd - aInitial) / (float)width;
            a = aInitial;
            for (x = 0; x < width; ++x) {
                extra = x > this.shadowOffsetY - 1 ? this.shadowOffsetY - 1 : x;
                for (y = 0; y < height - this.shadowOffsetY + 1 + extra; ++y) {
                    state.ch.plant(this.bbox.x + this.bbox.width + x, this.bbox.y + this.shadowOffsetY + y, 0.0, a, 0.0f, 0.0f, 0.0f);
                }
                a += aInc;
            }
        }
    }

    private void drawFill(State state, Graphics bgc) {
        block11: {
            block12: {
                if (this.texImage != null && this.texEnvMode != 3) break block11;
                if (!this.gradientFill) break block12;
                float r1 = (float)this.colorGradient.color1.getRed() / 255.0f;
                float g1 = (float)this.colorGradient.color1.getGreen() / 255.0f;
                float b1 = (float)this.colorGradient.color1.getBlue() / 255.0f;
                float a1 = this.colorGradient.alpha1;
                float r2 = (float)this.colorGradient.color2.getRed() / 255.0f;
                float g2 = (float)this.colorGradient.color2.getGreen() / 255.0f;
                float b2 = (float)this.colorGradient.color2.getBlue() / 255.0f;
                float a2 = this.colorGradient.alpha2;
                switch (this.colorGradient.direction) {
                    case 0: {
                        for (int x = this.bbox.x; x < this.bbox.x + this.bbox.width; ++x) {
                            float factor = (float)(x - this.bbox.x) / (float)this.bbox.width;
                            float r = r1 + factor * (r2 - r1);
                            float g = g1 + factor * (g2 - g1);
                            float b = b1 + factor * (b2 - b1);
                            float a = a1 + factor * (a2 - a1);
                            for (int y = this.bbox.y; y < this.bbox.y + this.bbox.height; ++y) {
                                state.ch.plant(x, y, 0.0, a, r, g, b);
                            }
                        }
                        break block11;
                    }
                    default: {
                        for (int y = this.bbox.y; y < this.bbox.y + this.bbox.height; ++y) {
                            float factor = (float)(y - this.bbox.y) / (float)this.bbox.height;
                            float r = r1 + factor * (r2 - r1);
                            float g = g1 + factor * (g2 - g1);
                            float b = b1 + factor * (b2 - b1);
                            float a = a1 + factor * (a2 - a1);
                            for (int x = this.bbox.x; x < this.bbox.x + this.bbox.width; ++x) {
                                state.ch.plant(x, y, 0.0, a, r, g, b);
                            }
                        }
                        break block11;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                break block11;
            }
            float r = (float)this.color.getRed() / 255.0f;
            float g = (float)this.color.getGreen() / 255.0f;
            float b = (float)this.color.getBlue() / 255.0f;
            float a = this.alpha;
            int argb = this.color.getRGB();
            for (int y = this.bbox.y; y < this.bbox.y + this.bbox.height; ++y) {
                for (int x = this.bbox.x; x < this.bbox.x + this.bbox.width; ++x) {
                    if (state.capabilities[12]) {
                        state.ch.plant(x, y, 0.0, a, r, g, b);
                        continue;
                    }
                    state.ch.plant(x, y, 0.0, argb);
                }
            }
        }
    }

    private void drawOutline(State state, Graphics bgc, Color color) {
        int[] x = new int[]{this.bbox.x, this.bbox.x + this.bbox.width - 1, this.bbox.x + this.bbox.width - 1, this.bbox.x, this.bbox.x};
        int[] y = new int[]{this.bbox.y, this.bbox.y, this.bbox.y + this.bbox.height - 1, this.bbox.y + this.bbox.height - 1, this.bbox.y};
        for (int i = 0; i < 5; ++i) {
            int nextI = (i + 1) % 5;
            ScanConvert.bresenhamLine(state, state.lineWidth, x[i], y[i], color, 1.0f, x[nextI], y[nextI], color, 1.0f);
        }
    }

    private void drawTexture(State state, Graphics bgc) {
        if (this.texImage != null) {
            int texImageHeight = this.texImage.getHeight(state.ch.component);
            int texImageWidth = this.texImage.getWidth(state.ch.component);
            state.ch.setTexturePlant(true);
            if (this.texEnvStyle == 5) {
                int height = (int)((double)this.bbox.width * (double)texImageHeight / (double)texImageWidth);
                Image tex = this.texImage.getScaledInstance(this.bbox.width, height, 1);
                texImageWidth = this.bbox.width;
                texImageHeight = height;
                int[] texPixels = state.getTempPixelBuffer(this.bbox.width * height);
                PixelGrabber pg = new PixelGrabber(tex, 0, 0, texImageWidth, texImageHeight, texPixels, 0, texImageWidth);
                try {
                    pg.grabPixels();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int verticalTileCount = (int)Math.ceil((double)this.bbox.height / (double)texImageHeight);
                int startRow = this.bbox.y + this.bbox.height - 1;
                for (int i = 0; i < verticalTileCount; ++i) {
                    int rowsToCopy = startRow - this.bbox.y > texImageHeight ? texImageHeight : startRow - this.bbox.y + 1;
                    for (int y = 0; y < rowsToCopy; ++y) {
                        for (int x = 0; x < texImageWidth; ++x) {
                            int argb = texPixels[x + (texImageHeight - 1 - y) * texImageWidth];
                            if (this.texEnvMode == 3) {
                                float a = this.alpha;
                                float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                                float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                                float b = (float)(argb & 0xFF) / 255.0f;
                                state.ch.plant(this.bbox.x + x, startRow - y, 0.0, a, r, g, b);
                                continue;
                            }
                            state.ch.plant(this.bbox.x + x, startRow - y, 0.0, argb);
                        }
                    }
                    startRow -= texImageHeight;
                }
            } else {
                Image tex = this.texImage.getScaledInstance(this.bbox.width, this.bbox.height, 1);
                int[] texPixels = state.getTempPixelBuffer(this.bbox.width * this.bbox.height);
                PixelGrabber pg = new PixelGrabber(tex, 0, 0, this.bbox.width, this.bbox.height, texPixels, 0, this.bbox.width);
                try {
                    pg.grabPixels();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                for (int y = 0; y < this.bbox.height; ++y) {
                    for (int x = 0; x < this.bbox.width; ++x) {
                        int argb = texPixels[x + y * this.bbox.width];
                        if (this.texEnvMode == 3) {
                            float a = this.alpha;
                            float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                            float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                            float b = (float)(argb & 0xFF) / 255.0f;
                            state.ch.plant(this.bbox.x + x, this.bbox.y + y, 0.0, a, r, g, b);
                            continue;
                        }
                        state.ch.plant(this.bbox.x + x, this.bbox.y + y, 0.0, argb);
                    }
                }
            }
            state.ch.setTexturePlant(false);
        }
    }

    public void setCorners(double x1, double y1, double x2, double y2) {
        this.world[0].x = x1;
        this.world[0].y = y1;
        this.world[0].z = 0.0;
        this.world[1].x = x2;
        this.world[1].y = y2;
        this.world[1].z = 0.0;
    }

    public void setColorGradient(ColorGradient gradient) {
        boolean bl = this.gradientFill = gradient != null;
        if (gradient == null) {
            return;
        }
        if (this.colorGradient == null) {
            this.colorGradient = new ColorGradient();
        }
        this.colorGradient.color1 = gradient.color1;
        this.colorGradient.alpha1 = gradient.alpha1;
        this.colorGradient.color2 = gradient.color2;
        this.colorGradient.alpha2 = gradient.alpha2;
        this.colorGradient.direction = gradient.direction;
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.name = ch.state.currentName;
        this.edgeColor = ch.state.edgecolor;
        this.fillmode = ch.state.fillmode;
        this.texImage = null;
        if (ch.state.capabilities[10]) {
            this.texImage = ch.state.texImage;
            this.texEnvMode = ch.state.texEnvMode;
            this.texEnvStyle = ch.state.texEnvStyle;
        }
        this.screen[0].set(this.world[0]);
        ch.trans.Object2Window(this.screen[0]);
        this.screen[1].set(this.world[1]);
        ch.trans.Object2Window(this.screen[1]);
        this.zmin = Math.min(this.screen[0].z, this.screen[1].z);
        this.zmax = Math.min(this.screen[0].z, this.screen[1].z);
        int xmin = (int)(Math.min(this.screen[0].x, this.screen[1].x) + 0.5);
        int xmax = (int)(Math.max(this.screen[0].x, this.screen[1].x) + 0.5);
        int ymin = (int)(Math.min(this.screen[0].y, this.screen[1].y) + 0.5);
        int ymax = (int)(Math.max(this.screen[0].y, this.screen[1].y) + 0.5);
        this.bbox.setBounds(xmin, ymin, xmax - xmin + 1, ymax - ymin + 1);
        this.clip = this.zmin < 0.0 || this.zmax > 1.0;
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        Rectangle bounds = state.rt1;
        bounds.setBounds(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        Rectangle clippedBounds = state.ApplyClip(this.clipRect, bounds);
        return aperture.intersects(clippedBounds);
    }
}

