/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.Point4;
import com.sas.graphics.util.jxd.Primitive;
import com.sas.graphics.util.jxd.ScanConvert;
import com.sas.graphics.util.jxd.Solid;
import com.sas.graphics.util.jxd.State;
import com.sas.graphics.util.jxd.TransInfo;
import com.sas.graphics.util.jxd.VertexSet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

class J3Polygon
extends VertexSet
implements Cloneable {
    Point4 wn;
    Point4 nv;
    Point4 wc = new Point4(0.0, 0.0, 0.0, 1.0);
    Point4 center;
    boolean light;
    int edgeWidth;
    boolean fillIncludesEdges;
    Color litColor;
    Color edgeColor;
    Color[] litColorPerVertex;
    int fillmode;

    J3Polygon() {
        this.wn = new Point4();
        this.nv = new Point4();
        this.center = new Point4();
        this.normal = new Point4();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.wc.set(0.0, 0.0, 0.0, 1.0);
    }

    void copyInit(J3Polygon p) {
        super.copyInit(p);
        p.wc = this.wc.copy();
        p.wn = this.wn.copy();
        p.nv = this.nv.copy();
        p.center = this.center.copy();
        p.normal = this.normal.copy();
    }

    J3Polygon copy() {
        J3Polygon p = null;
        try {
            p = (J3Polygon)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        this.copyInit(p);
        return p;
    }

    @Override
    public Point4 getScreenCenter() {
        return this.center;
    }

    @Override
    void end(Channel ch) {
        super.end(ch);
        State state = ch.getState();
        if (state.capabilities[0]) {
            this.wn.set(this.computeNormal(state, state.winding));
        } else {
            this.wn.set(state.normal);
            this.wn.t = 0.0;
        }
        this.wc.scale(1.0 / (double)this.vertexCount);
        this.wc.t = 1.0;
    }

    Primitive[] extrude(State state) {
        if (this.falseEdgeFlagCount > 0 && this.falseEdgeFlagIndex[this.falseEdgeFlagCount - 1] == this.vertexCount - 1) {
            --this.falseEdgeFlagCount;
        }
        Primitive[] pList = new Primitive[1];
        Point4 extrusionVector = state.extrusionVector;
        J3Polygon from = this.copy();
        J3Polygon to = this.copy();
        Point4 fromNormal = state.pt5;
        fromNormal.set(this.computeNormal(state, state.winding));
        if (fromNormal.dot(extrusionVector) > 0.0) {
            J3Polygon.reverseWinding(state, from);
            fromNormal.scale(-1.0);
        } else {
            J3Polygon.reverseWinding(state, to);
        }
        state.Normal(fromNormal.x, fromNormal.y, fromNormal.z);
        from.end(state.ch);
        Solid solid = new Solid();
        solid.addPolygon2(from);
        pList[0] = solid;
        to.wc.set(0.0, 0.0, 0.0, 1.0);
        for (int i = 0; i < from.vertexCount; ++i) {
            to.vertex[i].add(extrusionVector);
            to.vertex[i].t = 1.0;
            to.wc.add(to.vertex[i]);
        }
        state.Normal(-fromNormal.x, -fromNormal.y, -fromNormal.z);
        to.end(state.ch);
        solid.addPolygon2(to);
        boolean autoNormal = state.capabilities[0];
        state.capabilities[0] = false;
        boolean edgeFlag = state.edgeFlag;
        state.edgeFlag = true;
        Point4 nv1 = state.pt3;
        Point4 nv2 = state.pt4;
        int efi = 0;
        for (int vi = 0; vi < from.vertexCount - 1; ++vi) {
            if (from.falseEdgeFlagCount > 0 && efi <= from.falseEdgeFlagIndex.length - 1 && from.falseEdgeFlagIndex[efi] == vi) {
                ++efi;
                continue;
            }
            Point4 v1 = from.vertex[vi];
            Point4 v2 = to.vertex[to.vertexCount - vi - 1];
            if (v1.x == v2.x && v1.y == v2.y && v1.z == v2.z) continue;
            Point4 v3 = to.vertex[to.vertexCount - vi - 2];
            Point4 v4 = from.vertex[vi + 1];
            J3Polygon p = new J3Polygon();
            p.vertex(state.ch, v1.x, v1.y, v1.z);
            p.vertex(state.ch, v2.x, v2.y, v2.z);
            p.vertex(state.ch, v3.x, v3.y, v3.z);
            p.vertex(state.ch, v4.x, v4.y, v4.z);
            nv1.set(p.vertex[2]);
            nv1.sub(p.vertex[0]);
            nv2.set(p.vertex[3]);
            nv2.sub(p.vertex[1]);
            nv1.cross(nv2);
            nv1.normalize();
            state.Normal(nv1.x, nv1.y, nv1.z);
            p.end(state.ch);
            solid.addPolygon(p);
        }
        solid.end(state.ch);
        state.capabilities[0] = autoNormal;
        state.edgeFlag = edgeFlag;
        return pList;
    }

    private static void reverseWinding(State state, J3Polygon p) {
        int i;
        Point4 temp = state.pt1;
        for (i = 0; i < p.vertexCount / 2; ++i) {
            temp.set(p.vertex[i]);
            p.vertex[i].set(p.vertex[p.vertexCount - i - 1]);
            p.vertex[p.vertexCount - i - 1].set(temp);
        }
        if (p.falseEdgeFlagCount > 0) {
            state.reallocScratchInt(p.falseEdgeFlagCount);
            System.arraycopy(p.falseEdgeFlagIndex, 0, state.scratchInt, 0, p.falseEdgeFlagCount);
            int n = p.falseEdgeFlagCount;
            int ec = 0;
            for (i = 0; i < n; ++i) {
                int ei = p.vertexCount - 2 - state.scratchInt[n - 1 - i];
                if (ei < 0) {
                    --p.falseEdgeFlagCount;
                    continue;
                }
                p.falseEdgeFlagIndex[ec++] = ei;
            }
        }
    }

    @Override
    public void computeScreen(Channel ch) {
        State state = ch.getState();
        TransInfo tr = ch.trans;
        this.clip = false;
        this.fillmode = state.fillmode;
        this.edgeWidth = state.lineWidth;
        this.edgeColor = state.edgecolor;
        this.light = state.capabilities[3];
        this.fillIncludesEdges = state.capabilities[9];
        this.nv.set(this.wn);
        tr.Object2EyeNormal(this.nv);
        this.nv.normalize();
        Point4 po = ch.state.pt6;
        po.set(this.wc);
        tr.Object2Eye(po);
        if (tr.getProjectionMode() != 2 && state.capabilities[1] && this.backFacing(tr.getProjectionMode(), po, this.nv)) {
            this.clip = true;
            return;
        }
        super.computeScreen(ch);
        if (this.clip) {
            return;
        }
        this.center.set(this.wc);
        tr.Object2Window(this.center);
        this.normal.set(this.computeScreenNormal(ch.state));
        this.normal.t = 0.0;
        if (tr.getProjectionMode() == 2 && state.capabilities[1] && this.backFacing(tr.getProjectionMode(), this.dscr[0], this.normal)) {
            this.clip = true;
            return;
        }
        Point4 eye = state.pt2;
        eye.set(0.0, 0.0, 0.0, 0.0);
        this.litColor = this.color;
        if (this.light && (this.fillmode == 3 || this.fillmode == 4)) {
            if (state.isSoftwareRender() && state.shadeModel == 0) {
                if (this.litColorPerVertex == null || this.litColorPerVertex.length < this.vertexCount) {
                    this.litColorPerVertex = new Color[this.vertexCount];
                }
                for (int i = 0; i < this.vertexCount; ++i) {
                    this.litColorPerVertex[i] = state.lightMgr.computeColor(po, this.nv, eye, this.colorPerVertex[i]);
                }
            } else {
                this.litColor = state.lightMgr.computeColor(po, this.nv, eye, this.color);
            }
        }
    }

    final Point4 getNormal() {
        return this.normal;
    }

    @Override
    public final void render(State state, Graphics bgc) {
        if (this.clip || this.vertexCount == 0) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        bgc.setColor(this.litColor);
        if (state.isSoftwareRender()) {
            this.softwareRender(state, bgc);
        } else {
            this.awtRender(state, bgc);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private void awtRender(State state, Graphics bgc) {
        switch (this.fillmode) {
            default: {
                this.drawFill(bgc, state);
                break;
            }
            case 2: {
                this.drawOutline(state, bgc, this.litColor);
                break;
            }
            case 1: {
                for (int j = 0; j < this.vertexCount; ++j) {
                    bgc.drawOval(this.xpoints[j], this.ypoints[j], 2, 2);
                }
                break;
            }
            case 4: {
                this.drawFill(bgc, state);
                bgc.setColor(this.edgeColor);
                this.drawOutline(state, bgc, this.edgeColor);
            }
            case 5: 
        }
    }

    private void softwareRender(State state, Graphics bgc) {
        boolean clockwise;
        boolean bl = clockwise = state.winding == 1;
        clockwise = this.normal.z > 0.0 ? clockwise : !clockwise;
        state.appearance.color = this.color;
        state.appearance.litColor = this.litColor;
        state.appearance.colorPerVertex = this.colorPerVertex;
        state.appearance.litColorPerVertex = this.litColorPerVertex;
        state.appearance.alphaPerVertex = this.alphaPerVertex;
        state.appearance.alpha = this.alpha;
        state.appearance.isLightOn = this.light;
        switch (this.fillmode) {
            default: {
                state.scanConvert.drawConcavePolygon(state, this.vertexCount, this.dscr, state.appearance);
                break;
            }
            case 2: {
                this.drawOutline(state, bgc, this.litColor);
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                state.scanConvert.drawConcavePolygon(state, this.vertexCount, this.dscr, state.appearance);
                this.drawOutline(state, bgc, this.edgeColor);
            }
            case 5: 
        }
    }

    private void drawFill(Graphics g, State state) {
        if (this.fillIncludesEdges || state.capabilities[9] && state.capabilities[8]) {
            g.drawPolygon(this.xpoints, this.ypoints, this.vertexCount);
        }
        g.fillPolygon(this.xpoints, this.ypoints, this.vertexCount);
    }

    private void drawOutline(State state, Graphics g, Color color) {
        if (this.falseEdgeFlagCount == 0) {
            if (state.isSoftwareRender()) {
                for (int from = 0; from < this.vertexCount; ++from) {
                    int to = (from + 1) % this.vertexCount;
                    ScanConvert.bresenhamLine(state, this.edgeWidth, this.xpoints[from], this.ypoints[from], color, 1.0f, this.xpoints[to], this.ypoints[to], color, 1.0f);
                }
            } else {
                g.drawPolygon(this.xpoints, this.ypoints, this.vertexCount);
                g.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[this.vertexCount - 1], this.ypoints[this.vertexCount - 1]);
            }
        } else {
            int from = 0;
            int to = 1;
            int i = 1;
            int ei = 0;
            while (i < this.vertexCount) {
                if (ei < this.falseEdgeFlagIndex.length && this.falseEdgeFlagIndex[ei] + 1 == i) {
                    ++ei;
                } else if (state.isSoftwareRender()) {
                    ScanConvert.bresenhamLine(state, this.edgeWidth, this.xpoints[from], this.ypoints[from], color, 1.0f, this.xpoints[to], this.ypoints[to], color, 1.0f);
                } else {
                    g.drawLine(this.xpoints[from], this.ypoints[from], this.xpoints[to], this.ypoints[to]);
                }
                ++i;
                ++from;
                ++to;
            }
            if ((this.xpoints[0] != this.xpoints[this.vertexCount - 1] || this.ypoints[0] != this.ypoints[this.vertexCount - 1]) && this.falseEdgeFlagIndex[this.falseEdgeFlagCount - 1] != this.vertexCount - 1) {
                g.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[this.vertexCount - 1], this.ypoints[this.vertexCount - 1]);
            }
        }
    }

    @Override
    final void vertex(Channel ch, double x, double y, double z) {
        super.vertex(ch, x, y, z);
        this.wc.add(this.vertex[this.vertexCount - 1]);
    }

    protected final boolean backFacing(int projectionMode, Point4 p, Point4 n) {
        return projectionMode == 1 ? p.dot(n) >= 0.0 : (projectionMode == 2 ? n.z >= 0.0 : n.z < 0.0);
    }

    protected final Point4 computeNormal(State state, int winding) {
        Point4 n = this.computeNormal(state, false);
        n.t = 0.0;
        n.normalize();
        if (winding == 1) {
            n.scale(-1.0);
        }
        return n;
    }

    protected final Point4 computeScreenNormal(State state) {
        Point4 n = this.computeNormal(state, true);
        n.t = 1.0;
        n.normalize();
        return n;
    }

    protected final Point4 computeNormal(State state, boolean screen) {
        Point4 faceNormal = null;
        switch (this.vertexCount) {
            case 0: 
            case 1: 
            case 2: {
                faceNormal = state.pt1;
                faceNormal.set(0.0, 0.0, 0.0, 0.0);
                break;
            }
            case 3: {
                faceNormal = this.computeArea(state, screen);
                break;
            }
            case 4: {
                faceNormal = this.computeArea(state, screen);
                break;
            }
            default: {
                faceNormal = this.computeArea(state, screen);
            }
        }
        return faceNormal;
    }

    protected final Point4 computeArea(State state, boolean screen) {
        int j = 0;
        Point4 area = state.pt1;
        area.set(0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < this.vertexCount; ++i) {
            j = i;
            int next = i == this.vertexCount - 1 ? 0 : i + 1;
            Point4 p1 = screen ? this.dscr[i] : this.vertex[i];
            Point4 p2 = screen ? this.dscr[next] : this.vertex[next];
            area.x += (p2.z - p1.z) / 2.0 * (p1.y + p2.y);
            area.y += (p2.x - p1.x) / 2.0 * (p1.z + p2.z);
            area.z += (p2.x - p1.x) / 2.0 * (p1.y + p2.y);
        }
        area.z *= -1.0;
        return area;
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        return this.intersects(state, aperture);
    }

    @Override
    final boolean inside(int x, int y, State state) {
        return VertexSet.inside(x, y, this.xpoints, this.ypoints, this.vertexCount, this.falseEdgeFlagIndex, this.falseEdgeFlagCount, state);
    }

    final boolean intersects(State state, Rectangle aperture) {
        if (!aperture.intersects(this.bbox)) {
            return false;
        }
        return VertexSet.apertureIntersectsPolygon(state, aperture, this.xpoints, this.ypoints, this.vertexCount, this.falseEdgeFlagIndex, this.falseEdgeFlagCount);
    }
}

