/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.BillBoardImage;
import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.DisplayList;
import com.sas.graphics.util.jxd.J3Line;
import com.sas.graphics.util.jxd.J3Point;
import com.sas.graphics.util.jxd.J3Polygon;
import com.sas.graphics.util.jxd.ListReference;
import com.sas.graphics.util.jxd.RasterText;
import com.sas.graphics.util.jxd.Solid;
import com.sas.graphics.util.jxd.State;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;

public class Diagnostics
extends MouseAdapter
implements MouseMotionListener {
    private static final int POLYGON = 0;
    private static final int LINE = 1;
    private static final int POINT = 2;
    private static final int TEXT = 3;
    private static final int IMAGE = 4;
    private static final int POLYGON_IN_SOLID = 5;
    private static final int DL_REFERENCE = 6;
    private static final int PRIMITIVE_COUNT = 7;
    private int motionEventCount;
    private long startTime;
    private Channel channel;

    public Diagnostics() {
        this.channel = null;
    }

    public Diagnostics(Channel c) {
        this.setChannelToMonitor(c);
    }

    public void setChannelToMonitor(Channel c) {
        this.stop();
        this.channel = c;
    }

    public void stop() {
        Component component;
        if (this.channel != null && (component = this.channel.getComponent()) != null) {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            this.channel.disableRefreshCount();
        }
    }

    public void start() {
        Component component;
        if (this.channel != null && (component = this.channel.getComponent()) != null) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            this.startTime = 0L;
            this.motionEventCount = 0;
            this.channel.enableRefreshCount();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        ++this.motionEventCount;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        ++this.motionEventCount;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startTime = System.currentTimeMillis();
        this.motionEventCount = 0;
        this.channel.resetRefreshCount();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        long t = System.currentTimeMillis() - this.startTime;
        if (t > 0L) {
            int refreshCount = this.channel.getRefreshCount();
            t = (long)(refreshCount * 1000) / t;
            System.out.println(t + " frames/sec, " + refreshCount + " frames, " + this.motionEventCount + " motion events.");
        }
    }

    public static void dumpDisplayList(Channel channel, long listName) {
        State state;
        if (channel != null && (state = channel.getState()) != null) {
            Diagnostics.dumpDisplayList(state, listName, true);
        }
    }

    public static void dumpDisplayList(Channel channel) {
        State state;
        if (channel != null && (state = channel.getState()) != null) {
            Enumeration e = state.displayList.elements();
            while (e.hasMoreElements()) {
                DisplayList dl = (DisplayList)e.nextElement();
                Diagnostics.dumpDisplayList(state, dl.id, false);
            }
        }
    }

    private static void dumpDisplayList(State state, long listName, boolean recursive) {
        DisplayList displayList = state.getDisplayList(listName);
        int[] primitiveCounts = new int[7];
        if (displayList != null) {
            Diagnostics.dumpDisplayList(state, displayList, primitiveCounts, 0, recursive);
        }
        Diagnostics.printPrimitiveCounts(listName, primitiveCounts);
    }

    private static void dumpDisplayList(State state, DisplayList displayList, int[] primitiveCounts, int indentLevel, boolean recursive) {
        int n = displayList.primitives.size();
        for (int i = 0; i < n; ++i) {
            Object primitive = displayList.primitives.elementAt(i);
            if (primitive instanceof ListReference) {
                primitiveCounts[6] = primitiveCounts[6] + 1;
                if (!recursive) continue;
                ListReference rl = (ListReference)primitive;
                DisplayList dl = state.getDisplayList(rl.listName);
                if (dl == null) continue;
                Diagnostics.dumpDisplayList(state, dl, primitiveCounts, indentLevel + 1, recursive);
                continue;
            }
            if (primitive instanceof J3Polygon) {
                primitiveCounts[0] = primitiveCounts[0] + 1;
                continue;
            }
            if (primitive instanceof Solid) {
                Solid solid = (Solid)primitive;
                primitiveCounts[5] = primitiveCounts[5] + solid.getPolygonList().size();
                continue;
            }
            if (primitive instanceof J3Line) {
                primitiveCounts[1] = primitiveCounts[1] + 1;
                continue;
            }
            if (primitive instanceof J3Point) {
                primitiveCounts[2] = primitiveCounts[2] + 1;
                continue;
            }
            if (primitive instanceof RasterText) {
                primitiveCounts[3] = primitiveCounts[3] + 1;
                continue;
            }
            if (!(primitive instanceof BillBoardImage)) continue;
            primitiveCounts[4] = primitiveCounts[4] + 1;
        }
    }

    private static void printPrimitiveCounts(long listName, int[] primitiveCounts) {
        System.out.println("Primitive counts for list " + listName + ":");
        System.out.println("   total polgons=" + (primitiveCounts[0] + primitiveCounts[5]) + ", in Solids=" + primitiveCounts[5] + ", individual=" + primitiveCounts[0]);
        System.out.println("   lines=" + primitiveCounts[1]);
        System.out.println("   points=" + primitiveCounts[2]);
        System.out.println("   text=" + primitiveCounts[3]);
        System.out.println("   images=" + primitiveCounts[4]);
        System.out.println("   display list references=" + primitiveCounts[6]);
    }
}

