/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.jxd;

import com.sas.graphics.util.jxd.Channel;
import com.sas.graphics.util.jxd.RasterShape;
import com.sas.graphics.util.jxd.State;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;

class BillBoardImage
extends RasterShape {
    private static Image waitImage = null;
    double lastXo = -1.0;
    double lastYo = -1.0;

    BillBoardImage(State state, Image img, double x, double y, double z, int aWidth, int aHeight, Color bgColor) {
        this.image = img;
        waitImage = State.waitImage;
        this.backgroundColor = bgColor;
        this.width = aWidth;
        this.height = aHeight;
        this.init(x, y, z);
    }

    @Override
    public void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        if (this.image == null) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        int x = (int)this.screen.x;
        int y = (int)this.screen.y;
        Channel ch = state.ch;
        double[] newInfo = this.computeAlignmentInfo(state, bgc, x, y);
        int xo = (int)newInfo[0];
        int yo = (int)newInfo[1];
        if (state.isSoftwareRender()) {
            int[] pixels = state.getTempPixelBuffer(this.width * this.height);
            PixelGrabber pg = new PixelGrabber(this.image, 0, 0, this.width, this.height, pixels, 0, this.width);
            try {
                pg.grabPixels();
                for (int iy = 0; iy < this.height; ++iy) {
                    float a = (float)iy / (float)this.height;
                    for (int ix = 0; ix < this.width; ++ix) {
                        int argb = pixels[ix + iy * this.width];
                        a = (float)(argb >> 24 & 0xFF) / 255.0f;
                        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                        float b = (float)(argb & 0xFF) / 255.0f;
                        state.ch.plant(xo + ix, yo + iy, 0.0, a, r, g, b);
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else if (this.backgroundColor != null) {
            if (!bgc.drawImage(this.image, xo, yo, this.backgroundColor, ch.component) && waitImage != null) {
                bgc.drawImage(waitImage, xo, yo, ch.component);
            }
        } else if (!bgc.drawImage(this.image, xo, yo, ch.component) && waitImage != null) {
            bgc.drawImage(waitImage, xo, yo, ch.component);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }
}

