/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.StringVariable;
import java.util.Vector;

public class VariableSearch {
    StringVariable variable;

    public VariableSearch() {
    }

    public VariableSearch(StringVariable variable) {
        this.variable = variable;
    }

    public void setVariable(StringVariable variable) {
        this.variable = variable;
    }

    public boolean contains(String value) {
        if (this.variable != null) {
            int valueCount = this.variable.getUniqueValueCount();
            for (int ii = 0; ii < valueCount; ++ii) {
                try {
                    if (value.equals(this.variable.uniqueValue.getValue(ii))) {
                        return true;
                    }
                    continue;
                }
                catch (MissingValueException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public VariableSearchResult compare(String value, int count) {
        String valueUpperCase = value.toUpperCase();
        if (this.variable == null) {
            return null;
        }
        VariableSearchResult searchResult = new VariableSearchResult();
        int uniqueValueCount = this.variable.getUniqueValueCount();
        Vector<String> vCompareList = new Vector<String>();
        for (int ii = 0; ii < uniqueValueCount; ++ii) {
            try {
                int jj;
                String variableValue = this.variable.uniqueValue.getValue(ii);
                String variableValueUpperCase = variableValue.toUpperCase();
                if (valueUpperCase.equals(variableValueUpperCase)) {
                    vCompareList.insertElementAt(variableValue, 0);
                    int valueCount = this.variable.getValueCount();
                    for (jj = 0; jj < valueCount; ++jj) {
                        try {
                            if (!value.equals(this.variable.value.getValue(jj))) continue;
                            if (searchResult.matchingObservations == null) {
                                searchResult.matchingObservations = new int[]{jj};
                                continue;
                            }
                            int[] old = searchResult.matchingObservations;
                            searchResult.matchingObservations = new int[old.length + 1];
                            for (int kk = 0; kk < old.length; ++kk) {
                                searchResult.matchingObservations[kk] = old[kk];
                            }
                            searchResult.matchingObservations[old.length] = jj;
                            continue;
                        }
                        catch (MissingValueException e) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (variableValueUpperCase.compareTo(valueUpperCase) <= 0) continue;
                int size = Math.min(vCompareList.size(), count);
                for (jj = 0; jj < size && variableValue != null; ++jj) {
                    int result = variableValueUpperCase.compareTo(((String)vCompareList.elementAt(jj)).toUpperCase());
                    if (result >= 0) continue;
                    vCompareList.insertElementAt(variableValue, jj);
                    variableValue = null;
                }
                if (size >= count || variableValue == null) continue;
                vCompareList.addElement(variableValue);
                continue;
            }
            catch (MissingValueException e) {
                // empty catch block
            }
        }
        if (vCompareList != null) {
            int size = Math.min(vCompareList.size(), count);
            searchResult.compareList = new String[size];
            for (int ii = 0; ii < count && ii < size; ++ii) {
                searchResult.compareList[ii] = (String)vCompareList.elementAt(ii);
            }
        }
        return searchResult;
    }

    public static class VariableSearchResult {
        public String[] compareList;
        public int[] matchingObservations;
    }
}

