/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import com.sas.graphics.chart.util.ctk.vtk.CaseInsensitiveSortedStringVector;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.StringVariable;

public class StringVariableSearch {
    StringVariable variable;
    CaseInsensitiveSortedStringVector uniqueCache;
    int[] indexTable;

    public StringVariableSearch() {
    }

    public StringVariableSearch(StringVariable variable) {
        this.setVariable(variable);
    }

    public void setVariable(StringVariable variable) {
        this.variable = variable;
        this.uniqueCache = null;
    }

    public void setValidIndicies(int[] indexTable) {
        this.indexTable = indexTable;
        this.uniqueCache = null;
    }

    public boolean contains(String value) {
        if (this.uniqueCache == null || value == null) {
            return false;
        }
        return this.uniqueCache.indexOf(value) != -1;
    }

    private void cacheData() {
        block8: {
            if (this.uniqueCache != null || this.variable == null) break block8;
            if (this.indexTable == null) {
                this.uniqueCache = new CaseInsensitiveSortedStringVector();
                int uniqueValueCount = this.variable.getUniqueValueCount();
                for (int ii = 0; ii < uniqueValueCount; ++ii) {
                    try {
                        this.uniqueCache.addString(this.variable.uniqueValue.getValue(ii));
                        continue;
                    }
                    catch (MissingValueException e) {
                        // empty catch block
                    }
                }
            } else {
                this.uniqueCache = new CaseInsensitiveSortedStringVector();
                int indexTableCount = this.indexTable.length;
                for (int ii = 0; ii < indexTableCount; ++ii) {
                    try {
                        String stringValue = this.variable.value.getValue(this.indexTable[ii]);
                        if (this.uniqueCache.indexOf(stringValue) != -1) continue;
                        this.uniqueCache.addString(stringValue);
                        continue;
                    }
                    catch (MissingValueException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public Result compare(String value) {
        int uniqueCacheSize;
        String uniqueValue;
        this.cacheData();
        if (this.variable == null || this.uniqueCache == null) {
            return null;
        }
        Result searchResult = new Result();
        searchResult.list = this.uniqueCache.toStringArray();
        boolean uniqueMatch = false;
        int sortIndex = this.uniqueCache.sortIndex(value.toUpperCase());
        String string = uniqueValue = sortIndex == (uniqueCacheSize = this.uniqueCache.size()) ? null : this.uniqueCache.stringAt(sortIndex);
        if (uniqueValue != null && !(uniqueMatch = value.equals(uniqueValue))) {
            String uniqueValueUpperCase2;
            String valueUpperCase = value.toUpperCase();
            String uniqueValueUpperCase = uniqueValue.toUpperCase();
            if (uniqueValueUpperCase.startsWith(valueUpperCase) && !(uniqueMatch = uniqueCacheSize <= sortIndex + 1) && !(uniqueMatch = !(uniqueValueUpperCase2 = this.uniqueCache.stringAt(sortIndex + 1).toUpperCase()).startsWith(valueUpperCase))) {
                uniqueMatch = valueUpperCase.equals(uniqueValueUpperCase) && !valueUpperCase.equals(uniqueValueUpperCase2);
            }
        }
        searchResult.listIndex = sortIndex;
        if (uniqueMatch) {
            int valueCount = this.variable.getValueCount();
            for (int ii = 0; ii < valueCount; ++ii) {
                try {
                    if (!uniqueValue.equals(this.variable.value.getValue(ii))) continue;
                    if (searchResult.matchingObservations == null) {
                        searchResult.matchingObservations = new int[]{ii};
                        continue;
                    }
                    int[] old = searchResult.matchingObservations;
                    searchResult.matchingObservations = new int[old.length + 1];
                    for (int kk = 0; kk < old.length; ++kk) {
                        searchResult.matchingObservations[kk] = old[kk];
                    }
                    searchResult.matchingObservations[old.length] = ii;
                    continue;
                }
                catch (MissingValueException e) {
                    // empty catch block
                }
            }
        }
        return searchResult;
    }

    public static class Result {
        public String[] list;
        public int listIndex = -1;
        public int[] matchingObservations;
    }
}

