/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.chart.util.ctk.vtk;

import com.sas.graphics.chart.util.ctk.vtk.DoubleStrategyMapper;
import com.sas.graphics.chart.util.ctk.vtk.DoubleTickStrategyInterface;
import com.sas.graphics.chart.util.ctk.vtk.DoubleToDoubleTransformStrategyInterface;
import com.sas.graphics.util.vtk.AInitAction;
import com.sas.graphics.util.vtk.Formatter;
import com.sas.graphics.util.vtk.MissingValueException;
import com.sas.graphics.util.vtk.NumericProperty;

public class DoubleToDoubleStrategyMapper
extends DoubleStrategyMapper {
    public final NumericProperty input = new NumericProperty(this, true);
    protected DoubleTickStrategyInterface tickStrategy;
    protected DoubleToDoubleTransformStrategyInterface transformStrategy;

    public DoubleTickStrategyInterface setTickStrategy(DoubleTickStrategyInterface tickStrategy) {
        if (this.tickStrategy != null) {
            this.tickStrategy.removeStateListener(this);
        }
        this.tickStrategy = tickStrategy;
        if (this.tickStrategy != null) {
            tickStrategy.addStateListener(this);
        }
        return this.tickStrategy;
    }

    public DoubleTickStrategyInterface getTickStrategy() {
        return this.tickStrategy;
    }

    public DoubleToDoubleTransformStrategyInterface setTransformStrategy(DoubleToDoubleTransformStrategyInterface transformStrategy) {
        if (this.transformStrategy != null) {
            this.transformStrategy.removeStateListener(this);
        }
        this.transformStrategy = transformStrategy;
        if (this.transformStrategy != null) {
            transformStrategy.addStateListener(this);
        }
        return this.transformStrategy;
    }

    public DoubleToDoubleTransformStrategyInterface getTransformStrategy() {
        return this.transformStrategy;
    }

    @Override
    public double getValue(int index) throws MissingValueException {
        if (this.transformStrategy == null) {
            throw new MissingValueException();
        }
        double value = this.transformStrategy.getValue(this.input.getValue(index));
        if (Double.isNaN(value)) {
            throw new MissingValueException();
        }
        return value;
    }

    @Override
    public double getOutputMin() {
        return Double.NaN;
    }

    @Override
    public double getOutputMax() {
        return Double.NaN;
    }

    @Override
    public void init(AInitAction ia) {
        super.init(ia);
        if (ia.beenInitialized(this)) {
            return;
        }
        Formatter labelFormat = this.getFormatter();
        this.labelVector.removeAllValues();
        this.valueVector.removeAllValues();
        if (this.transformStrategy != null && this.tickStrategy != null) {
            double[] values = this.tickStrategy.getValues();
            this.labelVector.setSize(values.length);
            this.valueVector.setSize(values.length);
            for (int ii = 0; ii < values.length; ++ii) {
                this.labelVector.setValueAt(labelFormat.format(new Double(values[ii])), ii);
                this.valueVector.setValueAt(this.transformStrategy.getValue(values[ii]), ii);
            }
        }
    }
}

